package com.sinosig.client.usermgr.feign;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;
import com.sinosig.core.client.model.IORGUSER;
import com.sinosig.client.usermgr.model.ORGUSERImpl;
import com.sinosig.util.SearchContext;
/**
 * 实体[ORGUSER] 服务对象接口
 */
public interface ORGUSERFeignClient {

    @RequestMapping(method = RequestMethod.GET, value = "/web/orgusers/{orguserid}")
    public ORGUSERImpl get(@PathVariable("orguserid") String orguserid);


    @RequestMapping(method = RequestMethod.PUT, value = "/web/orgusers/{orguserid}")
    public ORGUSERImpl update(@PathVariable("orguserid") String orguserid,@RequestBody ORGUSERImpl orguser);


    @RequestMapping(method = RequestMethod.POST, value = "/web/orgusers")
    public ORGUSERImpl create(@RequestBody ORGUSERImpl orguser);
        

    @RequestMapping(method = RequestMethod.DELETE, value = "/web/orgusers/{orguserid}")
    public Boolean remove(@PathVariable("orguserid") String orguserid);
        

    @RequestMapping(method = RequestMethod.GET, value = "/web/orgusers/fetchdefault")
    public Page<ORGUSERImpl> fetchDefault(SearchContext context);


    @RequestMapping(method = RequestMethod.GET, value = "/web/orgusers/fetchcurorguser")
    public Page<ORGUSERImpl> fetchCurOrgUser(SearchContext context);


    @RequestMapping(method = RequestMethod.POST, value = "/web/orgusers/select")
    public Page<ORGUSERImpl> select();


    @RequestMapping(method = RequestMethod.GET, value = "/web/orgusers/getdraft")
    public ORGUSERImpl getDraft(@RequestBody ORGUSERImpl orguser);


    @RequestMapping(method = RequestMethod.POST, value = "/web/orgusers/checkkey")
    public ORGUSERImpl checkKey(@RequestBody ORGUSERImpl orguser);


    @RequestMapping(method = RequestMethod.POST, value = "/web/orgusers/save")
    public ORGUSERImpl save(@RequestBody ORGUSERImpl orguser);



}
