package com.sinosig.client.usermgr.feign;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;
import com.sinosig.core.client.model.IORG;
import com.sinosig.client.usermgr.model.ORGImpl;
import com.sinosig.util.SearchContext;
/**
 * 实体[ORG] 服务对象接口
 */
public interface ORGFeignClient {

    @RequestMapping(method = RequestMethod.GET, value = "/web/orgs/fetchtoporg")
    public Page<ORGImpl> fetchTopOrg(SearchContext context);


    @RequestMapping(method = RequestMethod.GET, value = "/web/orgs/fetchdefault")
    public Page<ORGImpl> fetchDefault(SearchContext context);


    @RequestMapping(method = RequestMethod.PUT, value = "/web/orgs/{orgid}")
    public ORGImpl update(@PathVariable("orgid") String orgid,@RequestBody ORGImpl org);


    @RequestMapping(method = RequestMethod.GET, value = "/web/orgs/fetchcurorg")
    public Page<ORGImpl> fetchCurOrg(SearchContext context);


    @RequestMapping(method = RequestMethod.DELETE, value = "/web/orgs/{orgid}")
    public Boolean remove(@PathVariable("orgid") String orgid);
        

    @RequestMapping(method = RequestMethod.GET, value = "/web/orgs/{orgid}")
    public ORGImpl get(@PathVariable("orgid") String orgid);


    @RequestMapping(method = RequestMethod.POST, value = "/web/orgs")
    public ORGImpl create(@RequestBody ORGImpl org);
        

    @RequestMapping(method = RequestMethod.POST, value = "/web/orgs/checkkey")
    public ORGImpl checkKey(@RequestBody ORGImpl org);


    @RequestMapping(method = RequestMethod.POST, value = "/web/orgs/save")
    public ORGImpl save(@RequestBody ORGImpl org);


    @RequestMapping(method = RequestMethod.GET, value = "/web/orgs/getdraft")
    public ORGImpl getDraft(@RequestBody ORGImpl org);



}
