import UIService from '../ui-service';
import { UIActionTool } from '@/utils';
import { Subject } from 'rxjs';
import JQXTBYDService from '@/service/jqxtbyd/jqxtbyd-service';

/**
 * 交强险特别约定UI服务对象基类
 *
 * @export
 * @class JQXTBYDUIServiceBase
 */
export default class JQXTBYDUIServiceBase extends UIService {

    /**
     * Creates an instance of  JQXTBYDUIServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  JQXTBYDUIServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

        /**
     * 删除
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @returns {Promise<any>}
     */
    public async JQXTBYD_Delete(args: any[],context:any = {}, params?: any, $event?: any, xData?: any,actionContext?: any){
        let data: any = {};
        const _args: any[] = actionContext.$util.deepCopy(args);
        const _this: any = actionContext;
        const actionTarget: string | null = 'SINGLEKEY';
        Object.assign(context, { jqxtbyd: '%jqxtbydid%' });
        Object.assign(params, { jqxtbydid: '%jqxtbydid%' });
        Object.assign(params, { jqxtbydname: '%jqxtbydname%' })
        context = UIActionTool.handleContextParam(actionTarget,_args,context);
        data = UIActionTool.handleActionParam(actionTarget,_args,params);
        Object.assign(context,actionContext.context,context);
        if(context && context.srfsessionid){
          context.srfsessionkey = context.srfsessionid;
            delete context.srfsessionid;
        }
        const backend = () => {
            const curService:JQXTBYDService =  new JQXTBYDService();
            curService.RemoveTemp(context,data, true).then((response: any) => {
                if (!response || response.status !== 200) {
                    actionContext.$Notice.error({ title: '错误', desc: response.message });
                    return;
                }
                actionContext.$Notice.success({ title: '成功', desc: '删除成功！' });

                const _this: any = actionContext;
                if (xData && xData.refresh && xData.refresh instanceof Function) {
                    xData.refresh(args);
                }
                return response;
            }).catch((response: any) => {
                if (!response || !response.status || !response.data) {
                    actionContext.$Notice.error({ title: '错误', desc: '系统异常！' });
                    return;
                }
                if (response.status === 401) {
                    return;
                }
                const { data: _data } = response;
                actionContext.$Notice.error({ title: _data.title, desc: _data.message });
                return response;
            });
        };
        backend();
    }


}