import UIService from '../ui-service';
import { UIActionTool } from '@/utils';
import { Subject } from 'rxjs';
import CIDService from '@/service/cid/cid-service';

/**
 * 车险单UI服务对象基类
 *
 * @export
 * @class CIDUIServiceBase
 */
export default class CIDUIServiceBase extends UIService {

    /**
     * Creates an instance of  CIDUIServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  CIDUIServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

        /**
     * 计算保费
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @returns {Promise<any>}
     */
    public async CID_JSBF(args: any[],context:any = {}, params?: any, $event?: any, xData?: any,actionContext?: any){
        let data: any = {};
        const _args: any[] = actionContext.$util.deepCopy(args);
        const _this: any = actionContext;
        const actionTarget: string | null = 'SINGLEKEY';
        Object.assign(context, { cid: '%cidid%' });
        Object.assign(params, { cidid: '%cidid%' });
        Object.assign(params, { cidname: '%cidname%' })
        context = UIActionTool.handleContextParam(actionTarget,_args,context);
        data = UIActionTool.handleActionParam(actionTarget,_args,params);
        Object.assign(context,actionContext.context,context);
        if(context && context.srfsessionid){
          context.srfsessionkey = context.srfsessionid;
            delete context.srfsessionid;
        }
        const backend = () => {
            const curService:CIDService =  new CIDService();
            curService.JSBF(context,data, true).then((response: any) => {
                if (!response || response.status !== 200) {
                    actionContext.$Notice.error({ title: '错误', desc: response.message });
                    return;
                }
                actionContext.$Notice.success({ title: '成功', desc: '计算保费成功！' });

                const _this: any = actionContext;
                if (xData && xData.refresh && xData.refresh instanceof Function) {
                    xData.refresh(args);
                }
                return response;
            }).catch((response: any) => {
                if (!response || !response.status || !response.data) {
                    actionContext.$Notice.error({ title: '错误', desc: '系统异常！' });
                    return;
                }
                if (response.status === 401) {
                    return;
                }
                const { data: _data } = response;
                actionContext.$Notice.error({ title: _data.title, desc: _data.message });
                return response;
            });
        };
        backend();
    }

        /**
     * 重新加载数据
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @returns {Promise<any>}
     */
    public async CID_load(args: any[], context:any = {} ,params?: any, $event?: any, xData?: any,actionContext?:any) {
        let data: any = {};
        const _args: any[] = actionContext.$util.deepCopy(args);
        const _this: any = actionContext;
        const actionTarget: string | null = 'NONE';
        context = UIActionTool.handleContextParam(actionTarget,_args,context);
        data = UIActionTool.handleActionParam(actionTarget,_args,params);
        Object.assign(context,actionContext.context,context);
        if(context && context.srfsessionid){
          context.srfsessionkey = context.srfsessionid;
            delete context.srfsessionid;
        }
              if (xData && xData.refresh && xData.refresh instanceof Function) {
                  xData.refresh(args);
              }

    }


}