import Vue from 'vue';
import Router from 'vue-router';
import { AuthGuard } from '@/utils';
import qs from 'qs';

Vue.use(Router);


const router = new Router({
    routes: [
        {
            path: '/appindexview/:appindexview?',
            beforeEnter: (to: any, from: any, next: any) => {
                const routerParamsName = 'appindexview';
                const params: any = {};
                if (to.params && to.params[routerParamsName]) {
                    Object.assign(params, qs.parse(to.params[routerParamsName], { delimiter: ';' }));
                }
                const url: string = 'v7/appdata';
                const auth: Promise<any> = AuthGuard.getInstance().authGuard(url, params, router);
                auth.then(() => {
                    next();
                }).catch(() => {
                    next();
                });
            },
            meta: {  
                caption: '首页',
                viewType: 'APPINDEX',
                parameters: [
                    { pathName: 'appindexview', parameterName: 'appindexview' },
                ],
                requireAuth: true,
            },
            component: () => import('@pages/module/app-index-view/app-index-view.vue'),
            children: [
                {
                    path: 'sjzdxes/:sjzdx?/editview/:editview?',
                    meta: {
                        caption: 'sjzdx.views.editview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'sjzdxes', parameterName: 'sjzdx' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/module/sjzdxedit-view/sjzdxedit-view.vue'),
                },
                {
                    path: 'cids/:cid?/syxtbyds/:syxtbyd?/gridview9/:gridview9?',
                    meta: {
                        caption: 'syxtbyd.views.gridview9.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'cids', parameterName: 'cid' },
                            { pathName: 'syxtbyds', parameterName: 'syxtbyd' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/module/syxtbydgrid-view9/syxtbydgrid-view9.vue'),
                },
                {
                    path: 'syxtbyds/:syxtbyd?/gridview9/:gridview9?',
                    meta: {
                        caption: 'syxtbyd.views.gridview9.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'syxtbyds', parameterName: 'syxtbyd' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/module/syxtbydgrid-view9/syxtbydgrid-view9.vue'),
                },
                {
                    path: 'cpxhs/:cpxh?/pickupview/:pickupview?',
                    meta: {
                        caption: 'cpxh.views.pickupview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'cpxhs', parameterName: 'cpxh' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/ungroup/cpxhpickup-view/cpxhpickup-view.vue'),
                },
                {
                    path: 'cids/:cid?/customers/:customer?/meditview9/:meditview9?',
                    meta: {
                        caption: 'customer.views.meditview9.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'cids', parameterName: 'cid' },
                            { pathName: 'customers', parameterName: 'customer' },
                            { pathName: 'meditview9', parameterName: 'meditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/module/customermedit-view9/customermedit-view9.vue'),
                },
                {
                    path: 'customers/:customer?/meditview9/:meditview9?',
                    meta: {
                        caption: 'customer.views.meditview9.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'customers', parameterName: 'customer' },
                            { pathName: 'meditview9', parameterName: 'meditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/module/customermedit-view9/customermedit-view9.vue'),
                },
                {
                    path: 'cids/:cid?/jqxxxes/:jqxxx?/editview/:editview?',
                    meta: {
                        caption: 'jqxxx.views.editview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'cids', parameterName: 'cid' },
                            { pathName: 'jqxxxes', parameterName: 'jqxxx' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/module/jqxxxedit-view/jqxxxedit-view.vue'),
                },
                {
                    path: 'jqxxxes/:jqxxx?/editview/:editview?',
                    meta: {
                        caption: 'jqxxx.views.editview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'jqxxxes', parameterName: 'jqxxx' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/module/jqxxxedit-view/jqxxxedit-view.vue'),
                },
                {
                    path: 'orgusers/:orguser?/editview/:editview?',
                    meta: {
                        caption: 'orguser.views.editview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'orgusers', parameterName: 'orguser' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/external/orguseredit-view/orguseredit-view.vue'),
                },
                {
                    path: 'dbds/:dbd?/editview/:editview?',
                    meta: {
                        caption: 'dbd.views.editview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'dbds', parameterName: 'dbd' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/module/dbdedit-view/dbdedit-view.vue'),
                },
                {
                    path: 'cids/:cid?/customers/:customer?/editview9/:editview9?',
                    meta: {
                        caption: 'customer.views.editview9.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'cids', parameterName: 'cid' },
                            { pathName: 'customers', parameterName: 'customer' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/module/customeredit-view9/customeredit-view9.vue'),
                },
                {
                    path: 'customers/:customer?/editview9/:editview9?',
                    meta: {
                        caption: 'customer.views.editview9.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'customers', parameterName: 'customer' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/module/customeredit-view9/customeredit-view9.vue'),
                },
                {
                    path: 'cids/:cid?/syxxxes/:syxxx?/editview/:editview?',
                    meta: {
                        caption: 'syxxx.views.editview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'cids', parameterName: 'cid' },
                            { pathName: 'syxxxes', parameterName: 'syxxx' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/module/syxxxedit-view/syxxxedit-view.vue'),
                },
                {
                    path: 'syxxxes/:syxxx?/editview/:editview?',
                    meta: {
                        caption: 'syxxx.views.editview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'syxxxes', parameterName: 'syxxx' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/module/syxxxedit-view/syxxxedit-view.vue'),
                },
                {
                    path: 'orgs/:org?/gridview/:gridview?',
                    meta: {
                        caption: 'org.views.gridview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'orgs', parameterName: 'org' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/external/orggrid-view/orggrid-view.vue'),
                },
                {
                    path: 'cids/:cid?/gridview/:gridview?',
                    meta: {
                        caption: 'cid.views.gridview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'cids', parameterName: 'cid' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/module/cidgrid-view/cidgrid-view.vue'),
                },
                {
                    path: 'tbydks/:tbydk?/gridview/:gridview?',
                    meta: {
                        caption: 'tbydk.views.gridview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'tbydks', parameterName: 'tbydk' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/module/tbydkgrid-view/tbydkgrid-view.vue'),
                },
                {
                    path: 'orgs/:org?/editview/:editview?',
                    meta: {
                        caption: 'org.views.editview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'orgs', parameterName: 'org' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/external/orgedit-view/orgedit-view.vue'),
                },
                {
                    path: 'tbydks/:tbydk?/editview/:editview?',
                    meta: {
                        caption: 'tbydk.views.editview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'tbydks', parameterName: 'tbydk' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/module/tbydkedit-view/tbydkedit-view.vue'),
                },
                {
                    path: 'orgs/:org?/pickupview/:pickupview?',
                    meta: {
                        caption: 'org.views.pickupview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'orgs', parameterName: 'org' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/ungroup/orgpickup-view/orgpickup-view.vue'),
                },
                {
                    path: 'orgs/:org?/pickuptreeview/:pickuptreeview?',
                    meta: {
                        caption: 'org.views.pickuptreeview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'orgs', parameterName: 'org' },
                            { pathName: 'pickuptreeview', parameterName: 'pickuptreeview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/external/orgpickup-tree-view/orgpickup-tree-view.vue'),
                },
                {
                    path: 'sjzds/:sjzd?/gridview/:gridview?',
                    meta: {
                        caption: 'sjzd.views.gridview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'sjzds', parameterName: 'sjzd' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/module/sjzdgrid-view/sjzdgrid-view.vue'),
                },
                {
                    path: 'orgusers/:orguser?/gridview/:gridview?',
                    meta: {
                        caption: 'orguser.views.gridview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'orgusers', parameterName: 'orguser' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/external/orgusergrid-view/orgusergrid-view.vue'),
                },
                {
                    path: 'cids/:cid?/jqxtbyds/:jqxtbyd?/editview/:editview?',
                    meta: {
                        caption: 'jqxtbyd.views.editview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'cids', parameterName: 'cid' },
                            { pathName: 'jqxtbyds', parameterName: 'jqxtbyd' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/module/jqxtbydedit-view/jqxtbydedit-view.vue'),
                },
                {
                    path: 'jqxtbyds/:jqxtbyd?/editview/:editview?',
                    meta: {
                        caption: 'jqxtbyd.views.editview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'jqxtbyds', parameterName: 'jqxtbyd' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/module/jqxtbydedit-view/jqxtbydedit-view.vue'),
                },
                {
                    path: 'cids/:cid?/jqxxxes/:jqxxx?/gridview9/:gridview9?',
                    meta: {
                        caption: 'jqxxx.views.gridview9.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'cids', parameterName: 'cid' },
                            { pathName: 'jqxxxes', parameterName: 'jqxxx' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/module/jqxxxgrid-view9/jqxxxgrid-view9.vue'),
                },
                {
                    path: 'jqxxxes/:jqxxx?/gridview9/:gridview9?',
                    meta: {
                        caption: 'jqxxx.views.gridview9.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'jqxxxes', parameterName: 'jqxxx' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/module/jqxxxgrid-view9/jqxxxgrid-view9.vue'),
                },
                {
                    path: 'orgusers/:orguser?/pickupview/:pickupview?',
                    meta: {
                        caption: 'orguser.views.pickupview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'orgusers', parameterName: 'orguser' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/ungroup/orguserpickup-view/orguserpickup-view.vue'),
                },
                {
                    path: 'sjzds/:sjzd?/editview/:editview?',
                    meta: {
                        caption: 'sjzd.views.editview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'sjzds', parameterName: 'sjzd' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/module/sjzdedit-view/sjzdedit-view.vue'),
                },
                {
                    path: 'cids/:cid?/syxtbyds/:syxtbyd?/editview/:editview?',
                    meta: {
                        caption: 'syxtbyd.views.editview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'cids', parameterName: 'cid' },
                            { pathName: 'syxtbyds', parameterName: 'syxtbyd' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/module/syxtbydedit-view/syxtbydedit-view.vue'),
                },
                {
                    path: 'syxtbyds/:syxtbyd?/editview/:editview?',
                    meta: {
                        caption: 'syxtbyd.views.editview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'syxtbyds', parameterName: 'syxtbyd' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/module/syxtbydedit-view/syxtbydedit-view.vue'),
                },
                {
                    path: 'orgs/:org?/usr2pickupview/:usr2pickupview?',
                    meta: {
                        caption: 'org.views.usr2pickupview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'orgs', parameterName: 'org' },
                            { pathName: 'usr2pickupview', parameterName: 'usr2pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/external/orgusr2-pickup-view/orgusr2-pickup-view.vue'),
                },
                {
                    path: 'orgs/:org?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'org.views.pickupgridview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'orgs', parameterName: 'org' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/ungroup/orgpickup-grid-view/orgpickup-grid-view.vue'),
                },
                {
                    path: 'sjzdxes/:sjzdx?/gridview9/:gridview9?',
                    meta: {
                        caption: 'sjzdx.views.gridview9.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'sjzdxes', parameterName: 'sjzdx' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/module/sjzdxgrid-view9/sjzdxgrid-view9.vue'),
                },
                {
                    path: 'orgusers/:orguser?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'orguser.views.pickupgridview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'orgusers', parameterName: 'orguser' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/ungroup/orguserpickup-grid-view/orguserpickup-grid-view.vue'),
                },
                {
                    path: 'cpxhs/:cpxh?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'cpxh.views.pickupgridview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'cpxhs', parameterName: 'cpxh' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/ungroup/cpxhpickup-grid-view/cpxhpickup-grid-view.vue'),
                },
                {
                    path: 'cids/:cid?/editview/:editview?',
                    meta: {
                        caption: 'cid.views.editview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'cids', parameterName: 'cid' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/module/cidedit-view/cidedit-view.vue'),
                },
                {
                    path: 'cids/:cid?/syxxxes/:syxxx?/gridview9/:gridview9?',
                    meta: {
                        caption: 'syxxx.views.gridview9.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'cids', parameterName: 'cid' },
                            { pathName: 'syxxxes', parameterName: 'syxxx' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/module/syxxxgrid-view9/syxxxgrid-view9.vue'),
                },
                {
                    path: 'syxxxes/:syxxx?/gridview9/:gridview9?',
                    meta: {
                        caption: 'syxxx.views.gridview9.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'syxxxes', parameterName: 'syxxx' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/module/syxxxgrid-view9/syxxxgrid-view9.vue'),
                },
                {
                    path: 'dbds/:dbd?/gridview/:gridview?',
                    meta: {
                        caption: 'dbd.views.gridview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'dbds', parameterName: 'dbd' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/module/dbdgrid-view/dbdgrid-view.vue'),
                },
                {
                    path: 'cids/:cid?/jqxtbyds/:jqxtbyd?/gridview9/:gridview9?',
                    meta: {
                        caption: 'jqxtbyd.views.gridview9.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'cids', parameterName: 'cid' },
                            { pathName: 'jqxtbyds', parameterName: 'jqxtbyd' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/module/jqxtbydgrid-view9/jqxtbydgrid-view9.vue'),
                },
                {
                    path: 'jqxtbyds/:jqxtbyd?/gridview9/:gridview9?',
                    meta: {
                        caption: 'jqxtbyd.views.gridview9.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'jqxtbyds', parameterName: 'jqxtbyd' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/module/jqxtbydgrid-view9/jqxtbydgrid-view9.vue'),
                },
            ],
        },
    {
        path: '/sjzdxes/:sjzdx?/editview/:editview?',
        meta: {
            caption: 'sjzdx.views.editview.caption',
            parameters: [
                { pathName: 'sjzdxes', parameterName: 'sjzdx' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/module/sjzdxedit-view/sjzdxedit-view.vue'),
    },
    {
        path: '/cids/:cid?/syxtbyds/:syxtbyd?/gridview9/:gridview9?',
        meta: {
            caption: 'syxtbyd.views.gridview9.caption',
            parameters: [
                { pathName: 'cids', parameterName: 'cid' },
                { pathName: 'syxtbyds', parameterName: 'syxtbyd' },
                { pathName: 'gridview9', parameterName: 'gridview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/module/syxtbydgrid-view9/syxtbydgrid-view9.vue'),
    },
    {
        path: '/syxtbyds/:syxtbyd?/gridview9/:gridview9?',
        meta: {
            caption: 'syxtbyd.views.gridview9.caption',
            parameters: [
                { pathName: 'syxtbyds', parameterName: 'syxtbyd' },
                { pathName: 'gridview9', parameterName: 'gridview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/module/syxtbydgrid-view9/syxtbydgrid-view9.vue'),
    },
    {
        path: '/cpxhs/:cpxh?/pickupview/:pickupview?',
        meta: {
            caption: 'cpxh.views.pickupview.caption',
            parameters: [
                { pathName: 'cpxhs', parameterName: 'cpxh' },
                { pathName: 'pickupview', parameterName: 'pickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ungroup/cpxhpickup-view/cpxhpickup-view.vue'),
    },
    {
        path: '/cids/:cid?/customers/:customer?/meditview9/:meditview9?',
        meta: {
            caption: 'customer.views.meditview9.caption',
            parameters: [
                { pathName: 'cids', parameterName: 'cid' },
                { pathName: 'customers', parameterName: 'customer' },
                { pathName: 'meditview9', parameterName: 'meditview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/module/customermedit-view9/customermedit-view9.vue'),
    },
    {
        path: '/customers/:customer?/meditview9/:meditview9?',
        meta: {
            caption: 'customer.views.meditview9.caption',
            parameters: [
                { pathName: 'customers', parameterName: 'customer' },
                { pathName: 'meditview9', parameterName: 'meditview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/module/customermedit-view9/customermedit-view9.vue'),
    },
    {
        path: '/cids/:cid?/jqxxxes/:jqxxx?/editview/:editview?',
        meta: {
            caption: 'jqxxx.views.editview.caption',
            parameters: [
                { pathName: 'cids', parameterName: 'cid' },
                { pathName: 'jqxxxes', parameterName: 'jqxxx' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/module/jqxxxedit-view/jqxxxedit-view.vue'),
    },
    {
        path: '/jqxxxes/:jqxxx?/editview/:editview?',
        meta: {
            caption: 'jqxxx.views.editview.caption',
            parameters: [
                { pathName: 'jqxxxes', parameterName: 'jqxxx' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/module/jqxxxedit-view/jqxxxedit-view.vue'),
    },
    {
        path: '/orgusers/:orguser?/editview/:editview?',
        meta: {
            caption: 'orguser.views.editview.caption',
            parameters: [
                { pathName: 'orgusers', parameterName: 'orguser' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/external/orguseredit-view/orguseredit-view.vue'),
    },
    {
        path: '/dbds/:dbd?/editview/:editview?',
        meta: {
            caption: 'dbd.views.editview.caption',
            parameters: [
                { pathName: 'dbds', parameterName: 'dbd' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/module/dbdedit-view/dbdedit-view.vue'),
    },
    {
        path: '/cids/:cid?/customers/:customer?/editview9/:editview9?',
        meta: {
            caption: 'customer.views.editview9.caption',
            parameters: [
                { pathName: 'cids', parameterName: 'cid' },
                { pathName: 'customers', parameterName: 'customer' },
                { pathName: 'editview9', parameterName: 'editview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/module/customeredit-view9/customeredit-view9.vue'),
    },
    {
        path: '/customers/:customer?/editview9/:editview9?',
        meta: {
            caption: 'customer.views.editview9.caption',
            parameters: [
                { pathName: 'customers', parameterName: 'customer' },
                { pathName: 'editview9', parameterName: 'editview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/module/customeredit-view9/customeredit-view9.vue'),
    },
    {
        path: '/cids/:cid?/syxxxes/:syxxx?/editview/:editview?',
        meta: {
            caption: 'syxxx.views.editview.caption',
            parameters: [
                { pathName: 'cids', parameterName: 'cid' },
                { pathName: 'syxxxes', parameterName: 'syxxx' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/module/syxxxedit-view/syxxxedit-view.vue'),
    },
    {
        path: '/syxxxes/:syxxx?/editview/:editview?',
        meta: {
            caption: 'syxxx.views.editview.caption',
            parameters: [
                { pathName: 'syxxxes', parameterName: 'syxxx' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/module/syxxxedit-view/syxxxedit-view.vue'),
    },
    {
        path: '/orgs/:org?/gridview/:gridview?',
        meta: {
            caption: 'org.views.gridview.caption',
            parameters: [
                { pathName: 'orgs', parameterName: 'org' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/external/orggrid-view/orggrid-view.vue'),
    },
    {
        path: '/cids/:cid?/gridview/:gridview?',
        meta: {
            caption: 'cid.views.gridview.caption',
            parameters: [
                { pathName: 'cids', parameterName: 'cid' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/module/cidgrid-view/cidgrid-view.vue'),
    },
    {
        path: '/tbydks/:tbydk?/gridview/:gridview?',
        meta: {
            caption: 'tbydk.views.gridview.caption',
            parameters: [
                { pathName: 'tbydks', parameterName: 'tbydk' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/module/tbydkgrid-view/tbydkgrid-view.vue'),
    },
    {
        path: '/orgs/:org?/editview/:editview?',
        meta: {
            caption: 'org.views.editview.caption',
            parameters: [
                { pathName: 'orgs', parameterName: 'org' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/external/orgedit-view/orgedit-view.vue'),
    },
    {
        path: '/tbydks/:tbydk?/editview/:editview?',
        meta: {
            caption: 'tbydk.views.editview.caption',
            parameters: [
                { pathName: 'tbydks', parameterName: 'tbydk' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/module/tbydkedit-view/tbydkedit-view.vue'),
    },
    {
        path: '/orgs/:org?/pickupview/:pickupview?',
        meta: {
            caption: 'org.views.pickupview.caption',
            parameters: [
                { pathName: 'orgs', parameterName: 'org' },
                { pathName: 'pickupview', parameterName: 'pickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ungroup/orgpickup-view/orgpickup-view.vue'),
    },
    {
        path: '/orgs/:org?/pickuptreeview/:pickuptreeview?',
        meta: {
            caption: 'org.views.pickuptreeview.caption',
            parameters: [
                { pathName: 'orgs', parameterName: 'org' },
                { pathName: 'pickuptreeview', parameterName: 'pickuptreeview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/external/orgpickup-tree-view/orgpickup-tree-view.vue'),
    },
    {
        path: '/sjzds/:sjzd?/gridview/:gridview?',
        meta: {
            caption: 'sjzd.views.gridview.caption',
            parameters: [
                { pathName: 'sjzds', parameterName: 'sjzd' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/module/sjzdgrid-view/sjzdgrid-view.vue'),
    },
    {
        path: '/orgusers/:orguser?/gridview/:gridview?',
        meta: {
            caption: 'orguser.views.gridview.caption',
            parameters: [
                { pathName: 'orgusers', parameterName: 'orguser' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/external/orgusergrid-view/orgusergrid-view.vue'),
    },
    {
        path: '/cids/:cid?/jqxtbyds/:jqxtbyd?/editview/:editview?',
        meta: {
            caption: 'jqxtbyd.views.editview.caption',
            parameters: [
                { pathName: 'cids', parameterName: 'cid' },
                { pathName: 'jqxtbyds', parameterName: 'jqxtbyd' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/module/jqxtbydedit-view/jqxtbydedit-view.vue'),
    },
    {
        path: '/jqxtbyds/:jqxtbyd?/editview/:editview?',
        meta: {
            caption: 'jqxtbyd.views.editview.caption',
            parameters: [
                { pathName: 'jqxtbyds', parameterName: 'jqxtbyd' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/module/jqxtbydedit-view/jqxtbydedit-view.vue'),
    },
    {
        path: '/cids/:cid?/jqxxxes/:jqxxx?/gridview9/:gridview9?',
        meta: {
            caption: 'jqxxx.views.gridview9.caption',
            parameters: [
                { pathName: 'cids', parameterName: 'cid' },
                { pathName: 'jqxxxes', parameterName: 'jqxxx' },
                { pathName: 'gridview9', parameterName: 'gridview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/module/jqxxxgrid-view9/jqxxxgrid-view9.vue'),
    },
    {
        path: '/jqxxxes/:jqxxx?/gridview9/:gridview9?',
        meta: {
            caption: 'jqxxx.views.gridview9.caption',
            parameters: [
                { pathName: 'jqxxxes', parameterName: 'jqxxx' },
                { pathName: 'gridview9', parameterName: 'gridview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/module/jqxxxgrid-view9/jqxxxgrid-view9.vue'),
    },
    {
        path: '/orgusers/:orguser?/pickupview/:pickupview?',
        meta: {
            caption: 'orguser.views.pickupview.caption',
            parameters: [
                { pathName: 'orgusers', parameterName: 'orguser' },
                { pathName: 'pickupview', parameterName: 'pickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ungroup/orguserpickup-view/orguserpickup-view.vue'),
    },
    {
        path: '/sjzds/:sjzd?/editview/:editview?',
        meta: {
            caption: 'sjzd.views.editview.caption',
            parameters: [
                { pathName: 'sjzds', parameterName: 'sjzd' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/module/sjzdedit-view/sjzdedit-view.vue'),
    },
    {
        path: '/cids/:cid?/syxtbyds/:syxtbyd?/editview/:editview?',
        meta: {
            caption: 'syxtbyd.views.editview.caption',
            parameters: [
                { pathName: 'cids', parameterName: 'cid' },
                { pathName: 'syxtbyds', parameterName: 'syxtbyd' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/module/syxtbydedit-view/syxtbydedit-view.vue'),
    },
    {
        path: '/syxtbyds/:syxtbyd?/editview/:editview?',
        meta: {
            caption: 'syxtbyd.views.editview.caption',
            parameters: [
                { pathName: 'syxtbyds', parameterName: 'syxtbyd' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/module/syxtbydedit-view/syxtbydedit-view.vue'),
    },
    {
        path: '/orgs/:org?/usr2pickupview/:usr2pickupview?',
        meta: {
            caption: 'org.views.usr2pickupview.caption',
            parameters: [
                { pathName: 'orgs', parameterName: 'org' },
                { pathName: 'usr2pickupview', parameterName: 'usr2pickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/external/orgusr2-pickup-view/orgusr2-pickup-view.vue'),
    },
    {
        path: '/orgs/:org?/pickupgridview/:pickupgridview?',
        meta: {
            caption: 'org.views.pickupgridview.caption',
            parameters: [
                { pathName: 'orgs', parameterName: 'org' },
                { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ungroup/orgpickup-grid-view/orgpickup-grid-view.vue'),
    },
    {
        path: '/sjzdxes/:sjzdx?/gridview9/:gridview9?',
        meta: {
            caption: 'sjzdx.views.gridview9.caption',
            parameters: [
                { pathName: 'sjzdxes', parameterName: 'sjzdx' },
                { pathName: 'gridview9', parameterName: 'gridview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/module/sjzdxgrid-view9/sjzdxgrid-view9.vue'),
    },
    {
        path: '/orgusers/:orguser?/pickupgridview/:pickupgridview?',
        meta: {
            caption: 'orguser.views.pickupgridview.caption',
            parameters: [
                { pathName: 'orgusers', parameterName: 'orguser' },
                { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ungroup/orguserpickup-grid-view/orguserpickup-grid-view.vue'),
    },
    {
        path: '/cpxhs/:cpxh?/pickupgridview/:pickupgridview?',
        meta: {
            caption: 'cpxh.views.pickupgridview.caption',
            parameters: [
                { pathName: 'cpxhs', parameterName: 'cpxh' },
                { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ungroup/cpxhpickup-grid-view/cpxhpickup-grid-view.vue'),
    },
    {
        path: '/cids/:cid?/editview/:editview?',
        meta: {
            caption: 'cid.views.editview.caption',
            parameters: [
                { pathName: 'cids', parameterName: 'cid' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/module/cidedit-view/cidedit-view.vue'),
    },
    {
        path: '/cids/:cid?/syxxxes/:syxxx?/gridview9/:gridview9?',
        meta: {
            caption: 'syxxx.views.gridview9.caption',
            parameters: [
                { pathName: 'cids', parameterName: 'cid' },
                { pathName: 'syxxxes', parameterName: 'syxxx' },
                { pathName: 'gridview9', parameterName: 'gridview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/module/syxxxgrid-view9/syxxxgrid-view9.vue'),
    },
    {
        path: '/syxxxes/:syxxx?/gridview9/:gridview9?',
        meta: {
            caption: 'syxxx.views.gridview9.caption',
            parameters: [
                { pathName: 'syxxxes', parameterName: 'syxxx' },
                { pathName: 'gridview9', parameterName: 'gridview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/module/syxxxgrid-view9/syxxxgrid-view9.vue'),
    },
    {
        path: '/dbds/:dbd?/gridview/:gridview?',
        meta: {
            caption: 'dbd.views.gridview.caption',
            parameters: [
                { pathName: 'dbds', parameterName: 'dbd' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/module/dbdgrid-view/dbdgrid-view.vue'),
    },
    {
        path: '/cids/:cid?/jqxtbyds/:jqxtbyd?/gridview9/:gridview9?',
        meta: {
            caption: 'jqxtbyd.views.gridview9.caption',
            parameters: [
                { pathName: 'cids', parameterName: 'cid' },
                { pathName: 'jqxtbyds', parameterName: 'jqxtbyd' },
                { pathName: 'gridview9', parameterName: 'gridview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/module/jqxtbydgrid-view9/jqxtbydgrid-view9.vue'),
    },
    {
        path: '/jqxtbyds/:jqxtbyd?/gridview9/:gridview9?',
        meta: {
            caption: 'jqxtbyd.views.gridview9.caption',
            parameters: [
                { pathName: 'jqxtbyds', parameterName: 'jqxtbyd' },
                { pathName: 'gridview9', parameterName: 'gridview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/module/jqxtbydgrid-view9/jqxtbydgrid-view9.vue'),
    },
        {
            path: '/login/:login?',
            name: 'login',
            meta: {  
                caption: '登录',
                viewType: 'login',
                requireAuth: false,
                ignoreAddPage: true,
            },
            beforeEnter: (to: any, from: any, next: any) => {
                router.app.$store.commit('resetRootStateData');
                next();
            },
            component: () => import('@components/login/login.vue'),
        },
        {
            path: '/404',
            component: () => import('@components/404/404.vue')
        },
        {
            path: '/500',
            component: () => import('@components/500/500.vue')
        },
        {
            path: '*',
            redirect: 'appindexview'
        },
    ],
});

export default router;
