import qs from 'qs';
import { MockAdapter } from '@/mock/mock-adapter';
const mock = MockAdapter.getInstance();

// 模拟数据
const mockDatas: Array<any> = [
    {"orguserid":"22","orgid":null,"orgname":null,"createdate":"2020-03-09 00:24:10","updateman":"示例操作者","updatedate":"2020-03-09 00:24:10","createman":"示例操作者","orgusername":"Test","srfkey":"22"},
    {"orguserid":"23","orgid":null,"orgname":null,"createdate":"2020-03-09 00:24:10","updateman":"示例操作者","updatedate":"2020-03-09 00:24:10","createman":"示例操作者","orgusername":"Test(1)","srfkey":"23"},
    {"orguserid":"24","orgid":null,"orgname":null,"createdate":"2020-03-09 00:24:10","updateman":"示例操作者","updatedate":"2020-03-09 00:24:10","createman":"示例操作者","orgusername":"Test(2)","srfkey":"24"},
    {"orguserid":"25","orgid":null,"orgname":null,"createdate":"2020-03-09 00:24:10","updateman":"示例操作者","updatedate":"2020-03-09 00:24:10","createman":"示例操作者","orgusername":"Test(3)","srfkey":"25"},
    {"orguserid":"26","orgid":null,"orgname":null,"createdate":"2020-03-09 00:24:10","updateman":"示例操作者","updatedate":"2020-03-09 00:24:10","createman":"示例操作者","orgusername":"Test(4)","srfkey":"26"},
    {"orguserid":"27","orgid":null,"orgname":null,"createdate":"2020-03-09 00:24:10","updateman":"示例操作者","updatedate":"2020-03-09 00:24:10","createman":"示例操作者","orgusername":"Test(5)","srfkey":"27"}
];



// Select
mock.onGet(new RegExp(/^\/orgusers\/([a-zA-Z0-9\-\;]{1,35})\/select$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['orguserid'];
    const matchArray:any = new RegExp(/^\/orgusers\/([a-zA-Z0-9\-\;]{1,35})\/select$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.orguserid, tempValue.orguserid));
    return [status, _items];
});

        
// Create
mock.onPost(new RegExp(/^\/orgusers\/?([a-zA-Z0-9\-\;]{0,35})$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['orguserid'];
    const matchArray:any = new RegExp(/^\/orgusers\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    return [status, mockDatas[0]];
});


// GetDraft
mock.onGet(new RegExp(/^\/orgusers\/getdraft$/)).reply((config: any) => {
    // GetDraft
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    return [status, {
    }];
});

        
// Update
mock.onPut(new RegExp(/^\/orgusers\/?([a-zA-Z0-9\-\;]{0,35})$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['orguserid'];
    const matchArray:any = new RegExp(/^\/orgusers\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.orguserid, tempValue.orguserid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['orguserid'] == tempValue['orguserid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    return [status, data];
});

// Get
mock.onGet(new RegExp(/^\/orgusers\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['orguserid'];
    const matchArray:any = new RegExp(/^\/orgusers\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.orguserid, tempValue.orguserid));
    return [status, _items?_items:{}];
});

        
// CheckKey
mock.onPost(new RegExp(/^\/orgusers\/?([a-zA-Z0-9\-\;]{0,35})\/checkkey$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['orguserid'];
    const matchArray:any = new RegExp(/^\/orgusers\/([a-zA-Z0-9\-\;]{1,35})\/checkkey$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.orguserid, tempValue.orguserid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['orguserid'] == tempValue['orguserid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    return [status, data];
});

// Remove
mock.onDelete(new RegExp(/^\/orgusers\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['orguserid'];
    const matchArray:any = new RegExp(/^\/orgusers\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.orguserid, tempValue.orguserid));
    return [status, _items?_items:{}];
});

        
// Save
mock.onPost(new RegExp(/^\/orgusers\/?([a-zA-Z0-9\-\;]{0,35})\/save$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['orguserid'];
    const matchArray:any = new RegExp(/^\/orgusers\/([a-zA-Z0-9\-\;]{1,35})\/save$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.orguserid, tempValue.orguserid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['orguserid'] == tempValue['orguserid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    return [status, data];
});

    
// FetchCurOrgUser
mock.onGet(new RegExp(/^\/orgusers\/fetchcurorguser$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    return [status, mockDatas ? mockDatas : []];
});


// FetchCurOrgUser
mock.onGet(new RegExp(/^\/orgusers\/fetchcurorguser(\?[\w-./?%&=]*)*$/)).reply((config: any) => {
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if((config.page-1)*config.size < total){
      records = mockDatas.slice(config.page,config.size);
    }
    return [status, records ?  records : []];
});



    
// FetchDefault
mock.onGet(new RegExp(/^\/orgusers\/fetchdefault$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    return [status, mockDatas ? mockDatas : []];
});


// FetchDefault
mock.onGet(new RegExp(/^\/orgusers\/fetchdefault(\?[\w-./?%&=]*)*$/)).reply((config: any) => {
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if((config.page-1)*config.size < total){
      records = mockDatas.slice(config.page,config.size);
    }
    return [status, records ?  records : []];
});



// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现
