import qs from 'qs';
import { MockAdapter } from '@/mock/mock-adapter';
const mock = MockAdapter.getInstance();

// 模拟数据
const mockDatas: Array<any> = [
    {"ssnf":null,"zbzl":null,"bz":null,"createdate":"2020-03-09 00:24:10","updateman":"示例操作者","abl":null,"sccs":null,"srfkey":"16","bm":null,"hdzk":null,"cllxms":null,"cxdm":null,"dycpxh":null,"cpxhid":"16","clsjjz":null,"cx":null,"hdzzl":null,"xcgzj":null,"gl":null,"cpxhname":"Test","pl":null,"hpds":null,"updatedate":"2020-03-09 00:24:10","pp":null,"createman":"示例操作者"},
    {"ssnf":null,"zbzl":null,"bz":null,"createdate":"2020-03-09 00:24:10","updateman":"示例操作者","abl":null,"sccs":null,"srfkey":"17","bm":null,"hdzk":null,"cllxms":null,"cxdm":null,"dycpxh":null,"cpxhid":"17","clsjjz":null,"cx":null,"hdzzl":null,"xcgzj":null,"gl":null,"cpxhname":"Test(1)","pl":null,"hpds":null,"updatedate":"2020-03-09 00:24:10","pp":null,"createman":"示例操作者"},
    {"ssnf":null,"zbzl":null,"bz":null,"createdate":"2020-03-09 00:24:10","updateman":"示例操作者","abl":null,"sccs":null,"srfkey":"18","bm":null,"hdzk":null,"cllxms":null,"cxdm":null,"dycpxh":null,"cpxhid":"18","clsjjz":null,"cx":null,"hdzzl":null,"xcgzj":null,"gl":null,"cpxhname":"Test(2)","pl":null,"hpds":null,"updatedate":"2020-03-09 00:24:10","pp":null,"createman":"示例操作者"},
    {"ssnf":null,"zbzl":null,"bz":null,"createdate":"2020-03-09 00:24:10","updateman":"示例操作者","abl":null,"sccs":null,"srfkey":"19","bm":null,"hdzk":null,"cllxms":null,"cxdm":null,"dycpxh":null,"cpxhid":"19","clsjjz":null,"cx":null,"hdzzl":null,"xcgzj":null,"gl":null,"cpxhname":"Test(3)","pl":null,"hpds":null,"updatedate":"2020-03-09 00:24:10","pp":null,"createman":"示例操作者"},
    {"ssnf":null,"zbzl":null,"bz":null,"createdate":"2020-03-09 00:24:10","updateman":"示例操作者","abl":null,"sccs":null,"srfkey":"20","bm":null,"hdzk":null,"cllxms":null,"cxdm":null,"dycpxh":null,"cpxhid":"20","clsjjz":null,"cx":null,"hdzzl":null,"xcgzj":null,"gl":null,"cpxhname":"Test(4)","pl":null,"hpds":null,"updatedate":"2020-03-09 00:24:10","pp":null,"createman":"示例操作者"},
    {"ssnf":null,"zbzl":null,"bz":null,"createdate":"2020-03-09 00:24:10","updateman":"示例操作者","abl":null,"sccs":null,"srfkey":"21","bm":null,"hdzk":null,"cllxms":null,"cxdm":null,"dycpxh":null,"cpxhid":"21","clsjjz":null,"cx":null,"hdzzl":null,"xcgzj":null,"gl":null,"cpxhname":"Test(5)","pl":null,"hpds":null,"updatedate":"2020-03-09 00:24:10","pp":null,"createman":"示例操作者"}
];



// Select
mock.onGet(new RegExp(/^\/cpxhs\/([a-zA-Z0-9\-\;]{1,35})\/select$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['cpxhid'];
    const matchArray:any = new RegExp(/^\/cpxhs\/([a-zA-Z0-9\-\;]{1,35})\/select$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.cpxhid, tempValue.cpxhid));
    return [status, _items];
});

        
// Create
mock.onPost(new RegExp(/^\/cpxhs\/?([a-zA-Z0-9\-\;]{0,35})$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['cpxhid'];
    const matchArray:any = new RegExp(/^\/cpxhs\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    return [status, mockDatas[0]];
});

        
// Update
mock.onPut(new RegExp(/^\/cpxhs\/?([a-zA-Z0-9\-\;]{0,35})$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['cpxhid'];
    const matchArray:any = new RegExp(/^\/cpxhs\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.cpxhid, tempValue.cpxhid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['cpxhid'] == tempValue['cpxhid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    return [status, data];
});


// GetDraft
mock.onGet(new RegExp(/^\/cpxhs\/getdraft$/)).reply((config: any) => {
    // GetDraft
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    return [status, {
    }];
});

// Remove
mock.onDelete(new RegExp(/^\/cpxhs\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['cpxhid'];
    const matchArray:any = new RegExp(/^\/cpxhs\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.cpxhid, tempValue.cpxhid));
    return [status, _items?_items:{}];
});

        
// CheckKey
mock.onPost(new RegExp(/^\/cpxhs\/?([a-zA-Z0-9\-\;]{0,35})\/checkkey$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['cpxhid'];
    const matchArray:any = new RegExp(/^\/cpxhs\/([a-zA-Z0-9\-\;]{1,35})\/checkkey$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.cpxhid, tempValue.cpxhid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['cpxhid'] == tempValue['cpxhid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    return [status, data];
});

        
// Save
mock.onPost(new RegExp(/^\/cpxhs\/?([a-zA-Z0-9\-\;]{0,35})\/save$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['cpxhid'];
    const matchArray:any = new RegExp(/^\/cpxhs\/([a-zA-Z0-9\-\;]{1,35})\/save$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.cpxhid, tempValue.cpxhid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['cpxhid'] == tempValue['cpxhid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    return [status, data];
});

// Get
mock.onGet(new RegExp(/^\/cpxhs\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['cpxhid'];
    const matchArray:any = new RegExp(/^\/cpxhs\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.cpxhid, tempValue.cpxhid));
    return [status, _items?_items:{}];
});

    
// FetchDefault
mock.onGet(new RegExp(/^\/cpxhs\/fetchdefault$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    return [status, mockDatas ? mockDatas : []];
});


// FetchDefault
mock.onGet(new RegExp(/^\/cpxhs\/fetchdefault(\?[\w-./?%&=]*)*$/)).reply((config: any) => {
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if((config.page-1)*config.size < total){
      records = mockDatas.slice(config.page,config.size);
    }
    return [status, records ?  records : []];
});



// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现
