import { Http,Util } from '@/utils';
import EntityService from '../entity-service';
import GenratePersonFileLogic from '@/service/pim-person/genrate-person-file-logic';
import GetJTLXRDHLogic from '@/service/pim-person/get-jtlxrdh-logic';
import PersonUpdateInfoLogic from '@/service/pim-person/person-update-info-logic';



/**
 * 人员信息服务对象基类
 *
 * @export
 * @class PimPersonServiceBase
 * @extends {EntityServie}
 */
export default class PimPersonServiceBase extends EntityService {

    /**
     * Creates an instance of  PimPersonServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  PimPersonServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof PimPersonServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='pimperson';
        this.APPDEKEY = 'pimpersonid';
        this.APPDENAME = 'pimpeople';
        this.APPDETEXT = 'pimpersonname';
        this.APPNAME = 'ehratt';
        this.SYSTEMNAME = 'ehr_practice05';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().get(`/pimpeople/${context.pimperson}/select`,isloading);
            
            return res;
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/pimpeople`,data,isloading);
        this.tempStorage.setItem(tempContext.srfsessionkey+'_attendancemreportmxes',JSON.stringify(res.data.attendancemreportmxes?res.data.attendancemreportmxes:[]));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_attendancerecords',JSON.stringify(res.data.attendancerecords?res.data.attendancerecords:[]));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_attendancesettings',JSON.stringify(res.data.attendancesettings?res.data.attendancesettings:[]));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_vacleavemanages',JSON.stringify(res.data.vacleavemanages?res.data.vacleavemanages:[]));
        
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/pimpeople/${context.pimperson}`,data,isloading);
            
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().delete(`/pimpeople/${context.pimperson}`,isloading);
                let genratepersonfile:GenratePersonFileLogic = new GenratePersonFileLogic({context:JSON.parse(JSON.stringify(context)),data:JSON.parse(JSON.stringify(res)).data});
            let genratepersonfileData:any = await genratepersonfile.onExecute(context,res.data,isloading?true:false);
            res ={status:200,data:genratepersonfileData};

            return res;
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = await Http.getInstance().get(`/pimpeople/${context.pimperson}`,isloading);
            
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any = await  Http.getInstance().get(`/pimpeople/getdraft`,isloading);
        res.data.pimperson = data.pimperson;
        
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().post(`/pimpeople/${context.pimperson}/checkkey`,data,isloading);
            return res;
    }

    /**
     * FillPersonType接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FillPersonType(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().post(`/pimpeople/${context.pimperson}/fillpersontype`,data,isloading);
            return res;
    }

    /**
     * GeneratePersonFile接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async GeneratePersonFile(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().post(`/pimpeople/${context.pimperson}/generatepersonfile`,data,isloading);
            return res;
    }

    /**
     * GetJTLXRDH接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async GetJTLXRDH(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let appLogic:GetJTLXRDHLogic = new GetJTLXRDHLogic({context:JSON.parse(JSON.stringify(context)),data:JSON.parse(JSON.stringify(data))});
        const res = await appLogic.onExecute(context,data,isloading?true:false);
        return {status:200,data:res};
    }

    /**
     * PersonUpdateInfo接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async PersonUpdateInfo(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().put(`/pimpeople/${context.pimperson}/personupdateinfo`,data,isloading);
            return res;
    }

    /**
     * QRTX接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async QRTX(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().post(`/pimpeople/${context.pimperson}/qrtx`,data,isloading);
            return res;
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/pimpeople/${context.pimperson}/save`,data,isloading);
            
            return res;
    }

    /**
     * SynPerson接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async SynPerson(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().post(`/pimpeople/${context.pimperson}/synperson`,data,isloading);
            return res;
    }

    /**
     * ToggleLeader接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async ToggleLeader(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().post(`/pimpeople/${context.pimperson}/toggleleader`,data,isloading);
            return res;
    }

    /**
     * YZSFYZFP接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async YZSFYZFP(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().post(`/pimpeople/${context.pimperson}/yzsfyzfp`,data,isloading);
            return res;
    }

    /**
     * FetchAuthPerson接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchAuthPerson(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchauthperson`,tempData,isloading);
        return res;
    }

    /**
     * FetchBYLYG接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchBYLYG(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchbylyg`,tempData,isloading);
        return res;
    }

    /**
     * FetchCurJHRY接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchCurJHRY(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchcurjhry`,tempData,isloading);
        return res;
    }

    /**
     * FetchCurLeader接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchCurLeader(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchcurleader`,tempData,isloading);
        return res;
    }

    /**
     * FetchCurOrgPerson接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchCurOrgPerson(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchcurorgperson`,tempData,isloading);
        return res;
    }

    /**
     * FetchCurOrgPimperson接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchCurOrgPimperson(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchcurorgpimperson`,tempData,isloading);
        return res;
    }

    /**
     * FetchDTXYG接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchDTXYG(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchdtxyg`,tempData,isloading);
        return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchdefault`,tempData,isloading);
        return res;
    }

    /**
     * FetchGBHMC接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchGBHMC(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchgbhmc`,tempData,isloading);
        return res;
    }

    /**
     * FetchGZDQGL接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchGZDQGL(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchgzdqgl`,tempData,isloading);
        return res;
    }

    /**
     * FetchJLSSGR接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchJLSSGR(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchjlssgr`,tempData,isloading);
        return res;
    }

    /**
     * FetchJXQKZZRY接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchJXQKZZRY(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchjxqkzzry`,tempData,isloading);
        return res;
    }

    /**
     * FetchJXQYGCX接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchJXQYGCX(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchjxqygcx`,tempData,isloading);
        return res;
    }

    /**
     * FetchKFPRY接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchKFPRY(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchkfpry`,tempData,isloading);
        return res;
    }

    /**
     * FetchKGZRY接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchKGZRY(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchkgzry`,tempData,isloading);
        return res;
    }

    /**
     * FetchKQJRYCX接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchKQJRYCX(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchkqjrycx`,tempData,isloading);
        return res;
    }

    /**
     * FetchKTXYG接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchKTXYG(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchktxyg`,tempData,isloading);
        return res;
    }

    /**
     * FetchKXZSYQKZZRYDS接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchKXZSYQKZZRYDS(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchkxzsyqkzzryds`,tempData,isloading);
        return res;
    }

    /**
     * FetchKZJBDRY接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchKZJBDRY(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchkzjbdry`,tempData,isloading);
        return res;
    }

    /**
     * FetchLTXSTAFF接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchLTXSTAFF(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchltxstaff`,tempData,isloading);
        return res;
    }

    /**
     * FetchLZRYHMC接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchLZRYHMC(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchlzryhmc`,tempData,isloading);
        return res;
    }

    /**
     * FetchREP_PERSONAGE接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchREP_PERSONAGE(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchrep_personage`,tempData,isloading);
        return res;
    }

    /**
     * FetchREP_PERSONORGTYPE接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchREP_PERSONORGTYPE(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchrep_personorgtype`,tempData,isloading);
        return res;
    }

    /**
     * FetchRYZT_30接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchRYZT_30(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchryzt_30`,tempData,isloading);
        return res;
    }

    /**
     * FetchSELFHELPID接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchSELFHELPID(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchselfhelpid`,tempData,isloading);
        return res;
    }

    /**
     * FetchSFHMD接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchSFHMD(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchsfhmd`,tempData,isloading);
        return res;
    }

    /**
     * FetchSSTRERSONINFO接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchSSTRERSONINFO(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchsstrersoninfo`,tempData,isloading);
        return res;
    }

    /**
     * FetchSYQKZZRY接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchSYQKZZRY(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchsyqkzzry`,tempData,isloading);
        return res;
    }

    /**
     * FetchSYQYGCX接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchSYQYGCX(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchsyqygcx`,tempData,isloading);
        return res;
    }

    /**
     * FetchSetAttRules接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchSetAttRules(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchsetattrules`,tempData,isloading);
        return res;
    }

    /**
     * FetchSetSocArchives接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchSetSocArchives(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchsetsocarchives`,tempData,isloading);
        return res;
    }

    /**
     * FetchTXGB接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchTXGB(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchtxgb`,tempData,isloading);
        return res;
    }

    /**
     * FetchTXRYCX接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchTXRYCX(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchtxrycx`,tempData,isloading);
        return res;
    }

    /**
     * FetchTitleUse接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchTitleUse(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchtitleuse`,tempData,isloading);
        return res;
    }

    /**
     * FetchXMBRYCX接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchXMBRYCX(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchxmbrycx`,tempData,isloading);
        return res;
    }

    /**
     * FetchXZKQRY接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchXZKQRY(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchxzkqry`,tempData,isloading);
        return res;
    }

    /**
     * FetchYGXXGLY接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchYGXXGLY(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchygxxgly`,tempData,isloading);
        return res;
    }

    /**
     * FetchYXZFPRYDS接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PimPersonServiceBase
     */
    public async FetchYXZFPRYDS(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/pimpeople/fetchyxzfpryds`,tempData,isloading);
        return res;
    }
}