/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'userroledataid',
          prop: 'userroledataid',
          dataType: 'PICKUP',
        },
        {
          name: 'dename',
          prop: 'dename',
          dataType: 'PICKUPDATA',
        },
        {
          name: 'updateman',
          prop: 'updateman',
          dataType: 'TEXT',
        },
        {
          name: 'userroledataname',
          prop: 'userroledataname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'userrolename',
          prop: 'userrolename',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'updatedate',
          prop: 'updatedate',
          dataType: 'DATETIME',
        },
        {
          name: 'srfmajortext',
          prop: 'userroledatasname',
          dataType: 'TEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'userroledatasid',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'userroledatasid',
          dataType: 'GUID',
        },
        {
          name: 'userroleid',
          prop: 'userroleid',
          dataType: 'PICKUP',
        },
        {
          name: 'userroledatas',
          prop: 'userroledatasid',
        },
      {
        name: 'n_userroledatasname_like',
        prop: 'n_userroledatasname_like',
        dataType: 'TEXT',
      },
      {
        name: 'n_userroledataname_like',
        prop: 'n_userroledataname_like',
        dataType: 'PICKUPTEXT',
      },

        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}