/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'socselfarebaseid',
          prop: 'socselfarebaseid',
          dataType: 'PICKUP',
        },
        {
          name: 'de',
          prop: 'de',
          dataType: 'TEXT',
        },
        {
          name: 'dwbl',
          prop: 'dwbl',
          dataType: 'TEXT',
        },
        {
          name: 'sm',
          prop: 'sm',
          dataType: 'TEXT',
        },
        {
          name: 'sbfllx',
          prop: 'sbfllx',
          dataType: 'SSCODELIST',
        },
        {
          name: 'soccompanywelid',
          prop: 'soccompanywelid',
          dataType: 'PICKUP',
        },
        {
          name: 'updateman',
          prop: 'updateman',
          dataType: 'TEXT',
        },
        {
          name: 'grbl',
          prop: 'grbl',
          dataType: 'TEXT',
        },
        {
          name: 'updatedate',
          prop: 'updatedate',
          dataType: 'DATETIME',
        },
        {
          name: 'srfmajortext',
          prop: 'socselfarebasemxname',
          dataType: 'TEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'socselfarebasemxid',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'socselfarebasemxid',
          dataType: 'GUID',
        },
        {
          name: 'socselfarebasemx',
          prop: 'socselfarebasemxid',
        },
      {
        name: 'n_sbfllx_like',
        prop: 'n_sbfllx_like',
        dataType: 'SSCODELIST',
      },

        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}