/**
 * FAZZSY 部件模型
 *
 * @export
 * @class FAZZSYModel
 */
export default class FAZZSYModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof FAZZSYGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof FAZZSYGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'zw',
          prop: 'zw',
          dataType: 'TEXT',
        },
        {
          name: 'pimfaminfoname',
          prop: 'pimfaminfoname',
          dataType: 'TEXT',
        },
        {
          name: 'gzdw',
          prop: 'gzdw',
          dataType: 'TEXT',
        },
        {
          name: 'pimpersonid',
          prop: 'pimpersonid',
          dataType: 'PICKUP',
        },
        {
          name: 'xb',
          prop: 'xb',
          dataType: 'SSCODELIST',
        },
        {
          name: 'ybrgx',
          prop: 'ybrgx',
          dataType: 'SSCODELIST',
        },
        {
          name: 'srfmajortext',
          prop: 'pimfaminfoname',
          dataType: 'TEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'pimfaminfoid',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'pimfaminfoid',
          dataType: 'GUID',
        },
        {
          name: 'zzmm',
          prop: 'zzmm',
          dataType: 'SSCODELIST',
        },
        {
          name: 'pimpersonname',
          prop: 'pimpersonname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'nl',
          prop: 'nl',
          dataType: 'INT',
        },
        {
          name: 'pimfaminfo',
          prop: 'pimfaminfoid',
        },
        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}