/**
 * ZJBDSQMX 部件模型
 *
 * @export
 * @class ZJBDSQMXModel
 */
export default class ZJBDSQMXModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof ZJBDSQMXGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof ZJBDSQMXGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'ygbh',
          prop: 'ygbh',
          dataType: 'PICKUPDATA',
        },
        {
          name: 'ormorgsectorid',
          prop: 'ormorgsectorid',
          dataType: 'PICKUP',
        },
        {
          name: 'ormpostid',
          prop: 'ormpostid',
          dataType: 'PICKUP',
        },
        {
          name: 'pimpersonid',
          prop: 'pimpersonid',
          dataType: 'PICKUP',
        },
        {
          name: 'ormorgid',
          prop: 'ormorgid',
          dataType: 'PICKUP',
        },
        {
          name: 'zz',
          prop: 'zz',
          dataType: 'PICKUPDATA',
        },
        {
          name: 'xrank',
          prop: 'xrank',
          dataType: 'SSCODELIST',
        },
        {
          name: 'srfmstag',
        },
        {
          name: 'srfmajortext',
          prop: 'pcmbdsqdmxname',
          dataType: 'TEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'pcmbdsqdmxid',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'pcmbdsqdmxid',
          dataType: 'GUID',
        },
        {
          name: 'ormdutyname',
          prop: 'ormdutyname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'sxrq',
          prop: 'sxrq',
          dataType: 'DATE',
        },
        {
          name: 'lzmtrid',
          prop: 'lzmtrid',
          dataType: 'PICKUP',
        },
        {
          name: 'pcmbdsqdid',
          prop: 'pcmbdsqdid',
          dataType: 'PICKUP',
        },
        {
          name: 'fj',
          prop: 'fj',
          dataType: 'LONGTEXT_1000',
        },
        {
          name: 'rank',
          prop: 'rank',
          dataType: 'PICKUPDATA',
        },
        {
          name: 'ormdutyid',
          prop: 'ormdutyid',
          dataType: 'PICKUP',
        },
        {
          name: 'rzwh',
          prop: 'rzwh',
          dataType: 'TEXT',
        },
        {
          name: 'checkstatus',
          prop: 'checkstatus',
          dataType: 'SSCODELIST',
        },
        {
          name: 'ormorgsectorid2',
          prop: 'ormorgsectorid2',
          dataType: 'PICKUP',
        },
        {
          name: 'bm',
          prop: 'bm',
          dataType: 'PICKUPDATA',
        },
        {
          name: 'yzw',
          prop: 'yzw',
          dataType: 'PICKUPDATA',
        },
        {
          name: 'pimpersonname',
          prop: 'pimpersonname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'pcmbdsqdmx',
          prop: 'pcmbdsqdmxid',
        },
      {
        name: 'n_ygbh_like',
        prop: 'n_ygbh_like',
        dataType: 'PICKUPDATA',
      },
      {
        name: 'n_pimpersonname_like',
        prop: 'n_pimpersonname_like',
        dataType: 'PICKUPTEXT',
      },
      {
        name: 'n_sxrq_gtandeq',
        prop: 'n_sxrq_gtandeq',
        dataType: 'DATE',
      },
      {
        name: 'n_sxrq_ltandeq',
        prop: 'n_sxrq_ltandeq',
        dataType: 'DATE',
      },
      {
        name: 'n_checkstatus_eq',
        prop: 'n_checkstatus_eq',
        dataType: 'SSCODELIST',
      },

        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}