import { Http,Util,Errorlog } from '@/utils';
import ControlService from '@/widgets/control-service';
import PCMBDSQDMXService from '@/service/pcmbdsqdmx/pcmbdsqdmx-service';
import ZJBDSQForm_JSModel from './zjbdsqform-js-form-model';
import PIMPERSONService from '@/service/pimperson/pimperson-service';
import ORMORGService from '@/service/ormorg/ormorg-service';
import ORMORGSECTORService from '@/service/ormorgsector/ormorgsector-service';
import ORMDUTYService from '@/service/ormduty/ormduty-service';
import ORMPOSTService from '@/service/ormpost/ormpost-service';


/**
 * ZJBDSQForm_JS 部件服务对象
 *
 * @export
 * @class ZJBDSQForm_JSService
 */
export default class ZJBDSQForm_JSService extends ControlService {

    /**
     * 职级变动明细服务对象
     *
     * @type {PCMBDSQDMXService}
     * @memberof ZJBDSQForm_JSService
     */
    public appEntityService: PCMBDSQDMXService = new PCMBDSQDMXService({ $store: this.getStore() });

    /**
     * 设置从数据模式
     *
     * @type {boolean}
     * @memberof ZJBDSQForm_JSService
     */
    public setTempMode(){
        this.isTempMode = false;
    }

    /**
     * Creates an instance of ZJBDSQForm_JSService.
     * 
     * @param {*} [opts={}]
     * @memberof ZJBDSQForm_JSService
     */
    constructor(opts: any = {}) {
        super(opts);
        this.model = new ZJBDSQForm_JSModel();
    }

    /**
     * 人员信息服务对象
     *
     * @type {PIMPERSONService}
     * @memberof ZJBDSQForm_JSService
     */
    public pimpersonService: PIMPERSONService = new PIMPERSONService();

    /**
     * 组织管理服务对象
     *
     * @type {ORMORGService}
     * @memberof ZJBDSQForm_JSService
     */
    public ormorgService: ORMORGService = new ORMORGService();

    /**
     * 部门管理服务对象
     *
     * @type {ORMORGSECTORService}
     * @memberof ZJBDSQForm_JSService
     */
    public ormorgsectorService: ORMORGSECTORService = new ORMORGSECTORService();

    /**
     * 职务管理服务对象
     *
     * @type {ORMDUTYService}
     * @memberof ZJBDSQForm_JSService
     */
    public ormdutyService: ORMDUTYService = new ORMDUTYService();

    /**
     * 岗位集服务对象
     *
     * @type {ORMPOSTService}
     * @memberof ZJBDSQForm_JSService
     */
    public ormpostService: ORMPOSTService = new ORMPOSTService();

    /**
     * 处理数据
     *
     * @private
     * @param {Promise<any>} promise
     * @returns {Promise<any>}
     * @memberof ZJBDSQForm_JSService
     */
    private doItems(promise: Promise<any>, deKeyField: string, deName: string): Promise<any> {
        return new Promise((resolve, reject) => {
            promise.then((response: any) => {
                if (response && response.status === 200) {
                    const data = response.data;
                    data.forEach((item:any,index:number) =>{
                        item[deName] = item[deKeyField];
                        data[index] = item;
                    });
                    resolve(data);
                } else {
                    reject([])
                }
            }).catch((response: any) => {
                reject([])
            });
        });
    }

    /**
     * 获取跨实体数据集合
     *
     * @param {string} serviceName 服务名称
     * @param {string} interfaceName 接口名称
     * @param {*} data
     * @param {boolean} [isloading]
     * @returns {Promise<any[]>}
     * @memberof  ZJBDSQForm_JSService
     */
    @Errorlog
    public getItems(serviceName: string, interfaceName: string, context: any = {}, data: any, isloading?: boolean): Promise<any[]> {
        if (Object.is(serviceName, 'PIMPERSONService') && Object.is(interfaceName, 'FetchYXZFPRYDS')) {
            return this.doItems(this.pimpersonService.FetchYXZFPRYDS(JSON.parse(JSON.stringify(context)),data, isloading), 'pimpersonid', 'pimperson');
        }
        if (Object.is(serviceName, 'ORMORGService') && Object.is(interfaceName, 'FetchAuthSJYXZZ')) {
            return this.doItems(this.ormorgService.FetchAuthSJYXZZ(JSON.parse(JSON.stringify(context)),data, isloading), 'orgid', 'ormorg');
        }
        if (Object.is(serviceName, 'ORMORGSECTORService') && Object.is(interfaceName, 'FetchCURORMORG')) {
            return this.doItems(this.ormorgsectorService.FetchCURORMORG(JSON.parse(JSON.stringify(context)),data, isloading), 'orgsectorid', 'ormorgsector');
        }
        if (Object.is(serviceName, 'ORMDUTYService') && Object.is(interfaceName, 'FetchCurOrmorgsector')) {
            return this.doItems(this.ormdutyService.FetchCurOrmorgsector(JSON.parse(JSON.stringify(context)),data, isloading), 'ormdutyid', 'ormduty');
        }
        if (Object.is(serviceName, 'ORMPOSTService') && Object.is(interfaceName, 'FetchEJZZGW')) {
            return this.doItems(this.ormpostService.FetchEJZZGW(JSON.parse(JSON.stringify(context)),data, isloading), 'ormpostid', 'ormpost');
        }

        return Promise.reject([])
    }

    /**
     * 启动工作流
     *
     * @param {string} action
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @param {*} [localdata]
     * @returns {Promise<any>}
     * @memberof ZJBDSQForm_JSService
     */
    @Errorlog
    public wfstart(action: string,context: any = {},data: any = {}, isloading?: boolean,localdata?:any): Promise<any> {
        data = this.handleWFData(data);
        context = this.handleRequestData(action,context,data).context;
        return new Promise((resolve: any, reject: any) => {
            let result: Promise<any>;
            const _appEntityService: any = this.appEntityService;
            if (_appEntityService[action] && _appEntityService[action] instanceof Function) {
                result = _appEntityService[action](context,data, isloading,localdata);
            } else {
                result = this.appEntityService.WFStart(context,data, isloading,localdata);
            }
            result.then((response) => {
                this.handleResponse(action, response);
                resolve(response);
            }).catch(response => {
                reject(response);
            });
        });
    }

    /**
     * 提交工作流
     *
     * @param {string} action
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @param {*} [localdata]
     * @returns {Promise<any>}
     * @memberof ZJBDSQForm_JSService
     */
    @Errorlog
    public wfsubmit(action: string,context: any = {}, data: any = {}, isloading?: boolean,localdata?:any): Promise<any> {
        data = this.handleWFData(data,true);
        context = this.handleRequestData(action,context,data).context;
        return new Promise((resolve: any, reject: any) => {
            let result: Promise<any>;
            const _appEntityService: any = this.appEntityService;
            if (_appEntityService[action] && _appEntityService[action] instanceof Function) {
                result = _appEntityService[action](context,data, isloading,localdata);
            } else {
                result = this.appEntityService.WFSubmit(context,data, isloading,localdata);
            }
            result.then((response) => {
                this.handleResponse(action, response);
                resolve(response);
            }).catch(response => {
                reject(response);
            });
        });
    }


    /**
     * 添加数据
     *
     * @param {string} action
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof ZJBDSQForm_JSService
     */
    @Errorlog
    public add(action: string, context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        const {data:Data,context:Context} = this.handleRequestData(action,context,data);
        return new Promise((resolve: any, reject: any) => {
            let result: Promise<any>;
            const _appEntityService: any = this.appEntityService;
            if (_appEntityService[action] && _appEntityService[action] instanceof Function) {
                result = _appEntityService[action](Context,Data, isloading);
            } else {
                result = this.appEntityService.Create(Context,Data, isloading);
            }
            result.then((response) => {
                this.handleResponse(action, response);
                resolve(response);
            }).catch(response => {
                reject(response);
            });
        });
    }

    /**
     * 删除数据
     *
     * @param {string} action
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof ZJBDSQForm_JSService
     */
    @Errorlog
    public delete(action: string, context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        const {data:Data,context:Context} = this.handleRequestData(action,context,data);
        return new Promise((resolve: any, reject: any) => {
            let result: Promise<any>;
            const _appEntityService: any = this.appEntityService;
            if (_appEntityService[action] && _appEntityService[action] instanceof Function) {
                result = _appEntityService[action](Context,Data, isloading);
            } else {
                result = this.appEntityService.Remove(Context,Data, isloading);
            }
            result.then((response) => {
                resolve(response);
            }).catch(response => {
                reject(response);
            });
        });
    }

    /**
     * 修改数据
     *
     * @param {string} action
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof ZJBDSQForm_JSService
     */
    @Errorlog
    public update(action: string, context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        const {data:Data,context:Context} = this.handleRequestData(action,context,data);
        return new Promise((resolve: any, reject: any) => {
            let result: Promise<any>;
            const _appEntityService: any = this.appEntityService;
            if (_appEntityService[action] && _appEntityService[action] instanceof Function) {
                result = _appEntityService[action](Context,Data, isloading);
            } else {
                result = this.appEntityService.Update(Context,Data, isloading);
            }
            result.then((response) => {
                this.handleResponse(action, response);
                resolve(response);
            }).catch(response => {
                reject(response);
            });
        });
    }

    /**
     * 查询数据
     *
     * @param {string} action
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof ZJBDSQForm_JSService
     */
    @Errorlog
    public get(action: string,context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        const {data:Data,context:Context} = this.handleRequestData(action,context,data);
        return new Promise((resolve: any, reject: any) => {
            let result: Promise<any>;
            const _appEntityService: any = this.appEntityService;
            if (_appEntityService[action] && _appEntityService[action] instanceof Function) {
                result = _appEntityService[action](Context,Data, isloading);
            } else {
                result = this.appEntityService.Get(Context,Data, isloading);
            }
            result.then((response) => {
                this.handleResponse(action, response);
                resolve(response);
            }).catch(response => {
                reject(response);
            });
        });
    }

    /**
     * 加载草稿
     *
     * @param {string} action
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof ZJBDSQForm_JSService
     */
    @Errorlog
    public loadDraft(action: string,context: any = {}, data: any = {}, isloading?: boolean): Promise<any> {
        const {data:Data,context:Context} = this.handleRequestData(action,context,data);
        //仿真主键数据
        const PrimaryKey = Util.createUUID();
        Data.pcmbdsqdmxid = PrimaryKey;
        Data.pcmbdsqdmx = PrimaryKey;
        return new Promise((resolve: any, reject: any) => {
            let result: Promise<any>;
            const _appEntityService: any = this.appEntityService;
            if (_appEntityService[action] && _appEntityService[action] instanceof Function) {
                result = _appEntityService[action](Context,Data, isloading);
            } else {
                result = this.appEntityService.GetDraft(Context,Data, isloading);
            }
            result.then((response) => {
                response.data.pcmbdsqdmxid = PrimaryKey;
                this.handleResponse(action, response, true);
                resolve(response);
            }).catch(response => {
                reject(response);
            });
        });
    }

     /**
     * 前台逻辑
     * @param {string} action
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof ZJBDSQForm_JSService
     */
    @Errorlog
    public frontLogic(action:string,context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        const {data:Data,context:Context} = this.handleRequestData(action,context,data);
        return new Promise((resolve: any, reject: any)=>{
            let result: Promise<any>;
            const _appEntityService: any = this.appEntityService;
            if (_appEntityService[action] && _appEntityService[action] instanceof Function) {
                result = _appEntityService[action](Context,Data, isloading);
            } else {
                return Promise.reject({ status: 500, data: { title: '失败', message: '系统异常' } });
            }
            result.then((response) => {
                this.handleResponse(action, response,true);
                resolve(response);
            }).catch(response => {
                reject(response);
            });
        })
    }

    /**
     * 处理请求数据
     * 
     * @param action 行为 
     * @param data 数据
     * @memberof ZJBDSQForm_JSService
     */
    public handleRequestData(action: string,context:any, data: any = {}){
        let mode: any = this.getMode();
        if (!mode && mode.getDataItems instanceof Function) {
            return data;
        }
        let formItemItems: any[] = mode.getDataItems();
        let requestData:any = {};
        formItemItems.forEach((item:any) =>{
            if(item && item.dataType && Object.is(item.dataType,'FONTKEY')){
                if(item && item.prop){
                    requestData[item.prop] = context[item.name];
                }
            }else{
                if(item && item.prop){
                    requestData[item.prop] = data[item.name];
                }
            }
        });
        if(data && data.viewparams){
            Object.assign(requestData,data.viewparams);
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        if(tempContext && tempContext.srfsessionid){
            tempContext.srfsessionkey = tempContext.srfsessionid;
            delete tempContext.srfsessionid;
        }
        return {context:tempContext,data:requestData};
    }

}