/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'xh',
          prop: 'xh',
          dataType: 'INT',
        },
        {
          name: 'ormrankname',
          prop: 'ormrankname',
          dataType: 'TEXT',
        },
        {
          name: 'ormrankid',
          prop: 'ormrankid',
          dataType: 'GUID',
        },
        {
          name: 'jyjlnx',
          prop: 'jyjlnx',
          dataType: 'INT',
        },
        {
          name: 'zjsm',
          prop: 'zjsm',
          dataType: 'TEXT',
        },
        {
          name: 'srfmajortext',
          prop: 'ormrankname',
          dataType: 'TEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'ormrankid',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'ormrankid',
          dataType: 'GUID',
        },
        {
          name: 'ormrank',
          prop: 'ormrankid',
        },
      {
        name: 'n_ormrankname_like',
        prop: 'n_ormrankname_like',
        dataType: 'TEXT',
      },

        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}