import { Http,Util,Errorlog } from '@/utils';
import ControlService from '@/widgets/control-service';
import ShpModel from './shp-appmenu-model';


/**
 * Shp 部件服务对象
 *
 * @export
 * @class ShpService
 */
export default class ShpService extends ControlService {

    /**
     * 设置从数据模式
     *
     * @type {boolean}
     * @memberof ShpService
     */
    public setTempMode(){
        this.isTempMode = false;
    }

    /**
     * Creates an instance of ShpService.
     * 
     * @param {*} [opts={}]
     * @memberof ShpService
     */
    constructor(opts: any = {}) {
        super(opts);
        this.model = new ShpModel();
    }

    /**
     * 获取数据
     *
     * @returns {Promise<any>}
     * @memberof Shp
     */
    @Errorlog
    public get(params: any = {}): Promise<any> {
        return Http.getInstance().get('v7/shpappmenu', params);
    }

}