import { Http,Util,Errorlog } from '@/utils';
import ControlService from '@/widgets/control-service';
import SalModel from './sal-appmenu-model';


/**
 * Sal 部件服务对象
 *
 * @export
 * @class SalService
 */
export default class SalService extends ControlService {

    /**
     * 设置从数据模式
     *
     * @type {boolean}
     * @memberof SalService
     */
    public setTempMode(){
        this.isTempMode = false;
    }

    /**
     * Creates an instance of SalService.
     * 
     * @param {*} [opts={}]
     * @memberof SalService
     */
    constructor(opts: any = {}) {
        super(opts);
        this.model = new SalModel();
    }

    /**
     * 获取数据
     *
     * @returns {Promise<any>}
     * @memberof Sal
     */
    @Errorlog
    public get(params: any = {}): Promise<any> {
        return Http.getInstance().get('v7/salappmenu', params);
    }

}