import { Http,Util,Errorlog } from '@/utils';
import ControlService from '@/widgets/control-service';
import EhrModel from './ehr-appmenu-model';


/**
 * Ehr 部件服务对象
 *
 * @export
 * @class EhrService
 */
export default class EhrService extends ControlService {

    /**
     * 设置从数据模式
     *
     * @type {boolean}
     * @memberof EhrService
     */
    public setTempMode(){
        this.isTempMode = false;
    }

    /**
     * Creates an instance of EhrService.
     * 
     * @param {*} [opts={}]
     * @memberof EhrService
     */
    constructor(opts: any = {}) {
        super(opts);
        this.model = new EhrModel();
    }

    /**
     * 获取数据
     *
     * @returns {Promise<any>}
     * @memberof Ehr
     */
    @Errorlog
    public get(params: any = {}): Promise<any> {
        return Http.getInstance().get('v7/ehrappmenu', params);
    }

}