/**
 * Ehr 部件模型
 *
 * @export
 * @class EhrModel
 */
export default class EhrModel {

    /**
     * 菜单项集合
     *
     * @public
     * @type {any[]}
     * @memberof EhrModel
     */
    public items: any[] = [
        {
	id: '2cb744d50bd8f43153b3a70dab1ea296',
	name: 'menuitem5',
	text: '门户首页',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '门户首页',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: true,
	iconcls: '',
	icon: '../../../img/main/zzgl.png',
	textcls: '',
	appfunctag: 'Auto164',
	resourcetag: 'MHSY',
},
        {
	id: '6102758811cd475eee1eaa2710e340de',
	name: 'menuitem10',
	text: '组织管理',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '组织管理',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '../../../img/newimage/1/peixunjigou.png',
	textcls: '',
	appfunctag: 'Auto130',
	resourcetag: 'ORGANIZATIONMAG',
},
        {
	id: '9a7486c7e02074cce482ed51adf3539b',
	name: 'menuitem64',
	text: '基础管理',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '基础管理',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '../../../img/main/jcgl.png',
	textcls: '',
	appfunctag: 'Auto374',
	resourcetag: 'BASICMODULE',
},
        {
	id: 'f077cff8bf5ae81c6ebcd3323a89195b',
	name: 'menuitem75',
	text: '配置管理',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '配置管理',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '../../../img/main/pzgl.png',
	textcls: '',
	appfunctag: 'Auto450',
	resourcetag: 'CONFIGURATIONMAG',
},
        {
	id: '69bd132c53f8b15e935aee738977f5bb',
	name: 'menuitem1',
	text: '社保福利',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '社保福利',
	expanded: false,
	separator: false,
	hidden: true,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '../../../img/main/sbfl.png',
	textcls: '',
	appfunctag: 'Auto9',
	resourcetag: 'SOCIALSECURITY',
},
        {
	id: '4783d97a4a37c7937d54e40026d295e2',
	name: 'menuitem78',
	text: '薪酬管理',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '薪酬管理',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '../../../img/jcgl/1/xinchouxinxi.png',
	textcls: '',
	appfunctag: 'Auto86',
	resourcetag: 'EXCITATION',
},
        {
	id: '7003d8aedee40d4807718cb2ad83d414',
	name: 'menuitem79',
	text: '培训管理',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '培训管理',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '../../../img/main/kfgl.png',
	textcls: '',
	appfunctag: 'Auto191',
	resourcetag: 'TRAINMANAGEMENT',
},
        {
	id: '5d440e97321b34125b5006f0a2cc7c79',
	name: 'menuitem7',
	text: '干部管理',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '干部管理',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '../../../img/jcgl/1/junzhuanganbu.png',
	textcls: '',
	appfunctag: 'Auto223',
	resourcetag: 'CADREADMIN',
},
        {
	id: '6886c1c0d927d5b40a6b60375d2e914e',
	name: 'menuitem3',
	text: '系统管理',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '系统管理',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '../../../img/main/xtgl.png',
	textcls: '',
	appfunctag: 'Auto369',
	resourcetag: 'SYSTEMMAG',
},
    ];

	/**
	 * 应用功能集合
	 *
	 * @public
	 * @type {any[]}
	 * @memberof EhrModel
	 */
	public funcs: any[] = [
        {
            appfunctag: 'Auto191',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'trmmenu',
            deResParameters: [],
            routepath: '/index/:index?/trmmenu/:trmmenu?',
            parameters: [
                { pathName: 'trmmenu', parameterName: 'trmmenu' },
            ],
        },
        {
            appfunctag: 'Auto86',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'salmenu',
            deResParameters: [],
            routepath: '/index/:index?/salmenu/:salmenu?',
            parameters: [
                { pathName: 'salmenu', parameterName: 'salmenu' },
            ],
        },
        {
            appfunctag: 'Auto450',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'pcmmenu',
            deResParameters: [],
            routepath: '/index/:index?/pcmmenu/:pcmmenu?',
            parameters: [
                { pathName: 'pcmmenu', parameterName: 'pcmmenu' },
            ],
        },
        {
            appfunctag: 'Auto130',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'ormmenu',
            deResParameters: [],
            routepath: '/index/:index?/ormmenu/:ormmenu?',
            parameters: [
                { pathName: 'ormmenu', parameterName: 'ormmenu' },
            ],
        },
        {
            appfunctag: 'Auto369',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'smgmenu',
            deResParameters: [],
            routepath: '/index/:index?/smgmenu/:smgmenu?',
            parameters: [
                { pathName: 'smgmenu', parameterName: 'smgmenu' },
            ],
        },
        {
            appfunctag: 'Auto9',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'socmenu',
            deResParameters: [],
            routepath: '/index/:index?/socmenu/:socmenu?',
            parameters: [
                { pathName: 'socmenu', parameterName: 'socmenu' },
            ],
        },
        {
            appfunctag: 'Auto164',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'potal',
            deResParameters: [],
            routepath: '/index/:index?/potal/:potal?',
            parameters: [
                { pathName: 'potal', parameterName: 'potal' },
            ],
        },
        {
            appfunctag: 'Auto223',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'tiemenu',
            deResParameters: [],
            routepath: '/index/:index?/tiemenu/:tiemenu?',
            parameters: [
                { pathName: 'tiemenu', parameterName: 'tiemenu' },
            ],
        },
        {
            appfunctag: 'Auto374',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'pimmenu',
            deResParameters: [],
            routepath: '/index/:index?/pimmenu/:pimmenu?',
            parameters: [
                { pathName: 'pimmenu', parameterName: 'pimmenu' },
            ],
        },
	];

    /**
     * 获取所有菜单项集合
     *
     * @returns {any[]}
     * @memberof EhrModel
     */
    public getAppMenuItems(): any[] {
        return this.items;
    }

    /**
     * 获取所有应用功能集合
     *
     * @returns {any[]}
     * @memberof EhrModel
     */
    public getAppFuncs(): any[] {
        return this.funcs;
    }
}