import { MockAdapter } from '../mock-adapter';
const mock = MockAdapter.getInstance();

import Mock from 'mockjs'

// 获取全部数组
mock.onGet('./assets/json/data-dictionary.json').reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    return [status, [
        {
        srfkey: 'PARCL_MXZT',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '生效',
                text: '生效',
                "data":"",
                "codename":"Item_10",
                "color": "Blue",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '修改',
                text: '修改',
                "data":"",
                "codename":"Item_20",
                "color": "Cyan",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '失效',
                text: '失效',
                "data":"",
                "codename":"Item_30",
                "color": "Red",
                value: '30',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'ReasonType',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '离职原因',
                text: '离职原因',
                "data":"",
                "codename":"LZYY",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '解聘原因',
                text: '解聘原因',
                "data":"",
                "codename":"JPYY",
                value: '20',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'URDUserDR',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '1',
                label: '建立人',
                text: '建立人',
                "data":"",
                "codename":"CREATEMAN",
                value: 1,
                
                disabled: false,
            },
            {
                id: '2',
                label: '更新人',
                text: '更新人',
                "data":"",
                "codename":"UPDATEMAN",
                value: 2,
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'WFConfigState',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '1',
                label: '正常状态',
                text: '正常状态',
                "data":"",
                "codename":"Item_1",
                value: '1',
                
                disabled: false,
            },
            {
                id: '2',
                label: '暂停状态',
                text: '暂停状态',
                "data":"",
                "codename":"Item_2",
                value: '2',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'ATTCL_Range',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '100',
                label: '100米',
                text: '100米',
                "data":"",
                "codename":"Item_100",
                value: '100',
                
                disabled: false,
            },
            {
                id: '200',
                label: '200米',
                text: '200米',
                "data":"",
                "codename":"Item_200",
                value: '200',
                
                disabled: false,
            },
            {
                id: '300',
                label: '300米',
                text: '300米',
                "data":"",
                "codename":"Item_300",
                value: '300',
                
                disabled: false,
            },
            {
                id: '400',
                label: '400米',
                text: '400米',
                "data":"",
                "codename":"Item_400",
                value: '400',
                
                disabled: false,
            },
            {
                id: '500',
                label: '500米',
                text: '500米',
                "data":"",
                "codename":"Item_500",
                value: '500',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "PIMCL_ZCDJ",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        srfkey: 'URDBCDR',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '1',
                label: '当前条线',
                text: '当前条线',
                "data":"",
                "codename":"CURBC",
                value: 1,
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PARCL_SPZT',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '部门负责人考评',
                text: '部门负责人考评',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '分管领导考评',
                text: '分管领导考评',
                "data":"",
                "codename":"Item_20",
                "color": "Cyan",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '集中述职评审',
                text: '集中述职评审',
                "data":"",
                "codename":"Item_30",
                "color": "Red",
                value: '30',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'CodeList82',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '01',
                label: '1月',
                text: '1月',
                "data":"",
                "codename":"Item_01",
                value: '01',
                
                disabled: false,
            },
            {
                id: '02',
                label: '2月',
                text: '2月',
                "data":"",
                "codename":"Item_02",
                value: '02',
                
                disabled: false,
            },
            {
                id: '03',
                label: '3月',
                text: '3月',
                "data":"",
                "codename":"Item_03",
                value: '03',
                
                disabled: false,
            },
            {
                id: '04',
                label: '4月',
                text: '4月',
                "data":"",
                "codename":"Item_04",
                value: '04',
                
                disabled: false,
            },
            {
                id: '05',
                label: '5月',
                text: '5月',
                "data":"",
                "codename":"Item_05",
                value: '05',
                
                disabled: false,
            },
            {
                id: '06',
                label: '6月',
                text: '6月',
                "data":"",
                "codename":"Item_06",
                value: '06',
                
                disabled: false,
            },
            {
                id: '07',
                label: '7月',
                text: '7月',
                "data":"",
                "codename":"Item_07",
                value: '07',
                
                disabled: false,
            },
            {
                id: '08',
                label: '8月',
                text: '8月',
                "data":"",
                "codename":"Item_08",
                value: '08',
                
                disabled: false,
            },
            {
                id: '09',
                label: '9月',
                text: '9月',
                "data":"",
                "codename":"Item_09",
                value: '09',
                
                disabled: false,
            },
            {
                id: '10',
                label: '10月',
                text: '10月',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '11',
                label: '11月',
                text: '11月',
                "data":"",
                "codename":"Item_11",
                value: '11',
                
                disabled: false,
            },
            {
                id: '12',
                label: '12月',
                text: '12月',
                "data":"",
                "codename":"Item_12",
                value: '12',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'ServiceStartMode',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: 'AUTO',
                label: '自动',
                text: '自动',
                "data":"",
                "codename":"Auto",
                value: 'AUTO',
                
                disabled: false,
            },
            {
                id: 'MANUAL',
                label: '手动',
                text: '手动',
                "data":"",
                "codename":"Manual",
                value: 'MANUAL',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'QQJYWZT',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '拟稿',
                text: '拟稿',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '审批中',
                text: '审批中',
                "data":"",
                "codename":"Item_20",
                "color": "Blue",
                value: '20',
                
                disabled: false,
            },
            {
                id: '25',
                label: '待销假',
                text: '待销假',
                "data":"",
                "codename":"Item_25",
                "color": "Blue",
                value: '25',
                
                disabled: false,
            },
            {
                id: '30',
                label: '已通过',
                text: '已通过',
                "data":"",
                "codename":"Item_30",
                "color": "Green",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '已驳回',
                text: '已驳回',
                "data":"",
                "codename":"Item_40",
                "color": "Red",
                value: '40',
                
                disabled: false,
            },
            {
                id: '50',
                label: '已取消',
                text: '已取消',
                "data":"",
                "codename":"Item_50",
                "color": "Red",
                value: '50',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "PIMCL_ZZMM",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        srfkey: 'PIMCL_LXRY',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '职级变动申请',
                text: '职级变动申请',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '挂职申请',
                text: '挂职申请',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '离职申请',
                text: '离职申请',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '解聘申请',
                text: '解聘申请',
                "data":"",
                "codename":"Item_40",
                value: '40',
                
                disabled: false,
            },
            {
                id: '50',
                label: '待岗申请',
                text: '待岗申请',
                "data":"",
                "codename":"Item_50",
                value: '50',
                
                disabled: false,
            },
            {
                id: '60',
                label: '内退申请',
                text: '内退申请',
                "data":"",
                "codename":"Item_60",
                value: '60',
                
                disabled: false,
            },
            {
                id: '70',
                label: '退休申请',
                text: '退休申请',
                "data":"",
                "codename":"Item_70",
                value: '70',
                
                disabled: false,
            },
            {
                id: '80',
                label: '长期病休申请',
                text: '长期病休申请',
                "data":"",
                "codename":"Item_80",
                value: '80',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PIMCL_EXPACCOUNT',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '老干部活动费',
                text: '老干部活动费',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '津补贴',
                text: '津补贴',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '企业效益奖金',
                text: '企业效益奖金',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '体检费',
                text: '体检费',
                "data":"",
                "codename":"Item_40",
                value: '40',
                
                disabled: false,
            },
            {
                id: '50',
                label: '医疗费',
                text: '医疗费',
                "data":"",
                "codename":"Item_50",
                value: '50',
                
                disabled: false,
            },
            {
                id: '60',
                label: '其他费用（备注明细）',
                text: '其他费用（备注明细）',
                "data":"",
                "codename":"Item_60",
                value: '60',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "WFGotoStep",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"WFUIWizard",
        "appdedataset":"",
        "items": []
    },
    {
        srfkey: 'PIMCL_STAFFTYPE',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '1000',
                label: '需审核',
                text: '需审核',
                "data":"",
                "codename":"Item_1000",
                "color": "Red",
                value: '1000',
                
                disabled: false,
            },
            {
                id: '2000',
                label: '不需审核',
                text: '不需审核',
                "data":"",
                "codename":"Item_2000",
                "color": "Green",
                value: '2000',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PIMCL_XJLX',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '事假',
                text: '事假',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '探亲假',
                text: '探亲假',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '结婚假',
                text: '结婚假',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '丧葬假',
                text: '丧葬假',
                "data":"",
                "codename":"Item_40",
                value: '40',
                
                disabled: false,
            },
            {
                id: '50',
                label: '孕期假',
                text: '孕期假',
                "data":"",
                "codename":"Item_50",
                value: '50',
                
                disabled: false,
            },
            {
                id: '60',
                label: '产假',
                text: '产假',
                "data":"",
                "codename":"Item_60",
                value: '60',
                
                disabled: false,
            },
            {
                id: '70',
                label: '陪产假',
                text: '陪产假',
                "data":"",
                "codename":"Item_70",
                value: '70',
                
                disabled: false,
            },
            {
                id: '80',
                label: '哺乳假',
                text: '哺乳假',
                "data":"",
                "codename":"Item_80",
                value: '80',
                
                disabled: false,
            },
            {
                id: '90',
                label: '病假',
                text: '病假',
                "data":"",
                "codename":"Item_90",
                value: '90',
                
                disabled: false,
            },
            {
                id: '100',
                label: '工伤假',
                text: '工伤假',
                "data":"",
                "codename":"Item_100",
                value: '100',
                
                disabled: false,
            },
            {
                id: '110',
                label: '年休假',
                text: '年休假',
                "data":"",
                "codename":"Item_110",
                value: '110',
                
                disabled: false,
            },
            {
                id: '120',
                label: '调休假',
                text: '调休假',
                "data":"",
                "codename":"Item_120",
                value: '120',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PARCL_JXKHLX',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '月度',
                text: '月度',
                "data":"",
                "codename":"Item_10",
                "color": "Blue",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '季度',
                text: '季度',
                "data":"",
                "codename":"Item_20",
                "color": "BlueViolet",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '半年度',
                text: '半年度',
                "data":"",
                "codename":"Item_30",
                "color": "Brown",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '年度',
                text: '年度',
                "data":"",
                "codename":"Item_40",
                "color": "BurlyWood",
                value: '40',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "UserRoleType",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"UserRoleType",
        "appdedataset":"FetchDefault",
        "items": []
    },
    {
        "srfkey": "TRMCL_PXJGDJ",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        srfkey: 'SALCL_XCJHZT',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '待执行',
                text: '待执行',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '已执行',
                text: '已执行',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '已取消',
                text: '已取消',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'SALCL_YSXLX',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '手工录入',
                text: '手工录入',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '引用规则',
                text: '引用规则',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '引用公式',
                text: '引用公式',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PCMCL_PROFILEType_Search',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '65',
                label: '待报到',
                text: '待报到',
                "data":"",
                "codename":"Item_65",
                "color": "Blue",
                value: '65',
                
                disabled: false,
            },
            {
                id: '70',
                label: '已报到',
                text: '已报到',
                "data":"",
                "codename":"Item_70",
                "color": "Green",
                value: '70',
                
                disabled: false,
            },
            {
                id: '80',
                label: '逾期未报到',
                text: '逾期未报到',
                "data":"",
                "codename":"Item_80",
                "color": "Red",
                value: '80',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "PIMCL_XKML",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        srfkey: 'ServiceContainer',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: 'SC01',
                label: '服务容器01',
                text: '服务容器01',
                "data":"",
                "codename":"Sc01",
                value: 'SC01',
                
                disabled: false,
            },
            {
                id: 'SC02',
                label: '服务容器02',
                text: '服务容器02',
                "data":"",
                "codename":"Sc02",
                value: 'SC02',
                
                disabled: false,
            },
            {
                id: 'SC03',
                label: '服务容器03',
                text: '服务容器03',
                "data":"",
                "codename":"Sc03",
                value: 'SC03',
                
                disabled: false,
            },
            {
                id: 'SC04',
                label: '服务容器04',
                text: '服务容器04',
                "data":"",
                "codename":"Sc04",
                value: 'SC04',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'TRMCL_HJZK',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '优秀',
                text: '优秀',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '良好',
                text: '良好',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '一般',
                text: '一般',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '差',
                text: '差',
                "data":"",
                "codename":"Item_40",
                value: '40',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "PIMCL_ZJLX",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        "srfkey": "PIMCL_JCLX",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        srfkey: 'PIMCL_ZQLX',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '年度',
                text: '年度',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '月度',
                text: '月度',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PCM_CONDITION',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '1',
                label: '全符合',
                text: '全符合',
                "data":"",
                "codename":"Item_1",
                "color": "Blue",
                value: '1',
                
                disabled: false,
            },
            {
                id: '2',
                label: '学科不符合',
                text: '学科不符合',
                "data":"",
                "codename":"Item_2",
                "color": "Red",
                value: '2',
                
                disabled: false,
            },
            {
                id: '3',
                label: '学校不符合',
                text: '学校不符合',
                "data":"",
                "codename":"Item_3",
                "color": "Red",
                value: '3',
                
                disabled: false,
            },
            {
                id: '4',
                label: '全不符合',
                text: '全不符合',
                "data":"",
                "codename":"Item_4",
                "color": "Red",
                value: '4',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "PIMCL_ZCLX",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        srfkey: 'PCMCL_YYDJ',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: 'CET-4',
                text: 'CET-4',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: 'CET-6',
                text: 'CET-6',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '英语专四',
                text: '英语专四',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '英语专八',
                text: '英语专八',
                "data":"",
                "codename":"Item_40",
                value: '40',
                
                disabled: false,
            },
            {
                id: '50',
                label: '其他语言',
                text: '其他语言',
                "data":"",
                "codename":"Item_50",
                value: '50',
                
                disabled: false,
            },
            {
                id: '60',
                label: '无',
                text: '无',
                "data":"",
                "codename":"Item_60",
                value: '60',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PARCL_GWLX',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '项目经理',
                text: '项目经理',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '项目其他序列岗位人员',
                text: '项目其他序列岗位人员',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "ATTCL_KQLX",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"ATTENDENCETYPE",
        "appdedataset":"FetchDefault",
        "items": []
    },
    {
        srfkey: 'Dkfs',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '打卡机',
                text: '打卡机',
                "data":"",
                "codename":"Item_10",
                "color": "Blue",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '定位打卡',
                text: '定位打卡',
                "data":"",
                "codename":"Item_20",
                "color": "Blue",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '不打卡',
                text: '不打卡',
                "data":"",
                "codename":"Item_30",
                "color": "Red",
                value: '30',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "PIMCL_RANK",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"ORMRANK",
        "appdedataset":"FetchDefault",
        "items": []
    },
    {
        srfkey: 'CodeList83',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '1',
                label: '1季度',
                text: '1季度',
                "data":"",
                "codename":"Item_1",
                value: '1',
                
                disabled: false,
            },
            {
                id: '2',
                label: '2季度',
                text: '2季度',
                "data":"",
                "codename":"Item_2",
                value: '2',
                
                disabled: false,
            },
            {
                id: '3',
                label: '3季度',
                text: '3季度',
                "data":"",
                "codename":"Item_3",
                value: '3',
                
                disabled: false,
            },
            {
                id: '4',
                label: '4季度',
                text: '4季度',
                "data":"",
                "codename":"Item_4",
                value: '4',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "PIMCL_YGLX",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"PIMSTAFFTYPE",
        "appdedataset":"FetchDefault",
        "items": []
    },
    {
        "srfkey": "ORMCL_QY",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"ORMQYGL",
        "appdedataset":"FetchDefault",
        "items": []
    },
    {
        srfkey: 'XMRSXQSH',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '拟稿',
                text: '拟稿',
                "data":"",
                "codename":"Item_10",
                "color": "Green",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '审批中',
                text: '审批中',
                "data":"",
                "codename":"Item_20",
                "color": "BlueViolet",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '审批通过',
                text: '审批通过',
                "data":"",
                "codename":"Item_30",
                "color": "Blue",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '审批不通过',
                text: '审批不通过',
                "data":"",
                "codename":"Item_40",
                "color": "Red",
                value: '40',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PVLayoutMode',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '70P_30P',
                label: '左右布局（70%;30%）',
                text: '左右布局（70%;30%）',
                "data":"",
                "codename":"Item_1",
                value: '70P_30P',
                
                disabled: false,
            },
            {
                id: '30P_70P',
                label: '左右布局（30%;70%）',
                text: '左右布局（30%;70%）',
                "data":"",
                "codename":"Item_2",
                value: '30P_70P',
                
                disabled: false,
            },
            {
                id: '50P_50P',
                label: '左右布局（50%;50%）',
                text: '左右布局（50%;50%）',
                "data":"",
                "codename":"Item_3",
                value: '50P_50P',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "ORMCL_GWTYPE",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        srfkey: 'CodeList5',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: 'USER',
                label: '用户',
                text: '用户',
                "data":"",
                "codename":"User",
                value: 'USER',
                
                disabled: false,
            },
            {
                id: 'USERGROUP',
                label: '用户组',
                text: '用户组',
                "data":"",
                "codename":"Usergroup",
                value: 'USERGROUP',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PIMCL_XMRYLX',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '项目经理',
                text: '项目经理',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '安全总监',
                text: '安全总监',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PARCL_PJ',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: 'A',
                label: 'A',
                text: 'A',
                "data":"",
                "codename":"A",
                value: 'A',
                
                disabled: false,
            },
            {
                id: 'B',
                label: 'B',
                text: 'B',
                "data":"",
                "codename":"B",
                value: 'B',
                
                disabled: false,
            },
            {
                id: 'C',
                label: 'C',
                text: 'C',
                "data":"",
                "codename":"C",
                value: 'C',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "LanguageLevel",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        srfkey: 'PARCL_PJJB',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '优秀',
                text: '优秀',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '良好',
                text: '良好',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '一般',
                text: '一般',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '不合格',
                text: '不合格',
                "data":"",
                "codename":"Item_40",
                value: '40',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PIMCL_ZGZT',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '在岗',
                text: '在岗',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '离岗',
                text: '离岗',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "PIMCL_RANK_JS",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"ORMRANK",
        "appdedataset":"FetchJSRANK",
        "items": []
    },
    {
        srfkey: 'MODBGZT',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '未变更',
                text: '未变更',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '变更审批中',
                text: '变更审批中',
                "data":"",
                "codename":"Item_20",
                "color": "Blue",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '变更审批通过',
                text: '变更审批通过',
                "data":"",
                "codename":"Item_30",
                "color": "Green",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '变更审批不通过',
                text: '变更审批不通过',
                "data":"",
                "codename":"Item_40",
                "color": "Red",
                value: '40',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'HDLX',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '上班',
                text: '上班',
                "data":"",
                "codename":"Item_10",
                "color": "Green",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '休假',
                text: '休假',
                "data":"",
                "codename":"Item_20",
                "color": "Gray",
                value: '20',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PCMCL_SGZT',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: 'SGZ',
                label: '试岗中',
                text: '试岗中',
                "data":"",
                "codename":"Sgz",
                value: 'SGZ',
                
                disabled: false,
            },
            {
                id: 'BTG',
                label: '试岗未通过',
                text: '试岗未通过',
                "data":"",
                "codename":"Btg",
                "color": "（红色）Red",
                value: 'BTG',
                
                disabled: false,
            },
            {
                id: 'TG',
                label: '试岗通过',
                text: '试岗通过',
                "data":"",
                "codename":"Tg",
                "color": "（调和绿）Green",
                value: 'TG',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "JGXZ",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        srfkey: 'MsgType',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '1',
                label: '系统消息',
                text: '系统消息',
                "data":"",
                "codename":"INTERNAL",
                value: 1,
                
                disabled: false,
            },
            {
                id: '2',
                label: '电子邮件',
                text: '电子邮件',
                "data":"",
                "codename":"EMAIL",
                value: 2,
                
                disabled: false,
            },
            {
                id: '4',
                label: '手机短信',
                text: '手机短信',
                "data":"",
                "codename":"SMS",
                value: 4,
                
                disabled: false,
            },
            {
                id: '8',
                label: 'MSN消息',
                text: 'MSN消息',
                "data":"",
                "codename":"MSN",
                value: 8,
                
                disabled: false,
            },
            {
                id: '16',
                label: '检务通消息',
                text: '检务通消息',
                "data":"",
                "codename":"SAIM",
                value: 16,
                
                disabled: false,
            },
            {
                id: '32',
                label: '微信',
                text: '微信',
                "data":"",
                "codename":"WT",
                value: 32,
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "PIM_XL2",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        "srfkey": "CFPLX",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        srfkey: 'PCMCL_ROLETYPE',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '1',
                label: '考勤专员',
                text: '考勤专员',
                "data":"",
                "codename":"Item_1",
                value: 1,
                
                disabled: false,
            },
            {
                id: '2',
                label: '薪酬专员',
                text: '薪酬专员',
                "data":"",
                "codename":"Item_2",
                value: 2,
                
                disabled: false,
            },
            {
                id: '4',
                label: '社保福利专员',
                text: '社保福利专员',
                "data":"",
                "codename":"Item_4",
                value: 4,
                
                disabled: false,
            },
            {
                id: '8',
                label: '档案管理员',
                text: '档案管理员',
                "data":"",
                "codename":"Item_8",
                value: 8,
                
                disabled: false,
            },
            {
                id: '16',
                label: '人事专员',
                text: '人事专员',
                "data":"",
                "codename":"Item_16",
                value: 16,
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'ORMCL_PostNature',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '标准工时制',
                text: '标准工时制',
                "data":"",
                "codename":"Item_10",
                "color": "Green",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '非标准工时制',
                text: '非标准工时制',
                "data":"",
                "codename":"Item_20",
                "color": "BlueViolet",
                value: '20',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PIMCL_GZZT',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '挂职进',
                text: '挂职进',
                "data":"",
                "codename":"Item_10",
                "color": "（深蓝）DarkBlue",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '挂职出',
                text: '挂职出',
                "data":"",
                "codename":"Item_20",
                "color": "（深绿）DarkGreen",
                value: '20',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'ORMCL_XMBLX',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '项目部',
                text: '项目部',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '子项目部',
                text: '子项目部',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PARCL_QDLX',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '开启量化目标填写',
                text: '开启量化目标填写',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '开启量化目标评分',
                text: '开启量化目标评分',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '开启年终绩效评分',
                text: '开启年终绩效评分',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "PCMCL_XKML",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"PCMXKML",
        "appdedataset":"FetchDefault",
        "items": []
    },
    {
        srfkey: 'ORMCL_XMGM',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '特级项目',
                text: '特级项目',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '一级项目',
                text: '一级项目',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '二级项目',
                text: '二级项目',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '三级项目',
                text: '三级项目',
                "data":"",
                "codename":"Item_40",
                value: '40',
                
                disabled: false,
            },
            {
                id: '50',
                label: '四级项目',
                text: '四级项目',
                "data":"",
                "codename":"Item_50",
                value: '50',
                
                disabled: false,
            },
            {
                id: '60',
                label: '五级项目',
                text: '五级项目',
                "data":"",
                "codename":"Item_60",
                value: '60',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "PIMCL_ZJ",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        srfkey: 'PIMCL_YGXXJLSS',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '管理员',
                text: '管理员',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '个人',
                text: '个人',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "PARCL_JXKHX",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"PARKHZCMX",
        "appdedataset":"FetchDefault",
        "items": []
    },
    {
        "srfkey": "PIMCL_TROOPTYPE",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        srfkey: 'ORMCL_ZWLB',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '局级机关',
                text: '局级机关',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '公司级机关',
                text: '公司级机关',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '经理部机关',
                text: '经理部机关',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '项目部',
                text: '项目部',
                "data":"",
                "codename":"Item_40",
                value: '40',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'ORMCL_POST_TYPE',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '0',
                label: '党内',
                text: '党内',
                "data":"",
                "codename":"Item_0",
                value: '0',
                
                disabled: false,
            },
            {
                id: '1',
                label: '行政',
                text: '行政',
                "data":"",
                "codename":"Item_1",
                value: '1',
                
                disabled: false,
            },
            {
                id: '2',
                label: '党内或行政',
                text: '党内或行政',
                "data":"",
                "codename":"Item_2",
                value: '2',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PCMCL_YGBHBGSY',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '5',
                label: '草稿',
                text: '草稿',
                "data":"",
                "codename":"Item_5",
                "color": "Green",
                value: '5',
                
                disabled: false,
            },
            {
                id: '7',
                label: '失效',
                text: '失效',
                "data":"",
                "codename":"Item_7",
                "color": "Darkorange",
                value: '7',
                
                disabled: false,
            },
            {
                id: '10',
                label: '待公司初审',
                text: '待公司初审',
                "data":"",
                "codename":"Item_10",
                "color": "Blue",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '公司初审不通过',
                text: '公司初审不通过',
                "data":"",
                "codename":"Item_20",
                "color": "Red",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '待公司董事长审批',
                text: '待公司董事长审批',
                "data":"",
                "codename":"Item_30",
                "color": "Blue",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '公司董事长不通过',
                text: '公司董事长不通过',
                "data":"",
                "codename":"Item_40",
                "color": "Red",
                value: '40',
                
                disabled: false,
            },
            {
                id: '50',
                label: '待局总部初审',
                text: '待局总部初审',
                "data":"",
                "codename":"Item_50",
                "color": "Blue",
                value: '50',
                
                disabled: false,
            },
            {
                id: '60',
                label: '局总部初审不通过',
                text: '局总部初审不通过',
                "data":"",
                "codename":"Item_60",
                "color": "Red",
                value: '60',
                
                disabled: false,
            },
            {
                id: '65',
                label: '待局总部审核',
                text: '待局总部审核',
                "data":"",
                "codename":"Item_65",
                "color": "Blue",
                value: '65',
                
                disabled: false,
            },
            {
                id: '68',
                label: '局总部审核不通过',
                text: '局总部审核不通过',
                "data":"",
                "codename":"Item_68",
                "color": "Red",
                value: '68',
                
                disabled: false,
            },
            {
                id: '70',
                label: '待局总部审批',
                text: '待局总部审批',
                "data":"",
                "codename":"Item_70",
                "color": "Blue",
                value: '70',
                
                disabled: false,
            },
            {
                id: '80',
                label: '局总部审批不通过',
                text: '局总部审批不通过',
                "data":"",
                "codename":"Item_80",
                "color": "Red",
                value: '80',
                
                disabled: false,
            },
            {
                id: '90',
                label: '审批完成',
                text: '审批完成',
                "data":"",
                "codename":"Item_90",
                "color": "Blue",
                value: '90',
                
                disabled: false,
            },
            {
                id: '100',
                label: '待上报',
                text: '待上报',
                "data":"",
                "codename":"Item_100",
                "color": "Green",
                value: '100',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PARCL_MBLX_BM',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '公司战略分解类',
                text: '公司战略分解类',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '部门职责类',
                text: '部门职责类',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '部门协作类',
                text: '部门协作类',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '通用指标类',
                text: '通用指标类',
                "data":"",
                "codename":"Item_40",
                value: '40',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PCMCL_YPZGWLB',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '房屋建筑类',
                text: '房屋建筑类',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '基础设施类',
                text: '基础设施类',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '金融投资类',
                text: '金融投资类',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '勘察设计类',
                text: '勘察设计类',
                "data":"",
                "codename":"Item_40",
                value: '40',
                
                disabled: false,
            },
            {
                id: '50',
                label: '职能管理类',
                text: '职能管理类',
                "data":"",
                "codename":"Item_50",
                value: '50',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'TRMCL_YYSB',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '投影设备',
                text: '投影设备',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: 'LED设备',
                text: 'LED设备',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '等离子设备',
                text: '等离子设备',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '电脑',
                text: '电脑',
                "data":"",
                "codename":"Item_40",
                value: '40',
                
                disabled: false,
            },
            {
                id: '50',
                label: '视频播放器',
                text: '视频播放器',
                "data":"",
                "codename":"Item_50",
                value: '50',
                
                disabled: false,
            },
            {
                id: '60',
                label: '音响设备',
                text: '音响设备',
                "data":"",
                "codename":"Item_60",
                value: '60',
                
                disabled: false,
            },
            {
                id: '70',
                label: '无线麦克',
                text: '无线麦克',
                "data":"",
                "codename":"Item_70",
                value: '70',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "PIMCL_HY",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        srfkey: 'PCMActionType',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '更新',
                text: '更新',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '更正',
                text: '更正',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'YesNo',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '1',
                label: '是',
                text: '是',
                "data":"",
                "codename":"Item_1",
                value: '1',
                
                disabled: false,
            },
            {
                id: '0',
                label: '否',
                text: '否',
                "data":"",
                "codename":"Item_0",
                value: '0',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "PIMCL_YYZL",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        "srfkey": "PIMCL_RZLB",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        srfkey: 'PIMCL_SF',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '安徽省',
                text: '安徽省',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '澳门特别行政区',
                text: '澳门特别行政区',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '北京市',
                text: '北京市',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '重庆市',
                text: '重庆市',
                "data":"",
                "codename":"Item_40",
                value: '40',
                
                disabled: false,
            },
            {
                id: '50',
                label: '福建省',
                text: '福建省',
                "data":"",
                "codename":"Item_50",
                value: '50',
                
                disabled: false,
            },
            {
                id: '60',
                label: '甘肃省',
                text: '甘肃省',
                "data":"",
                "codename":"Item_60",
                value: '60',
                
                disabled: false,
            },
            {
                id: '70',
                label: '广东省',
                text: '广东省',
                "data":"",
                "codename":"Item_70",
                value: '70',
                
                disabled: false,
            },
            {
                id: '80',
                label: '广西壮族自治区',
                text: '广西壮族自治区',
                "data":"",
                "codename":"Item_80",
                value: '80',
                
                disabled: false,
            },
            {
                id: '90',
                label: '贵州省',
                text: '贵州省',
                "data":"",
                "codename":"Item_90",
                value: '90',
                
                disabled: false,
            },
            {
                id: '100',
                label: '海南省',
                text: '海南省',
                "data":"",
                "codename":"Item_100",
                value: '100',
                
                disabled: false,
            },
            {
                id: '110',
                label: '河北省',
                text: '河北省',
                "data":"",
                "codename":"Item_110",
                value: '110',
                
                disabled: false,
            },
            {
                id: '120',
                label: '黑龙江省',
                text: '黑龙江省',
                "data":"",
                "codename":"Item_120",
                value: '120',
                
                disabled: false,
            },
            {
                id: '130',
                label: '河南省',
                text: '河南省',
                "data":"",
                "codename":"Item_130",
                value: '130',
                
                disabled: false,
            },
            {
                id: '140',
                label: '湖北省',
                text: '湖北省',
                "data":"",
                "codename":"Item_140",
                value: '140',
                
                disabled: false,
            },
            {
                id: '150',
                label: '湖南省',
                text: '湖南省',
                "data":"",
                "codename":"Item_150",
                value: '150',
                
                disabled: false,
            },
            {
                id: '160',
                label: '江苏省',
                text: '江苏省',
                "data":"",
                "codename":"Item_160",
                value: '160',
                
                disabled: false,
            },
            {
                id: '170',
                label: '江西省',
                text: '江西省',
                "data":"",
                "codename":"Item_170",
                value: '170',
                
                disabled: false,
            },
            {
                id: '180',
                label: '吉林省',
                text: '吉林省',
                "data":"",
                "codename":"Item_180",
                value: '180',
                
                disabled: false,
            },
            {
                id: '190',
                label: '辽宁省',
                text: '辽宁省',
                "data":"",
                "codename":"Item_190",
                value: '190',
                
                disabled: false,
            },
            {
                id: '200',
                label: '内蒙古',
                text: '内蒙古',
                "data":"",
                "codename":"Item_200",
                value: '200',
                
                disabled: false,
            },
            {
                id: '210',
                label: '宁夏回族自治区',
                text: '宁夏回族自治区',
                "data":"",
                "codename":"Item_210",
                value: '210',
                
                disabled: false,
            },
            {
                id: '220',
                label: '青海省',
                text: '青海省',
                "data":"",
                "codename":"Item_220",
                value: '220',
                
                disabled: false,
            },
            {
                id: '230',
                label: '陕西省',
                text: '陕西省',
                "data":"",
                "codename":"Item_230",
                value: '230',
                
                disabled: false,
            },
            {
                id: '240',
                label: '山东省',
                text: '山东省',
                "data":"",
                "codename":"Item_240",
                value: '240',
                
                disabled: false,
            },
            {
                id: '250',
                label: '上海市',
                text: '上海市',
                "data":"",
                "codename":"Item_250",
                value: '250',
                
                disabled: false,
            },
            {
                id: '260',
                label: '山西省',
                text: '山西省',
                "data":"",
                "codename":"Item_260",
                value: '260',
                
                disabled: false,
            },
            {
                id: '270',
                label: '四川省',
                text: '四川省',
                "data":"",
                "codename":"Item_270",
                value: '270',
                
                disabled: false,
            },
            {
                id: '280',
                label: '天津市',
                text: '天津市',
                "data":"",
                "codename":"Item_280",
                value: '280',
                
                disabled: false,
            },
            {
                id: '290',
                label: '新疆维吾尔族自治区',
                text: '新疆维吾尔族自治区',
                "data":"",
                "codename":"Item_290",
                value: '290',
                
                disabled: false,
            },
            {
                id: '300',
                label: '西藏自治区',
                text: '西藏自治区',
                "data":"",
                "codename":"Item_300",
                value: '300',
                
                disabled: false,
            },
            {
                id: '310',
                label: '云南省',
                text: '云南省',
                "data":"",
                "codename":"Item_310",
                value: '310',
                
                disabled: false,
            },
            {
                id: '320',
                label: '浙江省',
                text: '浙江省',
                "data":"",
                "codename":"Item_320",
                value: '320',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'WORKSTATE',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '可调配',
                text: '可调配',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '不可调配',
                text: '不可调配',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'WXEntAppType',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: 'H5',
                label: 'H5主页型',
                text: 'H5主页型',
                "data":"",
                "codename":"H5",
                value: 'H5',
                
                disabled: false,
            },
            {
                id: 'MSG',
                label: '消息响应型',
                text: '消息响应型',
                "data":"",
                "codename":"Msg",
                value: 'MSG',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'MsgImportanceLevel',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '100',
                label: '高',
                text: '高',
                "data":"",
                "codename":"HIGH",
                value: 100,
                
                disabled: false,
            },
            {
                id: '50',
                label: '普通',
                text: '普通',
                "data":"",
                "codename":"NORMAL",
                value: 50,
                
                disabled: false,
            },
            {
                id: '10',
                label: '低',
                text: '低',
                "data":"",
                "codename":"LOW",
                value: 10,
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PIMCL_SPZT',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '正常',
                text: '正常',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '待新增审批',
                text: '待新增审批',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '待删除审批',
                text: '待删除审批',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '待更新审批',
                text: '待更新审批',
                "data":"",
                "codename":"Item_40",
                value: '40',
                
                disabled: false,
            },
            {
                id: '50',
                label: '已拒绝',
                text: '已拒绝',
                "data":"",
                "codename":"Item_50",
                value: '50',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "PIMCL_HTLX",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"PIMCONTRACTTYPE",
        "appdedataset":"FetchDefault",
        "items": []
    },
    {
        srfkey: 'PIMCL_BGLX',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '更新',
                text: '更新',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '更正',
                text: '更正',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '删除',
                text: '删除',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'SALCL_BJGZ',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '>',
                label: '>',
                text: '>',
                "data":"",
                "codename":"GT",
                value: '>',
                
                disabled: false,
            },
            {
                id: '>=',
                label: '>=',
                text: '>=',
                "data":"",
                "codename":"GTEQ",
                value: '>=',
                
                disabled: false,
            },
            {
                id: '=',
                label: '=',
                text: '=',
                "data":"",
                "codename":"EQ",
                value: '=',
                
                disabled: false,
            },
            {
                id: '<=',
                label: '<=',
                text: '<=',
                "data":"",
                "codename":"LTEQ",
                value: '<=',
                
                disabled: false,
            },
            {
                id: '<',
                label: '<',
                text: '<',
                "data":"",
                "codename":"LT",
                value: '<',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'DABGDD',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '局总部',
                text: '局总部',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '公司本部',
                text: '公司本部',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '其他',
                text: '其他',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PCMCL_LDZYTYPE',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '1',
                label: '仲裁',
                text: '仲裁',
                "data":"",
                "codename":"Item_1",
                value: '1',
                
                disabled: false,
            },
            {
                id: '2',
                label: '诉讼',
                text: '诉讼',
                "data":"",
                "codename":"Item_2",
                value: '2',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "PIMCL_XWLX",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        "srfkey": "PCMCL_SBLX",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"PIMSTAFFTYPE",
        "appdedataset":"FetchYPZ",
        "items": []
    },
    {
        "srfkey": "NATIVEPLACE",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        srfkey: 'PIMCL_ND2',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '2019',
                label: '2019年',
                text: '2019年',
                "data":"",
                "codename":"Item_2019",
                value: '2019',
                
                disabled: false,
            },
            {
                id: '2020',
                label: '2020年',
                text: '2020年',
                "data":"",
                "codename":"Item_2020",
                value: '2020',
                
                disabled: false,
            },
            {
                id: '2021',
                label: '2021年',
                text: '2021年',
                "data":"",
                "codename":"Item_2021",
                value: '2021',
                
                disabled: false,
            },
            {
                id: '2022',
                label: '2022年',
                text: '2022年',
                "data":"",
                "codename":"Item_2022",
                value: '2022',
                
                disabled: false,
            },
            {
                id: '2023',
                label: '2023年',
                text: '2023年',
                "data":"",
                "codename":"Item_2023",
                value: '2023',
                
                disabled: false,
            },
            {
                id: '2024',
                label: '2024年',
                text: '2024年',
                "data":"",
                "codename":"Item_2024",
                value: '2024',
                
                disabled: false,
            },
            {
                id: '2025',
                label: '2025年',
                text: '2025年',
                "data":"",
                "codename":"Item_2025",
                value: '2025',
                
                disabled: false,
            },
            {
                id: '2026',
                label: '2026年',
                text: '2026年',
                "data":"",
                "codename":"Item_2026",
                value: '2026',
                
                disabled: false,
            },
            {
                id: '2027',
                label: '2027年',
                text: '2027年',
                "data":"",
                "codename":"Item_2027",
                value: '2027',
                
                disabled: false,
            },
            {
                id: '2028',
                label: '2028年',
                text: '2028年',
                "data":"",
                "codename":"Item_2028",
                value: '2028',
                
                disabled: false,
            },
            {
                id: '2029',
                label: '2029年',
                text: '2029年',
                "data":"",
                "codename":"Item_2029",
                value: '2029',
                
                disabled: false,
            },
            {
                id: '2030',
                label: '2030年',
                text: '2030年',
                "data":"",
                "codename":"Item_2030",
                value: '2030',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PCMCL_YesNo',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '1',
                label: '是',
                text: '是',
                "data":"",
                "codename":"Item_1",
                "color": "Red",
                value: 1,
                
                disabled: false,
            },
            {
                id: '0',
                label: '否',
                text: '否',
                "data":"",
                "codename":"Item_0",
                "color": "Feldspar",
                value: 0,
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'JJCD',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '一般',
                text: '一般',
                "data":"",
                "codename":"Item_10",
                "color": "Green",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '紧急',
                text: '紧急',
                "data":"",
                "codename":"Item_20",
                "color": "Orange",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '特急',
                text: '特急',
                "data":"",
                "codename":"Item_30",
                "color": "Red",
                value: '30',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PCMCL_NQGBSPZT',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '入选',
                text: '入选',
                "data":"",
                "codename":"Item_10",
                "color": "DarkGreen",
                value: '10',
                
                disabled: false,
            },
            {
                id: '40',
                label: '退出',
                text: '退出',
                "data":"",
                "codename":"Item_40",
                "color": "Red",
                value: '40',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "ORMCL_EngineeringPurpose",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        srfkey: 'TRMCL_KPXX',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '普通发票',
                text: '普通发票',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '增值税专用发票',
                text: '增值税专用发票',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "SSQY",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        "srfkey": "PIMCL_XB",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        "srfkey": "PIMCL_LEVEL",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        srfkey: 'PIMCL_YW',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '0',
                label: '无',
                text: '无',
                "data":"",
                "codename":"Item_0",
                value: '0',
                
                disabled: false,
            },
            {
                id: '1',
                label: '有',
                text: '有',
                "data":"",
                "codename":"Item_1",
                value: '1',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'SALCL_YSXZJ',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '增加',
                text: '增加',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '扣减',
                text: '扣减',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'ORMCL_XMLX',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '工程总承包',
                text: '工程总承包',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '施工总承包',
                text: '施工总承包',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '专业承包',
                text: '专业承包',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '其他',
                text: '其他',
                "data":"",
                "codename":"Item_40",
                value: '40',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "PIMCL_NATION",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        srfkey: 'RecruitmentType',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '校园招聘',
                text: '校园招聘',
                "data":"",
                "codename":"XYZP",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '社会招聘',
                text: '社会招聘',
                "data":"",
                "codename":"SHZP",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '内部招聘',
                text: '内部招聘',
                "data":"",
                "codename":"NBZP",
                value: '30',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PIMCL_JLCZZ',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: 'ACTION',
                label: '执行',
                text: '执行',
                "data":"",
                "codename":"Action",
                value: 'ACTION',
                
                disabled: false,
            },
            {
                id: 'UNACTION',
                label: '不执行',
                text: '不执行',
                "data":"",
                "codename":"Unaction",
                value: 'UNACTION',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PIMCL_XMJB',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '0',
                label: '特级',
                text: '特级',
                "data":"",
                "codename":"Item_0",
                value: '0',
                
                disabled: false,
            },
            {
                id: '1',
                label: '一级',
                text: '一级',
                "data":"",
                "codename":"Item_1",
                value: '1',
                
                disabled: false,
            },
            {
                id: '2',
                label: '二级',
                text: '二级',
                "data":"",
                "codename":"Item_2",
                value: '2',
                
                disabled: false,
            },
            {
                id: '3',
                label: '三级',
                text: '三级',
                "data":"",
                "codename":"Item_3",
                value: '3',
                
                disabled: false,
            },
            {
                id: '4',
                label: '四级',
                text: '四级',
                "data":"",
                "codename":"Item_4",
                value: '4',
                
                disabled: false,
            },
            {
                id: '5',
                label: '五级',
                text: '五级',
                "data":"",
                "codename":"Item_5",
                value: '5',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "PCMCL_REASON",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"PCMPROFILESPYY",
        "appdedataset":"FetchDefault",
        "items": []
    },
    {
        srfkey: 'PIMCL_LAYERNO',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '上',
                text: '上',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '中',
                text: '中',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '下',
                text: '下',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PARCL_Quarter',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '第一季度',
                text: '第一季度',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '第二季度',
                text: '第二季度',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '第三季度',
                text: '第三季度',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '第四季度',
                text: '第四季度',
                "data":"",
                "codename":"Item_40",
                value: '40',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "ORMCL_ProCapitalAtt",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        "srfkey": "PIMCL_XX",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        "srfkey": "ORMCL_IsDirectlyManage",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        srfkey: 'TRMCL_TSSB',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '同声传译机',
                text: '同声传译机',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '舞台效果设备',
                text: '舞台效果设备',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '会议环节特制设备',
                text: '会议环节特制设备',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '投票设备',
                text: '投票设备',
                "data":"",
                "codename":"Item_40",
                value: '40',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "ORMCL_EngineeringScale",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        srfkey: 'PCMCL_HJDJ',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '80',
                label: '学校校级',
                text: '学校校级',
                "data":"",
                "codename":"Item_80",
                value: '80',
                
                disabled: false,
            },
            {
                id: '90',
                label: '学校院级',
                text: '学校院级',
                "data":"",
                "codename":"Item_90",
                value: '90',
                
                disabled: false,
            },
            {
                id: '10',
                label: '国家级',
                text: '国家级',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '省（自治区、直辖市）级',
                text: '省（自治区、直辖市）级',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '部委级',
                text: '部委级',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '地（市、厅）级',
                text: '地（市、厅）级',
                "data":"",
                "codename":"Item_40",
                value: '40',
                
                disabled: false,
            },
            {
                id: '50',
                label: '区（县）级',
                text: '区（县）级',
                "data":"",
                "codename":"Item_50",
                value: '50',
                
                disabled: false,
            },
            {
                id: '60',
                label: '基层单位',
                text: '基层单位',
                "data":"",
                "codename":"Item_60",
                value: '60',
                
                disabled: false,
            },
            {
                id: '70',
                label: '国际国外',
                text: '国际国外',
                "data":"",
                "codename":"Item_70",
                value: '70',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "PIMCL_KHJL",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        srfkey: 'TRMCL_SPZT',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '已通过',
                text: '已通过',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '已拒绝',
                text: '已拒绝',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "SysOperator",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"",
        "appdedataset":"",
        "items": []
    },
    {
        srfkey: 'PIMCL_DAGHZT',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '借阅中',
                text: '借阅中',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '已归还',
                text: '已归还',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'TRMCL_BGSB',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '办公文具',
                text: '办公文具',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '复印机',
                text: '复印机',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '打印机',
                text: '打印机',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '扫描仪',
                text: '扫描仪',
                "data":"",
                "codename":"Item_40",
                value: '40',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PIMCL_BMLX',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '机关部门',
                text: '机关部门',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '项目部门',
                text: '项目部门',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'TRMCL_JBLX',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '高级',
                text: '高级',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '中级',
                text: '中级',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '初级',
                text: '初级',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'TIEJZMZ',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '0',
                label: '降职',
                text: '降职',
                "data":"",
                "codename":"Item_0",
                value: '0',
                
                disabled: false,
            },
            {
                id: '1',
                label: '免职',
                text: '免职',
                "data":"",
                "codename":"Item_1",
                value: '1',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'VACCL_TQLX',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '探父母',
                text: '探父母',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '探配偶',
                text: '探配偶',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "TRMCL_HYSLX",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"",
        "items": []
    },
    {
        "srfkey": "PIMCL_RANK_JSN",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"ORMRANK",
        "appdedataset":"FetchJSNRANK",
        "items": []
    },
    {
        "srfkey": "PARCL_JXLX",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"PARKHFA",
        "appdedataset":"FetchDefault",
        "items": []
    },
    {
        srfkey: 'ServiceRunState',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: 'START',
                label: '已启动',
                text: '已启动',
                "data":"",
                "codename":"Start",
                value: 'START',
                
                disabled: false,
            },
            {
                id: 'STOP',
                label: '已停止',
                text: '已停止',
                "data":"",
                "codename":"Stop",
                value: 'STOP',
                
                disabled: false,
            },
            {
                id: 'STARTERROR',
                label: '启动错误',
                text: '启动错误',
                "data":"",
                "codename":"Starterror",
                value: 'STARTERROR',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'ZQ',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '上半年度',
                text: '上半年度',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '下半年度',
                text: '下半年度',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '年度',
                text: '年度',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'ORMCL_LegalEntity',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '法人单位',
                text: '法人单位',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '非法人单位',
                text: '非法人单位',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PCMCL_NOTICETYPE',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: 'RZ',
                label: '入职',
                text: '入职',
                "data":"",
                "codename":"Rz",
                value: 'RZ',
                
                disabled: false,
            },
            {
                id: 'DD',
                label: '调动',
                text: '调动',
                "data":"",
                "codename":"Dd",
                value: 'DD',
                
                disabled: false,
            },
            {
                id: 'JD',
                label: '借调',
                text: '借调',
                "data":"",
                "codename":"Jd",
                value: 'JD',
                
                disabled: false,
            },
            {
                id: 'JZ',
                label: '兼职',
                text: '兼职',
                "data":"",
                "codename":"Jz",
                value: 'JZ',
                
                disabled: false,
            },
            {
                id: 'GZ',
                label: '挂职',
                text: '挂职',
                "data":"",
                "codename":"Gz",
                value: 'GZ',
                
                disabled: false,
            },
            {
                id: 'DG',
                label: '待岗',
                text: '待岗',
                "data":"",
                "codename":"Dg",
                value: 'DG',
                
                disabled: false,
            },
            {
                id: 'KDP',
                label: '可调配',
                text: '可调配',
                "data":"",
                "codename":"Kdp",
                value: 'KDP',
                
                disabled: false,
            },
            {
                id: 'NT',
                label: '内退',
                text: '内退',
                "data":"",
                "codename":"Nt",
                value: 'NT',
                
                disabled: false,
            },
            {
                id: 'CQBX',
                label: '长期病休',
                text: '长期病休',
                "data":"",
                "codename":"Cqbx",
                value: 'CQBX',
                
                disabled: false,
            },
            {
                id: 'LZ',
                label: '离职',
                text: '离职',
                "data":"",
                "codename":"Lz",
                value: 'LZ',
                
                disabled: false,
            },
            {
                id: 'JP',
                label: '解聘',
                text: '解聘',
                "data":"",
                "codename":"Jp",
                value: 'JP',
                
                disabled: false,
            },
            {
                id: 'TX',
                label: '退休',
                text: '退休',
                "data":"",
                "codename":"Tx",
                value: 'TX',
                
                disabled: false,
            },
            {
                id: 'TXFP',
                label: '返聘',
                text: '返聘',
                "data":"",
                "codename":"Txfp",
                value: 'TXFP',
                
                disabled: false,
            },
            {
                id: 'XYGZZ',
                label: '新员工转正',
                text: '新员工转正',
                "data":"",
                "codename":"Xygzz",
                value: 'XYGZZ',
                
                disabled: false,
            },
            {
                id: 'JXSZZ',
                label: '见习生转正',
                text: '见习生转正',
                "data":"",
                "codename":"Jxszz",
                value: 'JXSZZ',
                
                disabled: false,
            },
            {
                id: 'BYLYGZZ',
                label: 'B/Y类员工转正',
                text: 'B/Y类员工转正',
                "data":"",
                "codename":"Bylygzz",
                value: 'BYLYGZZ',
                
                disabled: false,
            },
            {
                id: 'ZJBD',
                label: '职级变动',
                text: '职级变动',
                "data":"",
                "codename":"Zjbd",
                value: 'ZJBD',
                
                disabled: false,
            },
            {
                id: '40',
                label: '轮岗到期',
                text: '轮岗到期',
                "data":"",
                "codename":"Item_40",
                value: '40',
                
                disabled: false,
            },
            {
                id: '70',
                label: '挂职到期',
                text: '挂职到期',
                "data":"",
                "codename":"Item_70",
                value: '70',
                
                disabled: false,
            },
            {
                id: '90',
                label: '借调到期',
                text: '借调到期',
                "data":"",
                "codename":"Item_90",
                value: '90',
                
                disabled: false,
            },
            {
                id: '110',
                label: '兼职到期',
                text: '兼职到期',
                "data":"",
                "codename":"Item_110",
                value: '110',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "PIMCL_YGZT",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"",
        "appdedataset":"",
        "items": []
    },
    {
        srfkey: 'ORMCL_JZ',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '刚性',
                text: '刚性',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '柔性',
                text: '柔性',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'JJRLX',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '法定节假日',
                text: '法定节假日',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '年休假',
                text: '年休假',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '调休上班',
                text: '调休上班',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PCMCL_CSFS',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: 'TP',
                label: '投票',
                text: '投票',
                "data":"",
                "codename":"Tp",
                value: 'TP',
                
                disabled: false,
            },
            {
                id: 'TJ',
                label: '推荐',
                text: '推荐',
                "data":"",
                "codename":"Tj",
                value: 'TJ',
                
                disabled: false,
            },
            {
                id: 'QT',
                label: '其他',
                text: '其他',
                "data":"",
                "codename":"Qt",
                value: 'QT',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PCMCL_PASSORREJECT',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '通过',
                text: '通过',
                "data":"",
                "codename":"Item_10",
                "color": "Blue",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '拒绝',
                text: '拒绝',
                "data":"",
                "codename":"Item_20",
                "color": "Red",
                value: '20',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'URDOrgDR',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '1',
                label: '当前机构',
                text: '当前机构',
                "data":"",
                "codename":"Item_1",
                value: 1,
                
                disabled: false,
            },
            {
                id: '2',
                label: '上级机构',
                text: '上级机构',
                "data":"",
                "codename":"Item_2",
                value: 2,
                
                disabled: false,
            },
            {
                id: '4',
                label: '下级机构',
                text: '下级机构',
                "data":"",
                "codename":"Item_4",
                value: 4,
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PCMCL_BBZT',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '当前',
                text: '当前',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '0',
                label: '历史',
                text: '历史',
                "data":"",
                "codename":"Item_0",
                value: '0',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PIMCL_LX',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '调动申请',
                text: '调动申请',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '职务变动申请',
                text: '职务变动申请',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '轮岗申请',
                text: '轮岗申请',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '借调申请',
                text: '借调申请',
                "data":"",
                "codename":"Item_40",
                value: '40',
                
                disabled: false,
            },
            {
                id: '50',
                label: '兼职申请',
                text: '兼职申请',
                "data":"",
                "codename":"Item_50",
                value: '50',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'TRMCL_BJZT',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '立项中',
                text: '立项中',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '培训准备',
                text: '培训准备',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '培训中',
                text: '培训中',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '培训后',
                text: '培训后',
                "data":"",
                "codename":"Item_40",
                value: '40',
                
                disabled: false,
            },
            {
                id: '50',
                label: '已关闭',
                text: '已关闭',
                "data":"",
                "codename":"Item_50",
                value: '50',
                
                disabled: false,
            },
            {
                id: '60',
                label: '已取消',
                text: '已取消',
                "data":"",
                "codename":"Item_60",
                value: '60',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'URDSecDR',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '1',
                label: '当前部门',
                text: '当前部门',
                "data":"",
                "codename":"Item_1",
                value: 1,
                
                disabled: false,
            },
            {
                id: '2',
                label: '上级部门',
                text: '上级部门',
                "data":"",
                "codename":"Item_2",
                value: 2,
                
                disabled: false,
            },
            {
                id: '4',
                label: '下级部门',
                text: '下级部门',
                "data":"",
                "codename":"Item_4",
                value: 4,
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PARCL_TZLX',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '局副总师、助理总经理级领导人员类',
                text: '局副总师、助理总经理级领导人员类',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '职能部门正职类',
                text: '职能部门正职类',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '职能部门（分局、办事处）副职及以下人员类',
                text: '职能部门（分局、办事处）副职及以下人员类',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PCMCL_RCXLLX',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: 'GL',
                label: '管理序列',
                text: '管理序列',
                "data":"",
                "codename":"Gl",
                value: 'GL',
                
                disabled: false,
            },
            {
                id: 'GW',
                label: '顾问序列',
                text: '顾问序列',
                "data":"",
                "codename":"Gw",
                value: 'GW',
                
                disabled: false,
            },
            {
                id: 'ZY',
                label: '专业序列',
                text: '专业序列',
                "data":"",
                "codename":"Zy",
                value: 'ZY',
                
                disabled: false,
            },
            {
                id: 'CZ',
                label: '操作序列',
                text: '操作序列',
                "data":"",
                "codename":"Cz",
                value: 'CZ',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'ORMCL_QTBS',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '1',
                label: '启用',
                text: '启用',
                "data":"",
                "codename":"Item_1",
                "color": "Blue",
                value: '1',
                
                disabled: false,
            },
            {
                id: '0',
                label: '停用',
                text: '停用',
                "data":"",
                "codename":"Item_0",
                "color": "Red",
                value: '0',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "PIMCL_FPZT",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        srfkey: 'TRMCL_JTFS',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '公交',
                text: '公交',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '地铁',
                text: '地铁',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'WFUCPolicyState',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '1',
                label: '未应用',
                text: '未应用',
                "data":"",
                "codename":"NOTAPPLIED",
                value: 1,
                
                disabled: false,
            },
            {
                id: '2',
                label: '已应用',
                text: '已应用',
                "data":"",
                "codename":"APPLIED",
                value: 2,
                
                disabled: false,
            },
            {
                id: '3',
                label: '已过期',
                text: '已过期',
                "data":"",
                "codename":"EXPIRED",
                value: 3,
                
                disabled: false,
            },
            {
                id: '4',
                label: '已取消',
                text: '已取消',
                "data":"",
                "codename":"CANCELED",
                value: 4,
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'TRMCL_JSDJ',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '高级',
                text: '高级',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '中级',
                text: '中级',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '初级',
                text: '初级',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "LZReason",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"PCMReason",
        "appdedataset":"FetchDefault",
        "items": []
    },
    {
        "srfkey": "ORMCL_GW",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"ORMPOST",
        "appdedataset":"FetchDefault",
        "items": []
    },
    {
        srfkey: 'ZSLX',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '执（职）业资格证书',
                text: '执（职）业资格证书',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '5',
                label: '岗位（技能）证书',
                text: '岗位（技能）证书',
                "data":"",
                "codename":"Item_5",
                value: '5',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "SOCCL_XJLX",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"VACLEACETYPE",
        "appdedataset":"FetchDefault",
        "items": []
    },
    {
        srfkey: 'XMRLSF',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '待释放',
                text: '待释放',
                "data":"",
                "codename":"Item_10",
                "color": "Black",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '释放中',
                text: '释放中',
                "data":"",
                "codename":"Item_20",
                "color": "Blue",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '释放完成',
                text: '释放完成',
                "data":"",
                "codename":"Item_30",
                "color": "Green",
                value: '30',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PARCL_MBLX_LD',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '引领目标',
                text: '引领目标',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '服务目标',
                text: '服务目标',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '管理监督目标',
                text: '管理监督目标',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PARCL_JXJD',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '量化目标填报',
                text: '量化目标填报',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '量化目标修正',
                text: '量化目标修正',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '量化目标考核',
                text: '量化目标考核',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PCMCL_PlanState',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '0',
                label: '待执行',
                text: '待执行',
                "data":"",
                "codename":"Item_0",
                "color": "Black",
                value: '0',
                
                disabled: false,
            },
            {
                id: '1',
                label: '已到岗',
                text: '已到岗',
                "data":"",
                "codename":"Item_1",
                "color": "Blue",
                value: '1',
                
                disabled: false,
            },
            {
                id: '2',
                label: '已释放',
                text: '已释放',
                "data":"",
                "codename":"Item_2",
                "color": "DarkCyan",
                value: '2',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "PIMCL_YBRGX",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        srfkey: 'PIMCL_HTZT',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '20',
                label: '存续期',
                text: '存续期',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '已过期',
                text: '已过期',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
            {
                id: '50',
                label: '已终止',
                text: '已终止',
                "data":"",
                "codename":"Item_50",
                value: '50',
                
                disabled: false,
            },
            {
                id: '40',
                label: '已续签',
                text: '已续签',
                "data":"",
                "codename":"Item_40",
                value: '40',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PIMCL_JLCFLX',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: 'REWARD',
                label: '奖励',
                text: '奖励',
                "data":"",
                "codename":"Reward",
                value: 'REWARD',
                
                disabled: false,
            },
            {
                id: 'PUNISHMENT',
                label: '惩罚',
                text: '惩罚',
                "data":"",
                "codename":"Punishment",
                value: 'PUNISHMENT',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "PIMCL_RANKS",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"ORMRANK",
        "appdedataset":"FetchDefault",
        "items": []
    },
    {
        "srfkey": "PIMCL_XL",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        srfkey: 'TRMCL_DGSB',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '电脑灯',
                text: '电脑灯',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '30',
                label: '追光灯',
                text: '追光灯',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '地排灯',
                text: '地排灯',
                "data":"",
                "codename":"Item_40",
                value: '40',
                
                disabled: false,
            },
            {
                id: '50',
                label: '激光灯',
                text: '激光灯',
                "data":"",
                "codename":"Item_50",
                value: '50',
                
                disabled: false,
            },
            {
                id: '20',
                label: 'PAR灯',
                text: 'PAR灯',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PIMCL_EXITANDENTRY_WFState',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '拟稿',
                text: '拟稿',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '审批中',
                text: '审批中',
                "data":"",
                "codename":"Item_20",
                "color": "Blue",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '已通过',
                text: '已通过',
                "data":"",
                "codename":"Item_30",
                "color": "Green",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '已驳回',
                text: '已驳回',
                "data":"",
                "codename":"Item_40",
                "color": "Red",
                value: '40',
                
                disabled: false,
            },
            {
                id: '50',
                label: '已取消',
                text: '已取消',
                "data":"",
                "codename":"Item_50",
                "color": "Red",
                value: '50',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PIMCL_ARCHICEOPETYPE',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '调出操作',
                text: '调出操作',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '调入操作',
                text: '调入操作',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PIMCL_DAZT',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '员工在档',
                text: '员工在档',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '员工不在档',
                text: '员工不在档',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '25',
                label: '非员工不在档',
                text: '非员工不在档',
                "data":"",
                "codename":"Item_25",
                value: '25',
                
                disabled: false,
            },
            {
                id: '30',
                label: '非员工在档',
                text: '非员工在档',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "TRMCL_PXLX",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        srfkey: 'SXW',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '上午',
                text: '上午',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '下午',
                text: '下午',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'SALCL_YGXCZT',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '待确认',
                text: '待确认',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '已确认',
                text: '已确认',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '已取消',
                text: '已取消',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'TRMCL_PXMK',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '海外工程管理业务能力提升',
                text: '海外工程管理业务能力提升',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '投融资板块业务能力提升',
                text: '投融资板块业务能力提升',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '基础设施管理能力提升',
                text: '基础设施管理能力提升',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '总承包管理能力提升',
                text: '总承包管理能力提升',
                "data":"",
                "codename":"Item_40",
                value: '40',
                
                disabled: false,
            },
            {
                id: '50',
                label: '其他',
                text: '其他',
                "data":"",
                "codename":"Item_50",
                value: '50',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'JGLX',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '内部',
                text: '内部',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '外部',
                text: '外部',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PIMCL_ND',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '2012',
                label: '2012年',
                text: '2012年',
                "data":"",
                "codename":"Item_2012",
                value: '2012',
                
                disabled: false,
            },
            {
                id: '2013',
                label: '2013年',
                text: '2013年',
                "data":"",
                "codename":"Item_2013",
                value: '2013',
                
                disabled: false,
            },
            {
                id: '2014',
                label: '2014年',
                text: '2014年',
                "data":"",
                "codename":"Item_2014",
                value: '2014',
                
                disabled: false,
            },
            {
                id: '2015',
                label: '2015年',
                text: '2015年',
                "data":"",
                "codename":"Item_2015",
                value: '2015',
                
                disabled: false,
            },
            {
                id: '2016',
                label: '2016年',
                text: '2016年',
                "data":"",
                "codename":"Item_2016",
                value: '2016',
                
                disabled: false,
            },
            {
                id: '2017',
                label: '2017年',
                text: '2017年',
                "data":"",
                "codename":"Item_2017",
                value: '2017',
                
                disabled: false,
            },
            {
                id: '2018',
                label: '2018年',
                text: '2018年',
                "data":"",
                "codename":"Item_2018",
                value: '2018',
                
                disabled: false,
            },
            {
                id: '2019',
                label: '2019年',
                text: '2019年',
                "data":"",
                "codename":"Item_2019",
                value: '2019',
                
                disabled: false,
            },
            {
                id: '2020',
                label: '2020年',
                text: '2020年',
                "data":"",
                "codename":"Item_2020",
                value: '2020',
                
                disabled: false,
            },
            {
                id: '2021',
                label: '2021年',
                text: '2021年',
                "data":"",
                "codename":"Item_2021",
                value: '2021',
                
                disabled: false,
            },
            {
                id: '2022',
                label: '2022年',
                text: '2022年',
                "data":"",
                "codename":"Item_2022",
                value: '2022',
                
                disabled: false,
            },
            {
                id: '2023',
                label: '2023年',
                text: '2023年',
                "data":"",
                "codename":"Item_2023",
                value: '2023',
                
                disabled: false,
            },
            {
                id: '2024',
                label: '2024年',
                text: '2024年',
                "data":"",
                "codename":"Item_2024",
                value: '2024',
                
                disabled: false,
            },
            {
                id: '2025',
                label: '2025年',
                text: '2025年',
                "data":"",
                "codename":"Item_2025",
                value: '2025',
                
                disabled: false,
            },
            {
                id: '2026',
                label: '2026年',
                text: '2026年',
                "data":"",
                "codename":"Item_2026",
                value: '2026',
                
                disabled: false,
            },
            {
                id: '2027',
                label: '2027年',
                text: '2027年',
                "data":"",
                "codename":"Item_2027",
                value: '2027',
                
                disabled: false,
            },
            {
                id: '2028',
                label: '2028年',
                text: '2028年',
                "data":"",
                "codename":"Item_2028",
                value: '2028',
                
                disabled: false,
            },
            {
                id: '2029',
                label: '2029年',
                text: '2029年',
                "data":"",
                "codename":"Item_2029",
                value: '2029',
                
                disabled: false,
            },
            {
                id: '2030',
                label: '2030年',
                text: '2030年',
                "data":"",
                "codename":"Item_2030",
                value: '2030',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PCMCL_PROFILEType',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '录入',
                text: '录入',
                "data":"",
                "codename":"Item_10",
                "color": "Green",
                value: '10',
                
                disabled: false,
            },
            {
                id: '15',
                label: '待公司初审',
                text: '待公司初审',
                "data":"",
                "codename":"Item_15",
                "color": "Blue",
                value: '15',
                
                disabled: false,
            },
            {
                id: '20',
                label: '公司初审不通过',
                text: '公司初审不通过',
                "data":"",
                "codename":"Item_20",
                "color": "Red",
                value: '20',
                
                disabled: false,
            },
            {
                id: '21',
                label: '待公司董事长审批',
                text: '待公司董事长审批',
                "data":"",
                "codename":"Item_21",
                "color": "Blue",
                value: '21',
                
                disabled: false,
            },
            {
                id: '22',
                label: '公司董事长不通过',
                text: '公司董事长不通过',
                "data":"",
                "codename":"Item_22",
                "color": "Red",
                value: '22',
                
                disabled: false,
            },
            {
                id: '25',
                label: '待上报',
                text: '待上报',
                "data":"",
                "codename":"Item_25",
                "color": "Green",
                value: '25',
                
                disabled: false,
            },
            {
                id: '30',
                label: '待局总部初审',
                text: '待局总部初审',
                "data":"",
                "codename":"Item_30",
                "color": "Blue",
                value: '30',
                
                disabled: false,
            },
            {
                id: '50',
                label: '局总部初审不通过',
                text: '局总部初审不通过',
                "data":"",
                "codename":"Item_50",
                "color": "Red",
                value: '50',
                
                disabled: false,
            },
            {
                id: '55',
                label: '待局总部审核',
                text: '待局总部审核',
                "data":"",
                "codename":"Item_55",
                "color": "Blue",
                value: '55',
                
                disabled: false,
            },
            {
                id: '58',
                label: '局总部审核通过',
                text: '局总部审核通过',
                "data":"",
                "codename":"Item_58",
                "color": "Blue",
                value: '58',
                
                disabled: false,
            },
            {
                id: '60',
                label: '局总部审核不通过',
                text: '局总部审核不通过',
                "data":"",
                "codename":"Item_60",
                "color": "Red",
                value: '60',
                
                disabled: false,
            },
            {
                id: '61',
                label: '待局总部审批',
                text: '待局总部审批',
                "data":"",
                "codename":"Item_61",
                "color": "Blue",
                value: '61',
                
                disabled: false,
            },
            {
                id: '62',
                label: '待审批编号',
                text: '待审批编号',
                "data":"",
                "codename":"Item_62",
                "color": "Blue",
                value: '62',
                
                disabled: false,
            },
            {
                id: '63',
                label: '局总部审批不通过',
                text: '局总部审批不通过',
                "data":"",
                "codename":"Item_63",
                "color": "Red",
                value: '63',
                
                disabled: false,
            },
            {
                id: '65',
                label: '待报到',
                text: '待报到',
                "data":"",
                "codename":"Item_65",
                "color": "Blue",
                value: '65',
                
                disabled: false,
            },
            {
                id: '70',
                label: '已报到',
                text: '已报到',
                "data":"",
                "codename":"Item_70",
                "color": "Green",
                value: '70',
                
                disabled: false,
            },
            {
                id: '80',
                label: '逾期未报到',
                text: '逾期未报到',
                "data":"",
                "codename":"Item_80",
                "color": "Red",
                value: '80',
                
                disabled: false,
            },
            {
                id: '90',
                label: '失效',
                text: '失效',
                "data":"",
                "codename":"Item_90",
                "color": "Red",
                value: '90',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'CodeList59',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: 'Etc/GMT+12',
                label: '(UTC-12:00)GMT-12:00',
                text: '(UTC-12:00)GMT-12:00',
                "data":"",
                "codename":"Etc_gmt_ADD_12",
                value: 'Etc/GMT+12',
                
                disabled: false,
            },
            {
                id: 'Etc/GMT+11',
                label: '(UTC-11:00)GMT-11:00',
                text: '(UTC-11:00)GMT-11:00',
                "data":"",
                "codename":"Etc_gmt_ADD_11",
                value: 'Etc/GMT+11',
                
                disabled: false,
            },
            {
                id: 'MIT',
                label: '(UTC-11:00)West Samoa Time',
                text: '(UTC-11:00)West Samoa Time',
                "data":"",
                "codename":"Mit",
                value: 'MIT',
                
                disabled: false,
            },
            {
                id: 'Pacific/Midway',
                label: '(UTC-11:00)Samoa Standard Time',
                text: '(UTC-11:00)Samoa Standard Time',
                "data":"",
                "codename":"Pacific_midway",
                value: 'Pacific/Midway',
                
                disabled: false,
            },
            {
                id: 'Pacific/Niue',
                label: '(UTC-11:00)Niue Time',
                text: '(UTC-11:00)Niue Time',
                "data":"",
                "codename":"Pacific_niue",
                value: 'Pacific/Niue',
                
                disabled: false,
            },
            {
                id: 'America/Adak',
                label: '(UTC-10:00)Hawaii-Aleutian Standard Time',
                text: '(UTC-10:00)Hawaii-Aleutian Standard Time',
                "data":"",
                "codename":"America_adak",
                value: 'America/Adak',
                
                disabled: false,
            },
            {
                id: 'Etc/GMT+10',
                label: '(UTC-10:00)GMT-10:00',
                text: '(UTC-10:00)GMT-10:00',
                "data":"",
                "codename":"Etc_gmt_ADD_10",
                value: 'Etc/GMT+10',
                
                disabled: false,
            },
            {
                id: 'HST',
                label: '(UTC-10:00)Hawaii Standard Time',
                text: '(UTC-10:00)Hawaii Standard Time',
                "data":"",
                "codename":"Hst",
                value: 'HST',
                
                disabled: false,
            },
            {
                id: 'Pacific/Fakaofo',
                label: '(UTC-10:00)Tokelau Time',
                text: '(UTC-10:00)Tokelau Time',
                "data":"",
                "codename":"Pacific_fakaofo",
                value: 'Pacific/Fakaofo',
                
                disabled: false,
            },
            {
                id: 'Pacific/Rarotonga',
                label: '(UTC-10:00)Cook Is. Time',
                text: '(UTC-10:00)Cook Is. Time',
                "data":"",
                "codename":"Pacific_rarotonga",
                value: 'Pacific/Rarotonga',
                
                disabled: false,
            },
            {
                id: 'Pacific/Tahiti',
                label: '(UTC-10:00)Tahiti Time',
                text: '(UTC-10:00)Tahiti Time',
                "data":"",
                "codename":"Pacific_tahiti",
                value: 'Pacific/Tahiti',
                
                disabled: false,
            },
            {
                id: 'Pacific/Marquesas',
                label: '(UTC-9:00)Marquesas Time',
                text: '(UTC-9:00)Marquesas Time',
                "data":"",
                "codename":"Pacific_marquesas",
                value: 'Pacific/Marquesas',
                
                disabled: false,
            },
            {
                id: 'AST',
                label: '(UTC-9:00)Alaska Standard Time',
                text: '(UTC-9:00)Alaska Standard Time',
                "data":"",
                "codename":"Ast",
                value: 'AST',
                
                disabled: false,
            },
            {
                id: 'Etc/GMT+9',
                label: '(UTC-9:00)GMT-09:00',
                text: '(UTC-9:00)GMT-09:00',
                "data":"",
                "codename":"Etc_gmt_ADD_9",
                value: 'Etc/GMT+9',
                
                disabled: false,
            },
            {
                id: 'Pacific/Gambier',
                label: '(UTC-9:00)Gambier Time',
                text: '(UTC-9:00)Gambier Time',
                "data":"",
                "codename":"Pacific_gambier",
                value: 'Pacific/Gambier',
                
                disabled: false,
            },
            {
                id: 'America/Dawson',
                label: '(UTC-8:00)Pacific Standard Time',
                text: '(UTC-8:00)Pacific Standard Time',
                "data":"",
                "codename":"America_dawson",
                value: 'America/Dawson',
                
                disabled: false,
            },
            {
                id: 'Etc/GMT+8',
                label: '(UTC-8:00)GMT-08:00',
                text: '(UTC-8:00)GMT-08:00',
                "data":"",
                "codename":"Etc_gmt_ADD_8",
                value: 'Etc/GMT+8',
                
                disabled: false,
            },
            {
                id: 'Pacific/Pitcairn',
                label: '(UTC-8:00)Pitcairn Standard Time',
                text: '(UTC-8:00)Pitcairn Standard Time',
                "data":"",
                "codename":"Pacific_pitcairn",
                value: 'Pacific/Pitcairn',
                
                disabled: false,
            },
            {
                id: 'America/Boise',
                label: '(UTC-7:00)Mountain Standard Time',
                text: '(UTC-7:00)Mountain Standard Time',
                "data":"",
                "codename":"America_boise",
                value: 'America/Boise',
                
                disabled: false,
            },
            {
                id: 'Etc/GMT+7',
                label: '(UTC-7:00)GMT-07:00',
                text: '(UTC-7:00)GMT-07:00',
                "data":"",
                "codename":"Etc_gmt_ADD_7",
                value: 'Etc/GMT+7',
                
                disabled: false,
            },
            {
                id: 'America/Belize',
                label: '(UTC-6:00)Central Standard Time',
                text: '(UTC-6:00)Central Standard Time',
                "data":"",
                "codename":"America_belize",
                value: 'America/Belize',
                
                disabled: false,
            },
            {
                id: 'Chile/EasterIsland',
                label: '(UTC-6:00)Easter Is. Time',
                text: '(UTC-6:00)Easter Is. Time',
                "data":"",
                "codename":"Chile_easterisland",
                value: 'Chile/EasterIsland',
                
                disabled: false,
            },
            {
                id: 'Etc/GMT+6',
                label: '(UTC-6:00)GMT-06:00',
                text: '(UTC-6:00)GMT-06:00',
                "data":"",
                "codename":"Etc_gmt_ADD_6",
                value: 'Etc/GMT+6',
                
                disabled: false,
            },
            {
                id: 'Pacific/Galapagos',
                label: '(UTC-6:00)Galapagos Time',
                text: '(UTC-6:00)Galapagos Time',
                "data":"",
                "codename":"Pacific_galapagos",
                value: 'Pacific/Galapagos',
                
                disabled: false,
            },
            {
                id: 'America/Atikokan',
                label: '(UTC-5:00)Eastern Standard Time',
                text: '(UTC-5:00)Eastern Standard Time',
                "data":"",
                "codename":"America_atikokan",
                value: 'America/Atikokan',
                
                disabled: false,
            },
            {
                id: 'America/Bogota',
                label: '(UTC-5:00)Colombia Time',
                text: '(UTC-5:00)Colombia Time',
                "data":"",
                "codename":"America_bogota",
                value: 'America/Bogota',
                
                disabled: false,
            },
            {
                id: 'America/Eirunepe',
                label: '(UTC-5:00)Acre Time',
                text: '(UTC-5:00)Acre Time',
                "data":"",
                "codename":"America_eirunepe",
                value: 'America/Eirunepe',
                
                disabled: false,
            },
            {
                id: 'America/Guayaquil',
                label: '(UTC-5:00)Ecuador Time',
                text: '(UTC-5:00)Ecuador Time',
                "data":"",
                "codename":"America_guayaquil",
                value: 'America/Guayaquil',
                
                disabled: false,
            },
            {
                id: 'America/Havana',
                label: '(UTC-5:00)Cuba Standard Time',
                text: '(UTC-5:00)Cuba Standard Time',
                "data":"",
                "codename":"America_havana",
                value: 'America/Havana',
                
                disabled: false,
            },
            {
                id: 'America/Lima',
                label: '(UTC-5:00)Peru Time',
                text: '(UTC-5:00)Peru Time',
                "data":"",
                "codename":"America_lima",
                value: 'America/Lima',
                
                disabled: false,
            },
            {
                id: 'Etc/GMT+5',
                label: '(UTC-5:00)GMT-05:00',
                text: '(UTC-5:00)GMT-05:00',
                "data":"",
                "codename":"Etc_gmt_ADD_5",
                value: 'Etc/GMT+5',
                
                disabled: false,
            },
            {
                id: 'America/Caracas',
                label: '(UTC-4:00)Venezuela Time',
                text: '(UTC-4:00)Venezuela Time',
                "data":"",
                "codename":"America_caracas",
                value: 'America/Caracas',
                
                disabled: false,
            },
            {
                id: 'America/Anguilla',
                label: '(UTC-4:00)Atlantic Standard Time',
                text: '(UTC-4:00)Atlantic Standard Time',
                "data":"",
                "codename":"America_anguilla",
                value: 'America/Anguilla',
                
                disabled: false,
            },
            {
                id: 'America/Asuncion',
                label: '(UTC-4:00)Paraguay Time',
                text: '(UTC-4:00)Paraguay Time',
                "data":"",
                "codename":"America_asuncion",
                value: 'America/Asuncion',
                
                disabled: false,
            },
            {
                id: 'America/Boa_Vista',
                label: '(UTC-4:00)Amazon Time',
                text: '(UTC-4:00)Amazon Time',
                "data":"",
                "codename":"America_boa_vista",
                value: 'America/Boa_Vista',
                
                disabled: false,
            },
            {
                id: 'America/Guyana',
                label: '(UTC-4:00)Guyana Time',
                text: '(UTC-4:00)Guyana Time',
                "data":"",
                "codename":"America_guyana",
                value: 'America/Guyana',
                
                disabled: false,
            },
            {
                id: 'America/La_Paz',
                label: '(UTC-4:00)Bolivia Time',
                text: '(UTC-4:00)Bolivia Time',
                "data":"",
                "codename":"America_la_paz",
                value: 'America/La_Paz',
                
                disabled: false,
            },
            {
                id: 'America/Santiago',
                label: '(UTC-4:00)Chile Time',
                text: '(UTC-4:00)Chile Time',
                "data":"",
                "codename":"America_santiago",
                value: 'America/Santiago',
                
                disabled: false,
            },
            {
                id: 'Atlantic/Stanley',
                label: '(UTC-4:00)Falkland Is. Time',
                text: '(UTC-4:00)Falkland Is. Time',
                "data":"",
                "codename":"Atlantic_stanley",
                value: 'Atlantic/Stanley',
                
                disabled: false,
            },
            {
                id: 'Etc/GMT+4',
                label: '(UTC-4:00)GMT-04:00',
                text: '(UTC-4:00)GMT-04:00',
                "data":"",
                "codename":"Etc_gmt_ADD_4",
                value: 'Etc/GMT+4',
                
                disabled: false,
            },
            {
                id: 'America/St_Johns',
                label: '(UTC-3:00)Newfoundland Standard Time',
                text: '(UTC-3:00)Newfoundland Standard Time',
                "data":"",
                "codename":"America_st_johns",
                value: 'America/St_Johns',
                
                disabled: false,
            },
            {
                id: 'AGT',
                label: '(UTC-3:00)Argentine Time',
                text: '(UTC-3:00)Argentine Time',
                "data":"",
                "codename":"Agt",
                value: 'AGT',
                
                disabled: false,
            },
            {
                id: 'America/Araguaina',
                label: '(UTC-3:00)Brasilia Time',
                text: '(UTC-3:00)Brasilia Time',
                "data":"",
                "codename":"America_araguaina",
                value: 'America/Araguaina',
                
                disabled: false,
            },
            {
                id: 'America/Cayenne',
                label: '(UTC-3:00)French Guiana Time',
                text: '(UTC-3:00)French Guiana Time',
                "data":"",
                "codename":"America_cayenne",
                value: 'America/Cayenne',
                
                disabled: false,
            },
            {
                id: 'America/Godthab',
                label: '(UTC-3:00)Western Greenland Time',
                text: '(UTC-3:00)Western Greenland Time',
                "data":"",
                "codename":"America_godthab",
                value: 'America/Godthab',
                
                disabled: false,
            },
            {
                id: 'America/Miquelon',
                label: '(UTC-3:00)Pierre & Miquelon Standard Time',
                text: '(UTC-3:00)Pierre & Miquelon Standard Time',
                "data":"",
                "codename":"America_miquelon",
                value: 'America/Miquelon',
                
                disabled: false,
            },
            {
                id: 'America/Montevideo',
                label: '(UTC-3:00)Uruguay Time',
                text: '(UTC-3:00)Uruguay Time',
                "data":"",
                "codename":"America_montevideo",
                value: 'America/Montevideo',
                
                disabled: false,
            },
            {
                id: 'America/Paramaribo',
                label: '(UTC-3:00)Suriname Time',
                text: '(UTC-3:00)Suriname Time',
                "data":"",
                "codename":"America_paramaribo",
                value: 'America/Paramaribo',
                
                disabled: false,
            },
            {
                id: 'Antarctica/Rothera',
                label: '(UTC-3:00)Rothera Time',
                text: '(UTC-3:00)Rothera Time',
                "data":"",
                "codename":"Antarctica_rothera",
                value: 'Antarctica/Rothera',
                
                disabled: false,
            },
            {
                id: 'Etc/GMT+3',
                label: '(UTC-3:00)GMT-03:00',
                text: '(UTC-3:00)GMT-03:00',
                "data":"",
                "codename":"Etc_gmt_ADD_3",
                value: 'Etc/GMT+3',
                
                disabled: false,
            },
            {
                id: 'America/Noronha',
                label: '(UTC-2:00)Fernando de Noronha Time',
                text: '(UTC-2:00)Fernando de Noronha Time',
                "data":"",
                "codename":"America_noronha",
                value: 'America/Noronha',
                
                disabled: false,
            },
            {
                id: 'Atlantic/South_Georgia',
                label: '(UTC-2:00)South Georgia Standard Time',
                text: '(UTC-2:00)South Georgia Standard Time',
                "data":"",
                "codename":"Atlantic_south_georgia",
                value: 'Atlantic/South_Georgia',
                
                disabled: false,
            },
            {
                id: 'Etc/GMT+2',
                label: '(UTC-2:00)GMT-02:00',
                text: '(UTC-2:00)GMT-02:00',
                "data":"",
                "codename":"Etc_gmt_ADD_2",
                value: 'Etc/GMT+2',
                
                disabled: false,
            },
            {
                id: 'America/Scoresbysund',
                label: '(UTC-1:00)Eastern Greenland Time',
                text: '(UTC-1:00)Eastern Greenland Time',
                "data":"",
                "codename":"America_scoresbysund",
                value: 'America/Scoresbysund',
                
                disabled: false,
            },
            {
                id: 'Atlantic/Azores',
                label: '(UTC-1:00)Azores Time',
                text: '(UTC-1:00)Azores Time',
                "data":"",
                "codename":"Atlantic_azores",
                value: 'Atlantic/Azores',
                
                disabled: false,
            },
            {
                id: 'Atlantic/Cape_Verde',
                label: '(UTC-1:00)Cape Verde Time',
                text: '(UTC-1:00)Cape Verde Time',
                "data":"",
                "codename":"Atlantic_cape_verde",
                value: 'Atlantic/Cape_Verde',
                
                disabled: false,
            },
            {
                id: 'Etc/GMT+1',
                label: '(UTC-1:00)GMT-01:00',
                text: '(UTC-1:00)GMT-01:00',
                "data":"",
                "codename":"Etc_gmt_ADD_1",
                value: 'Etc/GMT+1',
                
                disabled: false,
            },
            {
                id: 'Africa/Abidjan',
                label: '(UTC0:00)Greenwich Mean Time',
                text: '(UTC0:00)Greenwich Mean Time',
                "data":"",
                "codename":"Africa_abidjan",
                value: 'Africa/Abidjan',
                
                disabled: false,
            },
            {
                id: 'Africa/Accra',
                label: '(UTC0:00)Ghana Mean Time',
                text: '(UTC0:00)Ghana Mean Time',
                "data":"",
                "codename":"Africa_accra",
                value: 'Africa/Accra',
                
                disabled: false,
            },
            {
                id: 'Africa/Casablanca',
                label: '(UTC0:00)Western European Time',
                text: '(UTC0:00)Western European Time',
                "data":"",
                "codename":"Africa_casablanca",
                value: 'Africa/Casablanca',
                
                disabled: false,
            },
            {
                id: 'Etc/GMT',
                label: '(UTC0:00)GMT+00:00',
                text: '(UTC0:00)GMT+00:00',
                "data":"",
                "codename":"Etc_gmt",
                value: 'Etc/GMT',
                
                disabled: false,
            },
            {
                id: 'Etc/UCT',
                label: '(UTC0:00)Coordinated Universal Time',
                text: '(UTC0:00)Coordinated Universal Time',
                "data":"",
                "codename":"Etc_uct",
                value: 'Etc/UCT',
                
                disabled: false,
            },
            {
                id: 'Africa/Algiers',
                label: '(UTC+1:00)Central European Time',
                text: '(UTC+1:00)Central European Time',
                "data":"",
                "codename":"Africa_algiers",
                value: 'Africa/Algiers',
                
                disabled: false,
            },
            {
                id: 'Africa/Bangui',
                label: '(UTC+1:00)Western African Time',
                text: '(UTC+1:00)Western African Time',
                "data":"",
                "codename":"Africa_bangui",
                value: 'Africa/Bangui',
                
                disabled: false,
            },
            {
                id: 'Etc/GMT-1',
                label: '(UTC+1:00)GMT+01:00',
                text: '(UTC+1:00)GMT+01:00',
                "data":"",
                "codename":"Etc_gmt_SUB_1",
                value: 'Etc/GMT-1',
                
                disabled: false,
            },
            {
                id: 'MET',
                label: '(UTC+1:00)Middle Europe Time',
                text: '(UTC+1:00)Middle Europe Time',
                "data":"",
                "codename":"Met",
                value: 'MET',
                
                disabled: false,
            },
            {
                id: 'ART',
                label: '(UTC+2:00)Eastern European Time',
                text: '(UTC+2:00)Eastern European Time',
                "data":"",
                "codename":"Art",
                value: 'ART',
                
                disabled: false,
            },
            {
                id: 'Africa/Blantyre',
                label: '(UTC+2:00)Central African Time',
                text: '(UTC+2:00)Central African Time',
                "data":"",
                "codename":"Africa_blantyre",
                value: 'Africa/Blantyre',
                
                disabled: false,
            },
            {
                id: 'Africa/Johannesburg',
                label: '(UTC+2:00)South Africa Standard Time',
                text: '(UTC+2:00)South Africa Standard Time',
                "data":"",
                "codename":"Africa_johannesburg",
                value: 'Africa/Johannesburg',
                
                disabled: false,
            },
            {
                id: 'Asia/Jerusalem',
                label: '(UTC+2:00)Israel Standard Time',
                text: '(UTC+2:00)Israel Standard Time',
                "data":"",
                "codename":"Asia_jerusalem",
                value: 'Asia/Jerusalem',
                
                disabled: false,
            },
            {
                id: 'Etc/GMT-2',
                label: '(UTC+2:00)GMT+02:00',
                text: '(UTC+2:00)GMT+02:00',
                "data":"",
                "codename":"Etc_gmt_SUB_2",
                value: 'Etc/GMT-2',
                
                disabled: false,
            },
            {
                id: 'Africa/Addis_Ababa',
                label: '(UTC+3:00)Eastern African Time',
                text: '(UTC+3:00)Eastern African Time',
                "data":"",
                "codename":"Africa_addis_ababa",
                value: 'Africa/Addis_Ababa',
                
                disabled: false,
            },
            {
                id: 'Antarctica/Syowa',
                label: '(UTC+3:00)Syowa Time',
                text: '(UTC+3:00)Syowa Time',
                "data":"",
                "codename":"Antarctica_syowa",
                value: 'Antarctica/Syowa',
                
                disabled: false,
            },
            {
                id: 'Asia/Aden',
                label: '(UTC+3:00)Arabia Standard Time',
                text: '(UTC+3:00)Arabia Standard Time',
                "data":"",
                "codename":"Asia_aden",
                value: 'Asia/Aden',
                
                disabled: false,
            },
            {
                id: 'Etc/GMT-3',
                label: '(UTC+3:00)GMT+03:00',
                text: '(UTC+3:00)GMT+03:00',
                "data":"",
                "codename":"Etc_gmt_SUB_3",
                value: 'Etc/GMT-3',
                
                disabled: false,
            },
            {
                id: 'Europe/Moscow',
                label: '(UTC+3:00)Moscow Standard Time',
                text: '(UTC+3:00)Moscow Standard Time',
                "data":"",
                "codename":"Europe_moscow",
                value: 'Europe/Moscow',
                
                disabled: false,
            },
            {
                id: 'Europe/Volgograd',
                label: '(UTC+3:00)Volgograd Time',
                text: '(UTC+3:00)Volgograd Time',
                "data":"",
                "codename":"Europe_volgograd",
                value: 'Europe/Volgograd',
                
                disabled: false,
            },
            {
                id: 'Asia/Riyadh87',
                label: '(UTC+3:00)GMT+03:07',
                text: '(UTC+3:00)GMT+03:07',
                "data":"",
                "codename":"Asia_riyadh87",
                value: 'Asia/Riyadh87',
                
                disabled: false,
            },
            {
                id: 'Asia/Tehran',
                label: '(UTC+3:00)Iran Standard Time',
                text: '(UTC+3:00)Iran Standard Time',
                "data":"",
                "codename":"Asia_tehran",
                value: 'Asia/Tehran',
                
                disabled: false,
            },
            {
                id: 'Asia/Baku',
                label: '(UTC+4:00)Azerbaijan Time',
                text: '(UTC+4:00)Azerbaijan Time',
                "data":"",
                "codename":"Asia_baku",
                value: 'Asia/Baku',
                
                disabled: false,
            },
            {
                id: 'Asia/Dubai',
                label: '(UTC+4:00)Gulf Standard Time',
                text: '(UTC+4:00)Gulf Standard Time',
                "data":"",
                "codename":"Asia_dubai",
                value: 'Asia/Dubai',
                
                disabled: false,
            },
            {
                id: 'Asia/Tbilisi',
                label: '(UTC+4:00)Georgia Time',
                text: '(UTC+4:00)Georgia Time',
                "data":"",
                "codename":"Asia_tbilisi",
                value: 'Asia/Tbilisi',
                
                disabled: false,
            },
            {
                id: 'Asia/Yerevan',
                label: '(UTC+4:00)Armenia Time',
                text: '(UTC+4:00)Armenia Time',
                "data":"",
                "codename":"Asia_yerevan",
                value: 'Asia/Yerevan',
                
                disabled: false,
            },
            {
                id: 'Etc/GMT-4',
                label: '(UTC+4:00)GMT+04:00',
                text: '(UTC+4:00)GMT+04:00',
                "data":"",
                "codename":"Etc_gmt_SUB_4",
                value: 'Etc/GMT-4',
                
                disabled: false,
            },
            {
                id: 'Europe/Samara',
                label: '(UTC+4:00)Samara Time',
                text: '(UTC+4:00)Samara Time',
                "data":"",
                "codename":"Europe_samara",
                value: 'Europe/Samara',
                
                disabled: false,
            },
            {
                id: 'Indian/Mahe',
                label: '(UTC+4:00)Seychelles Time',
                text: '(UTC+4:00)Seychelles Time',
                "data":"",
                "codename":"Indian_mahe",
                value: 'Indian/Mahe',
                
                disabled: false,
            },
            {
                id: 'Indian/Mauritius',
                label: '(UTC+4:00)Mauritius Time',
                text: '(UTC+4:00)Mauritius Time',
                "data":"",
                "codename":"Indian_mauritius",
                value: 'Indian/Mauritius',
                
                disabled: false,
            },
            {
                id: 'Indian/Reunion',
                label: '(UTC+4:00)Reunion Time',
                text: '(UTC+4:00)Reunion Time',
                "data":"",
                "codename":"Indian_reunion",
                value: 'Indian/Reunion',
                
                disabled: false,
            },
            {
                id: 'Asia/Kabul',
                label: '(UTC+4:00)Afghanistan Time',
                text: '(UTC+4:00)Afghanistan Time',
                "data":"",
                "codename":"Asia_kabul",
                value: 'Asia/Kabul',
                
                disabled: false,
            },
            {
                id: 'Asia/Aqtau',
                label: '(UTC+5:00)Aqtau Time',
                text: '(UTC+5:00)Aqtau Time',
                "data":"",
                "codename":"Asia_aqtau",
                value: 'Asia/Aqtau',
                
                disabled: false,
            },
            {
                id: 'Asia/Aqtobe',
                label: '(UTC+5:00)Aqtobe Time',
                text: '(UTC+5:00)Aqtobe Time',
                "data":"",
                "codename":"Asia_aqtobe",
                value: 'Asia/Aqtobe',
                
                disabled: false,
            },
            {
                id: 'Asia/Ashgabat',
                label: '(UTC+5:00)Turkmenistan Time',
                text: '(UTC+5:00)Turkmenistan Time',
                "data":"",
                "codename":"Asia_ashgabat",
                value: 'Asia/Ashgabat',
                
                disabled: false,
            },
            {
                id: 'Asia/Dushanbe',
                label: '(UTC+5:00)Tajikistan Time',
                text: '(UTC+5:00)Tajikistan Time',
                "data":"",
                "codename":"Asia_dushanbe",
                value: 'Asia/Dushanbe',
                
                disabled: false,
            },
            {
                id: 'Asia/Karachi',
                label: '(UTC+5:00)Pakistan Time',
                text: '(UTC+5:00)Pakistan Time',
                "data":"",
                "codename":"Asia_karachi",
                value: 'Asia/Karachi',
                
                disabled: false,
            },
            {
                id: 'Asia/Oral',
                label: '(UTC+5:00)Oral Time',
                text: '(UTC+5:00)Oral Time',
                "data":"",
                "codename":"Asia_oral",
                value: 'Asia/Oral',
                
                disabled: false,
            },
            {
                id: 'Asia/Samarkand',
                label: '(UTC+5:00)Uzbekistan Time',
                text: '(UTC+5:00)Uzbekistan Time',
                "data":"",
                "codename":"Asia_samarkand",
                value: 'Asia/Samarkand',
                
                disabled: false,
            },
            {
                id: 'Asia/Yekaterinburg',
                label: '(UTC+5:00)Yekaterinburg Time',
                text: '(UTC+5:00)Yekaterinburg Time',
                "data":"",
                "codename":"Asia_yekaterinburg",
                value: 'Asia/Yekaterinburg',
                
                disabled: false,
            },
            {
                id: 'Etc/GMT-5',
                label: '(UTC+5:00)GMT+05:00',
                text: '(UTC+5:00)GMT+05:00',
                "data":"",
                "codename":"Etc_gmt_SUB_5",
                value: 'Etc/GMT-5',
                
                disabled: false,
            },
            {
                id: 'Indian/Kerguelen',
                label: '(UTC+5:00)French Southern & Antarctic Lands Time',
                text: '(UTC+5:00)French Southern & Antarctic Lands Time',
                "data":"",
                "codename":"Indian_kerguelen",
                value: 'Indian/Kerguelen',
                
                disabled: false,
            },
            {
                id: 'Indian/Maldives',
                label: '(UTC+5:00)Maldives Time',
                text: '(UTC+5:00)Maldives Time',
                "data":"",
                "codename":"Indian_maldives",
                value: 'Indian/Maldives',
                
                disabled: false,
            },
            {
                id: 'Asia/Calcutta',
                label: '(UTC+5:00)India Standard Time',
                text: '(UTC+5:00)India Standard Time',
                "data":"",
                "codename":"Asia_calcutta",
                value: 'Asia/Calcutta',
                
                disabled: false,
            },
            {
                id: 'Asia/Katmandu',
                label: '(UTC+5:00)Nepal Time',
                text: '(UTC+5:00)Nepal Time',
                "data":"",
                "codename":"Asia_katmandu",
                value: 'Asia/Katmandu',
                
                disabled: false,
            },
            {
                id: 'Antarctica/Mawson',
                label: '(UTC+6:00)Mawson Time',
                text: '(UTC+6:00)Mawson Time',
                "data":"",
                "codename":"Antarctica_mawson",
                value: 'Antarctica/Mawson',
                
                disabled: false,
            },
            {
                id: 'Antarctica/Vostok',
                label: '(UTC+6:00)Vostok Time',
                text: '(UTC+6:00)Vostok Time',
                "data":"",
                "codename":"Antarctica_vostok",
                value: 'Antarctica/Vostok',
                
                disabled: false,
            },
            {
                id: 'Asia/Almaty',
                label: '(UTC+6:00)Alma-Ata Time',
                text: '(UTC+6:00)Alma-Ata Time',
                "data":"",
                "codename":"Asia_almaty",
                value: 'Asia/Almaty',
                
                disabled: false,
            },
            {
                id: 'Asia/Bishkek',
                label: '(UTC+6:00)Kirgizstan Time',
                text: '(UTC+6:00)Kirgizstan Time',
                "data":"",
                "codename":"Asia_bishkek",
                value: 'Asia/Bishkek',
                
                disabled: false,
            },
            {
                id: 'Asia/Dacca',
                label: '(UTC+6:00)Bangladesh Time',
                text: '(UTC+6:00)Bangladesh Time',
                "data":"",
                "codename":"Asia_dacca",
                value: 'Asia/Dacca',
                
                disabled: false,
            },
            {
                id: 'Asia/Novosibirsk',
                label: '(UTC+6:00)Novosibirsk Time',
                text: '(UTC+6:00)Novosibirsk Time',
                "data":"",
                "codename":"Asia_novosibirsk",
                value: 'Asia/Novosibirsk',
                
                disabled: false,
            },
            {
                id: 'Asia/Omsk',
                label: '(UTC+6:00)Omsk Time',
                text: '(UTC+6:00)Omsk Time',
                "data":"",
                "codename":"Asia_omsk",
                value: 'Asia/Omsk',
                
                disabled: false,
            },
            {
                id: 'Asia/Qyzylorda',
                label: '(UTC+6:00)Qyzylorda Time',
                text: '(UTC+6:00)Qyzylorda Time',
                "data":"",
                "codename":"Asia_qyzylorda",
                value: 'Asia/Qyzylorda',
                
                disabled: false,
            },
            {
                id: 'Asia/Thimbu',
                label: '(UTC+6:00)Bhutan Time',
                text: '(UTC+6:00)Bhutan Time',
                "data":"",
                "codename":"Asia_thimbu",
                value: 'Asia/Thimbu',
                
                disabled: false,
            },
            {
                id: 'Etc/GMT-6',
                label: '(UTC+6:00)GMT+06:00',
                text: '(UTC+6:00)GMT+06:00',
                "data":"",
                "codename":"Etc_gmt_SUB_6",
                value: 'Etc/GMT-6',
                
                disabled: false,
            },
            {
                id: 'Indian/Chagos',
                label: '(UTC+6:00)Indian Ocean Territory Time',
                text: '(UTC+6:00)Indian Ocean Territory Time',
                "data":"",
                "codename":"Indian_chagos",
                value: 'Indian/Chagos',
                
                disabled: false,
            },
            {
                id: 'Asia/Rangoon',
                label: '(UTC+6:00)Myanmar Time',
                text: '(UTC+6:00)Myanmar Time',
                "data":"",
                "codename":"Asia_rangoon",
                value: 'Asia/Rangoon',
                
                disabled: false,
            },
            {
                id: 'Indian/Cocos',
                label: '(UTC+6:00)Cocos Islands Time',
                text: '(UTC+6:00)Cocos Islands Time',
                "data":"",
                "codename":"Indian_cocos",
                value: 'Indian/Cocos',
                
                disabled: false,
            },
            {
                id: 'Antarctica/Davis',
                label: '(UTC+7:00)Davis Time',
                text: '(UTC+7:00)Davis Time',
                "data":"",
                "codename":"Antarctica_davis",
                value: 'Antarctica/Davis',
                
                disabled: false,
            },
            {
                id: 'Asia/Bangkok',
                label: '(UTC+7:00)Indochina Time',
                text: '(UTC+7:00)Indochina Time',
                "data":"",
                "codename":"Asia_bangkok",
                value: 'Asia/Bangkok',
                
                disabled: false,
            },
            {
                id: 'Asia/Hovd',
                label: '(UTC+7:00)Hovd Time',
                text: '(UTC+7:00)Hovd Time',
                "data":"",
                "codename":"Asia_hovd",
                value: 'Asia/Hovd',
                
                disabled: false,
            },
            {
                id: 'Asia/Jakarta',
                label: '(UTC+7:00)West Indonesia Time',
                text: '(UTC+7:00)West Indonesia Time',
                "data":"",
                "codename":"Asia_jakarta",
                value: 'Asia/Jakarta',
                
                disabled: false,
            },
            {
                id: 'Asia/Krasnoyarsk',
                label: '(UTC+7:00)Krasnoyarsk Time',
                text: '(UTC+7:00)Krasnoyarsk Time',
                "data":"",
                "codename":"Asia_krasnoyarsk",
                value: 'Asia/Krasnoyarsk',
                
                disabled: false,
            },
            {
                id: 'Etc/GMT-7',
                label: '(UTC+7:00)GMT+07:00',
                text: '(UTC+7:00)GMT+07:00',
                "data":"",
                "codename":"Etc_gmt_SUB_7",
                value: 'Etc/GMT-7',
                
                disabled: false,
            },
            {
                id: 'Indian/Christmas',
                label: '(UTC+7:00)Christmas Island Time',
                text: '(UTC+7:00)Christmas Island Time',
                "data":"",
                "codename":"Indian_christmas",
                value: 'Indian/Christmas',
                
                disabled: false,
            },
            {
                id: 'Antarctica/Casey',
                label: '(UTC+8:00)Western Standard Time (Australia)',
                text: '(UTC+8:00)Western Standard Time (Australia)',
                "data":"",
                "codename":"Antarctica_casey",
                value: 'Antarctica/Casey',
                
                disabled: false,
            },
            {
                id: 'Asia/Brunei',
                label: '(UTC+8:00)Brunei Time',
                text: '(UTC+8:00)Brunei Time',
                "data":"",
                "codename":"Asia_brunei",
                value: 'Asia/Brunei',
                
                disabled: false,
            },
            {
                id: 'Asia/Choibalsan',
                label: '(UTC+8:00)Choibalsan Time',
                text: '(UTC+8:00)Choibalsan Time',
                "data":"",
                "codename":"Asia_choibalsan",
                value: 'Asia/Choibalsan',
                
                disabled: false,
            },
            {
                id: 'Asia/Shanghai',
                label: '(UTC+8:00)China Standard Time',
                text: '(UTC+8:00)China Standard Time',
                "data":"",
                "codename":"Asia_shanghai",
                value: 'Asia/Shanghai',
                
                disabled: false,
            },
            {
                id: 'Asia/Hong_Kong',
                label: '(UTC+8:00)Hong Kong Time',
                text: '(UTC+8:00)Hong Kong Time',
                "data":"",
                "codename":"Asia_hong_kong",
                value: 'Asia/Hong_Kong',
                
                disabled: false,
            },
            {
                id: 'Asia/Irkutsk',
                label: '(UTC+8:00)Irkutsk Time',
                text: '(UTC+8:00)Irkutsk Time',
                "data":"",
                "codename":"Asia_irkutsk",
                value: 'Asia/Irkutsk',
                
                disabled: false,
            },
            {
                id: 'Asia/Kuala_Lumpur',
                label: '(UTC+8:00)Malaysia Time',
                text: '(UTC+8:00)Malaysia Time',
                "data":"",
                "codename":"Asia_kuala_lumpur",
                value: 'Asia/Kuala_Lumpur',
                
                disabled: false,
            },
            {
                id: 'Asia/Makassar',
                label: '(UTC+8:00)Central Indonesia Time',
                text: '(UTC+8:00)Central Indonesia Time',
                "data":"",
                "codename":"Asia_makassar",
                value: 'Asia/Makassar',
                
                disabled: false,
            },
            {
                id: 'Asia/Manila',
                label: '(UTC+8:00)Philippines Time',
                text: '(UTC+8:00)Philippines Time',
                "data":"",
                "codename":"Asia_manila",
                value: 'Asia/Manila',
                
                disabled: false,
            },
            {
                id: 'Asia/Singapore',
                label: '(UTC+8:00)Singapore Time',
                text: '(UTC+8:00)Singapore Time',
                "data":"",
                "codename":"Asia_singapore",
                value: 'Asia/Singapore',
                
                disabled: false,
            },
            {
                id: 'Asia/Ulaanbaatar',
                label: '(UTC+8:00)Ulaanbaatar Time',
                text: '(UTC+8:00)Ulaanbaatar Time',
                "data":"",
                "codename":"Asia_ulaanbaatar",
                value: 'Asia/Ulaanbaatar',
                
                disabled: false,
            },
            {
                id: 'Etc/GMT-8',
                label: '(UTC+8:00)GMT+08:00',
                text: '(UTC+8:00)GMT+08:00',
                "data":"",
                "codename":"Etc_gmt_SUB_8",
                value: 'Etc/GMT-8',
                
                disabled: false,
            },
            {
                id: 'Australia/Eucla',
                label: '(UTC+8:00)Central Western Standard Time (Australia)',
                text: '(UTC+8:00)Central Western Standard Time (Australia)',
                "data":"",
                "codename":"Australia_eucla",
                value: 'Australia/Eucla',
                
                disabled: false,
            },
            {
                id: 'Asia/Dili',
                label: '(UTC+9:00)Timor-Leste Time',
                text: '(UTC+9:00)Timor-Leste Time',
                "data":"",
                "codename":"Asia_dili",
                value: 'Asia/Dili',
                
                disabled: false,
            },
            {
                id: 'Asia/Jayapura',
                label: '(UTC+9:00)East Indonesia Time',
                text: '(UTC+9:00)East Indonesia Time',
                "data":"",
                "codename":"Asia_jayapura",
                value: 'Asia/Jayapura',
                
                disabled: false,
            },
            {
                id: 'Asia/Pyongyang',
                label: '(UTC+9:00)Korea Standard Time',
                text: '(UTC+9:00)Korea Standard Time',
                "data":"",
                "codename":"Asia_pyongyang",
                value: 'Asia/Pyongyang',
                
                disabled: false,
            },
            {
                id: 'Asia/Tokyo',
                label: '(UTC+9:00)Japan Standard Time',
                text: '(UTC+9:00)Japan Standard Time',
                "data":"",
                "codename":"Asia_tokyo",
                value: 'Asia/Tokyo',
                
                disabled: false,
            },
            {
                id: 'Asia/Yakutsk',
                label: '(UTC+9:00)Yakutsk Time',
                text: '(UTC+9:00)Yakutsk Time',
                "data":"",
                "codename":"Asia_yakutsk",
                value: 'Asia/Yakutsk',
                
                disabled: false,
            },
            {
                id: 'Etc/GMT-9',
                label: '(UTC+9:00)GMT+09:00',
                text: '(UTC+9:00)GMT+09:00',
                "data":"",
                "codename":"Etc_gmt_SUB_9",
                value: 'Etc/GMT-9',
                
                disabled: false,
            },
            {
                id: 'Pacific/Palau',
                label: '(UTC+9:00)Palau Time',
                text: '(UTC+9:00)Palau Time',
                "data":"",
                "codename":"Pacific_palau",
                value: 'Pacific/Palau',
                
                disabled: false,
            },
            {
                id: 'ACT',
                label: '(UTC+9:00)Central Standard Time (Northern Territory)',
                text: '(UTC+9:00)Central Standard Time (Northern Territory)',
                "data":"",
                "codename":"Act",
                value: 'ACT',
                
                disabled: false,
            },
            {
                id: 'Australia/Adelaide',
                label: '(UTC+9:00)Central Standard Time (South Australia)',
                text: '(UTC+9:00)Central Standard Time (South Australia)',
                "data":"",
                "codename":"Australia_adelaide",
                value: 'Australia/Adelaide',
                
                disabled: false,
            },
            {
                id: 'Australia/Broken_Hill',
                label: '(UTC+9:00)Central Standard Time (South Australia/New South Wales)',
                text: '(UTC+9:00)Central Standard Time (South Australia/New South Wales)',
                "data":"",
                "codename":"Australia_broken_hill",
                value: 'Australia/Broken_Hill',
                
                disabled: false,
            },
            {
                id: 'AET',
                label: '(UTC+10:00)Eastern Standard Time (New South Wales)',
                text: '(UTC+10:00)Eastern Standard Time (New South Wales)',
                "data":"",
                "codename":"Aet",
                value: 'AET',
                
                disabled: false,
            },
            {
                id: 'Antarctica/DumontDUrville',
                label: '(UTC+10:00)Dumont-d|Urville Time',
                text: '(UTC+10:00)Dumont-d|Urville Time',
                "data":"",
                "codename":"Antarctica_dumontdurville",
                value: 'Antarctica/DumontDUrville',
                
                disabled: false,
            },
            {
                id: 'Asia/Sakhalin',
                label: '(UTC+10:00)Sakhalin Time',
                text: '(UTC+10:00)Sakhalin Time',
                "data":"",
                "codename":"Asia_sakhalin",
                value: 'Asia/Sakhalin',
                
                disabled: false,
            },
            {
                id: 'Asia/Vladivostok',
                label: '(UTC+10:00)Vladivostok Time',
                text: '(UTC+10:00)Vladivostok Time',
                "data":"",
                "codename":"Asia_vladivostok",
                value: 'Asia/Vladivostok',
                
                disabled: false,
            },
            {
                id: 'Australia/Brisbane',
                label: '(UTC+10:00)Eastern Standard Time (Queensland)',
                text: '(UTC+10:00)Eastern Standard Time (Queensland)',
                "data":"",
                "codename":"Australia_brisbane",
                value: 'Australia/Brisbane',
                
                disabled: false,
            },
            {
                id: 'Australia/Hobart',
                label: '(UTC+10:00)Eastern Standard Time (Tasmania)',
                text: '(UTC+10:00)Eastern Standard Time (Tasmania)',
                "data":"",
                "codename":"Australia_hobart",
                value: 'Australia/Hobart',
                
                disabled: false,
            },
            {
                id: 'Australia/Melbourne',
                label: '(UTC+10:00)Eastern Standard Time (Victoria)',
                text: '(UTC+10:00)Eastern Standard Time (Victoria)',
                "data":"",
                "codename":"Australia_melbourne",
                value: 'Australia/Melbourne',
                
                disabled: false,
            },
            {
                id: 'Etc/GMT-10',
                label: '(UTC+10:00)GMT+10:00',
                text: '(UTC+10:00)GMT+10:00',
                "data":"",
                "codename":"Etc_gmt_SUB_10",
                value: 'Etc/GMT-10',
                
                disabled: false,
            },
            {
                id: 'Pacific/Guam',
                label: '(UTC+10:00)Chamorro Standard Time',
                text: '(UTC+10:00)Chamorro Standard Time',
                "data":"",
                "codename":"Pacific_guam",
                value: 'Pacific/Guam',
                
                disabled: false,
            },
            {
                id: 'Pacific/Port_Moresby',
                label: '(UTC+10:00)Papua New Guinea Time',
                text: '(UTC+10:00)Papua New Guinea Time',
                "data":"",
                "codename":"Pacific_port_moresby",
                value: 'Pacific/Port_Moresby',
                
                disabled: false,
            },
            {
                id: 'Pacific/Truk',
                label: '(UTC+10:00)Truk Time',
                text: '(UTC+10:00)Truk Time',
                "data":"",
                "codename":"Pacific_truk",
                value: 'Pacific/Truk',
                
                disabled: false,
            },
            {
                id: 'Australia/LHI',
                label: '(UTC+10:00)Lord Howe Standard Time',
                text: '(UTC+10:00)Lord Howe Standard Time',
                "data":"",
                "codename":"Australia_lhi",
                value: 'Australia/LHI',
                
                disabled: false,
            },
            {
                id: 'Asia/Magadan',
                label: '(UTC+11:00)Magadan Time',
                text: '(UTC+11:00)Magadan Time',
                "data":"",
                "codename":"Asia_magadan",
                value: 'Asia/Magadan',
                
                disabled: false,
            },
            {
                id: 'Etc/GMT-11',
                label: '(UTC+11:00)GMT+11:00',
                text: '(UTC+11:00)GMT+11:00',
                "data":"",
                "codename":"Etc_gmt_SUB_11",
                value: 'Etc/GMT-11',
                
                disabled: false,
            },
            {
                id: 'Pacific/Efate',
                label: '(UTC+11:00)Vanuatu Time',
                text: '(UTC+11:00)Vanuatu Time',
                "data":"",
                "codename":"Pacific_efate",
                value: 'Pacific/Efate',
                
                disabled: false,
            },
            {
                id: 'Pacific/Guadalcanal',
                label: '(UTC+11:00)Solomon Is. Time',
                text: '(UTC+11:00)Solomon Is. Time',
                "data":"",
                "codename":"Pacific_guadalcanal",
                value: 'Pacific/Guadalcanal',
                
                disabled: false,
            },
            {
                id: 'Pacific/Kosrae',
                label: '(UTC+11:00)Kosrae Time',
                text: '(UTC+11:00)Kosrae Time',
                "data":"",
                "codename":"Pacific_kosrae",
                value: 'Pacific/Kosrae',
                
                disabled: false,
            },
            {
                id: 'Pacific/Noumea',
                label: '(UTC+11:00)New Caledonia Time',
                text: '(UTC+11:00)New Caledonia Time',
                "data":"",
                "codename":"Pacific_noumea",
                value: 'Pacific/Noumea',
                
                disabled: false,
            },
            {
                id: 'Pacific/Ponape',
                label: '(UTC+11:00)Ponape Time',
                text: '(UTC+11:00)Ponape Time',
                "data":"",
                "codename":"Pacific_ponape",
                value: 'Pacific/Ponape',
                
                disabled: false,
            },
            {
                id: 'Pacific/Norfolk',
                label: '(UTC+11:00)Norfolk Time',
                text: '(UTC+11:00)Norfolk Time',
                "data":"",
                "codename":"Pacific_norfolk",
                value: 'Pacific/Norfolk',
                
                disabled: false,
            },
            {
                id: 'Antarctica/McMurdo',
                label: '(UTC+12:00)New Zealand Standard Time',
                text: '(UTC+12:00)New Zealand Standard Time',
                "data":"",
                "codename":"Antarctica_mcmurdo",
                value: 'Antarctica/McMurdo',
                
                disabled: false,
            },
            {
                id: 'Asia/Anadyr',
                label: '(UTC+12:00)Anadyr Time',
                text: '(UTC+12:00)Anadyr Time',
                "data":"",
                "codename":"Asia_anadyr",
                value: 'Asia/Anadyr',
                
                disabled: false,
            },
            {
                id: 'Asia/Kamchatka',
                label: '(UTC+12:00)Petropavlovsk-Kamchatski Time',
                text: '(UTC+12:00)Petropavlovsk-Kamchatski Time',
                "data":"",
                "codename":"Asia_kamchatka",
                value: 'Asia/Kamchatka',
                
                disabled: false,
            },
            {
                id: 'Etc/GMT-12',
                label: '(UTC+12:00)GMT+12:00',
                text: '(UTC+12:00)GMT+12:00',
                "data":"",
                "codename":"Etc_gmt_SUB_12",
                value: 'Etc/GMT-12',
                
                disabled: false,
            },
            {
                id: 'Kwajalein',
                label: '(UTC+12:00)Marshall Islands Time',
                text: '(UTC+12:00)Marshall Islands Time',
                "data":"",
                "codename":"Kwajalein",
                value: 'Kwajalein',
                
                disabled: false,
            },
            {
                id: 'Pacific/Fiji',
                label: '(UTC+12:00)Fiji Time',
                text: '(UTC+12:00)Fiji Time',
                "data":"",
                "codename":"Pacific_fiji",
                value: 'Pacific/Fiji',
                
                disabled: false,
            },
            {
                id: 'Pacific/Funafuti',
                label: '(UTC+12:00)Tuvalu Time',
                text: '(UTC+12:00)Tuvalu Time',
                "data":"",
                "codename":"Pacific_funafuti",
                value: 'Pacific/Funafuti',
                
                disabled: false,
            },
            {
                id: 'Pacific/Nauru',
                label: '(UTC+12:00)Nauru Time',
                text: '(UTC+12:00)Nauru Time',
                "data":"",
                "codename":"Pacific_nauru",
                value: 'Pacific/Nauru',
                
                disabled: false,
            },
            {
                id: 'Pacific/Tarawa',
                label: '(UTC+12:00)Gilbert Is. Time',
                text: '(UTC+12:00)Gilbert Is. Time',
                "data":"",
                "codename":"Pacific_tarawa",
                value: 'Pacific/Tarawa',
                
                disabled: false,
            },
            {
                id: 'Pacific/Wake',
                label: '(UTC+12:00)Wake Time',
                text: '(UTC+12:00)Wake Time',
                "data":"",
                "codename":"Pacific_wake",
                value: 'Pacific/Wake',
                
                disabled: false,
            },
            {
                id: 'Pacific/Wallis',
                label: '(UTC+12:00)Wallis & Futuna Time',
                text: '(UTC+12:00)Wallis & Futuna Time',
                "data":"",
                "codename":"Pacific_wallis",
                value: 'Pacific/Wallis',
                
                disabled: false,
            },
            {
                id: 'NZ-CHAT',
                label: '(UTC+12:00)Chatham Standard Time',
                text: '(UTC+12:00)Chatham Standard Time',
                "data":"",
                "codename":"Nz_SUB_chat",
                value: 'NZ-CHAT',
                
                disabled: false,
            },
            {
                id: 'Etc/GMT-13',
                label: '(UTC+13:00)GMT+13:00',
                text: '(UTC+13:00)GMT+13:00',
                "data":"",
                "codename":"Etc_gmt_SUB_13",
                value: 'Etc/GMT-13',
                
                disabled: false,
            },
            {
                id: 'Pacific/Enderbury',
                label: '(UTC+13:00)Phoenix Is. Time',
                text: '(UTC+13:00)Phoenix Is. Time',
                "data":"",
                "codename":"Pacific_enderbury",
                value: 'Pacific/Enderbury',
                
                disabled: false,
            },
            {
                id: 'Pacific/Tongatapu',
                label: '(UTC+13:00)Tonga Time',
                text: '(UTC+13:00)Tonga Time',
                "data":"",
                "codename":"Pacific_tongatapu",
                value: 'Pacific/Tongatapu',
                
                disabled: false,
            },
            {
                id: 'Etc/GMT-14',
                label: '(UTC+14:00)GMT+14:00',
                text: '(UTC+14:00)GMT+14:00',
                "data":"",
                "codename":"Etc_gmt_SUB_14",
                value: 'Etc/GMT-14',
                
                disabled: false,
            },
            {
                id: 'Pacific/Kiritimati',
                label: '(UTC+14:00)Line Is. Time',
                text: '(UTC+14:00)Line Is. Time',
                "data":"",
                "codename":"Pacific_kiritimati",
                value: 'Pacific/Kiritimati',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "PIMCL_RANK_JZ",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"ORMRANK",
        "appdedataset":"FetchJZRANK",
        "items": []
    },
    {
        srfkey: 'XMRLTP',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '待调配',
                text: '待调配',
                "data":"",
                "codename":"Item_10",
                "color": "Black",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '审批中',
                text: '审批中',
                "data":"",
                "codename":"Item_20",
                "color": "Blue",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '审批通过',
                text: '审批通过',
                "data":"",
                "codename":"Item_30",
                "color": "Green",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '审批不通过',
                text: '审批不通过',
                "data":"",
                "codename":"Item_40",
                "color": "Red",
                value: '40',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PIMCL_DGLX',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '待岗',
                text: '待岗',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '可调配',
                text: '可调配',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'SBLX',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '基本养老保险',
                text: '基本养老保险',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '基本医疗保险',
                text: '基本医疗保险',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '生育保险',
                text: '生育保险',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '失业保险',
                text: '失业保险',
                "data":"",
                "codename":"Item_40",
                value: '40',
                
                disabled: false,
            },
            {
                id: '50',
                label: '工伤保险',
                text: '工伤保险',
                "data":"",
                "codename":"Item_50",
                value: '50',
                
                disabled: false,
            },
            {
                id: '60',
                label: '住房公积金',
                text: '住房公积金',
                "data":"",
                "codename":"Item_60",
                value: '60',
                
                disabled: false,
            },
            {
                id: '70',
                label: '补充住房公积金',
                text: '补充住房公积金',
                "data":"",
                "codename":"Item_70",
                value: '70',
                
                disabled: false,
            },
            {
                id: '80',
                label: '企业年金',
                text: '企业年金',
                "data":"",
                "codename":"Item_80",
                value: '80',
                
                disabled: false,
            },
            {
                id: '90',
                label: '大额医疗互助费',
                text: '大额医疗互助费',
                "data":"",
                "codename":"Item_90",
                value: '90',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'TRMCL_PXXQTZLX',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '局级',
                text: '局级',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '公司级',
                text: '公司级',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PIMCL_ZZLX',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: 'B/Y类员工转正',
                text: 'B/Y类员工转正',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '试用期员工转正',
                text: '试用期员工转正',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '见习期员工转正',
                text: '见习期员工转正',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PROYWZT',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '拟稿',
                text: '拟稿',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '审批中',
                text: '审批中',
                "data":"",
                "codename":"Item_20",
                "color": "Blue",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '审批通过',
                text: '审批通过',
                "data":"",
                "codename":"Item_30",
                "color": "Green",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '审批不通过',
                text: '审批不通过',
                "data":"",
                "codename":"Item_40",
                "color": "Red",
                value: '40',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'WFConfigType',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: 'STATIC',
                label: '静态流程',
                text: '静态流程',
                "data":"",
                "codename":"Static",
                value: 'STATIC',
                
                disabled: false,
            },
            {
                id: 'DYNAMIC',
                label: '动态流程',
                text: '动态流程',
                "data":"",
                "codename":"Dynamic",
                value: 'DYNAMIC',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'ORMCL_GWFL',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '0',
                label: '党内',
                text: '党内',
                "data":"",
                "codename":"Item_0",
                "color": "Red",
                value: '0',
                
                disabled: false,
            },
            {
                id: '1',
                label: '行政',
                text: '行政',
                "data":"",
                "codename":"Item_1",
                "color": "Blue",
                value: '1',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "JPReason",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"PCMReason",
        "appdedataset":"FetchDefault",
        "items": []
    },
    {
        "srfkey": "CodeList58",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"",
        "appdedataset":"",
        "items": []
    },
    {
        srfkey: 'DASTATE',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '有效',
                text: '有效',
                "data":"",
                "codename":"Item_10",
                value: 10,
                
                disabled: false,
            },
            {
                id: '20',
                label: '失效',
                text: '失效',
                "data":"",
                "codename":"Item_20",
                value: 20,
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'CodeList46',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '2',
                label: '星期一',
                text: '星期一',
                "data":"",
                "codename":"Item_2",
                value: '2',
                
                disabled: false,
            },
            {
                id: '3',
                label: '星期二',
                text: '星期二',
                "data":"",
                "codename":"Item_3",
                value: '3',
                
                disabled: false,
            },
            {
                id: '4',
                label: '星期三',
                text: '星期三',
                "data":"",
                "codename":"Item_4",
                value: '4',
                
                disabled: false,
            },
            {
                id: '5',
                label: '星期四',
                text: '星期四',
                "data":"",
                "codename":"Item_5",
                value: '5',
                
                disabled: false,
            },
            {
                id: '6',
                label: '星期五',
                text: '星期五',
                "data":"",
                "codename":"Item_6",
                value: '6',
                
                disabled: false,
            },
            {
                id: '7',
                label: '星期六',
                text: '星期六',
                "data":"",
                "codename":"Item_7",
                value: '7',
                
                disabled: false,
            },
            {
                id: '1',
                label: '星期日',
                text: '星期日',
                "data":"",
                "codename":"Item_1",
                value: '1',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PCMCL_CheckStatus',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '1',
                label: '待审核',
                text: '待审核',
                "data":"",
                "codename":"Item_1",
                "color": "Green",
                value: '1',
                
                disabled: false,
            },
            {
                id: '2',
                label: '审核中',
                text: '审核中',
                "data":"",
                "codename":"Item_2",
                "color": "Brown",
                value: '2',
                
                disabled: false,
            },
            {
                id: '3',
                label: '审核通过',
                text: '审核通过',
                "data":"",
                "codename":"Item_3",
                "color": "Blue",
                value: '3',
                
                disabled: false,
            },
            {
                id: '4',
                label: '审核未通过',
                text: '审核未通过',
                "data":"",
                "codename":"Item_4",
                "color": "Red",
                value: '4',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "PIMCL_HKLX",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        srfkey: 'CodeList88',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: 'NONE',
                label: '无',
                text: '无',
                "data":"",
                "codename":"None",
                value: 'NONE',
                
                disabled: false,
            },
            {
                id: 'READ',
                label: '读取',
                text: '读取',
                "data":"",
                "codename":"Read",
                value: 'READ',
                
                disabled: false,
            },
            {
                id: 'UPDATE',
                label: '更新',
                text: '更新',
                "data":"",
                "codename":"Update",
                value: 'UPDATE',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PIMCL_EXITANDENTRY_TYPE',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '因公',
                text: '因公',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '因私',
                text: '因私',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PCMCL_RLSBPROFILEType',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '待上报',
                text: '待上报',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '待局总部审批',
                text: '待局总部审批',
                "data":"",
                "codename":"Item_20",
                "color": "Blue",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '局总部审批不通过',
                text: '局总部审批不通过',
                "data":"",
                "codename":"Item_30",
                "color": "Red",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '待审批编号',
                text: '待审批编号',
                "data":"",
                "codename":"Item_40",
                "color": "Green",
                value: '40',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'MsgContentType',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: 'TEXT',
                label: '纯文本',
                text: '纯文本',
                "data":"",
                "codename":"Text",
                value: 'TEXT',
                
                disabled: false,
            },
            {
                id: 'HTML',
                label: 'HTML网页',
                text: 'HTML网页',
                "data":"",
                "codename":"Html",
                value: 'HTML',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'TRMCL_FJLX',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '标间',
                text: '标间',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '大床房',
                text: '大床房',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '套房',
                text: '套房',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "PIMCL_FPLX",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        "srfkey": "PIMCL_TYPECONTRACT",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"PIMTYPECONTRACT",
        "appdedataset":"FetchDefault",
        "items": []
    },
    {
        srfkey: 'TRMCL_JYJFLX',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '培训经费',
                text: '培训经费',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '考试经费',
                text: '考试经费',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '个人外出培训经费',
                text: '个人外出培训经费',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'YXNQGBTD_TCYY',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '超过要求年龄',
                text: '超过要求年龄',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '绩效成绩不达标',
                text: '绩效成绩不达标',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '身体情况不符合',
                text: '身体情况不符合',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '受到处分',
                text: '受到处分',
                "data":"",
                "codename":"Item_40",
                value: '40',
                
                disabled: false,
            },
            {
                id: '50',
                label: '其他',
                text: '其他',
                "data":"",
                "codename":"Item_50",
                value: '50',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "PIMCL_JCJB",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        srfkey: 'CodeList16',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: 'PAGE',
                label: '内置页面',
                text: '内置页面',
                "data":"",
                "codename":"Page",
                value: 'PAGE',
                
                disabled: false,
            },
            {
                id: 'REPORT',
                label: '报表',
                text: '报表',
                "data":"",
                "codename":"Report",
                value: 'REPORT',
                
                disabled: false,
            },
            {
                id: 'CUSTOM',
                label: '自定义',
                text: '自定义',
                "data":"",
                "codename":"Custom",
                value: 'CUSTOM',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "PIMCL_DANGJI",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        srfkey: 'WTZT',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '待处理',
                text: '待处理',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '处理中',
                text: '处理中',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '待确认',
                text: '待确认',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '已确认',
                text: '已确认',
                "data":"",
                "codename":"Item_40",
                value: '40',
                
                disabled: false,
            },
            {
                id: '50',
                label: '确认未通过',
                text: '确认未通过',
                "data":"",
                "codename":"Item_50",
                value: '50',
                
                disabled: false,
            },
            {
                id: '60',
                label: '已关闭',
                text: '已关闭',
                "data":"",
                "codename":"Item_60",
                value: '60',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PCMCL_DDSSFW',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '本单位',
                text: '本单位',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '调入',
                text: '调入',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '调出',
                text: '调出',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "PIMCL_XXXZ",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        srfkey: 'TRMCL_XQFL',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '企业培训需求',
                text: '企业培训需求',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '个人外出培训需求',
                text: '个人外出培训需求',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "ORMCL_ZW",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"ORMDUTY",
        "appdedataset":"FetchDefault",
        "items": []
    },
    {
        "srfkey": "SALCL_XCLX",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"SALTYPE",
        "appdedataset":"FetchDefault",
        "items": []
    },
    {
        srfkey: 'CodeList50',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '1',
                label: '是',
                text: '是',
                "data":"",
                "codename":"Item_1",
                value: '1',
                
                disabled: false,
            },
            {
                id: '0',
                label: '否',
                text: '否',
                "data":"",
                "codename":"Item_0",
                value: '0',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PCMCL_GBSGZT',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '0',
                label: '任职中',
                text: '任职中',
                "data":"",
                "codename":"Item_0",
                value: '0',
                
                disabled: false,
            },
            {
                id: '1',
                label: '试岗中',
                text: '试岗中',
                "data":"",
                "codename":"Item_1",
                value: '1',
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "ORMCL_LEVELTWOORG",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"ORMORG",
        "appdedataset":"FetchAllLevelTwoOrg2",
        "items": []
    },
    {
        "srfkey": "ORMCL_EngineeringBusType",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"CodeItem",
        "appdedataset":"FetchCurCL",
        "items": []
    },
    {
        srfkey: 'PARCL_ZBLX',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: 'A',
                label: 'A',
                text: 'A',
                "data":"",
                "codename":"A",
                value: 'A',
                
                disabled: false,
            },
            {
                id: 'B',
                label: 'B',
                text: 'B',
                "data":"",
                "codename":"B",
                value: 'B',
                
                disabled: false,
            },
            {
                id: 'C',
                label: 'C',
                text: 'C',
                "data":"",
                "codename":"C",
                value: 'C',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'CodeList56',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: 'EN',
                label: '英文',
                text: '英文',
                "data":"",
                "codename":"En",
                value: 'EN',
                
                disabled: false,
            },
            {
                id: 'ZH_CN',
                label: '中文简体',
                text: '中文简体',
                "data":"",
                "codename":"Zh_cn",
                value: 'ZH_CN',
                
                disabled: false,
            },
            {
                id: 'ZH_TW',
                label: '中文繁体（台湾）',
                text: '中文繁体（台湾）',
                "data":"",
                "codename":"Zh_tw",
                value: 'ZH_TW',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PIMCL_SFLJ',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '1',
                label: '是',
                text: '是',
                "data":"",
                "codename":"Item_1",
                "color": "Blue",
                value: '1',
                
                disabled: false,
            },
            {
                id: '0',
                label: '否',
                text: '否',
                "data":"",
                "codename":"Item_0",
                "color": "Red",
                value: '0',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PIMCL_SYQ',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '1',
                label: '1个月',
                text: '1个月',
                "data":"",
                "codename":"Item_1",
                value: '1',
                
                disabled: false,
            },
            {
                id: '2',
                label: '2个月',
                text: '2个月',
                "data":"",
                "codename":"Item_2",
                value: '2',
                
                disabled: false,
            },
            {
                id: '6',
                label: '6个月',
                text: '6个月',
                "data":"",
                "codename":"Item_6",
                value: '6',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PIMCL_FJ',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '10',
                label: '学历',
                text: '学历',
                "data":"",
                "codename":"Item_10",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '学位',
                text: '学位',
                "data":"",
                "codename":"Item_20",
                value: '20',
                
                disabled: false,
            },
            {
                id: '30',
                label: '证书',
                text: '证书',
                "data":"",
                "codename":"Item_30",
                value: '30',
                
                disabled: false,
            },
            {
                id: '40',
                label: '论文',
                text: '论文',
                "data":"",
                "codename":"Item_40",
                value: '40',
                
                disabled: false,
            },
            {
                id: '50',
                label: '科研成果',
                text: '科研成果',
                "data":"",
                "codename":"Item_50",
                value: '50',
                
                disabled: false,
            },
            {
                id: '60',
                label: '军转干部',
                text: '军转干部',
                "data":"",
                "codename":"Item_60",
                value: '60',
                
                disabled: false,
            },
            {
                id: '70',
                label: '专利',
                text: '专利',
                "data":"",
                "codename":"Item_70",
                value: '70',
                
                disabled: false,
            },
            {
                id: '90',
                label: '奖惩',
                text: '奖惩',
                "data":"",
                "codename":"Item_90",
                value: '90',
                
                disabled: false,
            },
            {
                id: '80',
                label: '语言能力',
                text: '语言能力',
                "data":"",
                "codename":"Item_80",
                value: '80',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PIMCL_JXQ',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '12',
                label: '1年',
                text: '1年',
                "data":"",
                "codename":"Item_12",
                value: '12',
                
                disabled: false,
            },
            {
                id: '6',
                label: '6个月',
                text: '6个月',
                "data":"",
                "codename":"Item_6",
                value: '6',
                
                disabled: false,
            },
            {
                id: '3',
                label: '3个月',
                text: '3个月',
                "data":"",
                "codename":"Item_3",
                value: '3',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'PCMCL_QTZP',
        emptytext: '',
        "codelisttype":"static",
        items: [
            {
                id: '40',
                label: '中建调入',
                text: '中建调入',
                "data":"",
                "codename":"Item_40",
                value: '40',
                
                disabled: false,
            },
            {
                id: '60',
                label: '军人安置',
                text: '军人安置',
                "data":"",
                "codename":"Item_60",
                value: '60',
                
                disabled: false,
            },
            {
                id: '90',
                label: '其他',
                text: '其他',
                "data":"",
                "codename":"Item_90",
                value: '90',
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: 'KQYBZT',
        emptytext: '未定义',
        "codelisttype":"static",
        items: [
            {
                id: '5',
                label: '待生成',
                text: '待生成',
                "data":"",
                "codename":"Item_5",
                "color": "Orange",
                value: '5',
                
                disabled: false,
            },
            {
                id: '10',
                label: '待确认',
                text: '待确认',
                "data":"",
                "codename":"Item_10",
                "color": "Red",
                value: '10',
                
                disabled: false,
            },
            {
                id: '20',
                label: '已确认',
                text: '已确认',
                "data":"",
                "codename":"Item_20",
                "color": "Green",
                value: '20',
                
                disabled: false,
            },
        ]
    }
    ]];
});

