import CounterService from '../counter-service';
/**
 * 员工自助审核计数器计数器服务对象基类
 *
 * @export
 * @class YGZZJSQCounterServiceBase
 */
export default class YGZZJSQCounterServiceBase extends CounterService {

    /**
     * 当前计数器数据对象
     * 
     * @param {*} [opts={}]
     * @memberof  YGZZJSQCounterServiceBase
     */
    public counterData:any ={};

    /**
     * Creates an instance of  YGZZJSQCounterServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  YGZZJSQCounterServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
        this.initCounterData();
        setInterval(() => {
            this.fetchCounterData();
        }, 90000);
    }

    /**
     * 初始化当前计数器数据对象
     * 
     * @param {*} [opts={}]
     * @memberof  YGZZJSQCounterServiceBase
     */
    public initCounterData(){
        this.fetchCounterData();
    }

    /**
     * 查询数据
     * 
     * @param {*} [opts={}]
     * @memberof  YGZZJSQCounterServiceBase
     */
    public async fetchCounterData(){
        this.counterData = {
            item1:parseInt((Math.random()*10)+''),
            item2:parseInt((Math.random()*100)+''),
            item3:parseInt((Math.random()*100)+''),
            item4:parseInt((Math.random()*100)+''),
            item5:parseInt((Math.random()*100)+''),
            item6:parseInt((Math.random()*100)+''),
            item7:parseInt((Math.random()*100)+''),
            item8:parseInt((Math.random()*100)+''),
            item9:parseInt((Math.random()*100)+''),
            item10:parseInt((Math.random()*100)+'')
        }
    }

    /**
     * 刷新数据
     *
     * @memberof YGZZJSQCounterServiceBase
     */
    public async refreshData(){
        const res = await this.fetchCounterData();
        return res;
    }

}