/**
 * Main2 部件模型
 *
 * @export
 * @class Main2Model
 */
export default class Main2Model {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof Main2GridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof Main2GridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'taxfee',
          prop: 'taxfee',
          dataType: 'CURRENCY',
        },
        {
          name: 'tsivo',
          prop: 'tsivo',
          dataType: 'TEXT',
        },
        {
          name: 'poamount',
          prop: 'poamount',
          dataType: 'CURRENCY',
        },
        {
          name: 'fgempid',
          prop: 'fgempid',
          dataType: 'PICKUP',
        },
        {
          name: 'labserviceid',
          prop: 'labserviceid',
          dataType: 'PICKUP',
        },
        {
          name: 'labservicedesc',
          prop: 'labservicedesc',
          dataType: 'LONGTEXT_1000',
        },
        {
          name: 'pdate',
          prop: 'pdate',
          dataType: 'DATETIME',
        },
        {
          name: 'srfmajortext',
          prop: 'emponame',
          dataType: 'TEXT',
        },
        {
          name: 'srfkey',
          prop: 'empoid',
          dataType: 'GUID',
        },
        {
          name: 'srfdataaccaction',
          prop: 'empoid',
          dataType: 'GUID',
        },
        {
          name: 'empoid',
          prop: 'empoid',
          dataType: 'GUID',
        },
        {
          name: 'zjlempid',
          prop: 'zjlempid',
          dataType: 'PICKUP',
        },
        {
          name: 'apprempname',
          prop: 'apprempname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'rempid',
          prop: 'rempid',
          dataType: 'PICKUP',
        },
        {
          name: 'rempname',
          prop: 'rempname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'eadate',
          prop: 'eadate',
          dataType: 'DATETIME',
        },
        {
          name: 'apprempid',
          prop: 'apprempid',
          dataType: 'PICKUP',
        },
        {
          name: 'labservicename',
          prop: 'labservicename',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'taxivo',
          prop: 'taxivo',
          dataType: 'TEXT',
        },
        {
          name: 'apprdate',
          prop: 'apprdate',
          dataType: 'DATETIME',
        },
        {
          name: 'payway',
          prop: 'payway',
          dataType: 'SSCODELIST',
        },
        {
          name: 'wfstep',
          prop: 'wfstep',
          dataType: 'SSCODELIST',
        },
        {
          name: 'civo',
          prop: 'civo',
          dataType: 'TEXT',
        },
        {
          name: 'postate',
          prop: 'postate',
          dataType: 'NSCODELIST',
        },
        {
          name: 'tsfee',
          prop: 'tsfee',
          dataType: 'CURRENCY',
        },
        {
          name: 'empo',
          prop: 'empoid',
        },
      {
        name: 'empoid',
        prop: 'empoid',
        dataType: 'GUID',
      },
      {
        name: 'postate',
        prop: 'postate',
        dataType: 'NSCODELIST',
      },
      {
        name: 'payway',
        prop: 'payway',
        dataType: 'SSCODELIST',
      },
      {
        name: 'empo',
        prop: 'empoid',
        dataType: 'FONTKEY',
      },

        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}