package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMServiceEvl;
import cn.ibizlab.eam.core.eam_core.service.IEMServiceEvlService;
import cn.ibizlab.eam.core.eam_core.filter.EMServiceEvlSearchContext;

@Slf4j
@Api(tags = {"服务商评估" })
@RestController("WebApi-emserviceevl")
@RequestMapping("")
public class EMServiceEvlResource {

    @Autowired
    public IEMServiceEvlService emserviceevlService;

    @Autowired
    @Lazy
    public EMServiceEvlMapping emserviceevlMapping;

    @ApiOperation(value = "检查服务商评估", tags = {"服务商评估" },  notes = "检查服务商评估")
	@RequestMapping(method = RequestMethod.POST, value = "/emserviceevls/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMServiceEvlDTO emserviceevldto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emserviceevlService.checkKey(emserviceevlMapping.toDomain(emserviceevldto)));
    }

    @ApiOperation(value = "获取服务商评估草稿", tags = {"服务商评估" },  notes = "获取服务商评估草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/emserviceevls/getdraft")
    public ResponseEntity<EMServiceEvlDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emserviceevlMapping.toDto(emserviceevlService.getDraft(new EMServiceEvl())));
    }

    @PreAuthorize("hasPermission(this.emserviceevlMapping.toDomain(#emserviceevldto),'eam_practice04-EMServiceEvl-Save')")
    @ApiOperation(value = "保存服务商评估", tags = {"服务商评估" },  notes = "保存服务商评估")
	@RequestMapping(method = RequestMethod.POST, value = "/emserviceevls/save")
    public ResponseEntity<Boolean> save(@RequestBody EMServiceEvlDTO emserviceevldto) {
        return ResponseEntity.status(HttpStatus.OK).body(emserviceevlService.save(emserviceevlMapping.toDomain(emserviceevldto)));
    }

    @PreAuthorize("hasPermission(this.emserviceevlMapping.toDomain(#emserviceevldtos),'eam_practice04-EMServiceEvl-Save')")
    @ApiOperation(value = "批量保存服务商评估", tags = {"服务商评估" },  notes = "批量保存服务商评估")
	@RequestMapping(method = RequestMethod.POST, value = "/emserviceevls/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMServiceEvlDTO> emserviceevldtos) {
        emserviceevlService.saveBatch(emserviceevlMapping.toDomain(emserviceevldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emserviceevlService.get(#emserviceevl_id),'eam_practice04-EMServiceEvl-Remove')")
    @ApiOperation(value = "删除服务商评估", tags = {"服务商评估" },  notes = "删除服务商评估")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emserviceevls/{emserviceevl_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emserviceevl_id") String emserviceevl_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emserviceevlService.remove(emserviceevl_id));
    }

    @PreAuthorize("hasPermission(this.emserviceevlService.getEmserviceevlByIds(#ids),'eam_practice04-EMServiceEvl-Remove')")
    @ApiOperation(value = "批量删除服务商评估", tags = {"服务商评估" },  notes = "批量删除服务商评估")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emserviceevls/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emserviceevlService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.emserviceevlMapping.toDomain(returnObject.body),'eam_practice04-EMServiceEvl-Get')")
    @ApiOperation(value = "获取服务商评估", tags = {"服务商评估" },  notes = "获取服务商评估")
	@RequestMapping(method = RequestMethod.GET, value = "/emserviceevls/{emserviceevl_id}")
    public ResponseEntity<EMServiceEvlDTO> get(@PathVariable("emserviceevl_id") String emserviceevl_id) {
        EMServiceEvl domain = emserviceevlService.get(emserviceevl_id);
        EMServiceEvlDTO dto = emserviceevlMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emserviceevlMapping.toDomain(#emserviceevldto),'eam_practice04-EMServiceEvl-Create')")
    @ApiOperation(value = "新建服务商评估", tags = {"服务商评估" },  notes = "新建服务商评估")
	@RequestMapping(method = RequestMethod.POST, value = "/emserviceevls")
    @Transactional
    public ResponseEntity<EMServiceEvlDTO> create(@RequestBody EMServiceEvlDTO emserviceevldto) {
        EMServiceEvl domain = emserviceevlMapping.toDomain(emserviceevldto);
		emserviceevlService.create(domain);
        EMServiceEvlDTO dto = emserviceevlMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emserviceevlMapping.toDomain(#emserviceevldtos),'eam_practice04-EMServiceEvl-Create')")
    @ApiOperation(value = "批量新建服务商评估", tags = {"服务商评估" },  notes = "批量新建服务商评估")
	@RequestMapping(method = RequestMethod.POST, value = "/emserviceevls/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMServiceEvlDTO> emserviceevldtos) {
        emserviceevlService.createBatch(emserviceevlMapping.toDomain(emserviceevldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emserviceevlService.get(#emserviceevl_id),'eam_practice04-EMServiceEvl-Update')")
    @ApiOperation(value = "更新服务商评估", tags = {"服务商评估" },  notes = "更新服务商评估")
	@RequestMapping(method = RequestMethod.PUT, value = "/emserviceevls/{emserviceevl_id}")
    @Transactional
    public ResponseEntity<EMServiceEvlDTO> update(@PathVariable("emserviceevl_id") String emserviceevl_id, @RequestBody EMServiceEvlDTO emserviceevldto) {
		EMServiceEvl domain  = emserviceevlMapping.toDomain(emserviceevldto);
        domain .setEmserviceevlid(emserviceevl_id);
		emserviceevlService.update(domain );
		EMServiceEvlDTO dto = emserviceevlMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emserviceevlService.getEmserviceevlByEntities(this.emserviceevlMapping.toDomain(#emserviceevldtos)),'eam_practice04-EMServiceEvl-Update')")
    @ApiOperation(value = "批量更新服务商评估", tags = {"服务商评估" },  notes = "批量更新服务商评估")
	@RequestMapping(method = RequestMethod.PUT, value = "/emserviceevls/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMServiceEvlDTO> emserviceevldtos) {
        emserviceevlService.updateBatch(emserviceevlMapping.toDomain(emserviceevldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMServiceEvl-Default-all')")
	@ApiOperation(value = "获取DEFAULT", tags = {"服务商评估" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emserviceevls/fetchdefault")
	public ResponseEntity<List<EMServiceEvlDTO>> fetchDefault(EMServiceEvlSearchContext context) {
        Page<EMServiceEvl> domains = emserviceevlService.searchDefault(context) ;
        List<EMServiceEvlDTO> list = emserviceevlMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMServiceEvl-Default-all')")
	@ApiOperation(value = "查询DEFAULT", tags = {"服务商评估" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emserviceevls/searchdefault")
	public ResponseEntity<Page<EMServiceEvlDTO>> searchDefault(@RequestBody EMServiceEvlSearchContext context) {
        Page<EMServiceEvl> domains = emserviceevlService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emserviceevlMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}

