package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMPODetail;
import cn.ibizlab.eam.core.eam_core.service.IEMPODetailService;
import cn.ibizlab.eam.core.eam_core.filter.EMPODetailSearchContext;

@Slf4j
@Api(tags = {"订单条目" })
@RestController("WebApi-empodetail")
@RequestMapping("")
public class EMPODetailResource {

    @Autowired
    public IEMPODetailService empodetailService;

    @Autowired
    @Lazy
    public EMPODetailMapping empodetailMapping;

    @PreAuthorize("hasPermission(this.empodetailService.get(#empodetail_id),'eam_practice04-EMPODetail-Update')")
    @ApiOperation(value = "更新订单条目", tags = {"订单条目" },  notes = "更新订单条目")
	@RequestMapping(method = RequestMethod.PUT, value = "/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<EMPODetailDTO> update(@PathVariable("empodetail_id") String empodetail_id, @RequestBody EMPODetailDTO empodetaildto) {
		EMPODetail domain  = empodetailMapping.toDomain(empodetaildto);
        domain .setEmpodetailid(empodetail_id);
		empodetailService.update(domain );
		EMPODetailDTO dto = empodetailMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.empodetailService.getEmpodetailByEntities(this.empodetailMapping.toDomain(#empodetaildtos)),'eam_practice04-EMPODetail-Update')")
    @ApiOperation(value = "批量更新订单条目", tags = {"订单条目" },  notes = "批量更新订单条目")
	@RequestMapping(method = RequestMethod.PUT, value = "/empodetails/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMPODetailDTO> empodetaildtos) {
        empodetailService.updateBatch(empodetailMapping.toDomain(empodetaildtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.empodetailMapping.toDomain(returnObject.body),'eam_practice04-EMPODetail-Get')")
    @ApiOperation(value = "获取订单条目", tags = {"订单条目" },  notes = "获取订单条目")
	@RequestMapping(method = RequestMethod.GET, value = "/empodetails/{empodetail_id}")
    public ResponseEntity<EMPODetailDTO> get(@PathVariable("empodetail_id") String empodetail_id) {
        EMPODetail domain = empodetailService.get(empodetail_id);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildto),'eam_practice04-EMPODetail-Create')")
    @ApiOperation(value = "新建订单条目", tags = {"订单条目" },  notes = "新建订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/empodetails")
    @Transactional
    public ResponseEntity<EMPODetailDTO> create(@RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
		empodetailService.create(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildtos),'eam_practice04-EMPODetail-Create')")
    @ApiOperation(value = "批量新建订单条目", tags = {"订单条目" },  notes = "批量新建订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/empodetails/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMPODetailDTO> empodetaildtos) {
        empodetailService.createBatch(empodetailMapping.toDomain(empodetaildtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "获取订单条目草稿", tags = {"订单条目" },  notes = "获取订单条目草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/empodetails/getdraft")
    public ResponseEntity<EMPODetailDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(empodetailMapping.toDto(empodetailService.getDraft(new EMPODetail())));
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildto),'eam_practice04-EMPODetail-Save')")
    @ApiOperation(value = "保存订单条目", tags = {"订单条目" },  notes = "保存订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/empodetails/save")
    public ResponseEntity<Boolean> save(@RequestBody EMPODetailDTO empodetaildto) {
        return ResponseEntity.status(HttpStatus.OK).body(empodetailService.save(empodetailMapping.toDomain(empodetaildto)));
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildtos),'eam_practice04-EMPODetail-Save')")
    @ApiOperation(value = "批量保存订单条目", tags = {"订单条目" },  notes = "批量保存订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/empodetails/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMPODetailDTO> empodetaildtos) {
        empodetailService.saveBatch(empodetailMapping.toDomain(empodetaildtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "检查订单条目", tags = {"订单条目" },  notes = "检查订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/empodetails/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMPODetailDTO empodetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(empodetailService.checkKey(empodetailMapping.toDomain(empodetaildto)));
    }

    @PreAuthorize("hasPermission(this.empodetailService.get(#empodetail_id),'eam_practice04-EMPODetail-Remove')")
    @ApiOperation(value = "删除订单条目", tags = {"订单条目" },  notes = "删除订单条目")
	@RequestMapping(method = RequestMethod.DELETE, value = "/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("empodetail_id") String empodetail_id) {
         return ResponseEntity.status(HttpStatus.OK).body(empodetailService.remove(empodetail_id));
    }

    @PreAuthorize("hasPermission(this.empodetailService.getEmpodetailByIds(#ids),'eam_practice04-EMPODetail-Remove')")
    @ApiOperation(value = "批量删除订单条目", tags = {"订单条目" },  notes = "批量删除订单条目")
	@RequestMapping(method = RequestMethod.DELETE, value = "/empodetails/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        empodetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-LaterYear-all')")
	@ApiOperation(value = "获取近五年采购", tags = {"订单条目" } ,notes = "获取近五年采购")
    @RequestMapping(method= RequestMethod.GET , value="/empodetails/fetchlateryear")
	public ResponseEntity<List<HashMap>> fetchLaterYear(EMPODetailSearchContext context) {
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-LaterYear-all')")
	@ApiOperation(value = "查询近五年采购", tags = {"订单条目" } ,notes = "查询近五年采购")
    @RequestMapping(method= RequestMethod.POST , value="/empodetails/searchlateryear")
	public ResponseEntity<Page<HashMap>> searchLaterYear(@RequestBody EMPODetailSearchContext context) {
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-Default-all')")
	@ApiOperation(value = "获取DEFAULT", tags = {"订单条目" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/empodetails/fetchdefault")
	public ResponseEntity<List<EMPODetailDTO>> fetchDefault(EMPODetailSearchContext context) {
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
        List<EMPODetailDTO> list = empodetailMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-Default-all')")
	@ApiOperation(value = "查询DEFAULT", tags = {"订单条目" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/empodetails/searchdefault")
	public ResponseEntity<Page<EMPODetailDTO>> searchDefault(@RequestBody EMPODetailSearchContext context) {
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(empodetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(this.empodetailService.get(#empodetail_id),'eam_practice04-EMPODetail-Update')")
    @ApiOperation(value = "根据物品更新订单条目", tags = {"订单条目" },  notes = "根据物品更新订单条目")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitems/{emitem_id}/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<EMPODetailDTO> updateByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
        domain.setEmpodetailid(empodetail_id);
		empodetailService.update(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.empodetailService.getEmpodetailByEntities(this.empodetailMapping.toDomain(#empodetaildtos)),'eam_practice04-EMPODetail-Update')")
    @ApiOperation(value = "根据物品批量更新订单条目", tags = {"订单条目" },  notes = "根据物品批量更新订单条目")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> updateBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        empodetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.empodetailMapping.toDomain(returnObject.body),'eam_practice04-EMPODetail-Get')")
    @ApiOperation(value = "根据物品获取订单条目", tags = {"订单条目" },  notes = "根据物品获取订单条目")
	@RequestMapping(method = RequestMethod.GET, value = "/emitems/{emitem_id}/empodetails/{empodetail_id}")
    public ResponseEntity<EMPODetailDTO> getByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id) {
        EMPODetail domain = empodetailService.get(empodetail_id);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildto),'eam_practice04-EMPODetail-Create')")
    @ApiOperation(value = "根据物品建立订单条目", tags = {"订单条目" },  notes = "根据物品建立订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/empodetails")
    @Transactional
    public ResponseEntity<EMPODetailDTO> createByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
		empodetailService.create(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildtos),'eam_practice04-EMPODetail-Create')")
    @ApiOperation(value = "根据物品批量建立订单条目", tags = {"订单条目" },  notes = "根据物品批量建立订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> createBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        empodetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "根据物品获取订单条目草稿", tags = {"订单条目" },  notes = "根据物品获取订单条目草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/emitems/{emitem_id}/empodetails/getdraft")
    public ResponseEntity<EMPODetailDTO> getDraftByEMItem(@PathVariable("emitem_id") String emitem_id) {
        EMPODetail domain = new EMPODetail();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(empodetailMapping.toDto(empodetailService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildto),'eam_practice04-EMPODetail-Save')")
    @ApiOperation(value = "根据物品保存订单条目", tags = {"订单条目" },  notes = "根据物品保存订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/empodetails/save")
    public ResponseEntity<Boolean> saveByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(empodetailService.save(domain));
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildtos),'eam_practice04-EMPODetail-Save')")
    @ApiOperation(value = "根据物品批量保存订单条目", tags = {"订单条目" },  notes = "根据物品批量保存订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/empodetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
             domain.setItemid(emitem_id);
        }
        empodetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "根据物品检查订单条目", tags = {"订单条目" },  notes = "根据物品检查订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/empodetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(empodetailService.checkKey(empodetailMapping.toDomain(empodetaildto)));
    }

    @PreAuthorize("hasPermission(this.empodetailService.get(#empodetail_id),'eam_practice04-EMPODetail-Remove')")
    @ApiOperation(value = "根据物品删除订单条目", tags = {"订单条目" },  notes = "根据物品删除订单条目")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitems/{emitem_id}/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(empodetailService.remove(empodetail_id));
    }

    @PreAuthorize("hasPermission(this.empodetailService.getEmpodetailByIds(#ids),'eam_practice04-EMPODetail-Remove')")
    @ApiOperation(value = "根据物品批量删除订单条目", tags = {"订单条目" },  notes = "根据物品批量删除订单条目")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> removeBatchByEMItem(@RequestBody List<String> ids) {
        empodetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-LaterYear-all')")
	@ApiOperation(value = "根据物品获取近五年采购", tags = {"订单条目" } ,notes = "根据物品获取近五年采购")
    @RequestMapping(method= RequestMethod.GET , value="/emitems/{emitem_id}/empodetails/fetchlateryear")
	public ResponseEntity<List<HashMap>> fetchEMPODetailLaterYearByEMItem(@PathVariable("emitem_id") String emitem_id,EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-LaterYear-all')")
	@ApiOperation(value = "根据物品查询近五年采购", tags = {"订单条目" } ,notes = "根据物品查询近五年采购")
    @RequestMapping(method= RequestMethod.POST , value="/emitems/{emitem_id}/empodetails/searchlateryear")
	public ResponseEntity<Page<HashMap>> searchEMPODetailLaterYearByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-Default-all')")
	@ApiOperation(value = "根据物品获取DEFAULT", tags = {"订单条目" } ,notes = "根据物品获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emitems/{emitem_id}/empodetails/fetchdefault")
	public ResponseEntity<List<EMPODetailDTO>> fetchEMPODetailDefaultByEMItem(@PathVariable("emitem_id") String emitem_id,EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
        List<EMPODetailDTO> list = empodetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-Default-all')")
	@ApiOperation(value = "根据物品查询DEFAULT", tags = {"订单条目" } ,notes = "根据物品查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emitems/{emitem_id}/empodetails/searchdefault")
	public ResponseEntity<Page<EMPODetailDTO>> searchEMPODetailDefaultByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(empodetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(this.empodetailService.get(#empodetail_id),'eam_practice04-EMPODetail-Update')")
    @ApiOperation(value = "根据订单更新订单条目", tags = {"订单条目" },  notes = "根据订单更新订单条目")
	@RequestMapping(method = RequestMethod.PUT, value = "/empos/{empo_id}/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<EMPODetailDTO> updateByEMPO(@PathVariable("empo_id") String empo_id, @PathVariable("empodetail_id") String empodetail_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setPoid(empo_id);
        domain.setEmpodetailid(empodetail_id);
		empodetailService.update(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.empodetailService.getEmpodetailByEntities(this.empodetailMapping.toDomain(#empodetaildtos)),'eam_practice04-EMPODetail-Update')")
    @ApiOperation(value = "根据订单批量更新订单条目", tags = {"订单条目" },  notes = "根据订单批量更新订单条目")
	@RequestMapping(method = RequestMethod.PUT, value = "/empos/{empo_id}/empodetails/batch")
    public ResponseEntity<Boolean> updateBatchByEMPO(@PathVariable("empo_id") String empo_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
            domain.setPoid(empo_id);
        }
        empodetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.empodetailMapping.toDomain(returnObject.body),'eam_practice04-EMPODetail-Get')")
    @ApiOperation(value = "根据订单获取订单条目", tags = {"订单条目" },  notes = "根据订单获取订单条目")
	@RequestMapping(method = RequestMethod.GET, value = "/empos/{empo_id}/empodetails/{empodetail_id}")
    public ResponseEntity<EMPODetailDTO> getByEMPO(@PathVariable("empo_id") String empo_id, @PathVariable("empodetail_id") String empodetail_id) {
        EMPODetail domain = empodetailService.get(empodetail_id);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildto),'eam_practice04-EMPODetail-Create')")
    @ApiOperation(value = "根据订单建立订单条目", tags = {"订单条目" },  notes = "根据订单建立订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/empos/{empo_id}/empodetails")
    @Transactional
    public ResponseEntity<EMPODetailDTO> createByEMPO(@PathVariable("empo_id") String empo_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setPoid(empo_id);
		empodetailService.create(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildtos),'eam_practice04-EMPODetail-Create')")
    @ApiOperation(value = "根据订单批量建立订单条目", tags = {"订单条目" },  notes = "根据订单批量建立订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/empos/{empo_id}/empodetails/batch")
    public ResponseEntity<Boolean> createBatchByEMPO(@PathVariable("empo_id") String empo_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
            domain.setPoid(empo_id);
        }
        empodetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "根据订单获取订单条目草稿", tags = {"订单条目" },  notes = "根据订单获取订单条目草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/empos/{empo_id}/empodetails/getdraft")
    public ResponseEntity<EMPODetailDTO> getDraftByEMPO(@PathVariable("empo_id") String empo_id) {
        EMPODetail domain = new EMPODetail();
        domain.setPoid(empo_id);
        return ResponseEntity.status(HttpStatus.OK).body(empodetailMapping.toDto(empodetailService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildto),'eam_practice04-EMPODetail-Save')")
    @ApiOperation(value = "根据订单保存订单条目", tags = {"订单条目" },  notes = "根据订单保存订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/empos/{empo_id}/empodetails/save")
    public ResponseEntity<Boolean> saveByEMPO(@PathVariable("empo_id") String empo_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setPoid(empo_id);
        return ResponseEntity.status(HttpStatus.OK).body(empodetailService.save(domain));
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildtos),'eam_practice04-EMPODetail-Save')")
    @ApiOperation(value = "根据订单批量保存订单条目", tags = {"订单条目" },  notes = "根据订单批量保存订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/empos/{empo_id}/empodetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMPO(@PathVariable("empo_id") String empo_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
             domain.setPoid(empo_id);
        }
        empodetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "根据订单检查订单条目", tags = {"订单条目" },  notes = "根据订单检查订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/empos/{empo_id}/empodetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMPO(@PathVariable("empo_id") String empo_id, @RequestBody EMPODetailDTO empodetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(empodetailService.checkKey(empodetailMapping.toDomain(empodetaildto)));
    }

    @PreAuthorize("hasPermission(this.empodetailService.get(#empodetail_id),'eam_practice04-EMPODetail-Remove')")
    @ApiOperation(value = "根据订单删除订单条目", tags = {"订单条目" },  notes = "根据订单删除订单条目")
	@RequestMapping(method = RequestMethod.DELETE, value = "/empos/{empo_id}/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMPO(@PathVariable("empo_id") String empo_id, @PathVariable("empodetail_id") String empodetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(empodetailService.remove(empodetail_id));
    }

    @PreAuthorize("hasPermission(this.empodetailService.getEmpodetailByIds(#ids),'eam_practice04-EMPODetail-Remove')")
    @ApiOperation(value = "根据订单批量删除订单条目", tags = {"订单条目" },  notes = "根据订单批量删除订单条目")
	@RequestMapping(method = RequestMethod.DELETE, value = "/empos/{empo_id}/empodetails/batch")
    public ResponseEntity<Boolean> removeBatchByEMPO(@RequestBody List<String> ids) {
        empodetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-LaterYear-all')")
	@ApiOperation(value = "根据订单获取近五年采购", tags = {"订单条目" } ,notes = "根据订单获取近五年采购")
    @RequestMapping(method= RequestMethod.GET , value="/empos/{empo_id}/empodetails/fetchlateryear")
	public ResponseEntity<List<HashMap>> fetchEMPODetailLaterYearByEMPO(@PathVariable("empo_id") String empo_id,EMPODetailSearchContext context) {
        context.setN_poid_eq(empo_id);
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-LaterYear-all')")
	@ApiOperation(value = "根据订单查询近五年采购", tags = {"订单条目" } ,notes = "根据订单查询近五年采购")
    @RequestMapping(method= RequestMethod.POST , value="/empos/{empo_id}/empodetails/searchlateryear")
	public ResponseEntity<Page<HashMap>> searchEMPODetailLaterYearByEMPO(@PathVariable("empo_id") String empo_id, @RequestBody EMPODetailSearchContext context) {
        context.setN_poid_eq(empo_id);
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-Default-all')")
	@ApiOperation(value = "根据订单获取DEFAULT", tags = {"订单条目" } ,notes = "根据订单获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/empos/{empo_id}/empodetails/fetchdefault")
	public ResponseEntity<List<EMPODetailDTO>> fetchEMPODetailDefaultByEMPO(@PathVariable("empo_id") String empo_id,EMPODetailSearchContext context) {
        context.setN_poid_eq(empo_id);
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
        List<EMPODetailDTO> list = empodetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-Default-all')")
	@ApiOperation(value = "根据订单查询DEFAULT", tags = {"订单条目" } ,notes = "根据订单查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/empos/{empo_id}/empodetails/searchdefault")
	public ResponseEntity<Page<EMPODetailDTO>> searchEMPODetailDefaultByEMPO(@PathVariable("empo_id") String empo_id, @RequestBody EMPODetailSearchContext context) {
        context.setN_poid_eq(empo_id);
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(empodetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(this.empodetailService.get(#empodetail_id),'eam_practice04-EMPODetail-Update')")
    @ApiOperation(value = "根据服务商物品更新订单条目", tags = {"订单条目" },  notes = "根据服务商物品更新订单条目")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<EMPODetailDTO> updateByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
        domain.setEmpodetailid(empodetail_id);
		empodetailService.update(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.empodetailService.getEmpodetailByEntities(this.empodetailMapping.toDomain(#empodetaildtos)),'eam_practice04-EMPODetail-Update')")
    @ApiOperation(value = "根据服务商物品批量更新订单条目", tags = {"订单条目" },  notes = "根据服务商物品批量更新订单条目")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> updateBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        empodetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.empodetailMapping.toDomain(returnObject.body),'eam_practice04-EMPODetail-Get')")
    @ApiOperation(value = "根据服务商物品获取订单条目", tags = {"订单条目" },  notes = "根据服务商物品获取订单条目")
	@RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    public ResponseEntity<EMPODetailDTO> getByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id) {
        EMPODetail domain = empodetailService.get(empodetail_id);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildto),'eam_practice04-EMPODetail-Create')")
    @ApiOperation(value = "根据服务商物品建立订单条目", tags = {"订单条目" },  notes = "根据服务商物品建立订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/empodetails")
    @Transactional
    public ResponseEntity<EMPODetailDTO> createByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
		empodetailService.create(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildtos),'eam_practice04-EMPODetail-Create')")
    @ApiOperation(value = "根据服务商物品批量建立订单条目", tags = {"订单条目" },  notes = "根据服务商物品批量建立订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> createBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        empodetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "根据服务商物品获取订单条目草稿", tags = {"订单条目" },  notes = "根据服务商物品获取订单条目草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitems/{emitem_id}/empodetails/getdraft")
    public ResponseEntity<EMPODetailDTO> getDraftByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id) {
        EMPODetail domain = new EMPODetail();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(empodetailMapping.toDto(empodetailService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildto),'eam_practice04-EMPODetail-Save')")
    @ApiOperation(value = "根据服务商物品保存订单条目", tags = {"订单条目" },  notes = "根据服务商物品保存订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/empodetails/save")
    public ResponseEntity<Boolean> saveByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(empodetailService.save(domain));
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildtos),'eam_practice04-EMPODetail-Save')")
    @ApiOperation(value = "根据服务商物品批量保存订单条目", tags = {"订单条目" },  notes = "根据服务商物品批量保存订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/empodetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
             domain.setItemid(emitem_id);
        }
        empodetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "根据服务商物品检查订单条目", tags = {"订单条目" },  notes = "根据服务商物品检查订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/empodetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(empodetailService.checkKey(empodetailMapping.toDomain(empodetaildto)));
    }

    @PreAuthorize("hasPermission(this.empodetailService.get(#empodetail_id),'eam_practice04-EMPODetail-Remove')")
    @ApiOperation(value = "根据服务商物品删除订单条目", tags = {"订单条目" },  notes = "根据服务商物品删除订单条目")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(empodetailService.remove(empodetail_id));
    }

    @PreAuthorize("hasPermission(this.empodetailService.getEmpodetailByIds(#ids),'eam_practice04-EMPODetail-Remove')")
    @ApiOperation(value = "根据服务商物品批量删除订单条目", tags = {"订单条目" },  notes = "根据服务商物品批量删除订单条目")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> removeBatchByEMServiceEMItem(@RequestBody List<String> ids) {
        empodetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-LaterYear-all')")
	@ApiOperation(value = "根据服务商物品获取近五年采购", tags = {"订单条目" } ,notes = "根据服务商物品获取近五年采购")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emitems/{emitem_id}/empodetails/fetchlateryear")
	public ResponseEntity<List<HashMap>> fetchEMPODetailLaterYearByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id,EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-LaterYear-all')")
	@ApiOperation(value = "根据服务商物品查询近五年采购", tags = {"订单条目" } ,notes = "根据服务商物品查询近五年采购")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emitems/{emitem_id}/empodetails/searchlateryear")
	public ResponseEntity<Page<HashMap>> searchEMPODetailLaterYearByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-Default-all')")
	@ApiOperation(value = "根据服务商物品获取DEFAULT", tags = {"订单条目" } ,notes = "根据服务商物品获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emitems/{emitem_id}/empodetails/fetchdefault")
	public ResponseEntity<List<EMPODetailDTO>> fetchEMPODetailDefaultByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id,EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
        List<EMPODetailDTO> list = empodetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-Default-all')")
	@ApiOperation(value = "根据服务商物品查询DEFAULT", tags = {"订单条目" } ,notes = "根据服务商物品查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emitems/{emitem_id}/empodetails/searchdefault")
	public ResponseEntity<Page<EMPODetailDTO>> searchEMPODetailDefaultByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(empodetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(this.empodetailService.get(#empodetail_id),'eam_practice04-EMPODetail-Update')")
    @ApiOperation(value = "根据仓库库位物品更新订单条目", tags = {"订单条目" },  notes = "根据仓库库位物品更新订单条目")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<EMPODetailDTO> updateByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
        domain.setEmpodetailid(empodetail_id);
		empodetailService.update(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.empodetailService.getEmpodetailByEntities(this.empodetailMapping.toDomain(#empodetaildtos)),'eam_practice04-EMPODetail-Update')")
    @ApiOperation(value = "根据仓库库位物品批量更新订单条目", tags = {"订单条目" },  notes = "根据仓库库位物品批量更新订单条目")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> updateBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        empodetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.empodetailMapping.toDomain(returnObject.body),'eam_practice04-EMPODetail-Get')")
    @ApiOperation(value = "根据仓库库位物品获取订单条目", tags = {"订单条目" },  notes = "根据仓库库位物品获取订单条目")
	@RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    public ResponseEntity<EMPODetailDTO> getByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id) {
        EMPODetail domain = empodetailService.get(empodetail_id);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildto),'eam_practice04-EMPODetail-Create')")
    @ApiOperation(value = "根据仓库库位物品建立订单条目", tags = {"订单条目" },  notes = "根据仓库库位物品建立订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails")
    @Transactional
    public ResponseEntity<EMPODetailDTO> createByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
		empodetailService.create(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildtos),'eam_practice04-EMPODetail-Create')")
    @ApiOperation(value = "根据仓库库位物品批量建立订单条目", tags = {"订单条目" },  notes = "根据仓库库位物品批量建立订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> createBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        empodetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "根据仓库库位物品获取订单条目草稿", tags = {"订单条目" },  notes = "根据仓库库位物品获取订单条目草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/getdraft")
    public ResponseEntity<EMPODetailDTO> getDraftByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id) {
        EMPODetail domain = new EMPODetail();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(empodetailMapping.toDto(empodetailService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildto),'eam_practice04-EMPODetail-Save')")
    @ApiOperation(value = "根据仓库库位物品保存订单条目", tags = {"订单条目" },  notes = "根据仓库库位物品保存订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/save")
    public ResponseEntity<Boolean> saveByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(empodetailService.save(domain));
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildtos),'eam_practice04-EMPODetail-Save')")
    @ApiOperation(value = "根据仓库库位物品批量保存订单条目", tags = {"订单条目" },  notes = "根据仓库库位物品批量保存订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
             domain.setItemid(emitem_id);
        }
        empodetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "根据仓库库位物品检查订单条目", tags = {"订单条目" },  notes = "根据仓库库位物品检查订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(empodetailService.checkKey(empodetailMapping.toDomain(empodetaildto)));
    }

    @PreAuthorize("hasPermission(this.empodetailService.get(#empodetail_id),'eam_practice04-EMPODetail-Remove')")
    @ApiOperation(value = "根据仓库库位物品删除订单条目", tags = {"订单条目" },  notes = "根据仓库库位物品删除订单条目")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(empodetailService.remove(empodetail_id));
    }

    @PreAuthorize("hasPermission(this.empodetailService.getEmpodetailByIds(#ids),'eam_practice04-EMPODetail-Remove')")
    @ApiOperation(value = "根据仓库库位物品批量删除订单条目", tags = {"订单条目" },  notes = "根据仓库库位物品批量删除订单条目")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> removeBatchByEMStorePartEMItem(@RequestBody List<String> ids) {
        empodetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-LaterYear-all')")
	@ApiOperation(value = "根据仓库库位物品获取近五年采购", tags = {"订单条目" } ,notes = "根据仓库库位物品获取近五年采购")
    @RequestMapping(method= RequestMethod.GET , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/fetchlateryear")
	public ResponseEntity<List<HashMap>> fetchEMPODetailLaterYearByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-LaterYear-all')")
	@ApiOperation(value = "根据仓库库位物品查询近五年采购", tags = {"订单条目" } ,notes = "根据仓库库位物品查询近五年采购")
    @RequestMapping(method= RequestMethod.POST , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/searchlateryear")
	public ResponseEntity<Page<HashMap>> searchEMPODetailLaterYearByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-Default-all')")
	@ApiOperation(value = "根据仓库库位物品获取DEFAULT", tags = {"订单条目" } ,notes = "根据仓库库位物品获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/fetchdefault")
	public ResponseEntity<List<EMPODetailDTO>> fetchEMPODetailDefaultByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
        List<EMPODetailDTO> list = empodetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-Default-all')")
	@ApiOperation(value = "根据仓库库位物品查询DEFAULT", tags = {"订单条目" } ,notes = "根据仓库库位物品查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/searchdefault")
	public ResponseEntity<Page<EMPODetailDTO>> searchEMPODetailDefaultByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(empodetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(this.empodetailService.get(#empodetail_id),'eam_practice04-EMPODetail-Update')")
    @ApiOperation(value = "根据仓库物品更新订单条目", tags = {"订单条目" },  notes = "根据仓库物品更新订单条目")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<EMPODetailDTO> updateByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
        domain.setEmpodetailid(empodetail_id);
		empodetailService.update(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.empodetailService.getEmpodetailByEntities(this.empodetailMapping.toDomain(#empodetaildtos)),'eam_practice04-EMPODetail-Update')")
    @ApiOperation(value = "根据仓库物品批量更新订单条目", tags = {"订单条目" },  notes = "根据仓库物品批量更新订单条目")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> updateBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        empodetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.empodetailMapping.toDomain(returnObject.body),'eam_practice04-EMPODetail-Get')")
    @ApiOperation(value = "根据仓库物品获取订单条目", tags = {"订单条目" },  notes = "根据仓库物品获取订单条目")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    public ResponseEntity<EMPODetailDTO> getByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id) {
        EMPODetail domain = empodetailService.get(empodetail_id);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildto),'eam_practice04-EMPODetail-Create')")
    @ApiOperation(value = "根据仓库物品建立订单条目", tags = {"订单条目" },  notes = "根据仓库物品建立订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/empodetails")
    @Transactional
    public ResponseEntity<EMPODetailDTO> createByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
		empodetailService.create(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildtos),'eam_practice04-EMPODetail-Create')")
    @ApiOperation(value = "根据仓库物品批量建立订单条目", tags = {"订单条目" },  notes = "根据仓库物品批量建立订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> createBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        empodetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "根据仓库物品获取订单条目草稿", tags = {"订单条目" },  notes = "根据仓库物品获取订单条目草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitems/{emitem_id}/empodetails/getdraft")
    public ResponseEntity<EMPODetailDTO> getDraftByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id) {
        EMPODetail domain = new EMPODetail();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(empodetailMapping.toDto(empodetailService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildto),'eam_practice04-EMPODetail-Save')")
    @ApiOperation(value = "根据仓库物品保存订单条目", tags = {"订单条目" },  notes = "根据仓库物品保存订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/empodetails/save")
    public ResponseEntity<Boolean> saveByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(empodetailService.save(domain));
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildtos),'eam_practice04-EMPODetail-Save')")
    @ApiOperation(value = "根据仓库物品批量保存订单条目", tags = {"订单条目" },  notes = "根据仓库物品批量保存订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/empodetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
             domain.setItemid(emitem_id);
        }
        empodetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "根据仓库物品检查订单条目", tags = {"订单条目" },  notes = "根据仓库物品检查订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/empodetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(empodetailService.checkKey(empodetailMapping.toDomain(empodetaildto)));
    }

    @PreAuthorize("hasPermission(this.empodetailService.get(#empodetail_id),'eam_practice04-EMPODetail-Remove')")
    @ApiOperation(value = "根据仓库物品删除订单条目", tags = {"订单条目" },  notes = "根据仓库物品删除订单条目")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(empodetailService.remove(empodetail_id));
    }

    @PreAuthorize("hasPermission(this.empodetailService.getEmpodetailByIds(#ids),'eam_practice04-EMPODetail-Remove')")
    @ApiOperation(value = "根据仓库物品批量删除订单条目", tags = {"订单条目" },  notes = "根据仓库物品批量删除订单条目")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> removeBatchByEMStoreEMItem(@RequestBody List<String> ids) {
        empodetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-LaterYear-all')")
	@ApiOperation(value = "根据仓库物品获取近五年采购", tags = {"订单条目" } ,notes = "根据仓库物品获取近五年采购")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emitems/{emitem_id}/empodetails/fetchlateryear")
	public ResponseEntity<List<HashMap>> fetchEMPODetailLaterYearByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id,EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-LaterYear-all')")
	@ApiOperation(value = "根据仓库物品查询近五年采购", tags = {"订单条目" } ,notes = "根据仓库物品查询近五年采购")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emitems/{emitem_id}/empodetails/searchlateryear")
	public ResponseEntity<Page<HashMap>> searchEMPODetailLaterYearByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-Default-all')")
	@ApiOperation(value = "根据仓库物品获取DEFAULT", tags = {"订单条目" } ,notes = "根据仓库物品获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emitems/{emitem_id}/empodetails/fetchdefault")
	public ResponseEntity<List<EMPODetailDTO>> fetchEMPODetailDefaultByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id,EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
        List<EMPODetailDTO> list = empodetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-Default-all')")
	@ApiOperation(value = "根据仓库物品查询DEFAULT", tags = {"订单条目" } ,notes = "根据仓库物品查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emitems/{emitem_id}/empodetails/searchdefault")
	public ResponseEntity<Page<EMPODetailDTO>> searchEMPODetailDefaultByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(empodetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(this.empodetailService.get(#empodetail_id),'eam_practice04-EMPODetail-Update')")
    @ApiOperation(value = "根据职员物品更新订单条目", tags = {"订单条目" },  notes = "根据职员物品更新订单条目")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<EMPODetailDTO> updateByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
        domain.setEmpodetailid(empodetail_id);
		empodetailService.update(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.empodetailService.getEmpodetailByEntities(this.empodetailMapping.toDomain(#empodetaildtos)),'eam_practice04-EMPODetail-Update')")
    @ApiOperation(value = "根据职员物品批量更新订单条目", tags = {"订单条目" },  notes = "根据职员物品批量更新订单条目")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> updateBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        empodetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.empodetailMapping.toDomain(returnObject.body),'eam_practice04-EMPODetail-Get')")
    @ApiOperation(value = "根据职员物品获取订单条目", tags = {"订单条目" },  notes = "根据职员物品获取订单条目")
	@RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    public ResponseEntity<EMPODetailDTO> getByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id) {
        EMPODetail domain = empodetailService.get(empodetail_id);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildto),'eam_practice04-EMPODetail-Create')")
    @ApiOperation(value = "根据职员物品建立订单条目", tags = {"订单条目" },  notes = "根据职员物品建立订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/empodetails")
    @Transactional
    public ResponseEntity<EMPODetailDTO> createByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
		empodetailService.create(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildtos),'eam_practice04-EMPODetail-Create')")
    @ApiOperation(value = "根据职员物品批量建立订单条目", tags = {"订单条目" },  notes = "根据职员物品批量建立订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> createBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        empodetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "根据职员物品获取订单条目草稿", tags = {"订单条目" },  notes = "根据职员物品获取订单条目草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/empodetails/getdraft")
    public ResponseEntity<EMPODetailDTO> getDraftByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id) {
        EMPODetail domain = new EMPODetail();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(empodetailMapping.toDto(empodetailService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildto),'eam_practice04-EMPODetail-Save')")
    @ApiOperation(value = "根据职员物品保存订单条目", tags = {"订单条目" },  notes = "根据职员物品保存订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/empodetails/save")
    public ResponseEntity<Boolean> saveByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(empodetailService.save(domain));
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildtos),'eam_practice04-EMPODetail-Save')")
    @ApiOperation(value = "根据职员物品批量保存订单条目", tags = {"订单条目" },  notes = "根据职员物品批量保存订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/empodetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
             domain.setItemid(emitem_id);
        }
        empodetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "根据职员物品检查订单条目", tags = {"订单条目" },  notes = "根据职员物品检查订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/empodetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(empodetailService.checkKey(empodetailMapping.toDomain(empodetaildto)));
    }

    @PreAuthorize("hasPermission(this.empodetailService.get(#empodetail_id),'eam_practice04-EMPODetail-Remove')")
    @ApiOperation(value = "根据职员物品删除订单条目", tags = {"订单条目" },  notes = "根据职员物品删除订单条目")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(empodetailService.remove(empodetail_id));
    }

    @PreAuthorize("hasPermission(this.empodetailService.getEmpodetailByIds(#ids),'eam_practice04-EMPODetail-Remove')")
    @ApiOperation(value = "根据职员物品批量删除订单条目", tags = {"订单条目" },  notes = "根据职员物品批量删除订单条目")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> removeBatchByPFEmpEMItem(@RequestBody List<String> ids) {
        empodetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-LaterYear-all')")
	@ApiOperation(value = "根据职员物品获取近五年采购", tags = {"订单条目" } ,notes = "根据职员物品获取近五年采购")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/empodetails/fetchlateryear")
	public ResponseEntity<List<HashMap>> fetchEMPODetailLaterYearByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id,EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-LaterYear-all')")
	@ApiOperation(value = "根据职员物品查询近五年采购", tags = {"订单条目" } ,notes = "根据职员物品查询近五年采购")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/empodetails/searchlateryear")
	public ResponseEntity<Page<HashMap>> searchEMPODetailLaterYearByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-Default-all')")
	@ApiOperation(value = "根据职员物品获取DEFAULT", tags = {"订单条目" } ,notes = "根据职员物品获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/empodetails/fetchdefault")
	public ResponseEntity<List<EMPODetailDTO>> fetchEMPODetailDefaultByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id,EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
        List<EMPODetailDTO> list = empodetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-Default-all')")
	@ApiOperation(value = "根据职员物品查询DEFAULT", tags = {"订单条目" } ,notes = "根据职员物品查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/empodetails/searchdefault")
	public ResponseEntity<Page<EMPODetailDTO>> searchEMPODetailDefaultByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(empodetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(this.empodetailService.get(#empodetail_id),'eam_practice04-EMPODetail-Update')")
    @ApiOperation(value = "根据计量单位物品更新订单条目", tags = {"订单条目" },  notes = "根据计量单位物品更新订单条目")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<EMPODetailDTO> updateByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
        domain.setEmpodetailid(empodetail_id);
		empodetailService.update(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.empodetailService.getEmpodetailByEntities(this.empodetailMapping.toDomain(#empodetaildtos)),'eam_practice04-EMPODetail-Update')")
    @ApiOperation(value = "根据计量单位物品批量更新订单条目", tags = {"订单条目" },  notes = "根据计量单位物品批量更新订单条目")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> updateBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        empodetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.empodetailMapping.toDomain(returnObject.body),'eam_practice04-EMPODetail-Get')")
    @ApiOperation(value = "根据计量单位物品获取订单条目", tags = {"订单条目" },  notes = "根据计量单位物品获取订单条目")
	@RequestMapping(method = RequestMethod.GET, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    public ResponseEntity<EMPODetailDTO> getByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id) {
        EMPODetail domain = empodetailService.get(empodetail_id);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildto),'eam_practice04-EMPODetail-Create')")
    @ApiOperation(value = "根据计量单位物品建立订单条目", tags = {"订单条目" },  notes = "根据计量单位物品建立订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/empodetails")
    @Transactional
    public ResponseEntity<EMPODetailDTO> createByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
		empodetailService.create(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildtos),'eam_practice04-EMPODetail-Create')")
    @ApiOperation(value = "根据计量单位物品批量建立订单条目", tags = {"订单条目" },  notes = "根据计量单位物品批量建立订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> createBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        empodetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "根据计量单位物品获取订单条目草稿", tags = {"订单条目" },  notes = "根据计量单位物品获取订单条目草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/empodetails/getdraft")
    public ResponseEntity<EMPODetailDTO> getDraftByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id) {
        EMPODetail domain = new EMPODetail();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(empodetailMapping.toDto(empodetailService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildto),'eam_practice04-EMPODetail-Save')")
    @ApiOperation(value = "根据计量单位物品保存订单条目", tags = {"订单条目" },  notes = "根据计量单位物品保存订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/empodetails/save")
    public ResponseEntity<Boolean> saveByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(empodetailService.save(domain));
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildtos),'eam_practice04-EMPODetail-Save')")
    @ApiOperation(value = "根据计量单位物品批量保存订单条目", tags = {"订单条目" },  notes = "根据计量单位物品批量保存订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/empodetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
             domain.setItemid(emitem_id);
        }
        empodetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "根据计量单位物品检查订单条目", tags = {"订单条目" },  notes = "根据计量单位物品检查订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/empodetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(empodetailService.checkKey(empodetailMapping.toDomain(empodetaildto)));
    }

    @PreAuthorize("hasPermission(this.empodetailService.get(#empodetail_id),'eam_practice04-EMPODetail-Remove')")
    @ApiOperation(value = "根据计量单位物品删除订单条目", tags = {"订单条目" },  notes = "根据计量单位物品删除订单条目")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(empodetailService.remove(empodetail_id));
    }

    @PreAuthorize("hasPermission(this.empodetailService.getEmpodetailByIds(#ids),'eam_practice04-EMPODetail-Remove')")
    @ApiOperation(value = "根据计量单位物品批量删除订单条目", tags = {"订单条目" },  notes = "根据计量单位物品批量删除订单条目")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> removeBatchByPFUnitEMItem(@RequestBody List<String> ids) {
        empodetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-LaterYear-all')")
	@ApiOperation(value = "根据计量单位物品获取近五年采购", tags = {"订单条目" } ,notes = "根据计量单位物品获取近五年采购")
    @RequestMapping(method= RequestMethod.GET , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/empodetails/fetchlateryear")
	public ResponseEntity<List<HashMap>> fetchEMPODetailLaterYearByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id,EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-LaterYear-all')")
	@ApiOperation(value = "根据计量单位物品查询近五年采购", tags = {"订单条目" } ,notes = "根据计量单位物品查询近五年采购")
    @RequestMapping(method= RequestMethod.POST , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/empodetails/searchlateryear")
	public ResponseEntity<Page<HashMap>> searchEMPODetailLaterYearByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-Default-all')")
	@ApiOperation(value = "根据计量单位物品获取DEFAULT", tags = {"订单条目" } ,notes = "根据计量单位物品获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/empodetails/fetchdefault")
	public ResponseEntity<List<EMPODetailDTO>> fetchEMPODetailDefaultByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id,EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
        List<EMPODetailDTO> list = empodetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-Default-all')")
	@ApiOperation(value = "根据计量单位物品查询DEFAULT", tags = {"订单条目" } ,notes = "根据计量单位物品查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/empodetails/searchdefault")
	public ResponseEntity<Page<EMPODetailDTO>> searchEMPODetailDefaultByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(empodetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(this.empodetailService.get(#empodetail_id),'eam_practice04-EMPODetail-Update')")
    @ApiOperation(value = "根据仓库仓库库位物品更新订单条目", tags = {"订单条目" },  notes = "根据仓库仓库库位物品更新订单条目")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<EMPODetailDTO> updateByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
        domain.setEmpodetailid(empodetail_id);
		empodetailService.update(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.empodetailService.getEmpodetailByEntities(this.empodetailMapping.toDomain(#empodetaildtos)),'eam_practice04-EMPODetail-Update')")
    @ApiOperation(value = "根据仓库仓库库位物品批量更新订单条目", tags = {"订单条目" },  notes = "根据仓库仓库库位物品批量更新订单条目")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> updateBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        empodetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.empodetailMapping.toDomain(returnObject.body),'eam_practice04-EMPODetail-Get')")
    @ApiOperation(value = "根据仓库仓库库位物品获取订单条目", tags = {"订单条目" },  notes = "根据仓库仓库库位物品获取订单条目")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    public ResponseEntity<EMPODetailDTO> getByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id) {
        EMPODetail domain = empodetailService.get(empodetail_id);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildto),'eam_practice04-EMPODetail-Create')")
    @ApiOperation(value = "根据仓库仓库库位物品建立订单条目", tags = {"订单条目" },  notes = "根据仓库仓库库位物品建立订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails")
    @Transactional
    public ResponseEntity<EMPODetailDTO> createByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
		empodetailService.create(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildtos),'eam_practice04-EMPODetail-Create')")
    @ApiOperation(value = "根据仓库仓库库位物品批量建立订单条目", tags = {"订单条目" },  notes = "根据仓库仓库库位物品批量建立订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> createBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        empodetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "根据仓库仓库库位物品获取订单条目草稿", tags = {"订单条目" },  notes = "根据仓库仓库库位物品获取订单条目草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/getdraft")
    public ResponseEntity<EMPODetailDTO> getDraftByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id) {
        EMPODetail domain = new EMPODetail();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(empodetailMapping.toDto(empodetailService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildto),'eam_practice04-EMPODetail-Save')")
    @ApiOperation(value = "根据仓库仓库库位物品保存订单条目", tags = {"订单条目" },  notes = "根据仓库仓库库位物品保存订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/save")
    public ResponseEntity<Boolean> saveByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(empodetailService.save(domain));
    }

    @PreAuthorize("hasPermission(this.empodetailMapping.toDomain(#empodetaildtos),'eam_practice04-EMPODetail-Save')")
    @ApiOperation(value = "根据仓库仓库库位物品批量保存订单条目", tags = {"订单条目" },  notes = "根据仓库仓库库位物品批量保存订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
             domain.setItemid(emitem_id);
        }
        empodetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "根据仓库仓库库位物品检查订单条目", tags = {"订单条目" },  notes = "根据仓库仓库库位物品检查订单条目")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(empodetailService.checkKey(empodetailMapping.toDomain(empodetaildto)));
    }

    @PreAuthorize("hasPermission(this.empodetailService.get(#empodetail_id),'eam_practice04-EMPODetail-Remove')")
    @ApiOperation(value = "根据仓库仓库库位物品删除订单条目", tags = {"订单条目" },  notes = "根据仓库仓库库位物品删除订单条目")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(empodetailService.remove(empodetail_id));
    }

    @PreAuthorize("hasPermission(this.empodetailService.getEmpodetailByIds(#ids),'eam_practice04-EMPODetail-Remove')")
    @ApiOperation(value = "根据仓库仓库库位物品批量删除订单条目", tags = {"订单条目" },  notes = "根据仓库仓库库位物品批量删除订单条目")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> removeBatchByEMStoreEMStorePartEMItem(@RequestBody List<String> ids) {
        empodetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-LaterYear-all')")
	@ApiOperation(value = "根据仓库仓库库位物品获取近五年采购", tags = {"订单条目" } ,notes = "根据仓库仓库库位物品获取近五年采购")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/fetchlateryear")
	public ResponseEntity<List<HashMap>> fetchEMPODetailLaterYearByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-LaterYear-all')")
	@ApiOperation(value = "根据仓库仓库库位物品查询近五年采购", tags = {"订单条目" } ,notes = "根据仓库仓库库位物品查询近五年采购")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/searchlateryear")
	public ResponseEntity<Page<HashMap>> searchEMPODetailLaterYearByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-Default-all')")
	@ApiOperation(value = "根据仓库仓库库位物品获取DEFAULT", tags = {"订单条目" } ,notes = "根据仓库仓库库位物品获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/fetchdefault")
	public ResponseEntity<List<EMPODetailDTO>> fetchEMPODetailDefaultByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
        List<EMPODetailDTO> list = empodetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMPODetail-Default-all')")
	@ApiOperation(value = "根据仓库仓库库位物品查询DEFAULT", tags = {"订单条目" } ,notes = "根据仓库仓库库位物品查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/searchdefault")
	public ResponseEntity<Page<EMPODetailDTO>> searchEMPODetailDefaultByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(empodetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}

