package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMItemType;
import cn.ibizlab.eam.core.eam_core.service.IEMItemTypeService;
import cn.ibizlab.eam.core.eam_core.filter.EMItemTypeSearchContext;

@Slf4j
@Api(tags = {"物品类型" })
@RestController("WebApi-emitemtype")
@RequestMapping("")
public class EMItemTypeResource {

    @Autowired
    public IEMItemTypeService emitemtypeService;

    @Autowired
    @Lazy
    public EMItemTypeMapping emitemtypeMapping;

    @ApiOperation(value = "获取物品类型草稿", tags = {"物品类型" },  notes = "获取物品类型草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/emitemtypes/getdraft")
    public ResponseEntity<EMItemTypeDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emitemtypeMapping.toDto(emitemtypeService.getDraft(new EMItemType())));
    }

    @PostAuthorize("hasPermission(this.emitemtypeMapping.toDomain(returnObject.body),'eam_practice04-EMItemType-Get')")
    @ApiOperation(value = "获取物品类型", tags = {"物品类型" },  notes = "获取物品类型")
	@RequestMapping(method = RequestMethod.GET, value = "/emitemtypes/{emitemtype_id}")
    public ResponseEntity<EMItemTypeDTO> get(@PathVariable("emitemtype_id") String emitemtype_id) {
        EMItemType domain = emitemtypeService.get(emitemtype_id);
        EMItemTypeDTO dto = emitemtypeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemtypeMapping.toDomain(#emitemtypedto),'eam_practice04-EMItemType-Save')")
    @ApiOperation(value = "保存物品类型", tags = {"物品类型" },  notes = "保存物品类型")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemtypes/save")
    public ResponseEntity<Boolean> save(@RequestBody EMItemTypeDTO emitemtypedto) {
        return ResponseEntity.status(HttpStatus.OK).body(emitemtypeService.save(emitemtypeMapping.toDomain(emitemtypedto)));
    }

    @PreAuthorize("hasPermission(this.emitemtypeMapping.toDomain(#emitemtypedtos),'eam_practice04-EMItemType-Save')")
    @ApiOperation(value = "批量保存物品类型", tags = {"物品类型" },  notes = "批量保存物品类型")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemtypes/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMItemTypeDTO> emitemtypedtos) {
        emitemtypeService.saveBatch(emitemtypeMapping.toDomain(emitemtypedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "检查物品类型", tags = {"物品类型" },  notes = "检查物品类型")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemtypes/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMItemTypeDTO emitemtypedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemtypeService.checkKey(emitemtypeMapping.toDomain(emitemtypedto)));
    }

    @PreAuthorize("hasPermission(this.emitemtypeMapping.toDomain(#emitemtypedto),'eam_practice04-EMItemType-Create')")
    @ApiOperation(value = "新建物品类型", tags = {"物品类型" },  notes = "新建物品类型")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemtypes")
    @Transactional
    public ResponseEntity<EMItemTypeDTO> create(@RequestBody EMItemTypeDTO emitemtypedto) {
        EMItemType domain = emitemtypeMapping.toDomain(emitemtypedto);
		emitemtypeService.create(domain);
        EMItemTypeDTO dto = emitemtypeMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemtypeMapping.toDomain(#emitemtypedtos),'eam_practice04-EMItemType-Create')")
    @ApiOperation(value = "批量新建物品类型", tags = {"物品类型" },  notes = "批量新建物品类型")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemtypes/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMItemTypeDTO> emitemtypedtos) {
        emitemtypeService.createBatch(emitemtypeMapping.toDomain(emitemtypedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emitemtypeService.get(#emitemtype_id),'eam_practice04-EMItemType-Remove')")
    @ApiOperation(value = "删除物品类型", tags = {"物品类型" },  notes = "删除物品类型")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitemtypes/{emitemtype_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emitemtype_id") String emitemtype_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emitemtypeService.remove(emitemtype_id));
    }

    @PreAuthorize("hasPermission(this.emitemtypeService.getEmitemtypeByIds(#ids),'eam_practice04-EMItemType-Remove')")
    @ApiOperation(value = "批量删除物品类型", tags = {"物品类型" },  notes = "批量删除物品类型")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitemtypes/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emitemtypeService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emitemtypeService.get(#emitemtype_id),'eam_practice04-EMItemType-Update')")
    @ApiOperation(value = "更新物品类型", tags = {"物品类型" },  notes = "更新物品类型")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitemtypes/{emitemtype_id}")
    @Transactional
    public ResponseEntity<EMItemTypeDTO> update(@PathVariable("emitemtype_id") String emitemtype_id, @RequestBody EMItemTypeDTO emitemtypedto) {
		EMItemType domain  = emitemtypeMapping.toDomain(emitemtypedto);
        domain .setEmitemtypeid(emitemtype_id);
		emitemtypeService.update(domain );
		EMItemTypeDTO dto = emitemtypeMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemtypeService.getEmitemtypeByEntities(this.emitemtypeMapping.toDomain(#emitemtypedtos)),'eam_practice04-EMItemType-Update')")
    @ApiOperation(value = "批量更新物品类型", tags = {"物品类型" },  notes = "批量更新物品类型")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitemtypes/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMItemTypeDTO> emitemtypedtos) {
        emitemtypeService.updateBatch(emitemtypeMapping.toDomain(emitemtypedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMItemType-ItemType-all')")
	@ApiOperation(value = "获取上级类型查询", tags = {"物品类型" } ,notes = "获取上级类型查询")
    @RequestMapping(method= RequestMethod.GET , value="/emitemtypes/fetchitemtype")
	public ResponseEntity<List<EMItemTypeDTO>> fetchItemType(EMItemTypeSearchContext context) {
        Page<EMItemType> domains = emitemtypeService.searchItemType(context) ;
        List<EMItemTypeDTO> list = emitemtypeMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMItemType-ItemType-all')")
	@ApiOperation(value = "查询上级类型查询", tags = {"物品类型" } ,notes = "查询上级类型查询")
    @RequestMapping(method= RequestMethod.POST , value="/emitemtypes/searchitemtype")
	public ResponseEntity<Page<EMItemTypeDTO>> searchItemType(@RequestBody EMItemTypeSearchContext context) {
        Page<EMItemType> domains = emitemtypeService.searchItemType(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemtypeMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMItemType-Default-all')")
	@ApiOperation(value = "获取DEFAULT", tags = {"物品类型" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emitemtypes/fetchdefault")
	public ResponseEntity<List<EMItemTypeDTO>> fetchDefault(EMItemTypeSearchContext context) {
        Page<EMItemType> domains = emitemtypeService.searchDefault(context) ;
        List<EMItemTypeDTO> list = emitemtypeMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMItemType-Default-all')")
	@ApiOperation(value = "查询DEFAULT", tags = {"物品类型" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emitemtypes/searchdefault")
	public ResponseEntity<Page<EMItemTypeDTO>> searchDefault(@RequestBody EMItemTypeSearchContext context) {
        Page<EMItemType> domains = emitemtypeService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemtypeMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}

