package cn.ibizlab.eam.webapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;
import cn.ibizlab.eam.util.domain.DTOBase;
import lombok.Data;

/**
 * 服务DTO对象[EMBerthDTO]
 */
@Data
public class EMBerthDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [ENABLE]
     *
     */
    @JSONField(name = "enable")
    @JsonProperty("enable")
    private Integer enable;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;

    /**
     * 属性 [BERTHCODE]
     *
     */
    @JSONField(name = "berthcode")
    @JsonProperty("berthcode")
    private String berthcode;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [EMBERTHNAME]
     *
     */
    @JSONField(name = "emberthname")
    @JsonProperty("emberthname")
    private String emberthname;

    /**
     * 属性 [EMBERTHID]
     *
     */
    @JSONField(name = "emberthid")
    @JsonProperty("emberthid")
    private String emberthid;


    /**
     * 设置 [BERTHCODE]
     */
    public void setBerthcode(String  berthcode){
        this.berthcode = berthcode ;
        this.modify("berthcode",berthcode);
    }

    /**
     * 设置 [EMBERTHNAME]
     */
    public void setEmberthname(String  emberthname){
        this.emberthname = emberthname ;
        this.modify("emberthname",emberthname);
    }


}

