import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 备件包明细服务对象基类
 *
 * @export
 * @class EMEQSpareDetailServiceBase
 * @extends {EntityServie}
 */
export default class EMEQSpareDetailServiceBase extends EntityService {

    /**
     * Creates an instance of  EMEQSpareDetailServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  EMEQSpareDetailServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof EMEQSpareDetailServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='emeqsparedetail';
        this.APPDEKEY = 'emeqsparedetailid';
        this.APPDENAME = 'emeqsparedetails';
        this.APPDETEXT = 'emeqsparedetailname';
        this.APPNAME = 'eamweb';
        this.SYSTEMNAME = 'eam_practice04';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEQSpareDetailServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emeqsparedetail){
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}/select`,isloading);
        }
        if(context.pfunit && context.emitem && context.emeqsparedetail){
            return Http.getInstance().get(`/pfunits/${context.pfunit}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}/select`,isloading);
        }
        if(context.pfemp && context.emitem && context.emeqsparedetail){
            return Http.getInstance().get(`/pfemps/${context.pfemp}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}/select`,isloading);
        }
        if(context.emstore && context.emitem && context.emeqsparedetail){
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}/select`,isloading);
        }
        if(context.emstorepart && context.emitem && context.emeqsparedetail){
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}/select`,isloading);
        }
        if(context.emservice && context.emitem && context.emeqsparedetail){
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}/select`,isloading);
        }
        if(context.emitem && context.emeqsparedetail){
            return Http.getInstance().get(`/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}/select`,isloading);
        }
        if(context.emeqspare && context.emeqsparedetail){
            return Http.getInstance().get(`/emeqspares/${context.emeqspare}/emeqsparedetails/${context.emeqsparedetail}/select`,isloading);
        }
            return Http.getInstance().get(`/emeqsparedetails/${context.emeqsparedetail}/select`,isloading);
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEQSpareDetailServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emeqsparedetail){
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}`,isloading);
        }
        if(context.pfunit && context.emitem && context.emeqsparedetail){
            return Http.getInstance().get(`/pfunits/${context.pfunit}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}`,isloading);
        }
        if(context.pfemp && context.emitem && context.emeqsparedetail){
            return Http.getInstance().get(`/pfemps/${context.pfemp}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}`,isloading);
        }
        if(context.emstore && context.emitem && context.emeqsparedetail){
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}`,isloading);
        }
        if(context.emstorepart && context.emitem && context.emeqsparedetail){
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}`,isloading);
        }
        if(context.emservice && context.emitem && context.emeqsparedetail){
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}`,isloading);
        }
        if(context.emitem && context.emeqsparedetail){
            return Http.getInstance().get(`/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}`,isloading);
        }
        if(context.emeqspare && context.emeqsparedetail){
            return Http.getInstance().get(`/emeqspares/${context.emeqspare}/emeqsparedetails/${context.emeqsparedetail}`,isloading);
        }
            let res:any = await Http.getInstance().get(`/emeqsparedetails/${context.emeqsparedetail}`,isloading);
            return res;

    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEQSpareDetailServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            return Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emeqsparedetails`,data,isloading);
        }
        if(context.pfunit && context.emitem && true){
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            return Http.getInstance().post(`/pfunits/${context.pfunit}/emitems/${context.emitem}/emeqsparedetails`,data,isloading);
        }
        if(context.pfemp && context.emitem && true){
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            return Http.getInstance().post(`/pfemps/${context.pfemp}/emitems/${context.emitem}/emeqsparedetails`,data,isloading);
        }
        if(context.emstore && context.emitem && true){
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            return Http.getInstance().post(`/emstores/${context.emstore}/emitems/${context.emitem}/emeqsparedetails`,data,isloading);
        }
        if(context.emstorepart && context.emitem && true){
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            return Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emeqsparedetails`,data,isloading);
        }
        if(context.emservice && context.emitem && true){
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            return Http.getInstance().post(`/emservices/${context.emservice}/emitems/${context.emitem}/emeqsparedetails`,data,isloading);
        }
        if(context.emitem && true){
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            return Http.getInstance().post(`/emitems/${context.emitem}/emeqsparedetails`,data,isloading);
        }
        if(context.emeqspare && true){
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            return Http.getInstance().post(`/emeqspares/${context.emeqspare}/emeqsparedetails`,data,isloading);
        }
        let masterData:any = {};
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/emeqsparedetails`,data,isloading);
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEQSpareDetailServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emeqsparedetail){
            return Http.getInstance().put(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}`,data,isloading);
        }
        if(context.pfunit && context.emitem && context.emeqsparedetail){
            return Http.getInstance().put(`/pfunits/${context.pfunit}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}`,data,isloading);
        }
        if(context.pfemp && context.emitem && context.emeqsparedetail){
            return Http.getInstance().put(`/pfemps/${context.pfemp}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}`,data,isloading);
        }
        if(context.emstore && context.emitem && context.emeqsparedetail){
            return Http.getInstance().put(`/emstores/${context.emstore}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}`,data,isloading);
        }
        if(context.emstorepart && context.emitem && context.emeqsparedetail){
            return Http.getInstance().put(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}`,data,isloading);
        }
        if(context.emservice && context.emitem && context.emeqsparedetail){
            return Http.getInstance().put(`/emservices/${context.emservice}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}`,data,isloading);
        }
        if(context.emitem && context.emeqsparedetail){
            return Http.getInstance().put(`/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}`,data,isloading);
        }
        if(context.emeqspare && context.emeqsparedetail){
            return Http.getInstance().put(`/emeqspares/${context.emeqspare}/emeqsparedetails/${context.emeqsparedetail}`,data,isloading);
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/emeqsparedetails/${context.emeqsparedetail}`,data,isloading);
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEQSpareDetailServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emeqsparedetail){
            return Http.getInstance().delete(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}`,isloading);
        }
        if(context.pfunit && context.emitem && context.emeqsparedetail){
            return Http.getInstance().delete(`/pfunits/${context.pfunit}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}`,isloading);
        }
        if(context.pfemp && context.emitem && context.emeqsparedetail){
            return Http.getInstance().delete(`/pfemps/${context.pfemp}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}`,isloading);
        }
        if(context.emstore && context.emitem && context.emeqsparedetail){
            return Http.getInstance().delete(`/emstores/${context.emstore}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}`,isloading);
        }
        if(context.emstorepart && context.emitem && context.emeqsparedetail){
            return Http.getInstance().delete(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}`,isloading);
        }
        if(context.emservice && context.emitem && context.emeqsparedetail){
            return Http.getInstance().delete(`/emservices/${context.emservice}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}`,isloading);
        }
        if(context.emitem && context.emeqsparedetail){
            return Http.getInstance().delete(`/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}`,isloading);
        }
        if(context.emeqspare && context.emeqsparedetail){
            return Http.getInstance().delete(`/emeqspares/${context.emeqspare}/emeqsparedetails/${context.emeqsparedetail}`,isloading);
        }
            return Http.getInstance().delete(`/emeqsparedetails/${context.emeqsparedetail}`,isloading);

    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEQSpareDetailServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emeqsparedetail){
            return Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}/checkkey`,data,isloading);
        }
        if(context.pfunit && context.emitem && context.emeqsparedetail){
            return Http.getInstance().post(`/pfunits/${context.pfunit}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}/checkkey`,data,isloading);
        }
        if(context.pfemp && context.emitem && context.emeqsparedetail){
            return Http.getInstance().post(`/pfemps/${context.pfemp}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}/checkkey`,data,isloading);
        }
        if(context.emstore && context.emitem && context.emeqsparedetail){
            return Http.getInstance().post(`/emstores/${context.emstore}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}/checkkey`,data,isloading);
        }
        if(context.emstorepart && context.emitem && context.emeqsparedetail){
            return Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}/checkkey`,data,isloading);
        }
        if(context.emservice && context.emitem && context.emeqsparedetail){
            return Http.getInstance().post(`/emservices/${context.emservice}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}/checkkey`,data,isloading);
        }
        if(context.emitem && context.emeqsparedetail){
            return Http.getInstance().post(`/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}/checkkey`,data,isloading);
        }
        if(context.emeqspare && context.emeqsparedetail){
            return Http.getInstance().post(`/emeqspares/${context.emeqspare}/emeqsparedetails/${context.emeqsparedetail}/checkkey`,data,isloading);
        }
            return Http.getInstance().post(`/emeqsparedetails/${context.emeqsparedetail}/checkkey`,data,isloading);
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEQSpareDetailServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emeqsparedetails/getdraft`,isloading);
        }
        if(context.pfunit && context.emitem && true){
            return Http.getInstance().get(`/pfunits/${context.pfunit}/emitems/${context.emitem}/emeqsparedetails/getdraft`,isloading);
        }
        if(context.pfemp && context.emitem && true){
            return Http.getInstance().get(`/pfemps/${context.pfemp}/emitems/${context.emitem}/emeqsparedetails/getdraft`,isloading);
        }
        if(context.emstore && context.emitem && true){
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emeqsparedetails/getdraft`,isloading);
        }
        if(context.emstorepart && context.emitem && true){
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emeqsparedetails/getdraft`,isloading);
        }
        if(context.emservice && context.emitem && true){
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emeqsparedetails/getdraft`,isloading);
        }
        if(context.emitem && true){
            return Http.getInstance().get(`/emitems/${context.emitem}/emeqsparedetails/getdraft`,isloading);
        }
        if(context.emeqspare && true){
            return Http.getInstance().get(`/emeqspares/${context.emeqspare}/emeqsparedetails/getdraft`,isloading);
        }
        let res:any = await  Http.getInstance().get(`/emeqsparedetails/getdraft`,isloading);
        res.data.emeqsparedetail = data.emeqsparedetail;
        return res;
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEQSpareDetailServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emeqsparedetail){
            return Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}/save`,data,isloading);
        }
        if(context.pfunit && context.emitem && context.emeqsparedetail){
            return Http.getInstance().post(`/pfunits/${context.pfunit}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}/save`,data,isloading);
        }
        if(context.pfemp && context.emitem && context.emeqsparedetail){
            return Http.getInstance().post(`/pfemps/${context.pfemp}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}/save`,data,isloading);
        }
        if(context.emstore && context.emitem && context.emeqsparedetail){
            return Http.getInstance().post(`/emstores/${context.emstore}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}/save`,data,isloading);
        }
        if(context.emstorepart && context.emitem && context.emeqsparedetail){
            return Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}/save`,data,isloading);
        }
        if(context.emservice && context.emitem && context.emeqsparedetail){
            return Http.getInstance().post(`/emservices/${context.emservice}/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}/save`,data,isloading);
        }
        if(context.emitem && context.emeqsparedetail){
            return Http.getInstance().post(`/emitems/${context.emitem}/emeqsparedetails/${context.emeqsparedetail}/save`,data,isloading);
        }
        if(context.emeqspare && context.emeqsparedetail){
            return Http.getInstance().post(`/emeqspares/${context.emeqspare}/emeqsparedetails/${context.emeqsparedetail}/save`,data,isloading);
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/emeqsparedetails/${context.emeqsparedetail}/save`,data,isloading);
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEQSpareDetailServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emeqsparedetails/fetchdefault`,tempData,isloading);
        }
        if(context.pfunit && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/pfunits/${context.pfunit}/emitems/${context.emitem}/emeqsparedetails/fetchdefault`,tempData,isloading);
        }
        if(context.pfemp && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/pfemps/${context.pfemp}/emitems/${context.emitem}/emeqsparedetails/fetchdefault`,tempData,isloading);
        }
        if(context.emstore && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emeqsparedetails/fetchdefault`,tempData,isloading);
        }
        if(context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emeqsparedetails/fetchdefault`,tempData,isloading);
        }
        if(context.emservice && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emeqsparedetails/fetchdefault`,tempData,isloading);
        }
        if(context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emitems/${context.emitem}/emeqsparedetails/fetchdefault`,tempData,isloading);
        }
        if(context.emeqspare && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emeqspares/${context.emeqspare}/emeqsparedetails/fetchdefault`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emeqsparedetails/fetchdefault`,tempData,isloading);
    }
}