package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.po.domain.THEUPDATE;
import cn.ibizlab.eam.core.po.service.ITHEUPDATEService;
import cn.ibizlab.eam.core.po.filter.THEUPDATESearchContext;
import cn.ibizlab.eam.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"实体" })
@RestController("WebApi-theupdate")
@RequestMapping("")
public class THEUPDATEResource {

    @Autowired
    public ITHEUPDATEService theupdateService;

    @Autowired
    @Lazy
    public THEUPDATEMapping theupdateMapping;

    @PreAuthorize("hasPermission(this.theupdateMapping.toDomain(#theupdatedto),'eam_practice04-THEUPDATE-Create')")
    @ApiOperation(value = "新建实体", tags = {"实体" },  notes = "新建实体")
	@RequestMapping(method = RequestMethod.POST, value = "/theupdates")
    @Transactional
    public ResponseEntity<THEUPDATEDTO> create(@RequestBody THEUPDATEDTO theupdatedto) {
        THEUPDATE domain = theupdateMapping.toDomain(theupdatedto);
		theupdateService.create(domain);
        THEUPDATEDTO dto = theupdateMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.theupdateMapping.toDomain(#theupdatedtos),'eam_practice04-THEUPDATE-Create')")
    @ApiOperation(value = "批量新建实体", tags = {"实体" },  notes = "批量新建实体")
	@RequestMapping(method = RequestMethod.POST, value = "/theupdates/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<THEUPDATEDTO> theupdatedtos) {
        theupdateService.createBatch(theupdateMapping.toDomain(theupdatedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "theupdate" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.theupdateService.get(#theupdate_id),'eam_practice04-THEUPDATE-Update')")
    @ApiOperation(value = "更新实体", tags = {"实体" },  notes = "更新实体")
	@RequestMapping(method = RequestMethod.PUT, value = "/theupdates/{theupdate_id}")
    @Transactional
    public ResponseEntity<THEUPDATEDTO> update(@PathVariable("theupdate_id") String theupdate_id, @RequestBody THEUPDATEDTO theupdatedto) {
		THEUPDATE domain  = theupdateMapping.toDomain(theupdatedto);
        domain .setTheupdateid(theupdate_id);
		theupdateService.update(domain );
		THEUPDATEDTO dto = theupdateMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.theupdateService.getTheupdateByEntities(this.theupdateMapping.toDomain(#theupdatedtos)),'eam_practice04-THEUPDATE-Update')")
    @ApiOperation(value = "批量更新实体", tags = {"实体" },  notes = "批量更新实体")
	@RequestMapping(method = RequestMethod.PUT, value = "/theupdates/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<THEUPDATEDTO> theupdatedtos) {
        theupdateService.updateBatch(theupdateMapping.toDomain(theupdatedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.theupdateService.get(#theupdate_id),'eam_practice04-THEUPDATE-Remove')")
    @ApiOperation(value = "删除实体", tags = {"实体" },  notes = "删除实体")
	@RequestMapping(method = RequestMethod.DELETE, value = "/theupdates/{theupdate_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("theupdate_id") String theupdate_id) {
         return ResponseEntity.status(HttpStatus.OK).body(theupdateService.remove(theupdate_id));
    }

    @PreAuthorize("hasPermission(this.theupdateService.getTheupdateByIds(#ids),'eam_practice04-THEUPDATE-Remove')")
    @ApiOperation(value = "批量删除实体", tags = {"实体" },  notes = "批量删除实体")
	@RequestMapping(method = RequestMethod.DELETE, value = "/theupdates/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        theupdateService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.theupdateMapping.toDomain(returnObject.body),'eam_practice04-THEUPDATE-Get')")
    @ApiOperation(value = "获取实体", tags = {"实体" },  notes = "获取实体")
	@RequestMapping(method = RequestMethod.GET, value = "/theupdates/{theupdate_id}")
    public ResponseEntity<THEUPDATEDTO> get(@PathVariable("theupdate_id") String theupdate_id) {
        THEUPDATE domain = theupdateService.get(theupdate_id);
        THEUPDATEDTO dto = theupdateMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取实体草稿", tags = {"实体" },  notes = "获取实体草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/theupdates/getdraft")
    public ResponseEntity<THEUPDATEDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(theupdateMapping.toDto(theupdateService.getDraft(new THEUPDATE())));
    }

    @ApiOperation(value = "检查实体", tags = {"实体" },  notes = "检查实体")
	@RequestMapping(method = RequestMethod.POST, value = "/theupdates/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody THEUPDATEDTO theupdatedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(theupdateService.checkKey(theupdateMapping.toDomain(theupdatedto)));
    }

    @PreAuthorize("hasPermission(this.theupdateMapping.toDomain(#theupdatedto),'eam_practice04-THEUPDATE-Save')")
    @ApiOperation(value = "保存实体", tags = {"实体" },  notes = "保存实体")
	@RequestMapping(method = RequestMethod.POST, value = "/theupdates/save")
    public ResponseEntity<Boolean> save(@RequestBody THEUPDATEDTO theupdatedto) {
        return ResponseEntity.status(HttpStatus.OK).body(theupdateService.save(theupdateMapping.toDomain(theupdatedto)));
    }

    @PreAuthorize("hasPermission(this.theupdateMapping.toDomain(#theupdatedtos),'eam_practice04-THEUPDATE-Save')")
    @ApiOperation(value = "批量保存实体", tags = {"实体" },  notes = "批量保存实体")
	@RequestMapping(method = RequestMethod.POST, value = "/theupdates/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<THEUPDATEDTO> theupdatedtos) {
        theupdateService.saveBatch(theupdateMapping.toDomain(theupdatedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-THEUPDATE-searchDefault-all') and hasPermission(#context,'eam_practice04-THEUPDATE-Get')")
	@ApiOperation(value = "获取DEFAULT", tags = {"实体" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/theupdates/fetchdefault")
	public ResponseEntity<List<THEUPDATEDTO>> fetchDefault(THEUPDATESearchContext context) {
        Page<THEUPDATE> domains = theupdateService.searchDefault(context) ;
        List<THEUPDATEDTO> list = theupdateMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-THEUPDATE-searchDefault-all') and hasPermission(#context,'eam_practice04-THEUPDATE-Get')")
	@ApiOperation(value = "查询DEFAULT", tags = {"实体" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/theupdates/searchdefault")
	public ResponseEntity<Page<THEUPDATEDTO>> searchDefault(@RequestBody THEUPDATESearchContext context) {
        Page<THEUPDATE> domains = theupdateService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(theupdateMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}

