package cn.ibizlab.eam.webapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;
import cn.ibizlab.eam.util.domain.DTOBase;
import lombok.Data;

/**
 * 服务DTO对象[EMWOORIDTO]
 */
@Data
public class EMWOORIDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [DESCRIPTION]
     *
     */
    @JSONField(name = "description")
    @JsonProperty("description")
    private String description;

    /**
     * 属性 [ENABLE]
     *
     */
    @JSONField(name = "enable")
    @JsonProperty("enable")
    private Integer enable;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [ORGID]
     *
     */
    @JSONField(name = "orgid")
    @JsonProperty("orgid")
    private String orgid;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [EMWOORINAME]
     *
     */
    @JSONField(name = "emwooriname")
    @JsonProperty("emwooriname")
    private String emwooriname;

    /**
     * 属性 [WOORIINFO]
     *
     */
    @JSONField(name = "wooriinfo")
    @JsonProperty("wooriinfo")
    private String wooriinfo;

    /**
     * 属性 [EMWOORIID]
     *
     */
    @JSONField(name = "emwooriid")
    @JsonProperty("emwooriid")
    private String emwooriid;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;

    /**
     * 属性 [EMWOORITYPE]
     *
     */
    @JSONField(name = "emwooritype")
    @JsonProperty("emwooritype")
    private String emwooritype;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;


    /**
     * 设置 [DESCRIPTION]
     */
    public void setDescription(String  description){
        this.description = description ;
        this.modify("description",description);
    }

    /**
     * 设置 [EMWOORINAME]
     */
    public void setEmwooriname(String  emwooriname){
        this.emwooriname = emwooriname ;
        this.modify("emwooriname",emwooriname);
    }

    /**
     * 设置 [EMWOORITYPE]
     */
    public void setEmwooritype(String  emwooritype){
        this.emwooritype = emwooritype ;
        this.modify("emwooritype",emwooritype);
    }


}

