package cn.ibizlab.eam.webapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;
import cn.ibizlab.eam.util.domain.DTOBase;
import lombok.Data;

/**
 * 服务DTO对象[EMBrandDTO]
 */
@Data
public class EMBrandDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [EMBRANDID]
     *
     */
    @JSONField(name = "embrandid")
    @JsonProperty("embrandid")
    private String embrandid;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;

    /**
     * 属性 [ENABLE]
     *
     */
    @JSONField(name = "enable")
    @JsonProperty("enable")
    private Integer enable;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [EMBRANDNAME]
     *
     */
    @JSONField(name = "embrandname")
    @JsonProperty("embrandname")
    private String embrandname;

    /**
     * 属性 [EMBRANDCODE]
     *
     */
    @JSONField(name = "embrandcode")
    @JsonProperty("embrandcode")
    private String embrandcode;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [MACHTYPECODE]
     *
     */
    @JSONField(name = "machtypecode")
    @JsonProperty("machtypecode")
    private String machtypecode;


    /**
     * 设置 [EMBRANDNAME]
     */
    public void setEmbrandname(String  embrandname){
        this.embrandname = embrandname ;
        this.modify("embrandname",embrandname);
    }

    /**
     * 设置 [EMBRANDCODE]
     */
    public void setEmbrandcode(String  embrandcode){
        this.embrandcode = embrandcode ;
        this.modify("embrandcode",embrandcode);
    }

    /**
     * 设置 [MACHTYPECODE]
     */
    public void setMachtypecode(String  machtypecode){
        this.machtypecode = machtypecode ;
        this.modify("machtypecode",machtypecode);
    }


}

