package cn.ibizlab.eam.webapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;
import cn.ibizlab.eam.util.domain.DTOBase;
import lombok.Data;

/**
 * 服务DTO对象[EMWPListCostDTO]
 */
@Data
public class EMWPListCostDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [WPLISTCOSTINFO]
     *
     */
    @JSONField(name = "wplistcostinfo")
    @JsonProperty("wplistcostinfo")
    private String wplistcostinfo;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [PRICE]
     *
     */
    @JSONField(name = "price")
    @JsonProperty("price")
    private String price;

    /**
     * 属性 [ADATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "adate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("adate")
    private Timestamp adate;

    /**
     * 属性 [EMWPLISTCOSTNAME]
     *
     */
    @JSONField(name = "emwplistcostname")
    @JsonProperty("emwplistcostname")
    private String emwplistcostname;

    /**
     * 属性 [DISCNT]
     *
     */
    @JSONField(name = "discnt")
    @JsonProperty("discnt")
    private Double discnt;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [ITEMDESC]
     *
     */
    @JSONField(name = "itemdesc")
    @JsonProperty("itemdesc")
    private String itemdesc;

    /**
     * 属性 [UNITRATE]
     *
     */
    @JSONField(name = "unitrate")
    @JsonProperty("unitrate")
    private Double unitrate;

    /**
     * 属性 [BEGINDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "begindate" , format="yyyy-MM-dd")
    @JsonProperty("begindate")
    private Timestamp begindate;

    /**
     * 属性 [LISTPRICE]
     *
     */
    @JSONField(name = "listprice")
    @JsonProperty("listprice")
    private String listprice;

    /**
     * 属性 [ITEMS]
     *
     */
    @JSONField(name = "items")
    @JsonProperty("items")
    private String items;

    /**
     * 属性 [ORGID]
     *
     */
    @JSONField(name = "orgid")
    @JsonProperty("orgid")
    private String orgid;

    /**
     * 属性 [PRICECDT]
     *
     */
    @JSONField(name = "pricecdt")
    @JsonProperty("pricecdt")
    private String pricecdt;

    /**
     * 属性 [INTUNITFLAG]
     *
     */
    @JSONField(name = "intunitflag")
    @JsonProperty("intunitflag")
    private Integer intunitflag;

    /**
     * 属性 [DESCRIPTION]
     *
     */
    @JSONField(name = "description")
    @JsonProperty("description")
    private String description;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;

    /**
     * 属性 [EMWPLISTCOSTID]
     *
     */
    @JSONField(name = "emwplistcostid")
    @JsonProperty("emwplistcostid")
    private String emwplistcostid;

    /**
     * 属性 [WPLISTCOSTEVAL]
     *
     */
    @JSONField(name = "wplistcosteval")
    @JsonProperty("wplistcosteval")
    private Double wplistcosteval;

    /**
     * 属性 [UNITDESC]
     *
     */
    @JSONField(name = "unitdesc")
    @JsonProperty("unitdesc")
    private String unitdesc;

    /**
     * 属性 [ENDDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "enddate" , format="yyyy-MM-dd")
    @JsonProperty("enddate")
    private Timestamp enddate;

    /**
     * 属性 [WPLISTCOSTRESULT]
     *
     */
    @JSONField(name = "wplistcostresult")
    @JsonProperty("wplistcostresult")
    private String wplistcostresult;

    /**
     * 属性 [ENABLE]
     *
     */
    @JSONField(name = "enable")
    @JsonProperty("enable")
    private Integer enable;

    /**
     * 属性 [TAXRATE]
     *
     */
    @JSONField(name = "taxrate")
    @JsonProperty("taxrate")
    private Double taxrate;

    /**
     * 属性 [SUNITPRICE]
     *
     */
    @JSONField(name = "sunitprice")
    @JsonProperty("sunitprice")
    private Double sunitprice;

    /**
     * 属性 [SUNITID]
     *
     */
    @JSONField(name = "sunitid")
    @JsonProperty("sunitid")
    private String sunitid;

    /**
     * 属性 [UNITNAME]
     *
     */
    @JSONField(name = "unitname")
    @JsonProperty("unitname")
    private String unitname;

    /**
     * 属性 [REMPNAME]
     *
     */
    @JSONField(name = "rempname")
    @JsonProperty("rempname")
    private String rempname;

    /**
     * 属性 [SUNITNAME]
     *
     */
    @JSONField(name = "sunitname")
    @JsonProperty("sunitname")
    private String sunitname;

    /**
     * 属性 [ITEMNAME]
     *
     */
    @JSONField(name = "itemname")
    @JsonProperty("itemname")
    private String itemname;

    /**
     * 属性 [LABSERVICENAME]
     *
     */
    @JSONField(name = "labservicename")
    @JsonProperty("labservicename")
    private String labservicename;

    /**
     * 属性 [AVGPRICE]
     *
     */
    @JSONField(name = "avgprice")
    @JsonProperty("avgprice")
    private String avgprice;

    /**
     * 属性 [WPLISTID]
     *
     */
    @JSONField(name = "wplistid")
    @JsonProperty("wplistid")
    private String wplistid;

    /**
     * 属性 [REMPID]
     *
     */
    @JSONField(name = "rempid")
    @JsonProperty("rempid")
    private String rempid;

    /**
     * 属性 [LABSERVICEID]
     *
     */
    @JSONField(name = "labserviceid")
    @JsonProperty("labserviceid")
    private String labserviceid;

    /**
     * 属性 [ITEMID]
     *
     */
    @JSONField(name = "itemid")
    @JsonProperty("itemid")
    private String itemid;

    /**
     * 属性 [UNITID]
     *
     */
    @JSONField(name = "unitid")
    @JsonProperty("unitid")
    private String unitid;


    /**
     * 设置 [PRICE]
     */
    public void setPrice(String  price){
        this.price = price ;
        this.modify("price",price);
    }

    /**
     * 设置 [ADATE]
     */
    public void setAdate(Timestamp  adate){
        this.adate = adate ;
        this.modify("adate",adate);
    }

    /**
     * 设置 [EMWPLISTCOSTNAME]
     */
    public void setEmwplistcostname(String  emwplistcostname){
        this.emwplistcostname = emwplistcostname ;
        this.modify("emwplistcostname",emwplistcostname);
    }

    /**
     * 设置 [DISCNT]
     */
    public void setDiscnt(Double  discnt){
        this.discnt = discnt ;
        this.modify("discnt",discnt);
    }

    /**
     * 设置 [ITEMDESC]
     */
    public void setItemdesc(String  itemdesc){
        this.itemdesc = itemdesc ;
        this.modify("itemdesc",itemdesc);
    }

    /**
     * 设置 [UNITRATE]
     */
    public void setUnitrate(Double  unitrate){
        this.unitrate = unitrate ;
        this.modify("unitrate",unitrate);
    }

    /**
     * 设置 [BEGINDATE]
     */
    public void setBegindate(Timestamp  begindate){
        this.begindate = begindate ;
        this.modify("begindate",begindate);
    }

    /**
     * 设置 [LISTPRICE]
     */
    public void setListprice(String  listprice){
        this.listprice = listprice ;
        this.modify("listprice",listprice);
    }

    /**
     * 设置 [PRICECDT]
     */
    public void setPricecdt(String  pricecdt){
        this.pricecdt = pricecdt ;
        this.modify("pricecdt",pricecdt);
    }

    /**
     * 设置 [INTUNITFLAG]
     */
    public void setIntunitflag(Integer  intunitflag){
        this.intunitflag = intunitflag ;
        this.modify("intunitflag",intunitflag);
    }

    /**
     * 设置 [DESCRIPTION]
     */
    public void setDescription(String  description){
        this.description = description ;
        this.modify("description",description);
    }

    /**
     * 设置 [UNITDESC]
     */
    public void setUnitdesc(String  unitdesc){
        this.unitdesc = unitdesc ;
        this.modify("unitdesc",unitdesc);
    }

    /**
     * 设置 [ENDDATE]
     */
    public void setEnddate(Timestamp  enddate){
        this.enddate = enddate ;
        this.modify("enddate",enddate);
    }

    /**
     * 设置 [TAXRATE]
     */
    public void setTaxrate(Double  taxrate){
        this.taxrate = taxrate ;
        this.modify("taxrate",taxrate);
    }

    /**
     * 设置 [WPLISTID]
     */
    public void setWplistid(String  wplistid){
        this.wplistid = wplistid ;
        this.modify("wplistid",wplistid);
    }

    /**
     * 设置 [REMPID]
     */
    public void setRempid(String  rempid){
        this.rempid = rempid ;
        this.modify("rempid",rempid);
    }

    /**
     * 设置 [LABSERVICEID]
     */
    public void setLabserviceid(String  labserviceid){
        this.labserviceid = labserviceid ;
        this.modify("labserviceid",labserviceid);
    }

    /**
     * 设置 [ITEMID]
     */
    public void setItemid(String  itemid){
        this.itemid = itemid ;
        this.modify("itemid",itemid);
    }

    /**
     * 设置 [UNITID]
     */
    public void setUnitid(String  unitid){
        this.unitid = unitid ;
        this.modify("unitid",unitid);
    }


}

