package cn.ibizlab.eam.webapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;
import cn.ibizlab.eam.util.domain.DTOBase;
import lombok.Data;

/**
 * 服务DTO对象[EMResItemDTO]
 */
@Data
public class EMResItemDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [PRICE]
     *
     */
    @JSONField(name = "price")
    @JsonProperty("price")
    private String price;

    /**
     * 属性 [AMOUNT]
     *
     */
    @JSONField(name = "amount")
    @JsonProperty("amount")
    private String amount;

    /**
     * 属性 [EMRESITEMNAME]
     *
     */
    @JSONField(name = "emresitemname")
    @JsonProperty("emresitemname")
    private String emresitemname;

    /**
     * 属性 [DESCRIPTION]
     *
     */
    @JSONField(name = "description")
    @JsonProperty("description")
    private String description;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [PNUM]
     *
     */
    @JSONField(name = "pnum")
    @JsonProperty("pnum")
    private Double pnum;

    /**
     * 属性 [BDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "bdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("bdate")
    private Timestamp bdate;

    /**
     * 属性 [SNUM]
     *
     */
    @JSONField(name = "snum")
    @JsonProperty("snum")
    private Double snum;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;

    /**
     * 属性 [EMRESITEMID]
     *
     */
    @JSONField(name = "emresitemid")
    @JsonProperty("emresitemid")
    private String emresitemid;

    /**
     * 属性 [ORGID]
     *
     */
    @JSONField(name = "orgid")
    @JsonProperty("orgid")
    private String orgid;

    /**
     * 属性 [EDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "edate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("edate")
    private Timestamp edate;

    /**
     * 属性 [ENABLE]
     *
     */
    @JSONField(name = "enable")
    @JsonProperty("enable")
    private Integer enable;

    /**
     * 属性 [DATAFROM]
     *
     */
    @JSONField(name = "datafrom")
    @JsonProperty("datafrom")
    private String datafrom;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [RESREFOBJNAME]
     *
     */
    @JSONField(name = "resrefobjname")
    @JsonProperty("resrefobjname")
    private String resrefobjname;

    /**
     * 属性 [ITEMBTYPENAME]
     *
     */
    @JSONField(name = "itembtypename")
    @JsonProperty("itembtypename")
    private String itembtypename;

    /**
     * 属性 [SNAME]
     *
     */
    @JSONField(name = "sname")
    @JsonProperty("sname")
    private String sname;

    /**
     * 属性 [EQUIPCODE]
     *
     */
    @JSONField(name = "equipcode")
    @JsonProperty("equipcode")
    private String equipcode;

    /**
     * 属性 [ITEMBTYPEID]
     *
     */
    @JSONField(name = "itembtypeid")
    @JsonProperty("itembtypeid")
    private String itembtypeid;

    /**
     * 属性 [RESNAME_SHOW]
     *
     */
    @JSONField(name = "resname_show")
    @JsonProperty("resname_show")
    private String resnameShow;

    /**
     * 属性 [ITEMMTYPENAME]
     *
     */
    @JSONField(name = "itemmtypename")
    @JsonProperty("itemmtypename")
    private String itemmtypename;

    /**
     * 属性 [UNITNAME]
     *
     */
    @JSONField(name = "unitname")
    @JsonProperty("unitname")
    private String unitname;

    /**
     * 属性 [ITEMMTYPEID]
     *
     */
    @JSONField(name = "itemmtypeid")
    @JsonProperty("itemmtypeid")
    private String itemmtypeid;

    /**
     * 属性 [EQUIPNAME]
     *
     */
    @JSONField(name = "equipname")
    @JsonProperty("equipname")
    private String equipname;

    /**
     * 属性 [RESNAME]
     *
     */
    @JSONField(name = "resname")
    @JsonProperty("resname")
    private String resname;

    /**
     * 属性 [ITEMTYPEID]
     *
     */
    @JSONField(name = "itemtypeid")
    @JsonProperty("itemtypeid")
    private String itemtypeid;

    /**
     * 属性 [TEAMNAME]
     *
     */
    @JSONField(name = "teamname")
    @JsonProperty("teamname")
    private String teamname;

    /**
     * 属性 [EQENABLE]
     *
     */
    @JSONField(name = "eqenable")
    @JsonProperty("eqenable")
    private Integer eqenable;

    /**
     * 属性 [RESID]
     *
     */
    @JSONField(name = "resid")
    @JsonProperty("resid")
    private String resid;

    /**
     * 属性 [RESREFOBJID]
     *
     */
    @JSONField(name = "resrefobjid")
    @JsonProperty("resrefobjid")
    private String resrefobjid;

    /**
     * 属性 [EQUIPID]
     *
     */
    @JSONField(name = "equipid")
    @JsonProperty("equipid")
    private String equipid;


    /**
     * 设置 [PRICE]
     */
    public void setPrice(String  price){
        this.price = price ;
        this.modify("price",price);
    }

    /**
     * 设置 [AMOUNT]
     */
    public void setAmount(String  amount){
        this.amount = amount ;
        this.modify("amount",amount);
    }

    /**
     * 设置 [EMRESITEMNAME]
     */
    public void setEmresitemname(String  emresitemname){
        this.emresitemname = emresitemname ;
        this.modify("emresitemname",emresitemname);
    }

    /**
     * 设置 [DESCRIPTION]
     */
    public void setDescription(String  description){
        this.description = description ;
        this.modify("description",description);
    }

    /**
     * 设置 [PNUM]
     */
    public void setPnum(Double  pnum){
        this.pnum = pnum ;
        this.modify("pnum",pnum);
    }

    /**
     * 设置 [BDATE]
     */
    public void setBdate(Timestamp  bdate){
        this.bdate = bdate ;
        this.modify("bdate",bdate);
    }

    /**
     * 设置 [SNUM]
     */
    public void setSnum(Double  snum){
        this.snum = snum ;
        this.modify("snum",snum);
    }

    /**
     * 设置 [EDATE]
     */
    public void setEdate(Timestamp  edate){
        this.edate = edate ;
        this.modify("edate",edate);
    }

    /**
     * 设置 [DATAFROM]
     */
    public void setDatafrom(String  datafrom){
        this.datafrom = datafrom ;
        this.modify("datafrom",datafrom);
    }

    /**
     * 设置 [RESID]
     */
    public void setResid(String  resid){
        this.resid = resid ;
        this.modify("resid",resid);
    }

    /**
     * 设置 [RESREFOBJID]
     */
    public void setResrefobjid(String  resrefobjid){
        this.resrefobjid = resrefobjid ;
        this.modify("resrefobjid",resrefobjid);
    }

    /**
     * 设置 [EQUIPID]
     */
    public void setEquipid(String  equipid){
        this.equipid = equipid ;
        this.modify("equipid",equipid);
    }


}

