package cn.ibizlab.eam.webapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;
import cn.ibizlab.eam.util.domain.DTOBase;
import lombok.Data;

/**
 * 服务DTO对象[EMBiddingDTO]
 */
@Data
public class EMBiddingDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [ENABLE]
     *
     */
    @JSONField(name = "enable")
    @JsonProperty("enable")
    private Integer enable;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [EMBIDDINGID]
     *
     */
    @JSONField(name = "embiddingid")
    @JsonProperty("embiddingid")
    private String embiddingid;

    /**
     * 属性 [PARAMETER]
     *
     */
    @JSONField(name = "parameter")
    @JsonProperty("parameter")
    private String parameter;

    /**
     * 属性 [QUALIFICATION]
     *
     */
    @JSONField(name = "qualification")
    @JsonProperty("qualification")
    private String qualification;

    /**
     * 属性 [PRICE]
     *
     */
    @JSONField(name = "price")
    @JsonProperty("price")
    private String price;

    /**
     * 属性 [ACHIEVEMENT]
     *
     */
    @JSONField(name = "achievement")
    @JsonProperty("achievement")
    private String achievement;

    /**
     * 属性 [EMBIDDINGNAME]
     *
     */
    @JSONField(name = "embiddingname")
    @JsonProperty("embiddingname")
    private String embiddingname;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [EMSERVICENAME]
     *
     */
    @JSONField(name = "emservicename")
    @JsonProperty("emservicename")
    private String emservicename;

    /**
     * 属性 [EMSERVICEID]
     *
     */
    @JSONField(name = "emserviceid")
    @JsonProperty("emserviceid")
    private String emserviceid;


    /**
     * 设置 [PARAMETER]
     */
    public void setParameter(String  parameter){
        this.parameter = parameter ;
        this.modify("parameter",parameter);
    }

    /**
     * 设置 [QUALIFICATION]
     */
    public void setQualification(String  qualification){
        this.qualification = qualification ;
        this.modify("qualification",qualification);
    }

    /**
     * 设置 [PRICE]
     */
    public void setPrice(String  price){
        this.price = price ;
        this.modify("price",price);
    }

    /**
     * 设置 [ACHIEVEMENT]
     */
    public void setAchievement(String  achievement){
        this.achievement = achievement ;
        this.modify("achievement",achievement);
    }

    /**
     * 设置 [EMBIDDINGNAME]
     */
    public void setEmbiddingname(String  embiddingname){
        this.embiddingname = embiddingname ;
        this.modify("embiddingname",embiddingname);
    }

    /**
     * 设置 [EMSERVICEID]
     */
    public void setEmserviceid(String  emserviceid){
        this.emserviceid = emserviceid ;
        this.modify("emserviceid",emserviceid);
    }


}

