package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMItemPRtn;
import cn.ibizlab.eam.core.eam_core.service.IEMItemPRtnService;
import cn.ibizlab.eam.core.eam_core.filter.EMItemPRtnSearchContext;
import cn.ibizlab.eam.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"还料单" })
@RestController("WebApi-emitemprtn")
@RequestMapping("")
public class EMItemPRtnResource {

    @Autowired
    public IEMItemPRtnService emitemprtnService;

    @Autowired
    @Lazy
    public EMItemPRtnMapping emitemprtnMapping;

    @PreAuthorize("hasPermission(this.emitemprtnMapping.toDomain(#emitemprtndto),'eam_practice04-EMItemPRtn-Create')")
    @ApiOperation(value = "新建还料单", tags = {"还料单" },  notes = "新建还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemprtns")
    @Transactional
    public ResponseEntity<EMItemPRtnDTO> create(@RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
		emitemprtnService.create(domain);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemprtnMapping.toDomain(#emitemprtndtos),'eam_practice04-EMItemPRtn-Create')")
    @ApiOperation(value = "批量新建还料单", tags = {"还料单" },  notes = "批量新建还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemprtns/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        emitemprtnService.createBatch(emitemprtnMapping.toDomain(emitemprtndtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "emitemprtn" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.emitemprtnService.get(#emitemprtn_id),'eam_practice04-EMItemPRtn-Update')")
    @ApiOperation(value = "更新还料单", tags = {"还料单" },  notes = "更新还料单")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitemprtns/{emitemprtn_id}")
    @Transactional
    public ResponseEntity<EMItemPRtnDTO> update(@PathVariable("emitemprtn_id") String emitemprtn_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
		EMItemPRtn domain  = emitemprtnMapping.toDomain(emitemprtndto);
        domain .setEmitemprtnid(emitemprtn_id);
		emitemprtnService.update(domain );
		EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemprtnService.getEmitemprtnByEntities(this.emitemprtnMapping.toDomain(#emitemprtndtos)),'eam_practice04-EMItemPRtn-Update')")
    @ApiOperation(value = "批量更新还料单", tags = {"还料单" },  notes = "批量更新还料单")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitemprtns/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        emitemprtnService.updateBatch(emitemprtnMapping.toDomain(emitemprtndtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emitemprtnService.get(#emitemprtn_id),'eam_practice04-EMItemPRtn-Remove')")
    @ApiOperation(value = "删除还料单", tags = {"还料单" },  notes = "删除还料单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitemprtns/{emitemprtn_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emitemprtn_id") String emitemprtn_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.remove(emitemprtn_id));
    }

    @PreAuthorize("hasPermission(this.emitemprtnService.getEmitemprtnByIds(#ids),'eam_practice04-EMItemPRtn-Remove')")
    @ApiOperation(value = "批量删除还料单", tags = {"还料单" },  notes = "批量删除还料单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitemprtns/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emitemprtnService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.emitemprtnMapping.toDomain(returnObject.body),'eam_practice04-EMItemPRtn-Get')")
    @ApiOperation(value = "获取还料单", tags = {"还料单" },  notes = "获取还料单")
	@RequestMapping(method = RequestMethod.GET, value = "/emitemprtns/{emitemprtn_id}")
    public ResponseEntity<EMItemPRtnDTO> get(@PathVariable("emitemprtn_id") String emitemprtn_id) {
        EMItemPRtn domain = emitemprtnService.get(emitemprtn_id);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取还料单草稿", tags = {"还料单" },  notes = "获取还料单草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/emitemprtns/getdraft")
    public ResponseEntity<EMItemPRtnDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emitemprtnMapping.toDto(emitemprtnService.getDraft(new EMItemPRtn())));
    }

    @ApiOperation(value = "检查还料单", tags = {"还料单" },  notes = "检查还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemprtns/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMItemPRtnDTO emitemprtndto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.checkKey(emitemprtnMapping.toDomain(emitemprtndto)));
    }

    @PreAuthorize("hasPermission(this.emitemprtnMapping.toDomain(#emitemprtndto),'eam_practice04-EMItemPRtn-Save')")
    @ApiOperation(value = "保存还料单", tags = {"还料单" },  notes = "保存还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemprtns/save")
    public ResponseEntity<Boolean> save(@RequestBody EMItemPRtnDTO emitemprtndto) {
        return ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.save(emitemprtnMapping.toDomain(emitemprtndto)));
    }

    @PreAuthorize("hasPermission(this.emitemprtnMapping.toDomain(#emitemprtndtos),'eam_practice04-EMItemPRtn-Save')")
    @ApiOperation(value = "批量保存还料单", tags = {"还料单" },  notes = "批量保存还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemprtns/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        emitemprtnService.saveBatch(emitemprtnMapping.toDomain(emitemprtndtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMItemPRtn-searchDefault-all') and hasPermission(#context,'eam_practice04-EMItemPRtn-Get')")
	@ApiOperation(value = "获取DEFAULT", tags = {"还料单" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emitemprtns/fetchdefault")
	public ResponseEntity<List<EMItemPRtnDTO>> fetchDefault(EMItemPRtnSearchContext context) {
        Page<EMItemPRtn> domains = emitemprtnService.searchDefault(context) ;
        List<EMItemPRtnDTO> list = emitemprtnMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMItemPRtn-searchDefault-all') and hasPermission(#context,'eam_practice04-EMItemPRtn-Get')")
	@ApiOperation(value = "查询DEFAULT", tags = {"还料单" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emitemprtns/searchdefault")
	public ResponseEntity<Page<EMItemPRtnDTO>> searchDefault(@RequestBody EMItemPRtnSearchContext context) {
        Page<EMItemPRtn> domains = emitemprtnService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemprtnMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(this.emitemprtnMapping.toDomain(#emitemprtndto),'eam_practice04-EMItemPRtn-Create')")
    @ApiOperation(value = "根据物品建立还料单", tags = {"还料单" },  notes = "根据物品建立还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitemprtns")
    @Transactional
    public ResponseEntity<EMItemPRtnDTO> createByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
		emitemprtnService.create(domain);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemprtnMapping.toDomain(#emitemprtndtos),'eam_practice04-EMItemPRtn-Create')")
    @ApiOperation(value = "根据物品批量建立还料单", tags = {"还料单" },  notes = "根据物品批量建立还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> createBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemprtnService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "emitemprtn" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.emitemprtnService.get(#emitemprtn_id),'eam_practice04-EMItemPRtn-Update')")
    @ApiOperation(value = "根据物品更新还料单", tags = {"还料单" },  notes = "根据物品更新还料单")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    @Transactional
    public ResponseEntity<EMItemPRtnDTO> updateByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
        domain.setEmitemprtnid(emitemprtn_id);
		emitemprtnService.update(domain);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemprtnService.getEmitemprtnByEntities(this.emitemprtnMapping.toDomain(#emitemprtndtos)),'eam_practice04-EMItemPRtn-Update')")
    @ApiOperation(value = "根据物品批量更新还料单", tags = {"还料单" },  notes = "根据物品批量更新还料单")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> updateBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemprtnService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emitemprtnService.get(#emitemprtn_id),'eam_practice04-EMItemPRtn-Remove')")
    @ApiOperation(value = "根据物品删除还料单", tags = {"还料单" },  notes = "根据物品删除还料单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.remove(emitemprtn_id));
    }

    @PreAuthorize("hasPermission(this.emitemprtnService.getEmitemprtnByIds(#ids),'eam_practice04-EMItemPRtn-Remove')")
    @ApiOperation(value = "根据物品批量删除还料单", tags = {"还料单" },  notes = "根据物品批量删除还料单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> removeBatchByEMItem(@RequestBody List<String> ids) {
        emitemprtnService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.emitemprtnMapping.toDomain(returnObject.body),'eam_practice04-EMItemPRtn-Get')")
    @ApiOperation(value = "根据物品获取还料单", tags = {"还料单" },  notes = "根据物品获取还料单")
	@RequestMapping(method = RequestMethod.GET, value = "/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    public ResponseEntity<EMItemPRtnDTO> getByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id) {
        EMItemPRtn domain = emitemprtnService.get(emitemprtn_id);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "根据物品获取还料单草稿", tags = {"还料单" },  notes = "根据物品获取还料单草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/emitems/{emitem_id}/emitemprtns/getdraft")
    public ResponseEntity<EMItemPRtnDTO> getDraftByEMItem(@PathVariable("emitem_id") String emitem_id) {
        EMItemPRtn domain = new EMItemPRtn();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemprtnMapping.toDto(emitemprtnService.getDraft(domain)));
    }

    @ApiOperation(value = "根据物品检查还料单", tags = {"还料单" },  notes = "根据物品检查还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitemprtns/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.checkKey(emitemprtnMapping.toDomain(emitemprtndto)));
    }

    @PreAuthorize("hasPermission(this.emitemprtnMapping.toDomain(#emitemprtndto),'eam_practice04-EMItemPRtn-Save')")
    @ApiOperation(value = "根据物品保存还料单", tags = {"还料单" },  notes = "根据物品保存还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitemprtns/save")
    public ResponseEntity<Boolean> saveByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.save(domain));
    }

    @PreAuthorize("hasPermission(this.emitemprtnMapping.toDomain(#emitemprtndtos),'eam_practice04-EMItemPRtn-Save')")
    @ApiOperation(value = "根据物品批量保存还料单", tags = {"还料单" },  notes = "根据物品批量保存还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitemprtns/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemprtnService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMItemPRtn-searchDefault-all') and hasPermission(#context,'eam_practice04-EMItemPRtn-Get')")
	@ApiOperation(value = "根据物品获取DEFAULT", tags = {"还料单" } ,notes = "根据物品获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emitems/{emitem_id}/emitemprtns/fetchdefault")
	public ResponseEntity<List<EMItemPRtnDTO>> fetchEMItemPRtnDefaultByEMItem(@PathVariable("emitem_id") String emitem_id,EMItemPRtnSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPRtn> domains = emitemprtnService.searchDefault(context) ;
        List<EMItemPRtnDTO> list = emitemprtnMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMItemPRtn-searchDefault-all') and hasPermission(#context,'eam_practice04-EMItemPRtn-Get')")
	@ApiOperation(value = "根据物品查询DEFAULT", tags = {"还料单" } ,notes = "根据物品查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emitems/{emitem_id}/emitemprtns/searchdefault")
	public ResponseEntity<Page<EMItemPRtnDTO>> searchEMItemPRtnDefaultByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPRtn> domains = emitemprtnService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemprtnMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(this.emitemprtnMapping.toDomain(#emitemprtndto),'eam_practice04-EMItemPRtn-Create')")
    @ApiOperation(value = "根据服务商物品建立还料单", tags = {"还料单" },  notes = "根据服务商物品建立还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemprtns")
    @Transactional
    public ResponseEntity<EMItemPRtnDTO> createByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
		emitemprtnService.create(domain);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemprtnMapping.toDomain(#emitemprtndtos),'eam_practice04-EMItemPRtn-Create')")
    @ApiOperation(value = "根据服务商物品批量建立还料单", tags = {"还料单" },  notes = "根据服务商物品批量建立还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> createBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemprtnService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "emitemprtn" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.emitemprtnService.get(#emitemprtn_id),'eam_practice04-EMItemPRtn-Update')")
    @ApiOperation(value = "根据服务商物品更新还料单", tags = {"还料单" },  notes = "根据服务商物品更新还料单")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    @Transactional
    public ResponseEntity<EMItemPRtnDTO> updateByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
        domain.setEmitemprtnid(emitemprtn_id);
		emitemprtnService.update(domain);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemprtnService.getEmitemprtnByEntities(this.emitemprtnMapping.toDomain(#emitemprtndtos)),'eam_practice04-EMItemPRtn-Update')")
    @ApiOperation(value = "根据服务商物品批量更新还料单", tags = {"还料单" },  notes = "根据服务商物品批量更新还料单")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> updateBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemprtnService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emitemprtnService.get(#emitemprtn_id),'eam_practice04-EMItemPRtn-Remove')")
    @ApiOperation(value = "根据服务商物品删除还料单", tags = {"还料单" },  notes = "根据服务商物品删除还料单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.remove(emitemprtn_id));
    }

    @PreAuthorize("hasPermission(this.emitemprtnService.getEmitemprtnByIds(#ids),'eam_practice04-EMItemPRtn-Remove')")
    @ApiOperation(value = "根据服务商物品批量删除还料单", tags = {"还料单" },  notes = "根据服务商物品批量删除还料单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> removeBatchByEMServiceEMItem(@RequestBody List<String> ids) {
        emitemprtnService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.emitemprtnMapping.toDomain(returnObject.body),'eam_practice04-EMItemPRtn-Get')")
    @ApiOperation(value = "根据服务商物品获取还料单", tags = {"还料单" },  notes = "根据服务商物品获取还料单")
	@RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    public ResponseEntity<EMItemPRtnDTO> getByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id) {
        EMItemPRtn domain = emitemprtnService.get(emitemprtn_id);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "根据服务商物品获取还料单草稿", tags = {"还料单" },  notes = "根据服务商物品获取还料单草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemprtns/getdraft")
    public ResponseEntity<EMItemPRtnDTO> getDraftByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemPRtn domain = new EMItemPRtn();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemprtnMapping.toDto(emitemprtnService.getDraft(domain)));
    }

    @ApiOperation(value = "根据服务商物品检查还料单", tags = {"还料单" },  notes = "根据服务商物品检查还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemprtns/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.checkKey(emitemprtnMapping.toDomain(emitemprtndto)));
    }

    @PreAuthorize("hasPermission(this.emitemprtnMapping.toDomain(#emitemprtndto),'eam_practice04-EMItemPRtn-Save')")
    @ApiOperation(value = "根据服务商物品保存还料单", tags = {"还料单" },  notes = "根据服务商物品保存还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemprtns/save")
    public ResponseEntity<Boolean> saveByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.save(domain));
    }

    @PreAuthorize("hasPermission(this.emitemprtnMapping.toDomain(#emitemprtndtos),'eam_practice04-EMItemPRtn-Save')")
    @ApiOperation(value = "根据服务商物品批量保存还料单", tags = {"还料单" },  notes = "根据服务商物品批量保存还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemprtns/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemprtnService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMItemPRtn-searchDefault-all') and hasPermission(#context,'eam_practice04-EMItemPRtn-Get')")
	@ApiOperation(value = "根据服务商物品获取DEFAULT", tags = {"还料单" } ,notes = "根据服务商物品获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emitems/{emitem_id}/emitemprtns/fetchdefault")
	public ResponseEntity<List<EMItemPRtnDTO>> fetchEMItemPRtnDefaultByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id,EMItemPRtnSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPRtn> domains = emitemprtnService.searchDefault(context) ;
        List<EMItemPRtnDTO> list = emitemprtnMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMItemPRtn-searchDefault-all') and hasPermission(#context,'eam_practice04-EMItemPRtn-Get')")
	@ApiOperation(value = "根据服务商物品查询DEFAULT", tags = {"还料单" } ,notes = "根据服务商物品查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emitems/{emitem_id}/emitemprtns/searchdefault")
	public ResponseEntity<Page<EMItemPRtnDTO>> searchEMItemPRtnDefaultByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPRtn> domains = emitemprtnService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemprtnMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(this.emitemprtnMapping.toDomain(#emitemprtndto),'eam_practice04-EMItemPRtn-Create')")
    @ApiOperation(value = "根据仓库库位物品建立还料单", tags = {"还料单" },  notes = "根据仓库库位物品建立还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns")
    @Transactional
    public ResponseEntity<EMItemPRtnDTO> createByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
		emitemprtnService.create(domain);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemprtnMapping.toDomain(#emitemprtndtos),'eam_practice04-EMItemPRtn-Create')")
    @ApiOperation(value = "根据仓库库位物品批量建立还料单", tags = {"还料单" },  notes = "根据仓库库位物品批量建立还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> createBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemprtnService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "emitemprtn" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.emitemprtnService.get(#emitemprtn_id),'eam_practice04-EMItemPRtn-Update')")
    @ApiOperation(value = "根据仓库库位物品更新还料单", tags = {"还料单" },  notes = "根据仓库库位物品更新还料单")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    @Transactional
    public ResponseEntity<EMItemPRtnDTO> updateByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
        domain.setEmitemprtnid(emitemprtn_id);
		emitemprtnService.update(domain);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemprtnService.getEmitemprtnByEntities(this.emitemprtnMapping.toDomain(#emitemprtndtos)),'eam_practice04-EMItemPRtn-Update')")
    @ApiOperation(value = "根据仓库库位物品批量更新还料单", tags = {"还料单" },  notes = "根据仓库库位物品批量更新还料单")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> updateBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemprtnService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emitemprtnService.get(#emitemprtn_id),'eam_practice04-EMItemPRtn-Remove')")
    @ApiOperation(value = "根据仓库库位物品删除还料单", tags = {"还料单" },  notes = "根据仓库库位物品删除还料单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.remove(emitemprtn_id));
    }

    @PreAuthorize("hasPermission(this.emitemprtnService.getEmitemprtnByIds(#ids),'eam_practice04-EMItemPRtn-Remove')")
    @ApiOperation(value = "根据仓库库位物品批量删除还料单", tags = {"还料单" },  notes = "根据仓库库位物品批量删除还料单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> removeBatchByEMStorePartEMItem(@RequestBody List<String> ids) {
        emitemprtnService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.emitemprtnMapping.toDomain(returnObject.body),'eam_practice04-EMItemPRtn-Get')")
    @ApiOperation(value = "根据仓库库位物品获取还料单", tags = {"还料单" },  notes = "根据仓库库位物品获取还料单")
	@RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    public ResponseEntity<EMItemPRtnDTO> getByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id) {
        EMItemPRtn domain = emitemprtnService.get(emitemprtn_id);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "根据仓库库位物品获取还料单草稿", tags = {"还料单" },  notes = "根据仓库库位物品获取还料单草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/getdraft")
    public ResponseEntity<EMItemPRtnDTO> getDraftByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemPRtn domain = new EMItemPRtn();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemprtnMapping.toDto(emitemprtnService.getDraft(domain)));
    }

    @ApiOperation(value = "根据仓库库位物品检查还料单", tags = {"还料单" },  notes = "根据仓库库位物品检查还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.checkKey(emitemprtnMapping.toDomain(emitemprtndto)));
    }

    @PreAuthorize("hasPermission(this.emitemprtnMapping.toDomain(#emitemprtndto),'eam_practice04-EMItemPRtn-Save')")
    @ApiOperation(value = "根据仓库库位物品保存还料单", tags = {"还料单" },  notes = "根据仓库库位物品保存还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/save")
    public ResponseEntity<Boolean> saveByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.save(domain));
    }

    @PreAuthorize("hasPermission(this.emitemprtnMapping.toDomain(#emitemprtndtos),'eam_practice04-EMItemPRtn-Save')")
    @ApiOperation(value = "根据仓库库位物品批量保存还料单", tags = {"还料单" },  notes = "根据仓库库位物品批量保存还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemprtnService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMItemPRtn-searchDefault-all') and hasPermission(#context,'eam_practice04-EMItemPRtn-Get')")
	@ApiOperation(value = "根据仓库库位物品获取DEFAULT", tags = {"还料单" } ,notes = "根据仓库库位物品获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/fetchdefault")
	public ResponseEntity<List<EMItemPRtnDTO>> fetchEMItemPRtnDefaultByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMItemPRtnSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPRtn> domains = emitemprtnService.searchDefault(context) ;
        List<EMItemPRtnDTO> list = emitemprtnMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMItemPRtn-searchDefault-all') and hasPermission(#context,'eam_practice04-EMItemPRtn-Get')")
	@ApiOperation(value = "根据仓库库位物品查询DEFAULT", tags = {"还料单" } ,notes = "根据仓库库位物品查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/searchdefault")
	public ResponseEntity<Page<EMItemPRtnDTO>> searchEMItemPRtnDefaultByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPRtn> domains = emitemprtnService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemprtnMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(this.emitemprtnMapping.toDomain(#emitemprtndto),'eam_practice04-EMItemPRtn-Create')")
    @ApiOperation(value = "根据仓库物品建立还料单", tags = {"还料单" },  notes = "根据仓库物品建立还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemprtns")
    @Transactional
    public ResponseEntity<EMItemPRtnDTO> createByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
		emitemprtnService.create(domain);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemprtnMapping.toDomain(#emitemprtndtos),'eam_practice04-EMItemPRtn-Create')")
    @ApiOperation(value = "根据仓库物品批量建立还料单", tags = {"还料单" },  notes = "根据仓库物品批量建立还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> createBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemprtnService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "emitemprtn" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.emitemprtnService.get(#emitemprtn_id),'eam_practice04-EMItemPRtn-Update')")
    @ApiOperation(value = "根据仓库物品更新还料单", tags = {"还料单" },  notes = "根据仓库物品更新还料单")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    @Transactional
    public ResponseEntity<EMItemPRtnDTO> updateByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
        domain.setEmitemprtnid(emitemprtn_id);
		emitemprtnService.update(domain);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemprtnService.getEmitemprtnByEntities(this.emitemprtnMapping.toDomain(#emitemprtndtos)),'eam_practice04-EMItemPRtn-Update')")
    @ApiOperation(value = "根据仓库物品批量更新还料单", tags = {"还料单" },  notes = "根据仓库物品批量更新还料单")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> updateBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemprtnService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emitemprtnService.get(#emitemprtn_id),'eam_practice04-EMItemPRtn-Remove')")
    @ApiOperation(value = "根据仓库物品删除还料单", tags = {"还料单" },  notes = "根据仓库物品删除还料单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.remove(emitemprtn_id));
    }

    @PreAuthorize("hasPermission(this.emitemprtnService.getEmitemprtnByIds(#ids),'eam_practice04-EMItemPRtn-Remove')")
    @ApiOperation(value = "根据仓库物品批量删除还料单", tags = {"还料单" },  notes = "根据仓库物品批量删除还料单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> removeBatchByEMStoreEMItem(@RequestBody List<String> ids) {
        emitemprtnService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.emitemprtnMapping.toDomain(returnObject.body),'eam_practice04-EMItemPRtn-Get')")
    @ApiOperation(value = "根据仓库物品获取还料单", tags = {"还料单" },  notes = "根据仓库物品获取还料单")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    public ResponseEntity<EMItemPRtnDTO> getByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id) {
        EMItemPRtn domain = emitemprtnService.get(emitemprtn_id);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "根据仓库物品获取还料单草稿", tags = {"还料单" },  notes = "根据仓库物品获取还料单草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemprtns/getdraft")
    public ResponseEntity<EMItemPRtnDTO> getDraftByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemPRtn domain = new EMItemPRtn();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemprtnMapping.toDto(emitemprtnService.getDraft(domain)));
    }

    @ApiOperation(value = "根据仓库物品检查还料单", tags = {"还料单" },  notes = "根据仓库物品检查还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemprtns/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.checkKey(emitemprtnMapping.toDomain(emitemprtndto)));
    }

    @PreAuthorize("hasPermission(this.emitemprtnMapping.toDomain(#emitemprtndto),'eam_practice04-EMItemPRtn-Save')")
    @ApiOperation(value = "根据仓库物品保存还料单", tags = {"还料单" },  notes = "根据仓库物品保存还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemprtns/save")
    public ResponseEntity<Boolean> saveByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.save(domain));
    }

    @PreAuthorize("hasPermission(this.emitemprtnMapping.toDomain(#emitemprtndtos),'eam_practice04-EMItemPRtn-Save')")
    @ApiOperation(value = "根据仓库物品批量保存还料单", tags = {"还料单" },  notes = "根据仓库物品批量保存还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemprtns/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemprtnService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMItemPRtn-searchDefault-all') and hasPermission(#context,'eam_practice04-EMItemPRtn-Get')")
	@ApiOperation(value = "根据仓库物品获取DEFAULT", tags = {"还料单" } ,notes = "根据仓库物品获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emitems/{emitem_id}/emitemprtns/fetchdefault")
	public ResponseEntity<List<EMItemPRtnDTO>> fetchEMItemPRtnDefaultByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id,EMItemPRtnSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPRtn> domains = emitemprtnService.searchDefault(context) ;
        List<EMItemPRtnDTO> list = emitemprtnMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMItemPRtn-searchDefault-all') and hasPermission(#context,'eam_practice04-EMItemPRtn-Get')")
	@ApiOperation(value = "根据仓库物品查询DEFAULT", tags = {"还料单" } ,notes = "根据仓库物品查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emitems/{emitem_id}/emitemprtns/searchdefault")
	public ResponseEntity<Page<EMItemPRtnDTO>> searchEMItemPRtnDefaultByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPRtn> domains = emitemprtnService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemprtnMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(this.emitemprtnMapping.toDomain(#emitemprtndto),'eam_practice04-EMItemPRtn-Create')")
    @ApiOperation(value = "根据职员物品建立还料单", tags = {"还料单" },  notes = "根据职员物品建立还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemprtns")
    @Transactional
    public ResponseEntity<EMItemPRtnDTO> createByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
		emitemprtnService.create(domain);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemprtnMapping.toDomain(#emitemprtndtos),'eam_practice04-EMItemPRtn-Create')")
    @ApiOperation(value = "根据职员物品批量建立还料单", tags = {"还料单" },  notes = "根据职员物品批量建立还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> createBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemprtnService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "emitemprtn" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.emitemprtnService.get(#emitemprtn_id),'eam_practice04-EMItemPRtn-Update')")
    @ApiOperation(value = "根据职员物品更新还料单", tags = {"还料单" },  notes = "根据职员物品更新还料单")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    @Transactional
    public ResponseEntity<EMItemPRtnDTO> updateByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
        domain.setEmitemprtnid(emitemprtn_id);
		emitemprtnService.update(domain);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemprtnService.getEmitemprtnByEntities(this.emitemprtnMapping.toDomain(#emitemprtndtos)),'eam_practice04-EMItemPRtn-Update')")
    @ApiOperation(value = "根据职员物品批量更新还料单", tags = {"还料单" },  notes = "根据职员物品批量更新还料单")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> updateBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemprtnService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emitemprtnService.get(#emitemprtn_id),'eam_practice04-EMItemPRtn-Remove')")
    @ApiOperation(value = "根据职员物品删除还料单", tags = {"还料单" },  notes = "根据职员物品删除还料单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.remove(emitemprtn_id));
    }

    @PreAuthorize("hasPermission(this.emitemprtnService.getEmitemprtnByIds(#ids),'eam_practice04-EMItemPRtn-Remove')")
    @ApiOperation(value = "根据职员物品批量删除还料单", tags = {"还料单" },  notes = "根据职员物品批量删除还料单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> removeBatchByPFEmpEMItem(@RequestBody List<String> ids) {
        emitemprtnService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.emitemprtnMapping.toDomain(returnObject.body),'eam_practice04-EMItemPRtn-Get')")
    @ApiOperation(value = "根据职员物品获取还料单", tags = {"还料单" },  notes = "根据职员物品获取还料单")
	@RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    public ResponseEntity<EMItemPRtnDTO> getByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id) {
        EMItemPRtn domain = emitemprtnService.get(emitemprtn_id);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "根据职员物品获取还料单草稿", tags = {"还料单" },  notes = "根据职员物品获取还料单草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemprtns/getdraft")
    public ResponseEntity<EMItemPRtnDTO> getDraftByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemPRtn domain = new EMItemPRtn();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemprtnMapping.toDto(emitemprtnService.getDraft(domain)));
    }

    @ApiOperation(value = "根据职员物品检查还料单", tags = {"还料单" },  notes = "根据职员物品检查还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemprtns/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.checkKey(emitemprtnMapping.toDomain(emitemprtndto)));
    }

    @PreAuthorize("hasPermission(this.emitemprtnMapping.toDomain(#emitemprtndto),'eam_practice04-EMItemPRtn-Save')")
    @ApiOperation(value = "根据职员物品保存还料单", tags = {"还料单" },  notes = "根据职员物品保存还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemprtns/save")
    public ResponseEntity<Boolean> saveByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.save(domain));
    }

    @PreAuthorize("hasPermission(this.emitemprtnMapping.toDomain(#emitemprtndtos),'eam_practice04-EMItemPRtn-Save')")
    @ApiOperation(value = "根据职员物品批量保存还料单", tags = {"还料单" },  notes = "根据职员物品批量保存还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemprtns/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemprtnService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMItemPRtn-searchDefault-all') and hasPermission(#context,'eam_practice04-EMItemPRtn-Get')")
	@ApiOperation(value = "根据职员物品获取DEFAULT", tags = {"还料单" } ,notes = "根据职员物品获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemprtns/fetchdefault")
	public ResponseEntity<List<EMItemPRtnDTO>> fetchEMItemPRtnDefaultByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id,EMItemPRtnSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPRtn> domains = emitemprtnService.searchDefault(context) ;
        List<EMItemPRtnDTO> list = emitemprtnMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMItemPRtn-searchDefault-all') and hasPermission(#context,'eam_practice04-EMItemPRtn-Get')")
	@ApiOperation(value = "根据职员物品查询DEFAULT", tags = {"还料单" } ,notes = "根据职员物品查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemprtns/searchdefault")
	public ResponseEntity<Page<EMItemPRtnDTO>> searchEMItemPRtnDefaultByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPRtn> domains = emitemprtnService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemprtnMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(this.emitemprtnMapping.toDomain(#emitemprtndto),'eam_practice04-EMItemPRtn-Create')")
    @ApiOperation(value = "根据计量单位物品建立还料单", tags = {"还料单" },  notes = "根据计量单位物品建立还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemprtns")
    @Transactional
    public ResponseEntity<EMItemPRtnDTO> createByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
		emitemprtnService.create(domain);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemprtnMapping.toDomain(#emitemprtndtos),'eam_practice04-EMItemPRtn-Create')")
    @ApiOperation(value = "根据计量单位物品批量建立还料单", tags = {"还料单" },  notes = "根据计量单位物品批量建立还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> createBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemprtnService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "emitemprtn" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.emitemprtnService.get(#emitemprtn_id),'eam_practice04-EMItemPRtn-Update')")
    @ApiOperation(value = "根据计量单位物品更新还料单", tags = {"还料单" },  notes = "根据计量单位物品更新还料单")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    @Transactional
    public ResponseEntity<EMItemPRtnDTO> updateByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
        domain.setEmitemprtnid(emitemprtn_id);
		emitemprtnService.update(domain);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemprtnService.getEmitemprtnByEntities(this.emitemprtnMapping.toDomain(#emitemprtndtos)),'eam_practice04-EMItemPRtn-Update')")
    @ApiOperation(value = "根据计量单位物品批量更新还料单", tags = {"还料单" },  notes = "根据计量单位物品批量更新还料单")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> updateBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemprtnService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emitemprtnService.get(#emitemprtn_id),'eam_practice04-EMItemPRtn-Remove')")
    @ApiOperation(value = "根据计量单位物品删除还料单", tags = {"还料单" },  notes = "根据计量单位物品删除还料单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.remove(emitemprtn_id));
    }

    @PreAuthorize("hasPermission(this.emitemprtnService.getEmitemprtnByIds(#ids),'eam_practice04-EMItemPRtn-Remove')")
    @ApiOperation(value = "根据计量单位物品批量删除还料单", tags = {"还料单" },  notes = "根据计量单位物品批量删除还料单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> removeBatchByPFUnitEMItem(@RequestBody List<String> ids) {
        emitemprtnService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.emitemprtnMapping.toDomain(returnObject.body),'eam_practice04-EMItemPRtn-Get')")
    @ApiOperation(value = "根据计量单位物品获取还料单", tags = {"还料单" },  notes = "根据计量单位物品获取还料单")
	@RequestMapping(method = RequestMethod.GET, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    public ResponseEntity<EMItemPRtnDTO> getByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id) {
        EMItemPRtn domain = emitemprtnService.get(emitemprtn_id);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "根据计量单位物品获取还料单草稿", tags = {"还料单" },  notes = "根据计量单位物品获取还料单草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemprtns/getdraft")
    public ResponseEntity<EMItemPRtnDTO> getDraftByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemPRtn domain = new EMItemPRtn();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemprtnMapping.toDto(emitemprtnService.getDraft(domain)));
    }

    @ApiOperation(value = "根据计量单位物品检查还料单", tags = {"还料单" },  notes = "根据计量单位物品检查还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemprtns/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.checkKey(emitemprtnMapping.toDomain(emitemprtndto)));
    }

    @PreAuthorize("hasPermission(this.emitemprtnMapping.toDomain(#emitemprtndto),'eam_practice04-EMItemPRtn-Save')")
    @ApiOperation(value = "根据计量单位物品保存还料单", tags = {"还料单" },  notes = "根据计量单位物品保存还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemprtns/save")
    public ResponseEntity<Boolean> saveByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.save(domain));
    }

    @PreAuthorize("hasPermission(this.emitemprtnMapping.toDomain(#emitemprtndtos),'eam_practice04-EMItemPRtn-Save')")
    @ApiOperation(value = "根据计量单位物品批量保存还料单", tags = {"还料单" },  notes = "根据计量单位物品批量保存还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemprtns/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemprtnService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMItemPRtn-searchDefault-all') and hasPermission(#context,'eam_practice04-EMItemPRtn-Get')")
	@ApiOperation(value = "根据计量单位物品获取DEFAULT", tags = {"还料单" } ,notes = "根据计量单位物品获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemprtns/fetchdefault")
	public ResponseEntity<List<EMItemPRtnDTO>> fetchEMItemPRtnDefaultByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id,EMItemPRtnSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPRtn> domains = emitemprtnService.searchDefault(context) ;
        List<EMItemPRtnDTO> list = emitemprtnMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMItemPRtn-searchDefault-all') and hasPermission(#context,'eam_practice04-EMItemPRtn-Get')")
	@ApiOperation(value = "根据计量单位物品查询DEFAULT", tags = {"还料单" } ,notes = "根据计量单位物品查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemprtns/searchdefault")
	public ResponseEntity<Page<EMItemPRtnDTO>> searchEMItemPRtnDefaultByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPRtn> domains = emitemprtnService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemprtnMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(this.emitemprtnMapping.toDomain(#emitemprtndto),'eam_practice04-EMItemPRtn-Create')")
    @ApiOperation(value = "根据仓库仓库库位物品建立还料单", tags = {"还料单" },  notes = "根据仓库仓库库位物品建立还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns")
    @Transactional
    public ResponseEntity<EMItemPRtnDTO> createByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
		emitemprtnService.create(domain);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemprtnMapping.toDomain(#emitemprtndtos),'eam_practice04-EMItemPRtn-Create')")
    @ApiOperation(value = "根据仓库仓库库位物品批量建立还料单", tags = {"还料单" },  notes = "根据仓库仓库库位物品批量建立还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> createBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemprtnService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "emitemprtn" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.emitemprtnService.get(#emitemprtn_id),'eam_practice04-EMItemPRtn-Update')")
    @ApiOperation(value = "根据仓库仓库库位物品更新还料单", tags = {"还料单" },  notes = "根据仓库仓库库位物品更新还料单")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    @Transactional
    public ResponseEntity<EMItemPRtnDTO> updateByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
        domain.setEmitemprtnid(emitemprtn_id);
		emitemprtnService.update(domain);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemprtnService.getEmitemprtnByEntities(this.emitemprtnMapping.toDomain(#emitemprtndtos)),'eam_practice04-EMItemPRtn-Update')")
    @ApiOperation(value = "根据仓库仓库库位物品批量更新还料单", tags = {"还料单" },  notes = "根据仓库仓库库位物品批量更新还料单")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> updateBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemprtnService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emitemprtnService.get(#emitemprtn_id),'eam_practice04-EMItemPRtn-Remove')")
    @ApiOperation(value = "根据仓库仓库库位物品删除还料单", tags = {"还料单" },  notes = "根据仓库仓库库位物品删除还料单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.remove(emitemprtn_id));
    }

    @PreAuthorize("hasPermission(this.emitemprtnService.getEmitemprtnByIds(#ids),'eam_practice04-EMItemPRtn-Remove')")
    @ApiOperation(value = "根据仓库仓库库位物品批量删除还料单", tags = {"还料单" },  notes = "根据仓库仓库库位物品批量删除还料单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> removeBatchByEMStoreEMStorePartEMItem(@RequestBody List<String> ids) {
        emitemprtnService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.emitemprtnMapping.toDomain(returnObject.body),'eam_practice04-EMItemPRtn-Get')")
    @ApiOperation(value = "根据仓库仓库库位物品获取还料单", tags = {"还料单" },  notes = "根据仓库仓库库位物品获取还料单")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    public ResponseEntity<EMItemPRtnDTO> getByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id) {
        EMItemPRtn domain = emitemprtnService.get(emitemprtn_id);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "根据仓库仓库库位物品获取还料单草稿", tags = {"还料单" },  notes = "根据仓库仓库库位物品获取还料单草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/getdraft")
    public ResponseEntity<EMItemPRtnDTO> getDraftByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemPRtn domain = new EMItemPRtn();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemprtnMapping.toDto(emitemprtnService.getDraft(domain)));
    }

    @ApiOperation(value = "根据仓库仓库库位物品检查还料单", tags = {"还料单" },  notes = "根据仓库仓库库位物品检查还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.checkKey(emitemprtnMapping.toDomain(emitemprtndto)));
    }

    @PreAuthorize("hasPermission(this.emitemprtnMapping.toDomain(#emitemprtndto),'eam_practice04-EMItemPRtn-Save')")
    @ApiOperation(value = "根据仓库仓库库位物品保存还料单", tags = {"还料单" },  notes = "根据仓库仓库库位物品保存还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/save")
    public ResponseEntity<Boolean> saveByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.save(domain));
    }

    @PreAuthorize("hasPermission(this.emitemprtnMapping.toDomain(#emitemprtndtos),'eam_practice04-EMItemPRtn-Save')")
    @ApiOperation(value = "根据仓库仓库库位物品批量保存还料单", tags = {"还料单" },  notes = "根据仓库仓库库位物品批量保存还料单")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemprtnService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMItemPRtn-searchDefault-all') and hasPermission(#context,'eam_practice04-EMItemPRtn-Get')")
	@ApiOperation(value = "根据仓库仓库库位物品获取DEFAULT", tags = {"还料单" } ,notes = "根据仓库仓库库位物品获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/fetchdefault")
	public ResponseEntity<List<EMItemPRtnDTO>> fetchEMItemPRtnDefaultByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMItemPRtnSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPRtn> domains = emitemprtnService.searchDefault(context) ;
        List<EMItemPRtnDTO> list = emitemprtnMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice04-EMItemPRtn-searchDefault-all') and hasPermission(#context,'eam_practice04-EMItemPRtn-Get')")
	@ApiOperation(value = "根据仓库仓库库位物品查询DEFAULT", tags = {"还料单" } ,notes = "根据仓库仓库库位物品查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/searchdefault")
	public ResponseEntity<Page<EMItemPRtnDTO>> searchEMItemPRtnDefaultByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPRtn> domains = emitemprtnService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemprtnMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}

