import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 退货单服务对象基类
 *
 * @export
 * @class EMItemROutServiceBase
 * @extends {EntityServie}
 */
export default class EMItemROutServiceBase extends EntityService {

    /**
     * Creates an instance of  EMItemROutServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  EMItemROutServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof EMItemROutServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='emitemrout';
        this.APPDEKEY = 'emitemroutid';
        this.APPDENAME = 'emitemrouts';
        this.APPDETEXT = 'emitemroutname';
        this.APPNAME = 'eamweb';
        this.SYSTEMNAME = 'eam_practice03';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemROutServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emitemrout){
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}/select`,isloading);
        }
        if(context.pfunit && context.emitem && context.emitemrout){
            return Http.getInstance().get(`/pfunits/${context.pfunit}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}/select`,isloading);
        }
        if(context.pfemp && context.emitem && context.emitemrout){
            return Http.getInstance().get(`/pfemps/${context.pfemp}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}/select`,isloading);
        }
        if(context.emstore && context.emitem && context.emitemrout){
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}/select`,isloading);
        }
        if(context.emstorepart && context.emitem && context.emitemrout){
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}/select`,isloading);
        }
        if(context.emservice && context.emitem && context.emitemrout){
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}/select`,isloading);
        }
        if(context.emitem && context.emitemrout){
            return Http.getInstance().get(`/emitems/${context.emitem}/emitemrouts/${context.emitemrout}/select`,isloading);
        }
            return Http.getInstance().get(`/emitemrouts/${context.emitemrout}/select`,isloading);
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemROutServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            return Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrouts`,data,isloading);
        }
        if(context.pfunit && context.emitem && true){
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            return Http.getInstance().post(`/pfunits/${context.pfunit}/emitems/${context.emitem}/emitemrouts`,data,isloading);
        }
        if(context.pfemp && context.emitem && true){
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            return Http.getInstance().post(`/pfemps/${context.pfemp}/emitems/${context.emitem}/emitemrouts`,data,isloading);
        }
        if(context.emstore && context.emitem && true){
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            return Http.getInstance().post(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemrouts`,data,isloading);
        }
        if(context.emstorepart && context.emitem && true){
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            return Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrouts`,data,isloading);
        }
        if(context.emservice && context.emitem && true){
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            return Http.getInstance().post(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemrouts`,data,isloading);
        }
        if(context.emitem && true){
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            return Http.getInstance().post(`/emitems/${context.emitem}/emitemrouts`,data,isloading);
        }
        let masterData:any = {};
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/emitemrouts`,data,isloading);
        return res;
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemROutServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emitemrout){
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}`,isloading);
        }
        if(context.pfunit && context.emitem && context.emitemrout){
            return Http.getInstance().get(`/pfunits/${context.pfunit}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}`,isloading);
        }
        if(context.pfemp && context.emitem && context.emitemrout){
            return Http.getInstance().get(`/pfemps/${context.pfemp}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}`,isloading);
        }
        if(context.emstore && context.emitem && context.emitemrout){
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}`,isloading);
        }
        if(context.emstorepart && context.emitem && context.emitemrout){
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}`,isloading);
        }
        if(context.emservice && context.emitem && context.emitemrout){
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}`,isloading);
        }
        if(context.emitem && context.emitemrout){
            return Http.getInstance().get(`/emitems/${context.emitem}/emitemrouts/${context.emitemrout}`,isloading);
        }
            let res:any = await Http.getInstance().get(`/emitemrouts/${context.emitemrout}`,isloading);
            return res;

    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemROutServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emitemrout){
            return Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}/checkkey`,data,isloading);
        }
        if(context.pfunit && context.emitem && context.emitemrout){
            return Http.getInstance().post(`/pfunits/${context.pfunit}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}/checkkey`,data,isloading);
        }
        if(context.pfemp && context.emitem && context.emitemrout){
            return Http.getInstance().post(`/pfemps/${context.pfemp}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}/checkkey`,data,isloading);
        }
        if(context.emstore && context.emitem && context.emitemrout){
            return Http.getInstance().post(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}/checkkey`,data,isloading);
        }
        if(context.emstorepart && context.emitem && context.emitemrout){
            return Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}/checkkey`,data,isloading);
        }
        if(context.emservice && context.emitem && context.emitemrout){
            return Http.getInstance().post(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}/checkkey`,data,isloading);
        }
        if(context.emitem && context.emitemrout){
            return Http.getInstance().post(`/emitems/${context.emitem}/emitemrouts/${context.emitemrout}/checkkey`,data,isloading);
        }
            return Http.getInstance().post(`/emitemrouts/${context.emitemrout}/checkkey`,data,isloading);
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemROutServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emitemrout){
            return Http.getInstance().delete(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}`,isloading);
        }
        if(context.pfunit && context.emitem && context.emitemrout){
            return Http.getInstance().delete(`/pfunits/${context.pfunit}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}`,isloading);
        }
        if(context.pfemp && context.emitem && context.emitemrout){
            return Http.getInstance().delete(`/pfemps/${context.pfemp}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}`,isloading);
        }
        if(context.emstore && context.emitem && context.emitemrout){
            return Http.getInstance().delete(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}`,isloading);
        }
        if(context.emstorepart && context.emitem && context.emitemrout){
            return Http.getInstance().delete(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}`,isloading);
        }
        if(context.emservice && context.emitem && context.emitemrout){
            return Http.getInstance().delete(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}`,isloading);
        }
        if(context.emitem && context.emitemrout){
            return Http.getInstance().delete(`/emitems/${context.emitem}/emitemrouts/${context.emitemrout}`,isloading);
        }
            return Http.getInstance().delete(`/emitemrouts/${context.emitemrout}`,isloading);

    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemROutServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emitemrout){
            return Http.getInstance().put(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}`,data,isloading);
        }
        if(context.pfunit && context.emitem && context.emitemrout){
            return Http.getInstance().put(`/pfunits/${context.pfunit}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}`,data,isloading);
        }
        if(context.pfemp && context.emitem && context.emitemrout){
            return Http.getInstance().put(`/pfemps/${context.pfemp}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}`,data,isloading);
        }
        if(context.emstore && context.emitem && context.emitemrout){
            return Http.getInstance().put(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}`,data,isloading);
        }
        if(context.emstorepart && context.emitem && context.emitemrout){
            return Http.getInstance().put(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}`,data,isloading);
        }
        if(context.emservice && context.emitem && context.emitemrout){
            return Http.getInstance().put(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}`,data,isloading);
        }
        if(context.emitem && context.emitemrout){
            return Http.getInstance().put(`/emitems/${context.emitem}/emitemrouts/${context.emitemrout}`,data,isloading);
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/emitemrouts/${context.emitemrout}`,data,isloading);
            return res;
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemROutServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emitemrout){
            return Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}/save`,data,isloading);
        }
        if(context.pfunit && context.emitem && context.emitemrout){
            return Http.getInstance().post(`/pfunits/${context.pfunit}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}/save`,data,isloading);
        }
        if(context.pfemp && context.emitem && context.emitemrout){
            return Http.getInstance().post(`/pfemps/${context.pfemp}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}/save`,data,isloading);
        }
        if(context.emstore && context.emitem && context.emitemrout){
            return Http.getInstance().post(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}/save`,data,isloading);
        }
        if(context.emstorepart && context.emitem && context.emitemrout){
            return Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}/save`,data,isloading);
        }
        if(context.emservice && context.emitem && context.emitemrout){
            return Http.getInstance().post(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemrouts/${context.emitemrout}/save`,data,isloading);
        }
        if(context.emitem && context.emitemrout){
            return Http.getInstance().post(`/emitems/${context.emitem}/emitemrouts/${context.emitemrout}/save`,data,isloading);
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/emitemrouts/${context.emitemrout}/save`,data,isloading);
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemROutServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrouts/getdraft`,isloading);
        }
        if(context.pfunit && context.emitem && true){
            return Http.getInstance().get(`/pfunits/${context.pfunit}/emitems/${context.emitem}/emitemrouts/getdraft`,isloading);
        }
        if(context.pfemp && context.emitem && true){
            return Http.getInstance().get(`/pfemps/${context.pfemp}/emitems/${context.emitem}/emitemrouts/getdraft`,isloading);
        }
        if(context.emstore && context.emitem && true){
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemrouts/getdraft`,isloading);
        }
        if(context.emstorepart && context.emitem && true){
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrouts/getdraft`,isloading);
        }
        if(context.emservice && context.emitem && true){
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemrouts/getdraft`,isloading);
        }
        if(context.emitem && true){
            return Http.getInstance().get(`/emitems/${context.emitem}/emitemrouts/getdraft`,isloading);
        }
        let res:any = await  Http.getInstance().get(`/emitemrouts/getdraft`,isloading);
        res.data.emitemrout = data.emitemrout;
        return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemROutServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrouts/fetchdefault`,tempData,isloading);
        }
        if(context.pfunit && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/pfunits/${context.pfunit}/emitems/${context.emitem}/emitemrouts/fetchdefault`,tempData,isloading);
        }
        if(context.pfemp && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/pfemps/${context.pfemp}/emitems/${context.emitem}/emitemrouts/fetchdefault`,tempData,isloading);
        }
        if(context.emstore && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemrouts/fetchdefault`,tempData,isloading);
        }
        if(context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrouts/fetchdefault`,tempData,isloading);
        }
        if(context.emservice && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemrouts/fetchdefault`,tempData,isloading);
        }
        if(context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emitems/${context.emitem}/emitemrouts/fetchdefault`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emitemrouts/fetchdefault`,tempData,isloading);
    }
}