package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_pf.domain.PFOrg;
import cn.ibizlab.eam.core.eam_pf.service.IPFOrgService;
import cn.ibizlab.eam.core.eam_pf.filter.PFOrgSearchContext;

@Slf4j
@Api(tags = {"PFOrg" })
@RestController("WebApi-pforg")
@RequestMapping("")
public class PFOrgResource {

    @Autowired
    private IPFOrgService pforgService;

    @Autowired
    @Lazy
    public PFOrgMapping pforgMapping;

    public PFOrgDTO permissionDTO=new PFOrgDTO();

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-PFOrg-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"PFOrg" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/pforgs/getdraft")
    public ResponseEntity<PFOrgDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(pforgMapping.toDto(pforgService.getDraft(new PFOrg())));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-PFOrg-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"PFOrg" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/pforgs/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody PFOrgDTO pforgdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(pforgService.checkKey(pforgMapping.toDomain(pforgdto)));
    }

    @PreAuthorize("hasPermission(#pforg_id,'Remove',{'Sql',this.pforgMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"PFOrg" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pforgs/{pforg_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("pforg_id") String pforg_id) {
         return ResponseEntity.status(HttpStatus.OK).body(pforgService.remove(pforg_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.pforgMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"PFOrg" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pforgs/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        pforgService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#pforg_id,'Get',{'Sql',this.pforgMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"PFOrg" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/pforgs/{pforg_id}")
    public ResponseEntity<PFOrgDTO> get(@PathVariable("pforg_id") String pforg_id) {
        PFOrg domain = pforgService.get(pforg_id);
        PFOrgDTO dto = pforgMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.pforgMapping,#pforgdto})")
    @ApiOperation(value = "Create", tags = {"PFOrg" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/pforgs")
    @Transactional
    public ResponseEntity<PFOrgDTO> create(@RequestBody PFOrgDTO pforgdto) {
        PFOrg domain = pforgMapping.toDomain(pforgdto);
		pforgService.create(domain);
        PFOrgDTO dto = pforgMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.pforgMapping,#pforgdtos})")
    @ApiOperation(value = "createBatch", tags = {"PFOrg" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/pforgs/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<PFOrgDTO> pforgdtos) {
        pforgService.createBatch(pforgMapping.toDomain(pforgdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#pforg_id,'Update',{'Sql',this.pforgMapping,#pforgdto})")
    @ApiOperation(value = "Update", tags = {"PFOrg" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/pforgs/{pforg_id}")
    @Transactional
    public ResponseEntity<PFOrgDTO> update(@PathVariable("pforg_id") String pforg_id, @RequestBody PFOrgDTO pforgdto) {
		PFOrg domain  = pforgMapping.toDomain(pforgdto);
        domain .setPforgid(pforg_id);
		pforgService.update(domain );
		PFOrgDTO dto = pforgMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.pforgMapping,#pforgdtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"PFOrg" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/pforgs/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<PFOrgDTO> pforgdtos) {
        pforgService.updateBatch(pforgMapping.toDomain(pforgdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.pforgMapping,#pforgdto})")
    @ApiOperation(value = "Save", tags = {"PFOrg" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/pforgs/save")
    public ResponseEntity<Boolean> save(@RequestBody PFOrgDTO pforgdto) {
        return ResponseEntity.status(HttpStatus.OK).body(pforgService.save(pforgMapping.toDomain(pforgdto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.pforgMapping,#pforgdtos})")
    @ApiOperation(value = "SaveBatch", tags = {"PFOrg" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/pforgs/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<PFOrgDTO> pforgdtos) {
        pforgService.saveBatch(pforgMapping.toDomain(pforgdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-PFOrg-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"PFOrg" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/pforgs/fetchdefault")
	public ResponseEntity<List<PFOrgDTO>> fetchDefault(PFOrgSearchContext context) {
        Page<PFOrg> domains = pforgService.searchDefault(context) ;
        List<PFOrgDTO> list = pforgMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-PFOrg-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"PFOrg" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/pforgs/searchdefault")
	public ResponseEntity<Page<PFOrgDTO>> searchDefault(@RequestBody PFOrgSearchContext context) {
        Page<PFOrg> domains = pforgService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(pforgMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
