package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_pf.domain.PFEmp;
import cn.ibizlab.eam.core.eam_pf.service.IPFEmpService;
import cn.ibizlab.eam.core.eam_pf.filter.PFEmpSearchContext;

@Slf4j
@Api(tags = {"PFEmp" })
@RestController("WebApi-pfemp")
@RequestMapping("")
public class PFEmpResource {

    @Autowired
    private IPFEmpService pfempService;

    @Autowired
    @Lazy
    public PFEmpMapping pfempMapping;

    public PFEmpDTO permissionDTO=new PFEmpDTO();

    @PreAuthorize("hasPermission('','Create',{'Sql',this.pfempMapping,#pfempdto})")
    @ApiOperation(value = "Create", tags = {"PFEmp" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps")
    @Transactional
    public ResponseEntity<PFEmpDTO> create(@RequestBody PFEmpDTO pfempdto) {
        PFEmp domain = pfempMapping.toDomain(pfempdto);
		pfempService.create(domain);
        PFEmpDTO dto = pfempMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.pfempMapping,#pfempdtos})")
    @ApiOperation(value = "createBatch", tags = {"PFEmp" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<PFEmpDTO> pfempdtos) {
        pfempService.createBatch(pfempMapping.toDomain(pfempdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#pfemp_id,'Get',{'Sql',this.pfempMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"PFEmp" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}")
    public ResponseEntity<PFEmpDTO> get(@PathVariable("pfemp_id") String pfemp_id) {
        PFEmp domain = pfempService.get(pfemp_id);
        PFEmpDTO dto = pfempMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#pfemp_id,'Update',{'Sql',this.pfempMapping,#pfempdto})")
    @ApiOperation(value = "Update", tags = {"PFEmp" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}")
    @Transactional
    public ResponseEntity<PFEmpDTO> update(@PathVariable("pfemp_id") String pfemp_id, @RequestBody PFEmpDTO pfempdto) {
		PFEmp domain  = pfempMapping.toDomain(pfempdto);
        domain .setPfempid(pfemp_id);
		pfempService.update(domain );
		PFEmpDTO dto = pfempMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.pfempMapping,#pfempdtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"PFEmp" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<PFEmpDTO> pfempdtos) {
        pfempService.updateBatch(pfempMapping.toDomain(pfempdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.pfempMapping,#pfempdto})")
    @ApiOperation(value = "Save", tags = {"PFEmp" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/save")
    public ResponseEntity<Boolean> save(@RequestBody PFEmpDTO pfempdto) {
        return ResponseEntity.status(HttpStatus.OK).body(pfempService.save(pfempMapping.toDomain(pfempdto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.pfempMapping,#pfempdtos})")
    @ApiOperation(value = "SaveBatch", tags = {"PFEmp" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<PFEmpDTO> pfempdtos) {
        pfempService.saveBatch(pfempMapping.toDomain(pfempdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-PFEmp-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"PFEmp" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody PFEmpDTO pfempdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(pfempService.checkKey(pfempMapping.toDomain(pfempdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-PFEmp-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"PFEmp" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/pfemps/getdraft")
    public ResponseEntity<PFEmpDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(pfempMapping.toDto(pfempService.getDraft(new PFEmp())));
    }

    @PreAuthorize("hasPermission(#pfemp_id,'Remove',{'Sql',this.pfempMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"PFEmp" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("pfemp_id") String pfemp_id) {
         return ResponseEntity.status(HttpStatus.OK).body(pfempService.remove(pfemp_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.pfempMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"PFEmp" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        pfempService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-PFEmp-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"PFEmp" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/fetchdefault")
	public ResponseEntity<List<PFEmpDTO>> fetchDefault(PFEmpSearchContext context) {
        Page<PFEmp> domains = pfempService.searchDefault(context) ;
        List<PFEmpDTO> list = pfempMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-PFEmp-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"PFEmp" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/searchdefault")
	public ResponseEntity<Page<PFEmpDTO>> searchDefault(@RequestBody PFEmpSearchContext context) {
        Page<PFEmp> domains = pfempService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(pfempMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
