package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_pf.domain.PFEmpPostMap;
import cn.ibizlab.eam.core.eam_pf.service.IPFEmpPostMapService;
import cn.ibizlab.eam.core.eam_pf.filter.PFEmpPostMapSearchContext;

@Slf4j
@Api(tags = {"PFEmpPostMap" })
@RestController("WebApi-pfemppostmap")
@RequestMapping("")
public class PFEmpPostMapResource {

    @Autowired
    private IPFEmpPostMapService pfemppostmapService;

    @Autowired
    @Lazy
    public PFEmpPostMapMapping pfemppostmapMapping;

    public PFEmpPostMapDTO permissionDTO=new PFEmpPostMapDTO();

    @PreAuthorize("hasPermission(#pfemppostmap_id,'Get',{'Sql',this.pfemppostmapMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"PFEmpPostMap" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/pfemppostmaps/{pfemppostmap_id}")
    public ResponseEntity<PFEmpPostMapDTO> get(@PathVariable("pfemppostmap_id") String pfemppostmap_id) {
        PFEmpPostMap domain = pfemppostmapService.get(pfemppostmap_id);
        PFEmpPostMapDTO dto = pfemppostmapMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.pfemppostmapMapping,#pfemppostmapdto})")
    @ApiOperation(value = "Create", tags = {"PFEmpPostMap" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemppostmaps")
    @Transactional
    public ResponseEntity<PFEmpPostMapDTO> create(@RequestBody PFEmpPostMapDTO pfemppostmapdto) {
        PFEmpPostMap domain = pfemppostmapMapping.toDomain(pfemppostmapdto);
		pfemppostmapService.create(domain);
        PFEmpPostMapDTO dto = pfemppostmapMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.pfemppostmapMapping,#pfemppostmapdtos})")
    @ApiOperation(value = "createBatch", tags = {"PFEmpPostMap" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemppostmaps/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<PFEmpPostMapDTO> pfemppostmapdtos) {
        pfemppostmapService.createBatch(pfemppostmapMapping.toDomain(pfemppostmapdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#pfemppostmap_id,'Remove',{'Sql',this.pfemppostmapMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"PFEmpPostMap" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemppostmaps/{pfemppostmap_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("pfemppostmap_id") String pfemppostmap_id) {
         return ResponseEntity.status(HttpStatus.OK).body(pfemppostmapService.remove(pfemppostmap_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.pfemppostmapMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"PFEmpPostMap" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemppostmaps/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        pfemppostmapService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-PFEmpPostMap-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"PFEmpPostMap" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/pfemppostmaps/getdraft")
    public ResponseEntity<PFEmpPostMapDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(pfemppostmapMapping.toDto(pfemppostmapService.getDraft(new PFEmpPostMap())));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.pfemppostmapMapping,#pfemppostmapdto})")
    @ApiOperation(value = "Save", tags = {"PFEmpPostMap" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemppostmaps/save")
    public ResponseEntity<Boolean> save(@RequestBody PFEmpPostMapDTO pfemppostmapdto) {
        return ResponseEntity.status(HttpStatus.OK).body(pfemppostmapService.save(pfemppostmapMapping.toDomain(pfemppostmapdto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.pfemppostmapMapping,#pfemppostmapdtos})")
    @ApiOperation(value = "SaveBatch", tags = {"PFEmpPostMap" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemppostmaps/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<PFEmpPostMapDTO> pfemppostmapdtos) {
        pfemppostmapService.saveBatch(pfemppostmapMapping.toDomain(pfemppostmapdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-PFEmpPostMap-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"PFEmpPostMap" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemppostmaps/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody PFEmpPostMapDTO pfemppostmapdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(pfemppostmapService.checkKey(pfemppostmapMapping.toDomain(pfemppostmapdto)));
    }

    @PreAuthorize("hasPermission(#pfemppostmap_id,'Update',{'Sql',this.pfemppostmapMapping,#pfemppostmapdto})")
    @ApiOperation(value = "Update", tags = {"PFEmpPostMap" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemppostmaps/{pfemppostmap_id}")
    @Transactional
    public ResponseEntity<PFEmpPostMapDTO> update(@PathVariable("pfemppostmap_id") String pfemppostmap_id, @RequestBody PFEmpPostMapDTO pfemppostmapdto) {
		PFEmpPostMap domain  = pfemppostmapMapping.toDomain(pfemppostmapdto);
        domain .setPfemppostmapid(pfemppostmap_id);
		pfemppostmapService.update(domain );
		PFEmpPostMapDTO dto = pfemppostmapMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.pfemppostmapMapping,#pfemppostmapdtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"PFEmpPostMap" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemppostmaps/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<PFEmpPostMapDTO> pfemppostmapdtos) {
        pfemppostmapService.updateBatch(pfemppostmapMapping.toDomain(pfemppostmapdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-PFEmpPostMap-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"PFEmpPostMap" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/pfemppostmaps/fetchdefault")
	public ResponseEntity<List<PFEmpPostMapDTO>> fetchDefault(PFEmpPostMapSearchContext context) {
        Page<PFEmpPostMap> domains = pfemppostmapService.searchDefault(context) ;
        List<PFEmpPostMapDTO> list = pfemppostmapMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-PFEmpPostMap-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"PFEmpPostMap" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/pfemppostmaps/searchdefault")
	public ResponseEntity<Page<PFEmpPostMapDTO>> searchDefault(@RequestBody PFEmpPostMapSearchContext context) {
        Page<PFEmpPostMap> domains = pfemppostmapService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(pfemppostmapMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
