package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMWO_EN;
import cn.ibizlab.eam.core.eam_core.service.IEMWO_ENService;
import cn.ibizlab.eam.core.eam_core.filter.EMWO_ENSearchContext;

@Slf4j
@Api(tags = {"EMWO_EN" })
@RestController("WebApi-emwo_en")
@RequestMapping("")
public class EMWO_ENResource {

    @Autowired
    private IEMWO_ENService emwo_enService;

    @Autowired
    @Lazy
    public EMWO_ENMapping emwo_enMapping;

    public EMWO_ENDTO permissionDTO=new EMWO_ENDTO();

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emwo_enMapping,#emwo_endto})")
    @ApiOperation(value = "Save", tags = {"EMWO_EN" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emwo_ens/save")
    public ResponseEntity<Boolean> save(@RequestBody EMWO_ENDTO emwo_endto) {
        return ResponseEntity.status(HttpStatus.OK).body(emwo_enService.save(emwo_enMapping.toDomain(emwo_endto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emwo_enMapping,#emwo_endtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMWO_EN" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emwo_ens/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMWO_ENDTO> emwo_endtos) {
        emwo_enService.saveBatch(emwo_enMapping.toDomain(emwo_endtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwo_en_id,'Remove',{'Sql',this.emwo_enMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMWO_EN" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emwo_ens/{emwo_en_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emwo_en_id") String emwo_en_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emwo_enService.remove(emwo_en_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emwo_enMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMWO_EN" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emwo_ens/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emwo_enService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwo_en_id,'Update',{'Sql',this.emwo_enMapping,#emwo_endto})")
    @ApiOperation(value = "Update", tags = {"EMWO_EN" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emwo_ens/{emwo_en_id}")
    @Transactional
    public ResponseEntity<EMWO_ENDTO> update(@PathVariable("emwo_en_id") String emwo_en_id, @RequestBody EMWO_ENDTO emwo_endto) {
		EMWO_EN domain  = emwo_enMapping.toDomain(emwo_endto);
        domain .setEmwoEnid(emwo_en_id);
		emwo_enService.update(domain );
		EMWO_ENDTO dto = emwo_enMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emwo_enMapping,#emwo_endtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMWO_EN" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emwo_ens/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMWO_ENDTO> emwo_endtos) {
        emwo_enService.updateBatch(emwo_enMapping.toDomain(emwo_endtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emwo_enMapping,#emwo_endto})")
    @ApiOperation(value = "Create", tags = {"EMWO_EN" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emwo_ens")
    @Transactional
    public ResponseEntity<EMWO_ENDTO> create(@RequestBody EMWO_ENDTO emwo_endto) {
        EMWO_EN domain = emwo_enMapping.toDomain(emwo_endto);
		emwo_enService.create(domain);
        EMWO_ENDTO dto = emwo_enMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emwo_enMapping,#emwo_endtos})")
    @ApiOperation(value = "createBatch", tags = {"EMWO_EN" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emwo_ens/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMWO_ENDTO> emwo_endtos) {
        emwo_enService.createBatch(emwo_enMapping.toDomain(emwo_endtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_EN-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMWO_EN" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emwo_ens/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMWO_ENDTO emwo_endto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwo_enService.checkKey(emwo_enMapping.toDomain(emwo_endto)));
    }

    @PreAuthorize("hasPermission(#emwo_en_id,'Get',{'Sql',this.emwo_enMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMWO_EN" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emwo_ens/{emwo_en_id}")
    public ResponseEntity<EMWO_ENDTO> get(@PathVariable("emwo_en_id") String emwo_en_id) {
        EMWO_EN domain = emwo_enService.get(emwo_en_id);
        EMWO_ENDTO dto = emwo_enMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_EN-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMWO_EN" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emwo_ens/getdraft")
    public ResponseEntity<EMWO_ENDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emwo_enMapping.toDto(emwo_enService.getDraft(new EMWO_EN())));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_EN-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMWO_EN" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emwo_ens/fetchdefault")
	public ResponseEntity<List<EMWO_ENDTO>> fetchDefault(EMWO_ENSearchContext context) {
        Page<EMWO_EN> domains = emwo_enService.searchDefault(context) ;
        List<EMWO_ENDTO> list = emwo_enMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_EN-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMWO_EN" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emwo_ens/searchdefault")
	public ResponseEntity<Page<EMWO_ENDTO>> searchDefault(@RequestBody EMWO_ENSearchContext context) {
        Page<EMWO_EN> domains = emwo_enService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwo_enMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Save',{'Sql',this.emwo_enMapping,#emwo_endto})")
    @ApiOperation(value = "SaveByEMEquip", tags = {"EMWO_EN" },  notes = "SaveByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwo_ens/save")
    public ResponseEntity<Boolean> saveByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_ENDTO emwo_endto) {
        EMWO_EN domain = emwo_enMapping.toDomain(emwo_endto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_enService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emwo_enMapping,#emwo_endtos})")
    @ApiOperation(value = "SaveBatchByEMEquip", tags = {"EMWO_EN" },  notes = "SaveBatchByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwo_ens/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_ENDTO> emwo_endtos) {
        List<EMWO_EN> domainlist=emwo_enMapping.toDomain(emwo_endtos);
        for(EMWO_EN domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emwo_enService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwo_en_id,'Remove',{'Sql',this.emwo_enMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMEquip", tags = {"EMWO_EN" },  notes = "RemoveByEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emwo_ens/{emwo_en_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_en_id") String emwo_en_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwo_enService.remove(emwo_en_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emwo_enMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMEquip", tags = {"EMWO_EN" },  notes = "RemoveBatchByEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emwo_ens/batch")
    public ResponseEntity<Boolean> removeBatchByEMEquip(@RequestBody List<String> ids) {
        emwo_enService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwo_en_id,'Update',{'Sql',this.emwo_enMapping,#emwo_endto})")
    @ApiOperation(value = "UpdateByEMEquip", tags = {"EMWO_EN" },  notes = "UpdateByEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emwo_ens/{emwo_en_id}")
    @Transactional
    public ResponseEntity<EMWO_ENDTO> updateByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_en_id") String emwo_en_id, @RequestBody EMWO_ENDTO emwo_endto) {
        EMWO_EN domain = emwo_enMapping.toDomain(emwo_endto);
        domain.setEquipid(emequip_id);
        domain.setEmwoEnid(emwo_en_id);
		emwo_enService.update(domain);
        EMWO_ENDTO dto = emwo_enMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emwo_enMapping,#emwo_endtos})")
    @ApiOperation(value = "UpdateBatchByEMEquip", tags = {"EMWO_EN" },  notes = "UpdateBatchByEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emwo_ens/batch")
    public ResponseEntity<Boolean> updateBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_ENDTO> emwo_endtos) {
        List<EMWO_EN> domainlist=emwo_enMapping.toDomain(emwo_endtos);
        for(EMWO_EN domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_enService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emwo_enMapping,#emwo_endto})")
    @ApiOperation(value = "CreateByEMEquip", tags = {"EMWO_EN" },  notes = "CreateByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwo_ens")
    @Transactional
    public ResponseEntity<EMWO_ENDTO> createByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_ENDTO emwo_endto) {
        EMWO_EN domain = emwo_enMapping.toDomain(emwo_endto);
        domain.setEquipid(emequip_id);
		emwo_enService.create(domain);
        EMWO_ENDTO dto = emwo_enMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emwo_enMapping,#emwo_endtos})")
    @ApiOperation(value = "createBatchByEMEquip", tags = {"EMWO_EN" },  notes = "createBatchByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwo_ens/batch")
    public ResponseEntity<Boolean> createBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_ENDTO> emwo_endtos) {
        List<EMWO_EN> domainlist=emwo_enMapping.toDomain(emwo_endtos);
        for(EMWO_EN domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_enService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_EN-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMEquip", tags = {"EMWO_EN" },  notes = "CheckKeyByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwo_ens/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_ENDTO emwo_endto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwo_enService.checkKey(emwo_enMapping.toDomain(emwo_endto)));
    }

    @PreAuthorize("hasPermission(#emwo_en_id,'Get',{'Sql',this.emwo_enMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMEquip", tags = {"EMWO_EN" },  notes = "GetByEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emwo_ens/{emwo_en_id}")
    public ResponseEntity<EMWO_ENDTO> getByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_en_id") String emwo_en_id) {
        EMWO_EN domain = emwo_enService.get(emwo_en_id);
        EMWO_ENDTO dto = emwo_enMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_EN-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMEquip", tags = {"EMWO_EN" },  notes = "GetDraftByEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emwo_ens/getdraft")
    public ResponseEntity<EMWO_ENDTO> getDraftByEMEquip(@PathVariable("emequip_id") String emequip_id) {
        EMWO_EN domain = new EMWO_EN();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_enMapping.toDto(emwo_enService.getDraft(domain)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_EN-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMEquip", tags = {"EMWO_EN" } ,notes = "fetchDEFAULTByEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emequips/{emequip_id}/emwo_ens/fetchdefault")
	public ResponseEntity<List<EMWO_ENDTO>> fetchEMWO_ENDefaultByEMEquip(@PathVariable("emequip_id") String emequip_id,EMWO_ENSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_EN> domains = emwo_enService.searchDefault(context) ;
        List<EMWO_ENDTO> list = emwo_enMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_EN-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMEquip", tags = {"EMWO_EN" } ,notes = "searchDEFAULTByEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emequips/{emequip_id}/emwo_ens/searchdefault")
	public ResponseEntity<Page<EMWO_ENDTO>> searchEMWO_ENDefaultByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_ENSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_EN> domains = emwo_enService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwo_enMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Save',{'Sql',this.emwo_enMapping,#emwo_endto})")
    @ApiOperation(value = "SaveByEMEQTypeEMEquip", tags = {"EMWO_EN" },  notes = "SaveByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_ens/save")
    public ResponseEntity<Boolean> saveByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_ENDTO emwo_endto) {
        EMWO_EN domain = emwo_enMapping.toDomain(emwo_endto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_enService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emwo_enMapping,#emwo_endtos})")
    @ApiOperation(value = "SaveBatchByEMEQTypeEMEquip", tags = {"EMWO_EN" },  notes = "SaveBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_ens/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_ENDTO> emwo_endtos) {
        List<EMWO_EN> domainlist=emwo_enMapping.toDomain(emwo_endtos);
        for(EMWO_EN domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emwo_enService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwo_en_id,'Remove',{'Sql',this.emwo_enMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMEQTypeEMEquip", tags = {"EMWO_EN" },  notes = "RemoveByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_ens/{emwo_en_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_en_id") String emwo_en_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwo_enService.remove(emwo_en_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emwo_enMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMEQTypeEMEquip", tags = {"EMWO_EN" },  notes = "RemoveBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_ens/batch")
    public ResponseEntity<Boolean> removeBatchByEMEQTypeEMEquip(@RequestBody List<String> ids) {
        emwo_enService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwo_en_id,'Update',{'Sql',this.emwo_enMapping,#emwo_endto})")
    @ApiOperation(value = "UpdateByEMEQTypeEMEquip", tags = {"EMWO_EN" },  notes = "UpdateByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_ens/{emwo_en_id}")
    @Transactional
    public ResponseEntity<EMWO_ENDTO> updateByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_en_id") String emwo_en_id, @RequestBody EMWO_ENDTO emwo_endto) {
        EMWO_EN domain = emwo_enMapping.toDomain(emwo_endto);
        domain.setEquipid(emequip_id);
        domain.setEmwoEnid(emwo_en_id);
		emwo_enService.update(domain);
        EMWO_ENDTO dto = emwo_enMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emwo_enMapping,#emwo_endtos})")
    @ApiOperation(value = "UpdateBatchByEMEQTypeEMEquip", tags = {"EMWO_EN" },  notes = "UpdateBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_ens/batch")
    public ResponseEntity<Boolean> updateBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_ENDTO> emwo_endtos) {
        List<EMWO_EN> domainlist=emwo_enMapping.toDomain(emwo_endtos);
        for(EMWO_EN domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_enService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emwo_enMapping,#emwo_endto})")
    @ApiOperation(value = "CreateByEMEQTypeEMEquip", tags = {"EMWO_EN" },  notes = "CreateByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_ens")
    @Transactional
    public ResponseEntity<EMWO_ENDTO> createByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_ENDTO emwo_endto) {
        EMWO_EN domain = emwo_enMapping.toDomain(emwo_endto);
        domain.setEquipid(emequip_id);
		emwo_enService.create(domain);
        EMWO_ENDTO dto = emwo_enMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emwo_enMapping,#emwo_endtos})")
    @ApiOperation(value = "createBatchByEMEQTypeEMEquip", tags = {"EMWO_EN" },  notes = "createBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_ens/batch")
    public ResponseEntity<Boolean> createBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_ENDTO> emwo_endtos) {
        List<EMWO_EN> domainlist=emwo_enMapping.toDomain(emwo_endtos);
        for(EMWO_EN domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_enService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_EN-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMEQTypeEMEquip", tags = {"EMWO_EN" },  notes = "CheckKeyByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_ens/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_ENDTO emwo_endto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwo_enService.checkKey(emwo_enMapping.toDomain(emwo_endto)));
    }

    @PreAuthorize("hasPermission(#emwo_en_id,'Get',{'Sql',this.emwo_enMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMEQTypeEMEquip", tags = {"EMWO_EN" },  notes = "GetByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_ens/{emwo_en_id}")
    public ResponseEntity<EMWO_ENDTO> getByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_en_id") String emwo_en_id) {
        EMWO_EN domain = emwo_enService.get(emwo_en_id);
        EMWO_ENDTO dto = emwo_enMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_EN-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMEQTypeEMEquip", tags = {"EMWO_EN" },  notes = "GetDraftByEMEQTypeEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_ens/getdraft")
    public ResponseEntity<EMWO_ENDTO> getDraftByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id) {
        EMWO_EN domain = new EMWO_EN();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_enMapping.toDto(emwo_enService.getDraft(domain)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_EN-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMEQTypeEMEquip", tags = {"EMWO_EN" } ,notes = "fetchDEFAULTByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_ens/fetchdefault")
	public ResponseEntity<List<EMWO_ENDTO>> fetchEMWO_ENDefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id,EMWO_ENSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_EN> domains = emwo_enService.searchDefault(context) ;
        List<EMWO_ENDTO> list = emwo_enMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_EN-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMEQTypeEMEquip", tags = {"EMWO_EN" } ,notes = "searchDEFAULTByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_ens/searchdefault")
	public ResponseEntity<Page<EMWO_ENDTO>> searchEMWO_ENDefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_ENSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_EN> domains = emwo_enService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwo_enMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Save',{'Sql',this.emwo_enMapping,#emwo_endto})")
    @ApiOperation(value = "SaveByPFTeamEMEquip", tags = {"EMWO_EN" },  notes = "SaveByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_ens/save")
    public ResponseEntity<Boolean> saveByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_ENDTO emwo_endto) {
        EMWO_EN domain = emwo_enMapping.toDomain(emwo_endto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_enService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emwo_enMapping,#emwo_endtos})")
    @ApiOperation(value = "SaveBatchByPFTeamEMEquip", tags = {"EMWO_EN" },  notes = "SaveBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_ens/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_ENDTO> emwo_endtos) {
        List<EMWO_EN> domainlist=emwo_enMapping.toDomain(emwo_endtos);
        for(EMWO_EN domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emwo_enService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwo_en_id,'Remove',{'Sql',this.emwo_enMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFTeamEMEquip", tags = {"EMWO_EN" },  notes = "RemoveByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_ens/{emwo_en_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_en_id") String emwo_en_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwo_enService.remove(emwo_en_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emwo_enMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFTeamEMEquip", tags = {"EMWO_EN" },  notes = "RemoveBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_ens/batch")
    public ResponseEntity<Boolean> removeBatchByPFTeamEMEquip(@RequestBody List<String> ids) {
        emwo_enService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwo_en_id,'Update',{'Sql',this.emwo_enMapping,#emwo_endto})")
    @ApiOperation(value = "UpdateByPFTeamEMEquip", tags = {"EMWO_EN" },  notes = "UpdateByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_ens/{emwo_en_id}")
    @Transactional
    public ResponseEntity<EMWO_ENDTO> updateByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_en_id") String emwo_en_id, @RequestBody EMWO_ENDTO emwo_endto) {
        EMWO_EN domain = emwo_enMapping.toDomain(emwo_endto);
        domain.setEquipid(emequip_id);
        domain.setEmwoEnid(emwo_en_id);
		emwo_enService.update(domain);
        EMWO_ENDTO dto = emwo_enMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emwo_enMapping,#emwo_endtos})")
    @ApiOperation(value = "UpdateBatchByPFTeamEMEquip", tags = {"EMWO_EN" },  notes = "UpdateBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_ens/batch")
    public ResponseEntity<Boolean> updateBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_ENDTO> emwo_endtos) {
        List<EMWO_EN> domainlist=emwo_enMapping.toDomain(emwo_endtos);
        for(EMWO_EN domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_enService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emwo_enMapping,#emwo_endto})")
    @ApiOperation(value = "CreateByPFTeamEMEquip", tags = {"EMWO_EN" },  notes = "CreateByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_ens")
    @Transactional
    public ResponseEntity<EMWO_ENDTO> createByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_ENDTO emwo_endto) {
        EMWO_EN domain = emwo_enMapping.toDomain(emwo_endto);
        domain.setEquipid(emequip_id);
		emwo_enService.create(domain);
        EMWO_ENDTO dto = emwo_enMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emwo_enMapping,#emwo_endtos})")
    @ApiOperation(value = "createBatchByPFTeamEMEquip", tags = {"EMWO_EN" },  notes = "createBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_ens/batch")
    public ResponseEntity<Boolean> createBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_ENDTO> emwo_endtos) {
        List<EMWO_EN> domainlist=emwo_enMapping.toDomain(emwo_endtos);
        for(EMWO_EN domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_enService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_EN-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFTeamEMEquip", tags = {"EMWO_EN" },  notes = "CheckKeyByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_ens/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_ENDTO emwo_endto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwo_enService.checkKey(emwo_enMapping.toDomain(emwo_endto)));
    }

    @PreAuthorize("hasPermission(#emwo_en_id,'Get',{'Sql',this.emwo_enMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFTeamEMEquip", tags = {"EMWO_EN" },  notes = "GetByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_ens/{emwo_en_id}")
    public ResponseEntity<EMWO_ENDTO> getByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_en_id") String emwo_en_id) {
        EMWO_EN domain = emwo_enService.get(emwo_en_id);
        EMWO_ENDTO dto = emwo_enMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_EN-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFTeamEMEquip", tags = {"EMWO_EN" },  notes = "GetDraftByPFTeamEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_ens/getdraft")
    public ResponseEntity<EMWO_ENDTO> getDraftByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id) {
        EMWO_EN domain = new EMWO_EN();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_enMapping.toDto(emwo_enService.getDraft(domain)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_EN-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFTeamEMEquip", tags = {"EMWO_EN" } ,notes = "fetchDEFAULTByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_ens/fetchdefault")
	public ResponseEntity<List<EMWO_ENDTO>> fetchEMWO_ENDefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id,EMWO_ENSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_EN> domains = emwo_enService.searchDefault(context) ;
        List<EMWO_ENDTO> list = emwo_enMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_EN-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFTeamEMEquip", tags = {"EMWO_EN" } ,notes = "searchDEFAULTByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_ens/searchdefault")
	public ResponseEntity<Page<EMWO_ENDTO>> searchEMWO_ENDefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_ENSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_EN> domains = emwo_enService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwo_enMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
