package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMWO_DP;
import cn.ibizlab.eam.core.eam_core.service.IEMWO_DPService;
import cn.ibizlab.eam.core.eam_core.filter.EMWO_DPSearchContext;

@Slf4j
@Api(tags = {"EMWO_DP" })
@RestController("WebApi-emwo_dp")
@RequestMapping("")
public class EMWO_DPResource {

    @Autowired
    private IEMWO_DPService emwo_dpService;

    @Autowired
    @Lazy
    public EMWO_DPMapping emwo_dpMapping;

    public EMWO_DPDTO permissionDTO=new EMWO_DPDTO();

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emwo_dpMapping,#emwo_dpdto})")
    @ApiOperation(value = "Create", tags = {"EMWO_DP" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emwo_dps")
    @Transactional
    public ResponseEntity<EMWO_DPDTO> create(@RequestBody EMWO_DPDTO emwo_dpdto) {
        EMWO_DP domain = emwo_dpMapping.toDomain(emwo_dpdto);
		emwo_dpService.create(domain);
        EMWO_DPDTO dto = emwo_dpMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emwo_dpMapping,#emwo_dpdtos})")
    @ApiOperation(value = "createBatch", tags = {"EMWO_DP" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emwo_dps/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMWO_DPDTO> emwo_dpdtos) {
        emwo_dpService.createBatch(emwo_dpMapping.toDomain(emwo_dpdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwo_dp_id,'Get',{'Sql',this.emwo_dpMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMWO_DP" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emwo_dps/{emwo_dp_id}")
    public ResponseEntity<EMWO_DPDTO> get(@PathVariable("emwo_dp_id") String emwo_dp_id) {
        EMWO_DP domain = emwo_dpService.get(emwo_dp_id);
        EMWO_DPDTO dto = emwo_dpMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_DP-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMWO_DP" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emwo_dps/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMWO_DPDTO emwo_dpdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwo_dpService.checkKey(emwo_dpMapping.toDomain(emwo_dpdto)));
    }

    @PreAuthorize("hasPermission(#emwo_dp_id,'Remove',{'Sql',this.emwo_dpMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMWO_DP" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emwo_dps/{emwo_dp_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emwo_dp_id") String emwo_dp_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emwo_dpService.remove(emwo_dp_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emwo_dpMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMWO_DP" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emwo_dps/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emwo_dpService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_DP-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMWO_DP" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emwo_dps/getdraft")
    public ResponseEntity<EMWO_DPDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emwo_dpMapping.toDto(emwo_dpService.getDraft(new EMWO_DP())));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emwo_dpMapping,#emwo_dpdto})")
    @ApiOperation(value = "Save", tags = {"EMWO_DP" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emwo_dps/save")
    public ResponseEntity<Boolean> save(@RequestBody EMWO_DPDTO emwo_dpdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emwo_dpService.save(emwo_dpMapping.toDomain(emwo_dpdto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emwo_dpMapping,#emwo_dpdtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMWO_DP" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emwo_dps/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMWO_DPDTO> emwo_dpdtos) {
        emwo_dpService.saveBatch(emwo_dpMapping.toDomain(emwo_dpdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwo_dp_id,'Update',{'Sql',this.emwo_dpMapping,#emwo_dpdto})")
    @ApiOperation(value = "Update", tags = {"EMWO_DP" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emwo_dps/{emwo_dp_id}")
    @Transactional
    public ResponseEntity<EMWO_DPDTO> update(@PathVariable("emwo_dp_id") String emwo_dp_id, @RequestBody EMWO_DPDTO emwo_dpdto) {
		EMWO_DP domain  = emwo_dpMapping.toDomain(emwo_dpdto);
        domain .setEmwoDpid(emwo_dp_id);
		emwo_dpService.update(domain );
		EMWO_DPDTO dto = emwo_dpMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emwo_dpMapping,#emwo_dpdtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMWO_DP" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emwo_dps/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMWO_DPDTO> emwo_dpdtos) {
        emwo_dpService.updateBatch(emwo_dpMapping.toDomain(emwo_dpdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_DP-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMWO_DP" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emwo_dps/fetchdefault")
	public ResponseEntity<List<EMWO_DPDTO>> fetchDefault(EMWO_DPSearchContext context) {
        Page<EMWO_DP> domains = emwo_dpService.searchDefault(context) ;
        List<EMWO_DPDTO> list = emwo_dpMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_DP-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMWO_DP" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emwo_dps/searchdefault")
	public ResponseEntity<Page<EMWO_DPDTO>> searchDefault(@RequestBody EMWO_DPSearchContext context) {
        Page<EMWO_DP> domains = emwo_dpService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwo_dpMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Create',{'Sql',this.emwo_dpMapping,#emwo_dpdto})")
    @ApiOperation(value = "CreateByEMEquip", tags = {"EMWO_DP" },  notes = "CreateByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwo_dps")
    @Transactional
    public ResponseEntity<EMWO_DPDTO> createByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_DPDTO emwo_dpdto) {
        EMWO_DP domain = emwo_dpMapping.toDomain(emwo_dpdto);
        domain.setEquipid(emequip_id);
		emwo_dpService.create(domain);
        EMWO_DPDTO dto = emwo_dpMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emwo_dpMapping,#emwo_dpdtos})")
    @ApiOperation(value = "createBatchByEMEquip", tags = {"EMWO_DP" },  notes = "createBatchByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwo_dps/batch")
    public ResponseEntity<Boolean> createBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_DPDTO> emwo_dpdtos) {
        List<EMWO_DP> domainlist=emwo_dpMapping.toDomain(emwo_dpdtos);
        for(EMWO_DP domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_dpService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwo_dp_id,'Get',{'Sql',this.emwo_dpMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMEquip", tags = {"EMWO_DP" },  notes = "GetByEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emwo_dps/{emwo_dp_id}")
    public ResponseEntity<EMWO_DPDTO> getByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_dp_id") String emwo_dp_id) {
        EMWO_DP domain = emwo_dpService.get(emwo_dp_id);
        EMWO_DPDTO dto = emwo_dpMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_DP-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMEquip", tags = {"EMWO_DP" },  notes = "CheckKeyByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwo_dps/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_DPDTO emwo_dpdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwo_dpService.checkKey(emwo_dpMapping.toDomain(emwo_dpdto)));
    }

    @PreAuthorize("hasPermission(#emwo_dp_id,'Remove',{'Sql',this.emwo_dpMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMEquip", tags = {"EMWO_DP" },  notes = "RemoveByEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emwo_dps/{emwo_dp_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_dp_id") String emwo_dp_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwo_dpService.remove(emwo_dp_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emwo_dpMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMEquip", tags = {"EMWO_DP" },  notes = "RemoveBatchByEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emwo_dps/batch")
    public ResponseEntity<Boolean> removeBatchByEMEquip(@RequestBody List<String> ids) {
        emwo_dpService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_DP-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMEquip", tags = {"EMWO_DP" },  notes = "GetDraftByEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emwo_dps/getdraft")
    public ResponseEntity<EMWO_DPDTO> getDraftByEMEquip(@PathVariable("emequip_id") String emequip_id) {
        EMWO_DP domain = new EMWO_DP();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_dpMapping.toDto(emwo_dpService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emwo_dpMapping,#emwo_dpdto})")
    @ApiOperation(value = "SaveByEMEquip", tags = {"EMWO_DP" },  notes = "SaveByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwo_dps/save")
    public ResponseEntity<Boolean> saveByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_DPDTO emwo_dpdto) {
        EMWO_DP domain = emwo_dpMapping.toDomain(emwo_dpdto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_dpService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emwo_dpMapping,#emwo_dpdtos})")
    @ApiOperation(value = "SaveBatchByEMEquip", tags = {"EMWO_DP" },  notes = "SaveBatchByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwo_dps/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_DPDTO> emwo_dpdtos) {
        List<EMWO_DP> domainlist=emwo_dpMapping.toDomain(emwo_dpdtos);
        for(EMWO_DP domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emwo_dpService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwo_dp_id,'Update',{'Sql',this.emwo_dpMapping,#emwo_dpdto})")
    @ApiOperation(value = "UpdateByEMEquip", tags = {"EMWO_DP" },  notes = "UpdateByEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emwo_dps/{emwo_dp_id}")
    @Transactional
    public ResponseEntity<EMWO_DPDTO> updateByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_dp_id") String emwo_dp_id, @RequestBody EMWO_DPDTO emwo_dpdto) {
        EMWO_DP domain = emwo_dpMapping.toDomain(emwo_dpdto);
        domain.setEquipid(emequip_id);
        domain.setEmwoDpid(emwo_dp_id);
		emwo_dpService.update(domain);
        EMWO_DPDTO dto = emwo_dpMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emwo_dpMapping,#emwo_dpdtos})")
    @ApiOperation(value = "UpdateBatchByEMEquip", tags = {"EMWO_DP" },  notes = "UpdateBatchByEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emwo_dps/batch")
    public ResponseEntity<Boolean> updateBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_DPDTO> emwo_dpdtos) {
        List<EMWO_DP> domainlist=emwo_dpMapping.toDomain(emwo_dpdtos);
        for(EMWO_DP domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_dpService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_DP-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMEquip", tags = {"EMWO_DP" } ,notes = "fetchDEFAULTByEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emequips/{emequip_id}/emwo_dps/fetchdefault")
	public ResponseEntity<List<EMWO_DPDTO>> fetchEMWO_DPDefaultByEMEquip(@PathVariable("emequip_id") String emequip_id,EMWO_DPSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_DP> domains = emwo_dpService.searchDefault(context) ;
        List<EMWO_DPDTO> list = emwo_dpMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_DP-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMEquip", tags = {"EMWO_DP" } ,notes = "searchDEFAULTByEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emequips/{emequip_id}/emwo_dps/searchdefault")
	public ResponseEntity<Page<EMWO_DPDTO>> searchEMWO_DPDefaultByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_DPSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_DP> domains = emwo_dpService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwo_dpMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Create',{'Sql',this.emwo_dpMapping,#emwo_dpdto})")
    @ApiOperation(value = "CreateByPFDept", tags = {"EMWO_DP" },  notes = "CreateByPFDept")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emwo_dps")
    @Transactional
    public ResponseEntity<EMWO_DPDTO> createByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody EMWO_DPDTO emwo_dpdto) {
        EMWO_DP domain = emwo_dpMapping.toDomain(emwo_dpdto);
        domain.setRdeptid(pfdept_id);
		emwo_dpService.create(domain);
        EMWO_DPDTO dto = emwo_dpMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emwo_dpMapping,#emwo_dpdtos})")
    @ApiOperation(value = "createBatchByPFDept", tags = {"EMWO_DP" },  notes = "createBatchByPFDept")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emwo_dps/batch")
    public ResponseEntity<Boolean> createBatchByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody List<EMWO_DPDTO> emwo_dpdtos) {
        List<EMWO_DP> domainlist=emwo_dpMapping.toDomain(emwo_dpdtos);
        for(EMWO_DP domain:domainlist){
            domain.setRdeptid(pfdept_id);
        }
        emwo_dpService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwo_dp_id,'Get',{'Sql',this.emwo_dpMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFDept", tags = {"EMWO_DP" },  notes = "GetByPFDept")
	@RequestMapping(method = RequestMethod.GET, value = "/pfdepts/{pfdept_id}/emwo_dps/{emwo_dp_id}")
    public ResponseEntity<EMWO_DPDTO> getByPFDept(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emwo_dp_id") String emwo_dp_id) {
        EMWO_DP domain = emwo_dpService.get(emwo_dp_id);
        EMWO_DPDTO dto = emwo_dpMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_DP-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFDept", tags = {"EMWO_DP" },  notes = "CheckKeyByPFDept")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emwo_dps/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody EMWO_DPDTO emwo_dpdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwo_dpService.checkKey(emwo_dpMapping.toDomain(emwo_dpdto)));
    }

    @PreAuthorize("hasPermission(#emwo_dp_id,'Remove',{'Sql',this.emwo_dpMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFDept", tags = {"EMWO_DP" },  notes = "RemoveByPFDept")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfdepts/{pfdept_id}/emwo_dps/{emwo_dp_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFDept(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emwo_dp_id") String emwo_dp_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwo_dpService.remove(emwo_dp_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emwo_dpMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFDept", tags = {"EMWO_DP" },  notes = "RemoveBatchByPFDept")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfdepts/{pfdept_id}/emwo_dps/batch")
    public ResponseEntity<Boolean> removeBatchByPFDept(@RequestBody List<String> ids) {
        emwo_dpService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_DP-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFDept", tags = {"EMWO_DP" },  notes = "GetDraftByPFDept")
    @RequestMapping(method = RequestMethod.GET, value = "/pfdepts/{pfdept_id}/emwo_dps/getdraft")
    public ResponseEntity<EMWO_DPDTO> getDraftByPFDept(@PathVariable("pfdept_id") String pfdept_id) {
        EMWO_DP domain = new EMWO_DP();
        domain.setRdeptid(pfdept_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_dpMapping.toDto(emwo_dpService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emwo_dpMapping,#emwo_dpdto})")
    @ApiOperation(value = "SaveByPFDept", tags = {"EMWO_DP" },  notes = "SaveByPFDept")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emwo_dps/save")
    public ResponseEntity<Boolean> saveByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody EMWO_DPDTO emwo_dpdto) {
        EMWO_DP domain = emwo_dpMapping.toDomain(emwo_dpdto);
        domain.setRdeptid(pfdept_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_dpService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emwo_dpMapping,#emwo_dpdtos})")
    @ApiOperation(value = "SaveBatchByPFDept", tags = {"EMWO_DP" },  notes = "SaveBatchByPFDept")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emwo_dps/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody List<EMWO_DPDTO> emwo_dpdtos) {
        List<EMWO_DP> domainlist=emwo_dpMapping.toDomain(emwo_dpdtos);
        for(EMWO_DP domain:domainlist){
             domain.setRdeptid(pfdept_id);
        }
        emwo_dpService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwo_dp_id,'Update',{'Sql',this.emwo_dpMapping,#emwo_dpdto})")
    @ApiOperation(value = "UpdateByPFDept", tags = {"EMWO_DP" },  notes = "UpdateByPFDept")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfdepts/{pfdept_id}/emwo_dps/{emwo_dp_id}")
    @Transactional
    public ResponseEntity<EMWO_DPDTO> updateByPFDept(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emwo_dp_id") String emwo_dp_id, @RequestBody EMWO_DPDTO emwo_dpdto) {
        EMWO_DP domain = emwo_dpMapping.toDomain(emwo_dpdto);
        domain.setRdeptid(pfdept_id);
        domain.setEmwoDpid(emwo_dp_id);
		emwo_dpService.update(domain);
        EMWO_DPDTO dto = emwo_dpMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emwo_dpMapping,#emwo_dpdtos})")
    @ApiOperation(value = "UpdateBatchByPFDept", tags = {"EMWO_DP" },  notes = "UpdateBatchByPFDept")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfdepts/{pfdept_id}/emwo_dps/batch")
    public ResponseEntity<Boolean> updateBatchByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody List<EMWO_DPDTO> emwo_dpdtos) {
        List<EMWO_DP> domainlist=emwo_dpMapping.toDomain(emwo_dpdtos);
        for(EMWO_DP domain:domainlist){
            domain.setRdeptid(pfdept_id);
        }
        emwo_dpService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_DP-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFDept", tags = {"EMWO_DP" } ,notes = "fetchDEFAULTByPFDept")
    @RequestMapping(method= RequestMethod.GET , value="/pfdepts/{pfdept_id}/emwo_dps/fetchdefault")
	public ResponseEntity<List<EMWO_DPDTO>> fetchEMWO_DPDefaultByPFDept(@PathVariable("pfdept_id") String pfdept_id,EMWO_DPSearchContext context) {
        context.setN_rdeptid_eq(pfdept_id);
        Page<EMWO_DP> domains = emwo_dpService.searchDefault(context) ;
        List<EMWO_DPDTO> list = emwo_dpMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_DP-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFDept", tags = {"EMWO_DP" } ,notes = "searchDEFAULTByPFDept")
    @RequestMapping(method= RequestMethod.POST , value="/pfdepts/{pfdept_id}/emwo_dps/searchdefault")
	public ResponseEntity<Page<EMWO_DPDTO>> searchEMWO_DPDefaultByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody EMWO_DPSearchContext context) {
        context.setN_rdeptid_eq(pfdept_id);
        Page<EMWO_DP> domains = emwo_dpService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwo_dpMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Create',{'Sql',this.emwo_dpMapping,#emwo_dpdto})")
    @ApiOperation(value = "CreateByPFTeam", tags = {"EMWO_DP" },  notes = "CreateByPFTeam")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emwo_dps")
    @Transactional
    public ResponseEntity<EMWO_DPDTO> createByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody EMWO_DPDTO emwo_dpdto) {
        EMWO_DP domain = emwo_dpMapping.toDomain(emwo_dpdto);
        domain.setRteamid(pfteam_id);
		emwo_dpService.create(domain);
        EMWO_DPDTO dto = emwo_dpMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emwo_dpMapping,#emwo_dpdtos})")
    @ApiOperation(value = "createBatchByPFTeam", tags = {"EMWO_DP" },  notes = "createBatchByPFTeam")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emwo_dps/batch")
    public ResponseEntity<Boolean> createBatchByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody List<EMWO_DPDTO> emwo_dpdtos) {
        List<EMWO_DP> domainlist=emwo_dpMapping.toDomain(emwo_dpdtos);
        for(EMWO_DP domain:domainlist){
            domain.setRteamid(pfteam_id);
        }
        emwo_dpService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwo_dp_id,'Get',{'Sql',this.emwo_dpMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFTeam", tags = {"EMWO_DP" },  notes = "GetByPFTeam")
	@RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emwo_dps/{emwo_dp_id}")
    public ResponseEntity<EMWO_DPDTO> getByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emwo_dp_id") String emwo_dp_id) {
        EMWO_DP domain = emwo_dpService.get(emwo_dp_id);
        EMWO_DPDTO dto = emwo_dpMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_DP-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFTeam", tags = {"EMWO_DP" },  notes = "CheckKeyByPFTeam")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emwo_dps/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody EMWO_DPDTO emwo_dpdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwo_dpService.checkKey(emwo_dpMapping.toDomain(emwo_dpdto)));
    }

    @PreAuthorize("hasPermission(#emwo_dp_id,'Remove',{'Sql',this.emwo_dpMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFTeam", tags = {"EMWO_DP" },  notes = "RemoveByPFTeam")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emwo_dps/{emwo_dp_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emwo_dp_id") String emwo_dp_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwo_dpService.remove(emwo_dp_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emwo_dpMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFTeam", tags = {"EMWO_DP" },  notes = "RemoveBatchByPFTeam")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emwo_dps/batch")
    public ResponseEntity<Boolean> removeBatchByPFTeam(@RequestBody List<String> ids) {
        emwo_dpService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_DP-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFTeam", tags = {"EMWO_DP" },  notes = "GetDraftByPFTeam")
    @RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emwo_dps/getdraft")
    public ResponseEntity<EMWO_DPDTO> getDraftByPFTeam(@PathVariable("pfteam_id") String pfteam_id) {
        EMWO_DP domain = new EMWO_DP();
        domain.setRteamid(pfteam_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_dpMapping.toDto(emwo_dpService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emwo_dpMapping,#emwo_dpdto})")
    @ApiOperation(value = "SaveByPFTeam", tags = {"EMWO_DP" },  notes = "SaveByPFTeam")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emwo_dps/save")
    public ResponseEntity<Boolean> saveByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody EMWO_DPDTO emwo_dpdto) {
        EMWO_DP domain = emwo_dpMapping.toDomain(emwo_dpdto);
        domain.setRteamid(pfteam_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_dpService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emwo_dpMapping,#emwo_dpdtos})")
    @ApiOperation(value = "SaveBatchByPFTeam", tags = {"EMWO_DP" },  notes = "SaveBatchByPFTeam")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emwo_dps/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody List<EMWO_DPDTO> emwo_dpdtos) {
        List<EMWO_DP> domainlist=emwo_dpMapping.toDomain(emwo_dpdtos);
        for(EMWO_DP domain:domainlist){
             domain.setRteamid(pfteam_id);
        }
        emwo_dpService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwo_dp_id,'Update',{'Sql',this.emwo_dpMapping,#emwo_dpdto})")
    @ApiOperation(value = "UpdateByPFTeam", tags = {"EMWO_DP" },  notes = "UpdateByPFTeam")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emwo_dps/{emwo_dp_id}")
    @Transactional
    public ResponseEntity<EMWO_DPDTO> updateByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emwo_dp_id") String emwo_dp_id, @RequestBody EMWO_DPDTO emwo_dpdto) {
        EMWO_DP domain = emwo_dpMapping.toDomain(emwo_dpdto);
        domain.setRteamid(pfteam_id);
        domain.setEmwoDpid(emwo_dp_id);
		emwo_dpService.update(domain);
        EMWO_DPDTO dto = emwo_dpMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emwo_dpMapping,#emwo_dpdtos})")
    @ApiOperation(value = "UpdateBatchByPFTeam", tags = {"EMWO_DP" },  notes = "UpdateBatchByPFTeam")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emwo_dps/batch")
    public ResponseEntity<Boolean> updateBatchByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody List<EMWO_DPDTO> emwo_dpdtos) {
        List<EMWO_DP> domainlist=emwo_dpMapping.toDomain(emwo_dpdtos);
        for(EMWO_DP domain:domainlist){
            domain.setRteamid(pfteam_id);
        }
        emwo_dpService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_DP-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFTeam", tags = {"EMWO_DP" } ,notes = "fetchDEFAULTByPFTeam")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emwo_dps/fetchdefault")
	public ResponseEntity<List<EMWO_DPDTO>> fetchEMWO_DPDefaultByPFTeam(@PathVariable("pfteam_id") String pfteam_id,EMWO_DPSearchContext context) {
        context.setN_rteamid_eq(pfteam_id);
        Page<EMWO_DP> domains = emwo_dpService.searchDefault(context) ;
        List<EMWO_DPDTO> list = emwo_dpMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_DP-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFTeam", tags = {"EMWO_DP" } ,notes = "searchDEFAULTByPFTeam")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emwo_dps/searchdefault")
	public ResponseEntity<Page<EMWO_DPDTO>> searchEMWO_DPDefaultByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody EMWO_DPSearchContext context) {
        context.setN_rteamid_eq(pfteam_id);
        Page<EMWO_DP> domains = emwo_dpService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwo_dpMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Create',{'Sql',this.emwo_dpMapping,#emwo_dpdto})")
    @ApiOperation(value = "CreateByEMEQTypeEMEquip", tags = {"EMWO_DP" },  notes = "CreateByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_dps")
    @Transactional
    public ResponseEntity<EMWO_DPDTO> createByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_DPDTO emwo_dpdto) {
        EMWO_DP domain = emwo_dpMapping.toDomain(emwo_dpdto);
        domain.setEquipid(emequip_id);
		emwo_dpService.create(domain);
        EMWO_DPDTO dto = emwo_dpMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emwo_dpMapping,#emwo_dpdtos})")
    @ApiOperation(value = "createBatchByEMEQTypeEMEquip", tags = {"EMWO_DP" },  notes = "createBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_dps/batch")
    public ResponseEntity<Boolean> createBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_DPDTO> emwo_dpdtos) {
        List<EMWO_DP> domainlist=emwo_dpMapping.toDomain(emwo_dpdtos);
        for(EMWO_DP domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_dpService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwo_dp_id,'Get',{'Sql',this.emwo_dpMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMEQTypeEMEquip", tags = {"EMWO_DP" },  notes = "GetByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_dps/{emwo_dp_id}")
    public ResponseEntity<EMWO_DPDTO> getByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_dp_id") String emwo_dp_id) {
        EMWO_DP domain = emwo_dpService.get(emwo_dp_id);
        EMWO_DPDTO dto = emwo_dpMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_DP-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMEQTypeEMEquip", tags = {"EMWO_DP" },  notes = "CheckKeyByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_dps/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_DPDTO emwo_dpdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwo_dpService.checkKey(emwo_dpMapping.toDomain(emwo_dpdto)));
    }

    @PreAuthorize("hasPermission(#emwo_dp_id,'Remove',{'Sql',this.emwo_dpMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMEQTypeEMEquip", tags = {"EMWO_DP" },  notes = "RemoveByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_dps/{emwo_dp_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_dp_id") String emwo_dp_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwo_dpService.remove(emwo_dp_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emwo_dpMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMEQTypeEMEquip", tags = {"EMWO_DP" },  notes = "RemoveBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_dps/batch")
    public ResponseEntity<Boolean> removeBatchByEMEQTypeEMEquip(@RequestBody List<String> ids) {
        emwo_dpService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_DP-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMEQTypeEMEquip", tags = {"EMWO_DP" },  notes = "GetDraftByEMEQTypeEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_dps/getdraft")
    public ResponseEntity<EMWO_DPDTO> getDraftByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id) {
        EMWO_DP domain = new EMWO_DP();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_dpMapping.toDto(emwo_dpService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emwo_dpMapping,#emwo_dpdto})")
    @ApiOperation(value = "SaveByEMEQTypeEMEquip", tags = {"EMWO_DP" },  notes = "SaveByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_dps/save")
    public ResponseEntity<Boolean> saveByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_DPDTO emwo_dpdto) {
        EMWO_DP domain = emwo_dpMapping.toDomain(emwo_dpdto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_dpService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emwo_dpMapping,#emwo_dpdtos})")
    @ApiOperation(value = "SaveBatchByEMEQTypeEMEquip", tags = {"EMWO_DP" },  notes = "SaveBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_dps/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_DPDTO> emwo_dpdtos) {
        List<EMWO_DP> domainlist=emwo_dpMapping.toDomain(emwo_dpdtos);
        for(EMWO_DP domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emwo_dpService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwo_dp_id,'Update',{'Sql',this.emwo_dpMapping,#emwo_dpdto})")
    @ApiOperation(value = "UpdateByEMEQTypeEMEquip", tags = {"EMWO_DP" },  notes = "UpdateByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_dps/{emwo_dp_id}")
    @Transactional
    public ResponseEntity<EMWO_DPDTO> updateByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_dp_id") String emwo_dp_id, @RequestBody EMWO_DPDTO emwo_dpdto) {
        EMWO_DP domain = emwo_dpMapping.toDomain(emwo_dpdto);
        domain.setEquipid(emequip_id);
        domain.setEmwoDpid(emwo_dp_id);
		emwo_dpService.update(domain);
        EMWO_DPDTO dto = emwo_dpMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emwo_dpMapping,#emwo_dpdtos})")
    @ApiOperation(value = "UpdateBatchByEMEQTypeEMEquip", tags = {"EMWO_DP" },  notes = "UpdateBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_dps/batch")
    public ResponseEntity<Boolean> updateBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_DPDTO> emwo_dpdtos) {
        List<EMWO_DP> domainlist=emwo_dpMapping.toDomain(emwo_dpdtos);
        for(EMWO_DP domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_dpService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_DP-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMEQTypeEMEquip", tags = {"EMWO_DP" } ,notes = "fetchDEFAULTByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_dps/fetchdefault")
	public ResponseEntity<List<EMWO_DPDTO>> fetchEMWO_DPDefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id,EMWO_DPSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_DP> domains = emwo_dpService.searchDefault(context) ;
        List<EMWO_DPDTO> list = emwo_dpMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_DP-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMEQTypeEMEquip", tags = {"EMWO_DP" } ,notes = "searchDEFAULTByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_dps/searchdefault")
	public ResponseEntity<Page<EMWO_DPDTO>> searchEMWO_DPDefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_DPSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_DP> domains = emwo_dpService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwo_dpMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Create',{'Sql',this.emwo_dpMapping,#emwo_dpdto})")
    @ApiOperation(value = "CreateByPFTeamEMEquip", tags = {"EMWO_DP" },  notes = "CreateByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_dps")
    @Transactional
    public ResponseEntity<EMWO_DPDTO> createByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_DPDTO emwo_dpdto) {
        EMWO_DP domain = emwo_dpMapping.toDomain(emwo_dpdto);
        domain.setEquipid(emequip_id);
		emwo_dpService.create(domain);
        EMWO_DPDTO dto = emwo_dpMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emwo_dpMapping,#emwo_dpdtos})")
    @ApiOperation(value = "createBatchByPFTeamEMEquip", tags = {"EMWO_DP" },  notes = "createBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_dps/batch")
    public ResponseEntity<Boolean> createBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_DPDTO> emwo_dpdtos) {
        List<EMWO_DP> domainlist=emwo_dpMapping.toDomain(emwo_dpdtos);
        for(EMWO_DP domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_dpService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwo_dp_id,'Get',{'Sql',this.emwo_dpMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFTeamEMEquip", tags = {"EMWO_DP" },  notes = "GetByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_dps/{emwo_dp_id}")
    public ResponseEntity<EMWO_DPDTO> getByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_dp_id") String emwo_dp_id) {
        EMWO_DP domain = emwo_dpService.get(emwo_dp_id);
        EMWO_DPDTO dto = emwo_dpMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_DP-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFTeamEMEquip", tags = {"EMWO_DP" },  notes = "CheckKeyByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_dps/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_DPDTO emwo_dpdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwo_dpService.checkKey(emwo_dpMapping.toDomain(emwo_dpdto)));
    }

    @PreAuthorize("hasPermission(#emwo_dp_id,'Remove',{'Sql',this.emwo_dpMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFTeamEMEquip", tags = {"EMWO_DP" },  notes = "RemoveByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_dps/{emwo_dp_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_dp_id") String emwo_dp_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwo_dpService.remove(emwo_dp_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emwo_dpMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFTeamEMEquip", tags = {"EMWO_DP" },  notes = "RemoveBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_dps/batch")
    public ResponseEntity<Boolean> removeBatchByPFTeamEMEquip(@RequestBody List<String> ids) {
        emwo_dpService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_DP-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFTeamEMEquip", tags = {"EMWO_DP" },  notes = "GetDraftByPFTeamEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_dps/getdraft")
    public ResponseEntity<EMWO_DPDTO> getDraftByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id) {
        EMWO_DP domain = new EMWO_DP();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_dpMapping.toDto(emwo_dpService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emwo_dpMapping,#emwo_dpdto})")
    @ApiOperation(value = "SaveByPFTeamEMEquip", tags = {"EMWO_DP" },  notes = "SaveByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_dps/save")
    public ResponseEntity<Boolean> saveByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_DPDTO emwo_dpdto) {
        EMWO_DP domain = emwo_dpMapping.toDomain(emwo_dpdto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_dpService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emwo_dpMapping,#emwo_dpdtos})")
    @ApiOperation(value = "SaveBatchByPFTeamEMEquip", tags = {"EMWO_DP" },  notes = "SaveBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_dps/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_DPDTO> emwo_dpdtos) {
        List<EMWO_DP> domainlist=emwo_dpMapping.toDomain(emwo_dpdtos);
        for(EMWO_DP domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emwo_dpService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emwo_dp_id,'Update',{'Sql',this.emwo_dpMapping,#emwo_dpdto})")
    @ApiOperation(value = "UpdateByPFTeamEMEquip", tags = {"EMWO_DP" },  notes = "UpdateByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_dps/{emwo_dp_id}")
    @Transactional
    public ResponseEntity<EMWO_DPDTO> updateByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_dp_id") String emwo_dp_id, @RequestBody EMWO_DPDTO emwo_dpdto) {
        EMWO_DP domain = emwo_dpMapping.toDomain(emwo_dpdto);
        domain.setEquipid(emequip_id);
        domain.setEmwoDpid(emwo_dp_id);
		emwo_dpService.update(domain);
        EMWO_DPDTO dto = emwo_dpMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emwo_dpMapping,#emwo_dpdtos})")
    @ApiOperation(value = "UpdateBatchByPFTeamEMEquip", tags = {"EMWO_DP" },  notes = "UpdateBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_dps/batch")
    public ResponseEntity<Boolean> updateBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_DPDTO> emwo_dpdtos) {
        List<EMWO_DP> domainlist=emwo_dpMapping.toDomain(emwo_dpdtos);
        for(EMWO_DP domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_dpService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_DP-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFTeamEMEquip", tags = {"EMWO_DP" } ,notes = "fetchDEFAULTByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_dps/fetchdefault")
	public ResponseEntity<List<EMWO_DPDTO>> fetchEMWO_DPDefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id,EMWO_DPSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_DP> domains = emwo_dpService.searchDefault(context) ;
        List<EMWO_DPDTO> list = emwo_dpMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_DP-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFTeamEMEquip", tags = {"EMWO_DP" } ,notes = "searchDEFAULTByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_dps/searchdefault")
	public ResponseEntity<Page<EMWO_DPDTO>> searchEMWO_DPDefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_DPSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_DP> domains = emwo_dpService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwo_dpMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
