package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMSubList;
import cn.ibizlab.eam.core.eam_core.service.IEMSubListService;
import cn.ibizlab.eam.core.eam_core.filter.EMSubListSearchContext;

@Slf4j
@Api(tags = {"EMSubList" })
@RestController("WebApi-emsublist")
@RequestMapping("")
public class EMSubListResource {

    @Autowired
    private IEMSubListService emsublistService;

    @Autowired
    @Lazy
    public EMSubListMapping emsublistMapping;

    public EMSubListDTO permissionDTO=new EMSubListDTO();

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMSubList-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMSubList" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emsublists/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMSubListDTO emsublistdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emsublistService.checkKey(emsublistMapping.toDomain(emsublistdto)));
    }

    @PreAuthorize("hasPermission(#emsublist_id,'Get',{'Sql',this.emsublistMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMSubList" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emsublists/{emsublist_id}")
    public ResponseEntity<EMSubListDTO> get(@PathVariable("emsublist_id") String emsublist_id) {
        EMSubList domain = emsublistService.get(emsublist_id);
        EMSubListDTO dto = emsublistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emsublistMapping,#emsublistdto})")
    @ApiOperation(value = "Save", tags = {"EMSubList" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emsublists/save")
    public ResponseEntity<Boolean> save(@RequestBody EMSubListDTO emsublistdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emsublistService.save(emsublistMapping.toDomain(emsublistdto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emsublistMapping,#emsublistdtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMSubList" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emsublists/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMSubListDTO> emsublistdtos) {
        emsublistService.saveBatch(emsublistMapping.toDomain(emsublistdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emsublistMapping,#emsublistdto})")
    @ApiOperation(value = "Create", tags = {"EMSubList" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emsublists")
    @Transactional
    public ResponseEntity<EMSubListDTO> create(@RequestBody EMSubListDTO emsublistdto) {
        EMSubList domain = emsublistMapping.toDomain(emsublistdto);
		emsublistService.create(domain);
        EMSubListDTO dto = emsublistMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emsublistMapping,#emsublistdtos})")
    @ApiOperation(value = "createBatch", tags = {"EMSubList" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emsublists/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMSubListDTO> emsublistdtos) {
        emsublistService.createBatch(emsublistMapping.toDomain(emsublistdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMSubList-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMSubList" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emsublists/getdraft")
    public ResponseEntity<EMSubListDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emsublistMapping.toDto(emsublistService.getDraft(new EMSubList())));
    }

    @PreAuthorize("hasPermission(#emsublist_id,'Remove',{'Sql',this.emsublistMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMSubList" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emsublists/{emsublist_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emsublist_id") String emsublist_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emsublistService.remove(emsublist_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emsublistMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMSubList" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emsublists/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emsublistService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emsublist_id,'Update',{'Sql',this.emsublistMapping,#emsublistdto})")
    @ApiOperation(value = "Update", tags = {"EMSubList" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emsublists/{emsublist_id}")
    @Transactional
    public ResponseEntity<EMSubListDTO> update(@PathVariable("emsublist_id") String emsublist_id, @RequestBody EMSubListDTO emsublistdto) {
		EMSubList domain  = emsublistMapping.toDomain(emsublistdto);
        domain .setEmsublistid(emsublist_id);
		emsublistService.update(domain );
		EMSubListDTO dto = emsublistMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emsublistMapping,#emsublistdtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMSubList" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emsublists/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMSubListDTO> emsublistdtos) {
        emsublistService.updateBatch(emsublistMapping.toDomain(emsublistdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMSubList-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMSubList" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emsublists/fetchdefault")
	public ResponseEntity<List<EMSubListDTO>> fetchDefault(EMSubListSearchContext context) {
        Page<EMSubList> domains = emsublistService.searchDefault(context) ;
        List<EMSubListDTO> list = emsublistMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMSubList-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMSubList" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emsublists/searchdefault")
	public ResponseEntity<Page<EMSubListDTO>> searchDefault(@RequestBody EMSubListSearchContext context) {
        Page<EMSubList> domains = emsublistService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emsublistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
