package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMResService;
import cn.ibizlab.eam.core.eam_core.service.IEMResServiceService;
import cn.ibizlab.eam.core.eam_core.filter.EMResServiceSearchContext;

@Slf4j
@Api(tags = {"EMResService" })
@RestController("WebApi-emresservice")
@RequestMapping("")
public class EMResServiceResource {

    @Autowired
    private IEMResServiceService emresserviceService;

    @Autowired
    @Lazy
    public EMResServiceMapping emresserviceMapping;

    public EMResServiceDTO permissionDTO=new EMResServiceDTO();

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMResService-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMResService" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emresservices/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMResServiceDTO emresservicedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emresserviceService.checkKey(emresserviceMapping.toDomain(emresservicedto)));
    }

    @PreAuthorize("hasPermission(#emresservice_id,'Get',{'Sql',this.emresserviceMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMResService" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emresservices/{emresservice_id}")
    public ResponseEntity<EMResServiceDTO> get(@PathVariable("emresservice_id") String emresservice_id) {
        EMResService domain = emresserviceService.get(emresservice_id);
        EMResServiceDTO dto = emresserviceMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emresserviceMapping,#emresservicedto})")
    @ApiOperation(value = "Save", tags = {"EMResService" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emresservices/save")
    public ResponseEntity<Boolean> save(@RequestBody EMResServiceDTO emresservicedto) {
        return ResponseEntity.status(HttpStatus.OK).body(emresserviceService.save(emresserviceMapping.toDomain(emresservicedto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emresserviceMapping,#emresservicedtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMResService" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emresservices/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMResServiceDTO> emresservicedtos) {
        emresserviceService.saveBatch(emresserviceMapping.toDomain(emresservicedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emresserviceMapping,#emresservicedto})")
    @ApiOperation(value = "Create", tags = {"EMResService" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emresservices")
    @Transactional
    public ResponseEntity<EMResServiceDTO> create(@RequestBody EMResServiceDTO emresservicedto) {
        EMResService domain = emresserviceMapping.toDomain(emresservicedto);
		emresserviceService.create(domain);
        EMResServiceDTO dto = emresserviceMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emresserviceMapping,#emresservicedtos})")
    @ApiOperation(value = "createBatch", tags = {"EMResService" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emresservices/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMResServiceDTO> emresservicedtos) {
        emresserviceService.createBatch(emresserviceMapping.toDomain(emresservicedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emresservice_id,'Update',{'Sql',this.emresserviceMapping,#emresservicedto})")
    @ApiOperation(value = "Update", tags = {"EMResService" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emresservices/{emresservice_id}")
    @Transactional
    public ResponseEntity<EMResServiceDTO> update(@PathVariable("emresservice_id") String emresservice_id, @RequestBody EMResServiceDTO emresservicedto) {
		EMResService domain  = emresserviceMapping.toDomain(emresservicedto);
        domain .setEmresserviceid(emresservice_id);
		emresserviceService.update(domain );
		EMResServiceDTO dto = emresserviceMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emresserviceMapping,#emresservicedtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMResService" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emresservices/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMResServiceDTO> emresservicedtos) {
        emresserviceService.updateBatch(emresserviceMapping.toDomain(emresservicedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emresservice_id,'Remove',{'Sql',this.emresserviceMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMResService" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emresservices/{emresservice_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emresservice_id") String emresservice_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emresserviceService.remove(emresservice_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emresserviceMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMResService" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emresservices/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emresserviceService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMResService-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMResService" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emresservices/getdraft")
    public ResponseEntity<EMResServiceDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emresserviceMapping.toDto(emresserviceService.getDraft(new EMResService())));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMResService-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMResService" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emresservices/fetchdefault")
	public ResponseEntity<List<EMResServiceDTO>> fetchDefault(EMResServiceSearchContext context) {
        Page<EMResService> domains = emresserviceService.searchDefault(context) ;
        List<EMResServiceDTO> list = emresserviceMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMResService-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMResService" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emresservices/searchdefault")
	public ResponseEntity<Page<EMResServiceDTO>> searchDefault(@RequestBody EMResServiceSearchContext context) {
        Page<EMResService> domains = emresserviceService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emresserviceMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
