package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMResRefObj;
import cn.ibizlab.eam.core.eam_core.service.IEMResRefObjService;
import cn.ibizlab.eam.core.eam_core.filter.EMResRefObjSearchContext;

@Slf4j
@Api(tags = {"EMResRefObj" })
@RestController("WebApi-emresrefobj")
@RequestMapping("")
public class EMResRefObjResource {

    @Autowired
    private IEMResRefObjService emresrefobjService;

    @Autowired
    @Lazy
    public EMResRefObjMapping emresrefobjMapping;

    public EMResRefObjDTO permissionDTO=new EMResRefObjDTO();

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMResRefObj-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMResRefObj" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emresrefobjs/getdraft")
    public ResponseEntity<EMResRefObjDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emresrefobjMapping.toDto(emresrefobjService.getDraft(new EMResRefObj())));
    }

    @PreAuthorize("hasPermission(#emresrefobj_id,'Get',{'Sql',this.emresrefobjMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMResRefObj" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emresrefobjs/{emresrefobj_id}")
    public ResponseEntity<EMResRefObjDTO> get(@PathVariable("emresrefobj_id") String emresrefobj_id) {
        EMResRefObj domain = emresrefobjService.get(emresrefobj_id);
        EMResRefObjDTO dto = emresrefobjMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emresrefobj_id,'Update',{'Sql',this.emresrefobjMapping,#emresrefobjdto})")
    @ApiOperation(value = "Update", tags = {"EMResRefObj" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emresrefobjs/{emresrefobj_id}")
    @Transactional
    public ResponseEntity<EMResRefObjDTO> update(@PathVariable("emresrefobj_id") String emresrefobj_id, @RequestBody EMResRefObjDTO emresrefobjdto) {
		EMResRefObj domain  = emresrefobjMapping.toDomain(emresrefobjdto);
        domain .setEmresrefobjid(emresrefobj_id);
		emresrefobjService.update(domain );
		EMResRefObjDTO dto = emresrefobjMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emresrefobjMapping,#emresrefobjdtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMResRefObj" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emresrefobjs/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMResRefObjDTO> emresrefobjdtos) {
        emresrefobjService.updateBatch(emresrefobjMapping.toDomain(emresrefobjdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emresrefobjMapping,#emresrefobjdto})")
    @ApiOperation(value = "Save", tags = {"EMResRefObj" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emresrefobjs/save")
    public ResponseEntity<Boolean> save(@RequestBody EMResRefObjDTO emresrefobjdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emresrefobjService.save(emresrefobjMapping.toDomain(emresrefobjdto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emresrefobjMapping,#emresrefobjdtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMResRefObj" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emresrefobjs/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMResRefObjDTO> emresrefobjdtos) {
        emresrefobjService.saveBatch(emresrefobjMapping.toDomain(emresrefobjdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMResRefObj-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMResRefObj" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emresrefobjs/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMResRefObjDTO emresrefobjdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emresrefobjService.checkKey(emresrefobjMapping.toDomain(emresrefobjdto)));
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emresrefobjMapping,#emresrefobjdto})")
    @ApiOperation(value = "Create", tags = {"EMResRefObj" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emresrefobjs")
    @Transactional
    public ResponseEntity<EMResRefObjDTO> create(@RequestBody EMResRefObjDTO emresrefobjdto) {
        EMResRefObj domain = emresrefobjMapping.toDomain(emresrefobjdto);
		emresrefobjService.create(domain);
        EMResRefObjDTO dto = emresrefobjMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emresrefobjMapping,#emresrefobjdtos})")
    @ApiOperation(value = "createBatch", tags = {"EMResRefObj" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emresrefobjs/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMResRefObjDTO> emresrefobjdtos) {
        emresrefobjService.createBatch(emresrefobjMapping.toDomain(emresrefobjdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emresrefobj_id,'Remove',{'Sql',this.emresrefobjMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMResRefObj" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emresrefobjs/{emresrefobj_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emresrefobj_id") String emresrefobj_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emresrefobjService.remove(emresrefobj_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emresrefobjMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMResRefObj" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emresrefobjs/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emresrefobjService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMResRefObj-IndexDER-all')")
	@ApiOperation(value = "fetchIndexDER", tags = {"EMResRefObj" } ,notes = "fetchIndexDER")
    @RequestMapping(method= RequestMethod.GET , value="/emresrefobjs/fetchindexder")
	public ResponseEntity<List<EMResRefObjDTO>> fetchIndexDER(EMResRefObjSearchContext context) {
        Page<EMResRefObj> domains = emresrefobjService.searchIndexDER(context) ;
        List<EMResRefObjDTO> list = emresrefobjMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMResRefObj-IndexDER-all')")
	@ApiOperation(value = "searchIndexDER", tags = {"EMResRefObj" } ,notes = "searchIndexDER")
    @RequestMapping(method= RequestMethod.POST , value="/emresrefobjs/searchindexder")
	public ResponseEntity<Page<EMResRefObjDTO>> searchIndexDER(@RequestBody EMResRefObjSearchContext context) {
        Page<EMResRefObj> domains = emresrefobjService.searchIndexDER(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emresrefobjMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMResRefObj-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMResRefObj" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emresrefobjs/fetchdefault")
	public ResponseEntity<List<EMResRefObjDTO>> fetchDefault(EMResRefObjSearchContext context) {
        Page<EMResRefObj> domains = emresrefobjService.searchDefault(context) ;
        List<EMResRefObjDTO> list = emresrefobjMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMResRefObj-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMResRefObj" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emresrefobjs/searchdefault")
	public ResponseEntity<Page<EMResRefObjDTO>> searchDefault(@RequestBody EMResRefObjSearchContext context) {
        Page<EMResRefObj> domains = emresrefobjService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emresrefobjMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
