package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMRFODE;
import cn.ibizlab.eam.core.eam_core.service.IEMRFODEService;
import cn.ibizlab.eam.core.eam_core.filter.EMRFODESearchContext;

@Slf4j
@Api(tags = {"EMRFODE" })
@RestController("WebApi-emrfode")
@RequestMapping("")
public class EMRFODEResource {

    @Autowired
    private IEMRFODEService emrfodeService;

    @Autowired
    @Lazy
    public EMRFODEMapping emrfodeMapping;

    public EMRFODEDTO permissionDTO=new EMRFODEDTO();

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFODE-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMRFODE" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodes/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMRFODEDTO emrfodedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emrfodeService.checkKey(emrfodeMapping.toDomain(emrfodedto)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emrfodeMapping,#emrfodedto})")
    @ApiOperation(value = "Save", tags = {"EMRFODE" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodes/save")
    public ResponseEntity<Boolean> save(@RequestBody EMRFODEDTO emrfodedto) {
        return ResponseEntity.status(HttpStatus.OK).body(emrfodeService.save(emrfodeMapping.toDomain(emrfodedto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emrfodeMapping,#emrfodedtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMRFODE" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodes/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMRFODEDTO> emrfodedtos) {
        emrfodeService.saveBatch(emrfodeMapping.toDomain(emrfodedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emrfode_id,'Update',{'Sql',this.emrfodeMapping,#emrfodedto})")
    @ApiOperation(value = "Update", tags = {"EMRFODE" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emrfodes/{emrfode_id}")
    @Transactional
    public ResponseEntity<EMRFODEDTO> update(@PathVariable("emrfode_id") String emrfode_id, @RequestBody EMRFODEDTO emrfodedto) {
		EMRFODE domain  = emrfodeMapping.toDomain(emrfodedto);
        domain .setEmrfodeid(emrfode_id);
		emrfodeService.update(domain );
		EMRFODEDTO dto = emrfodeMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emrfodeMapping,#emrfodedtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMRFODE" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emrfodes/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMRFODEDTO> emrfodedtos) {
        emrfodeService.updateBatch(emrfodeMapping.toDomain(emrfodedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emrfode_id,'Remove',{'Sql',this.emrfodeMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMRFODE" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emrfodes/{emrfode_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emrfode_id") String emrfode_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emrfodeService.remove(emrfode_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emrfodeMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMRFODE" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emrfodes/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emrfodeService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emrfodeMapping,#emrfodedto})")
    @ApiOperation(value = "Create", tags = {"EMRFODE" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodes")
    @Transactional
    public ResponseEntity<EMRFODEDTO> create(@RequestBody EMRFODEDTO emrfodedto) {
        EMRFODE domain = emrfodeMapping.toDomain(emrfodedto);
		emrfodeService.create(domain);
        EMRFODEDTO dto = emrfodeMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emrfodeMapping,#emrfodedtos})")
    @ApiOperation(value = "createBatch", tags = {"EMRFODE" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodes/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMRFODEDTO> emrfodedtos) {
        emrfodeService.createBatch(emrfodeMapping.toDomain(emrfodedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emrfode_id,'Get',{'Sql',this.emrfodeMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMRFODE" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emrfodes/{emrfode_id}")
    public ResponseEntity<EMRFODEDTO> get(@PathVariable("emrfode_id") String emrfode_id) {
        EMRFODE domain = emrfodeService.get(emrfode_id);
        EMRFODEDTO dto = emrfodeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFODE-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMRFODE" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emrfodes/getdraft")
    public ResponseEntity<EMRFODEDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emrfodeMapping.toDto(emrfodeService.getDraft(new EMRFODE())));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFODE-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMRFODE" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emrfodes/fetchdefault")
	public ResponseEntity<List<EMRFODEDTO>> fetchDefault(EMRFODESearchContext context) {
        Page<EMRFODE> domains = emrfodeService.searchDefault(context) ;
        List<EMRFODEDTO> list = emrfodeMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFODE-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMRFODE" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emrfodes/searchdefault")
	public ResponseEntity<Page<EMRFODEDTO>> searchDefault(@RequestBody EMRFODESearchContext context) {
        Page<EMRFODE> domains = emrfodeService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emrfodeMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
