package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMRFOCA;
import cn.ibizlab.eam.core.eam_core.service.IEMRFOCAService;
import cn.ibizlab.eam.core.eam_core.filter.EMRFOCASearchContext;

@Slf4j
@Api(tags = {"EMRFOCA" })
@RestController("WebApi-emrfoca")
@RequestMapping("")
public class EMRFOCAResource {

    @Autowired
    private IEMRFOCAService emrfocaService;

    @Autowired
    @Lazy
    public EMRFOCAMapping emrfocaMapping;

    public EMRFOCADTO permissionDTO=new EMRFOCADTO();

    @PreAuthorize("hasPermission(#emrfoca_id,'Update',{'Sql',this.emrfocaMapping,#emrfocadto})")
    @ApiOperation(value = "Update", tags = {"EMRFOCA" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emrfocas/{emrfoca_id}")
    @Transactional
    public ResponseEntity<EMRFOCADTO> update(@PathVariable("emrfoca_id") String emrfoca_id, @RequestBody EMRFOCADTO emrfocadto) {
		EMRFOCA domain  = emrfocaMapping.toDomain(emrfocadto);
        domain .setEmrfocaid(emrfoca_id);
		emrfocaService.update(domain );
		EMRFOCADTO dto = emrfocaMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emrfocaMapping,#emrfocadtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMRFOCA" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emrfocas/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMRFOCADTO> emrfocadtos) {
        emrfocaService.updateBatch(emrfocaMapping.toDomain(emrfocadtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFOCA-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMRFOCA" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emrfocas/getdraft")
    public ResponseEntity<EMRFOCADTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emrfocaMapping.toDto(emrfocaService.getDraft(new EMRFOCA())));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emrfocaMapping,#emrfocadto})")
    @ApiOperation(value = "Save", tags = {"EMRFOCA" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfocas/save")
    public ResponseEntity<Boolean> save(@RequestBody EMRFOCADTO emrfocadto) {
        return ResponseEntity.status(HttpStatus.OK).body(emrfocaService.save(emrfocaMapping.toDomain(emrfocadto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emrfocaMapping,#emrfocadtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMRFOCA" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfocas/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMRFOCADTO> emrfocadtos) {
        emrfocaService.saveBatch(emrfocaMapping.toDomain(emrfocadtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emrfocaMapping,#emrfocadto})")
    @ApiOperation(value = "Create", tags = {"EMRFOCA" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfocas")
    @Transactional
    public ResponseEntity<EMRFOCADTO> create(@RequestBody EMRFOCADTO emrfocadto) {
        EMRFOCA domain = emrfocaMapping.toDomain(emrfocadto);
		emrfocaService.create(domain);
        EMRFOCADTO dto = emrfocaMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emrfocaMapping,#emrfocadtos})")
    @ApiOperation(value = "createBatch", tags = {"EMRFOCA" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfocas/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMRFOCADTO> emrfocadtos) {
        emrfocaService.createBatch(emrfocaMapping.toDomain(emrfocadtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emrfoca_id,'Remove',{'Sql',this.emrfocaMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMRFOCA" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emrfocas/{emrfoca_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emrfoca_id") String emrfoca_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emrfocaService.remove(emrfoca_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emrfocaMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMRFOCA" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emrfocas/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emrfocaService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emrfoca_id,'Get',{'Sql',this.emrfocaMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMRFOCA" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emrfocas/{emrfoca_id}")
    public ResponseEntity<EMRFOCADTO> get(@PathVariable("emrfoca_id") String emrfoca_id) {
        EMRFOCA domain = emrfocaService.get(emrfoca_id);
        EMRFOCADTO dto = emrfocaMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFOCA-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMRFOCA" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfocas/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMRFOCADTO emrfocadto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emrfocaService.checkKey(emrfocaMapping.toDomain(emrfocadto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFOCA-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMRFOCA" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emrfocas/fetchdefault")
	public ResponseEntity<List<EMRFOCADTO>> fetchDefault(EMRFOCASearchContext context) {
        Page<EMRFOCA> domains = emrfocaService.searchDefault(context) ;
        List<EMRFOCADTO> list = emrfocaMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFOCA-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMRFOCA" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emrfocas/searchdefault")
	public ResponseEntity<Page<EMRFOCADTO>> searchDefault(@RequestBody EMRFOCASearchContext context) {
        Page<EMRFOCA> domains = emrfocaService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emrfocaMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emrfoca_id,'Update',{'Sql',this.emrfocaMapping,#emrfocadto})")
    @ApiOperation(value = "UpdateByEMRFODE", tags = {"EMRFOCA" },  notes = "UpdateByEMRFODE")
	@RequestMapping(method = RequestMethod.PUT, value = "/emrfodes/{emrfode_id}/emrfocas/{emrfoca_id}")
    @Transactional
    public ResponseEntity<EMRFOCADTO> updateByEMRFODE(@PathVariable("emrfode_id") String emrfode_id, @PathVariable("emrfoca_id") String emrfoca_id, @RequestBody EMRFOCADTO emrfocadto) {
        EMRFOCA domain = emrfocaMapping.toDomain(emrfocadto);
        domain.setRfodeid(emrfode_id);
        domain.setEmrfocaid(emrfoca_id);
		emrfocaService.update(domain);
        EMRFOCADTO dto = emrfocaMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emrfocaMapping,#emrfocadtos})")
    @ApiOperation(value = "UpdateBatchByEMRFODE", tags = {"EMRFOCA" },  notes = "UpdateBatchByEMRFODE")
	@RequestMapping(method = RequestMethod.PUT, value = "/emrfodes/{emrfode_id}/emrfocas/batch")
    public ResponseEntity<Boolean> updateBatchByEMRFODE(@PathVariable("emrfode_id") String emrfode_id, @RequestBody List<EMRFOCADTO> emrfocadtos) {
        List<EMRFOCA> domainlist=emrfocaMapping.toDomain(emrfocadtos);
        for(EMRFOCA domain:domainlist){
            domain.setRfodeid(emrfode_id);
        }
        emrfocaService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFOCA-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMRFODE", tags = {"EMRFOCA" },  notes = "GetDraftByEMRFODE")
    @RequestMapping(method = RequestMethod.GET, value = "/emrfodes/{emrfode_id}/emrfocas/getdraft")
    public ResponseEntity<EMRFOCADTO> getDraftByEMRFODE(@PathVariable("emrfode_id") String emrfode_id) {
        EMRFOCA domain = new EMRFOCA();
        domain.setRfodeid(emrfode_id);
        return ResponseEntity.status(HttpStatus.OK).body(emrfocaMapping.toDto(emrfocaService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emrfocaMapping,#emrfocadto})")
    @ApiOperation(value = "SaveByEMRFODE", tags = {"EMRFOCA" },  notes = "SaveByEMRFODE")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodes/{emrfode_id}/emrfocas/save")
    public ResponseEntity<Boolean> saveByEMRFODE(@PathVariable("emrfode_id") String emrfode_id, @RequestBody EMRFOCADTO emrfocadto) {
        EMRFOCA domain = emrfocaMapping.toDomain(emrfocadto);
        domain.setRfodeid(emrfode_id);
        return ResponseEntity.status(HttpStatus.OK).body(emrfocaService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emrfocaMapping,#emrfocadtos})")
    @ApiOperation(value = "SaveBatchByEMRFODE", tags = {"EMRFOCA" },  notes = "SaveBatchByEMRFODE")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodes/{emrfode_id}/emrfocas/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMRFODE(@PathVariable("emrfode_id") String emrfode_id, @RequestBody List<EMRFOCADTO> emrfocadtos) {
        List<EMRFOCA> domainlist=emrfocaMapping.toDomain(emrfocadtos);
        for(EMRFOCA domain:domainlist){
             domain.setRfodeid(emrfode_id);
        }
        emrfocaService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emrfocaMapping,#emrfocadto})")
    @ApiOperation(value = "CreateByEMRFODE", tags = {"EMRFOCA" },  notes = "CreateByEMRFODE")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodes/{emrfode_id}/emrfocas")
    @Transactional
    public ResponseEntity<EMRFOCADTO> createByEMRFODE(@PathVariable("emrfode_id") String emrfode_id, @RequestBody EMRFOCADTO emrfocadto) {
        EMRFOCA domain = emrfocaMapping.toDomain(emrfocadto);
        domain.setRfodeid(emrfode_id);
		emrfocaService.create(domain);
        EMRFOCADTO dto = emrfocaMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emrfocaMapping,#emrfocadtos})")
    @ApiOperation(value = "createBatchByEMRFODE", tags = {"EMRFOCA" },  notes = "createBatchByEMRFODE")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodes/{emrfode_id}/emrfocas/batch")
    public ResponseEntity<Boolean> createBatchByEMRFODE(@PathVariable("emrfode_id") String emrfode_id, @RequestBody List<EMRFOCADTO> emrfocadtos) {
        List<EMRFOCA> domainlist=emrfocaMapping.toDomain(emrfocadtos);
        for(EMRFOCA domain:domainlist){
            domain.setRfodeid(emrfode_id);
        }
        emrfocaService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emrfoca_id,'Remove',{'Sql',this.emrfocaMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMRFODE", tags = {"EMRFOCA" },  notes = "RemoveByEMRFODE")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emrfodes/{emrfode_id}/emrfocas/{emrfoca_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMRFODE(@PathVariable("emrfode_id") String emrfode_id, @PathVariable("emrfoca_id") String emrfoca_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emrfocaService.remove(emrfoca_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emrfocaMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMRFODE", tags = {"EMRFOCA" },  notes = "RemoveBatchByEMRFODE")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emrfodes/{emrfode_id}/emrfocas/batch")
    public ResponseEntity<Boolean> removeBatchByEMRFODE(@RequestBody List<String> ids) {
        emrfocaService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emrfoca_id,'Get',{'Sql',this.emrfocaMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMRFODE", tags = {"EMRFOCA" },  notes = "GetByEMRFODE")
	@RequestMapping(method = RequestMethod.GET, value = "/emrfodes/{emrfode_id}/emrfocas/{emrfoca_id}")
    public ResponseEntity<EMRFOCADTO> getByEMRFODE(@PathVariable("emrfode_id") String emrfode_id, @PathVariable("emrfoca_id") String emrfoca_id) {
        EMRFOCA domain = emrfocaService.get(emrfoca_id);
        EMRFOCADTO dto = emrfocaMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFOCA-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMRFODE", tags = {"EMRFOCA" },  notes = "CheckKeyByEMRFODE")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodes/{emrfode_id}/emrfocas/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMRFODE(@PathVariable("emrfode_id") String emrfode_id, @RequestBody EMRFOCADTO emrfocadto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emrfocaService.checkKey(emrfocaMapping.toDomain(emrfocadto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFOCA-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMRFODE", tags = {"EMRFOCA" } ,notes = "fetchDEFAULTByEMRFODE")
    @RequestMapping(method= RequestMethod.GET , value="/emrfodes/{emrfode_id}/emrfocas/fetchdefault")
	public ResponseEntity<List<EMRFOCADTO>> fetchEMRFOCADefaultByEMRFODE(@PathVariable("emrfode_id") String emrfode_id,EMRFOCASearchContext context) {
        context.setN_rfodeid_eq(emrfode_id);
        Page<EMRFOCA> domains = emrfocaService.searchDefault(context) ;
        List<EMRFOCADTO> list = emrfocaMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFOCA-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMRFODE", tags = {"EMRFOCA" } ,notes = "searchDEFAULTByEMRFODE")
    @RequestMapping(method= RequestMethod.POST , value="/emrfodes/{emrfode_id}/emrfocas/searchdefault")
	public ResponseEntity<Page<EMRFOCADTO>> searchEMRFOCADefaultByEMRFODE(@PathVariable("emrfode_id") String emrfode_id, @RequestBody EMRFOCASearchContext context) {
        context.setN_rfodeid_eq(emrfode_id);
        Page<EMRFOCA> domains = emrfocaService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emrfocaMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emrfoca_id,'Update',{'Sql',this.emrfocaMapping,#emrfocadto})")
    @ApiOperation(value = "UpdateByEMRFOMO", tags = {"EMRFOCA" },  notes = "UpdateByEMRFOMO")
	@RequestMapping(method = RequestMethod.PUT, value = "/emrfomos/{emrfomo_id}/emrfocas/{emrfoca_id}")
    @Transactional
    public ResponseEntity<EMRFOCADTO> updateByEMRFOMO(@PathVariable("emrfomo_id") String emrfomo_id, @PathVariable("emrfoca_id") String emrfoca_id, @RequestBody EMRFOCADTO emrfocadto) {
        EMRFOCA domain = emrfocaMapping.toDomain(emrfocadto);
        domain.setRfomoid(emrfomo_id);
        domain.setEmrfocaid(emrfoca_id);
		emrfocaService.update(domain);
        EMRFOCADTO dto = emrfocaMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emrfocaMapping,#emrfocadtos})")
    @ApiOperation(value = "UpdateBatchByEMRFOMO", tags = {"EMRFOCA" },  notes = "UpdateBatchByEMRFOMO")
	@RequestMapping(method = RequestMethod.PUT, value = "/emrfomos/{emrfomo_id}/emrfocas/batch")
    public ResponseEntity<Boolean> updateBatchByEMRFOMO(@PathVariable("emrfomo_id") String emrfomo_id, @RequestBody List<EMRFOCADTO> emrfocadtos) {
        List<EMRFOCA> domainlist=emrfocaMapping.toDomain(emrfocadtos);
        for(EMRFOCA domain:domainlist){
            domain.setRfomoid(emrfomo_id);
        }
        emrfocaService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFOCA-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMRFOMO", tags = {"EMRFOCA" },  notes = "GetDraftByEMRFOMO")
    @RequestMapping(method = RequestMethod.GET, value = "/emrfomos/{emrfomo_id}/emrfocas/getdraft")
    public ResponseEntity<EMRFOCADTO> getDraftByEMRFOMO(@PathVariable("emrfomo_id") String emrfomo_id) {
        EMRFOCA domain = new EMRFOCA();
        domain.setRfomoid(emrfomo_id);
        return ResponseEntity.status(HttpStatus.OK).body(emrfocaMapping.toDto(emrfocaService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emrfocaMapping,#emrfocadto})")
    @ApiOperation(value = "SaveByEMRFOMO", tags = {"EMRFOCA" },  notes = "SaveByEMRFOMO")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfomos/{emrfomo_id}/emrfocas/save")
    public ResponseEntity<Boolean> saveByEMRFOMO(@PathVariable("emrfomo_id") String emrfomo_id, @RequestBody EMRFOCADTO emrfocadto) {
        EMRFOCA domain = emrfocaMapping.toDomain(emrfocadto);
        domain.setRfomoid(emrfomo_id);
        return ResponseEntity.status(HttpStatus.OK).body(emrfocaService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emrfocaMapping,#emrfocadtos})")
    @ApiOperation(value = "SaveBatchByEMRFOMO", tags = {"EMRFOCA" },  notes = "SaveBatchByEMRFOMO")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfomos/{emrfomo_id}/emrfocas/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMRFOMO(@PathVariable("emrfomo_id") String emrfomo_id, @RequestBody List<EMRFOCADTO> emrfocadtos) {
        List<EMRFOCA> domainlist=emrfocaMapping.toDomain(emrfocadtos);
        for(EMRFOCA domain:domainlist){
             domain.setRfomoid(emrfomo_id);
        }
        emrfocaService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emrfocaMapping,#emrfocadto})")
    @ApiOperation(value = "CreateByEMRFOMO", tags = {"EMRFOCA" },  notes = "CreateByEMRFOMO")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfomos/{emrfomo_id}/emrfocas")
    @Transactional
    public ResponseEntity<EMRFOCADTO> createByEMRFOMO(@PathVariable("emrfomo_id") String emrfomo_id, @RequestBody EMRFOCADTO emrfocadto) {
        EMRFOCA domain = emrfocaMapping.toDomain(emrfocadto);
        domain.setRfomoid(emrfomo_id);
		emrfocaService.create(domain);
        EMRFOCADTO dto = emrfocaMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emrfocaMapping,#emrfocadtos})")
    @ApiOperation(value = "createBatchByEMRFOMO", tags = {"EMRFOCA" },  notes = "createBatchByEMRFOMO")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfomos/{emrfomo_id}/emrfocas/batch")
    public ResponseEntity<Boolean> createBatchByEMRFOMO(@PathVariable("emrfomo_id") String emrfomo_id, @RequestBody List<EMRFOCADTO> emrfocadtos) {
        List<EMRFOCA> domainlist=emrfocaMapping.toDomain(emrfocadtos);
        for(EMRFOCA domain:domainlist){
            domain.setRfomoid(emrfomo_id);
        }
        emrfocaService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emrfoca_id,'Remove',{'Sql',this.emrfocaMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMRFOMO", tags = {"EMRFOCA" },  notes = "RemoveByEMRFOMO")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emrfomos/{emrfomo_id}/emrfocas/{emrfoca_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMRFOMO(@PathVariable("emrfomo_id") String emrfomo_id, @PathVariable("emrfoca_id") String emrfoca_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emrfocaService.remove(emrfoca_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emrfocaMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMRFOMO", tags = {"EMRFOCA" },  notes = "RemoveBatchByEMRFOMO")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emrfomos/{emrfomo_id}/emrfocas/batch")
    public ResponseEntity<Boolean> removeBatchByEMRFOMO(@RequestBody List<String> ids) {
        emrfocaService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emrfoca_id,'Get',{'Sql',this.emrfocaMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMRFOMO", tags = {"EMRFOCA" },  notes = "GetByEMRFOMO")
	@RequestMapping(method = RequestMethod.GET, value = "/emrfomos/{emrfomo_id}/emrfocas/{emrfoca_id}")
    public ResponseEntity<EMRFOCADTO> getByEMRFOMO(@PathVariable("emrfomo_id") String emrfomo_id, @PathVariable("emrfoca_id") String emrfoca_id) {
        EMRFOCA domain = emrfocaService.get(emrfoca_id);
        EMRFOCADTO dto = emrfocaMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFOCA-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMRFOMO", tags = {"EMRFOCA" },  notes = "CheckKeyByEMRFOMO")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfomos/{emrfomo_id}/emrfocas/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMRFOMO(@PathVariable("emrfomo_id") String emrfomo_id, @RequestBody EMRFOCADTO emrfocadto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emrfocaService.checkKey(emrfocaMapping.toDomain(emrfocadto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFOCA-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMRFOMO", tags = {"EMRFOCA" } ,notes = "fetchDEFAULTByEMRFOMO")
    @RequestMapping(method= RequestMethod.GET , value="/emrfomos/{emrfomo_id}/emrfocas/fetchdefault")
	public ResponseEntity<List<EMRFOCADTO>> fetchEMRFOCADefaultByEMRFOMO(@PathVariable("emrfomo_id") String emrfomo_id,EMRFOCASearchContext context) {
        context.setN_rfomoid_eq(emrfomo_id);
        Page<EMRFOCA> domains = emrfocaService.searchDefault(context) ;
        List<EMRFOCADTO> list = emrfocaMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFOCA-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMRFOMO", tags = {"EMRFOCA" } ,notes = "searchDEFAULTByEMRFOMO")
    @RequestMapping(method= RequestMethod.POST , value="/emrfomos/{emrfomo_id}/emrfocas/searchdefault")
	public ResponseEntity<Page<EMRFOCADTO>> searchEMRFOCADefaultByEMRFOMO(@PathVariable("emrfomo_id") String emrfomo_id, @RequestBody EMRFOCASearchContext context) {
        context.setN_rfomoid_eq(emrfomo_id);
        Page<EMRFOCA> domains = emrfocaService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emrfocaMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emrfoca_id,'Update',{'Sql',this.emrfocaMapping,#emrfocadto})")
    @ApiOperation(value = "UpdateByEMRFODEEMRFOMO", tags = {"EMRFOCA" },  notes = "UpdateByEMRFODEEMRFOMO")
	@RequestMapping(method = RequestMethod.PUT, value = "/emrfodes/{emrfode_id}/emrfomos/{emrfomo_id}/emrfocas/{emrfoca_id}")
    @Transactional
    public ResponseEntity<EMRFOCADTO> updateByEMRFODEEMRFOMO(@PathVariable("emrfode_id") String emrfode_id, @PathVariable("emrfomo_id") String emrfomo_id, @PathVariable("emrfoca_id") String emrfoca_id, @RequestBody EMRFOCADTO emrfocadto) {
        EMRFOCA domain = emrfocaMapping.toDomain(emrfocadto);
        domain.setRfomoid(emrfomo_id);
        domain.setEmrfocaid(emrfoca_id);
		emrfocaService.update(domain);
        EMRFOCADTO dto = emrfocaMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emrfocaMapping,#emrfocadtos})")
    @ApiOperation(value = "UpdateBatchByEMRFODEEMRFOMO", tags = {"EMRFOCA" },  notes = "UpdateBatchByEMRFODEEMRFOMO")
	@RequestMapping(method = RequestMethod.PUT, value = "/emrfodes/{emrfode_id}/emrfomos/{emrfomo_id}/emrfocas/batch")
    public ResponseEntity<Boolean> updateBatchByEMRFODEEMRFOMO(@PathVariable("emrfode_id") String emrfode_id, @PathVariable("emrfomo_id") String emrfomo_id, @RequestBody List<EMRFOCADTO> emrfocadtos) {
        List<EMRFOCA> domainlist=emrfocaMapping.toDomain(emrfocadtos);
        for(EMRFOCA domain:domainlist){
            domain.setRfomoid(emrfomo_id);
        }
        emrfocaService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFOCA-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMRFODEEMRFOMO", tags = {"EMRFOCA" },  notes = "GetDraftByEMRFODEEMRFOMO")
    @RequestMapping(method = RequestMethod.GET, value = "/emrfodes/{emrfode_id}/emrfomos/{emrfomo_id}/emrfocas/getdraft")
    public ResponseEntity<EMRFOCADTO> getDraftByEMRFODEEMRFOMO(@PathVariable("emrfode_id") String emrfode_id, @PathVariable("emrfomo_id") String emrfomo_id) {
        EMRFOCA domain = new EMRFOCA();
        domain.setRfomoid(emrfomo_id);
        return ResponseEntity.status(HttpStatus.OK).body(emrfocaMapping.toDto(emrfocaService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emrfocaMapping,#emrfocadto})")
    @ApiOperation(value = "SaveByEMRFODEEMRFOMO", tags = {"EMRFOCA" },  notes = "SaveByEMRFODEEMRFOMO")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodes/{emrfode_id}/emrfomos/{emrfomo_id}/emrfocas/save")
    public ResponseEntity<Boolean> saveByEMRFODEEMRFOMO(@PathVariable("emrfode_id") String emrfode_id, @PathVariable("emrfomo_id") String emrfomo_id, @RequestBody EMRFOCADTO emrfocadto) {
        EMRFOCA domain = emrfocaMapping.toDomain(emrfocadto);
        domain.setRfomoid(emrfomo_id);
        return ResponseEntity.status(HttpStatus.OK).body(emrfocaService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emrfocaMapping,#emrfocadtos})")
    @ApiOperation(value = "SaveBatchByEMRFODEEMRFOMO", tags = {"EMRFOCA" },  notes = "SaveBatchByEMRFODEEMRFOMO")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodes/{emrfode_id}/emrfomos/{emrfomo_id}/emrfocas/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMRFODEEMRFOMO(@PathVariable("emrfode_id") String emrfode_id, @PathVariable("emrfomo_id") String emrfomo_id, @RequestBody List<EMRFOCADTO> emrfocadtos) {
        List<EMRFOCA> domainlist=emrfocaMapping.toDomain(emrfocadtos);
        for(EMRFOCA domain:domainlist){
             domain.setRfomoid(emrfomo_id);
        }
        emrfocaService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emrfocaMapping,#emrfocadto})")
    @ApiOperation(value = "CreateByEMRFODEEMRFOMO", tags = {"EMRFOCA" },  notes = "CreateByEMRFODEEMRFOMO")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodes/{emrfode_id}/emrfomos/{emrfomo_id}/emrfocas")
    @Transactional
    public ResponseEntity<EMRFOCADTO> createByEMRFODEEMRFOMO(@PathVariable("emrfode_id") String emrfode_id, @PathVariable("emrfomo_id") String emrfomo_id, @RequestBody EMRFOCADTO emrfocadto) {
        EMRFOCA domain = emrfocaMapping.toDomain(emrfocadto);
        domain.setRfomoid(emrfomo_id);
		emrfocaService.create(domain);
        EMRFOCADTO dto = emrfocaMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emrfocaMapping,#emrfocadtos})")
    @ApiOperation(value = "createBatchByEMRFODEEMRFOMO", tags = {"EMRFOCA" },  notes = "createBatchByEMRFODEEMRFOMO")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodes/{emrfode_id}/emrfomos/{emrfomo_id}/emrfocas/batch")
    public ResponseEntity<Boolean> createBatchByEMRFODEEMRFOMO(@PathVariable("emrfode_id") String emrfode_id, @PathVariable("emrfomo_id") String emrfomo_id, @RequestBody List<EMRFOCADTO> emrfocadtos) {
        List<EMRFOCA> domainlist=emrfocaMapping.toDomain(emrfocadtos);
        for(EMRFOCA domain:domainlist){
            domain.setRfomoid(emrfomo_id);
        }
        emrfocaService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emrfoca_id,'Remove',{'Sql',this.emrfocaMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMRFODEEMRFOMO", tags = {"EMRFOCA" },  notes = "RemoveByEMRFODEEMRFOMO")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emrfodes/{emrfode_id}/emrfomos/{emrfomo_id}/emrfocas/{emrfoca_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMRFODEEMRFOMO(@PathVariable("emrfode_id") String emrfode_id, @PathVariable("emrfomo_id") String emrfomo_id, @PathVariable("emrfoca_id") String emrfoca_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emrfocaService.remove(emrfoca_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emrfocaMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMRFODEEMRFOMO", tags = {"EMRFOCA" },  notes = "RemoveBatchByEMRFODEEMRFOMO")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emrfodes/{emrfode_id}/emrfomos/{emrfomo_id}/emrfocas/batch")
    public ResponseEntity<Boolean> removeBatchByEMRFODEEMRFOMO(@RequestBody List<String> ids) {
        emrfocaService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emrfoca_id,'Get',{'Sql',this.emrfocaMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMRFODEEMRFOMO", tags = {"EMRFOCA" },  notes = "GetByEMRFODEEMRFOMO")
	@RequestMapping(method = RequestMethod.GET, value = "/emrfodes/{emrfode_id}/emrfomos/{emrfomo_id}/emrfocas/{emrfoca_id}")
    public ResponseEntity<EMRFOCADTO> getByEMRFODEEMRFOMO(@PathVariable("emrfode_id") String emrfode_id, @PathVariable("emrfomo_id") String emrfomo_id, @PathVariable("emrfoca_id") String emrfoca_id) {
        EMRFOCA domain = emrfocaService.get(emrfoca_id);
        EMRFOCADTO dto = emrfocaMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFOCA-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMRFODEEMRFOMO", tags = {"EMRFOCA" },  notes = "CheckKeyByEMRFODEEMRFOMO")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodes/{emrfode_id}/emrfomos/{emrfomo_id}/emrfocas/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMRFODEEMRFOMO(@PathVariable("emrfode_id") String emrfode_id, @PathVariable("emrfomo_id") String emrfomo_id, @RequestBody EMRFOCADTO emrfocadto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emrfocaService.checkKey(emrfocaMapping.toDomain(emrfocadto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFOCA-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMRFODEEMRFOMO", tags = {"EMRFOCA" } ,notes = "fetchDEFAULTByEMRFODEEMRFOMO")
    @RequestMapping(method= RequestMethod.GET , value="/emrfodes/{emrfode_id}/emrfomos/{emrfomo_id}/emrfocas/fetchdefault")
	public ResponseEntity<List<EMRFOCADTO>> fetchEMRFOCADefaultByEMRFODEEMRFOMO(@PathVariable("emrfode_id") String emrfode_id, @PathVariable("emrfomo_id") String emrfomo_id,EMRFOCASearchContext context) {
        context.setN_rfomoid_eq(emrfomo_id);
        Page<EMRFOCA> domains = emrfocaService.searchDefault(context) ;
        List<EMRFOCADTO> list = emrfocaMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFOCA-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMRFODEEMRFOMO", tags = {"EMRFOCA" } ,notes = "searchDEFAULTByEMRFODEEMRFOMO")
    @RequestMapping(method= RequestMethod.POST , value="/emrfodes/{emrfode_id}/emrfomos/{emrfomo_id}/emrfocas/searchdefault")
	public ResponseEntity<Page<EMRFOCADTO>> searchEMRFOCADefaultByEMRFODEEMRFOMO(@PathVariable("emrfode_id") String emrfode_id, @PathVariable("emrfomo_id") String emrfomo_id, @RequestBody EMRFOCASearchContext context) {
        context.setN_rfomoid_eq(emrfomo_id);
        Page<EMRFOCA> domains = emrfocaService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emrfocaMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
