package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMPurchangeHis;
import cn.ibizlab.eam.core.eam_core.service.IEMPurchangeHisService;
import cn.ibizlab.eam.core.eam_core.filter.EMPurchangeHisSearchContext;

@Slf4j
@Api(tags = {"EMPurchangeHis" })
@RestController("WebApi-empurchangehis")
@RequestMapping("")
public class EMPurchangeHisResource {

    @Autowired
    private IEMPurchangeHisService empurchangehisService;

    @Autowired
    @Lazy
    public EMPurchangeHisMapping empurchangehisMapping;

    public EMPurchangeHisDTO permissionDTO=new EMPurchangeHisDTO();

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPurchangeHis-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMPurchangeHis" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/empurchangehis/getdraft")
    public ResponseEntity<EMPurchangeHisDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(empurchangehisMapping.toDto(empurchangehisService.getDraft(new EMPurchangeHis())));
    }

    @PreAuthorize("hasPermission(#empurchangehis_id,'Update',{'Sql',this.empurchangehisMapping,#empurchangehisdto})")
    @ApiOperation(value = "Update", tags = {"EMPurchangeHis" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/empurchangehis/{empurchangehis_id}")
    @Transactional
    public ResponseEntity<EMPurchangeHisDTO> update(@PathVariable("empurchangehis_id") String empurchangehis_id, @RequestBody EMPurchangeHisDTO empurchangehisdto) {
		EMPurchangeHis domain  = empurchangehisMapping.toDomain(empurchangehisdto);
        domain .setEmpurchangehisid(empurchangehis_id);
		empurchangehisService.update(domain );
		EMPurchangeHisDTO dto = empurchangehisMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.empurchangehisMapping,#empurchangehisdtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMPurchangeHis" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/empurchangehis/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMPurchangeHisDTO> empurchangehisdtos) {
        empurchangehisService.updateBatch(empurchangehisMapping.toDomain(empurchangehisdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.empurchangehisMapping,#empurchangehisdto})")
    @ApiOperation(value = "Save", tags = {"EMPurchangeHis" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/empurchangehis/save")
    public ResponseEntity<Boolean> save(@RequestBody EMPurchangeHisDTO empurchangehisdto) {
        return ResponseEntity.status(HttpStatus.OK).body(empurchangehisService.save(empurchangehisMapping.toDomain(empurchangehisdto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.empurchangehisMapping,#empurchangehisdtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMPurchangeHis" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/empurchangehis/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMPurchangeHisDTO> empurchangehisdtos) {
        empurchangehisService.saveBatch(empurchangehisMapping.toDomain(empurchangehisdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#empurchangehis_id,'Get',{'Sql',this.empurchangehisMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMPurchangeHis" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/empurchangehis/{empurchangehis_id}")
    public ResponseEntity<EMPurchangeHisDTO> get(@PathVariable("empurchangehis_id") String empurchangehis_id) {
        EMPurchangeHis domain = empurchangehisService.get(empurchangehis_id);
        EMPurchangeHisDTO dto = empurchangehisMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#empurchangehis_id,'Remove',{'Sql',this.empurchangehisMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMPurchangeHis" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/empurchangehis/{empurchangehis_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("empurchangehis_id") String empurchangehis_id) {
         return ResponseEntity.status(HttpStatus.OK).body(empurchangehisService.remove(empurchangehis_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.empurchangehisMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMPurchangeHis" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/empurchangehis/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        empurchangehisService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPurchangeHis-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMPurchangeHis" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/empurchangehis/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMPurchangeHisDTO empurchangehisdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(empurchangehisService.checkKey(empurchangehisMapping.toDomain(empurchangehisdto)));
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.empurchangehisMapping,#empurchangehisdto})")
    @ApiOperation(value = "Create", tags = {"EMPurchangeHis" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/empurchangehis")
    @Transactional
    public ResponseEntity<EMPurchangeHisDTO> create(@RequestBody EMPurchangeHisDTO empurchangehisdto) {
        EMPurchangeHis domain = empurchangehisMapping.toDomain(empurchangehisdto);
		empurchangehisService.create(domain);
        EMPurchangeHisDTO dto = empurchangehisMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.empurchangehisMapping,#empurchangehisdtos})")
    @ApiOperation(value = "createBatch", tags = {"EMPurchangeHis" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/empurchangehis/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMPurchangeHisDTO> empurchangehisdtos) {
        empurchangehisService.createBatch(empurchangehisMapping.toDomain(empurchangehisdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPurchangeHis-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMPurchangeHis" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/empurchangehis/fetchdefault")
	public ResponseEntity<List<EMPurchangeHisDTO>> fetchDefault(EMPurchangeHisSearchContext context) {
        Page<EMPurchangeHis> domains = empurchangehisService.searchDefault(context) ;
        List<EMPurchangeHisDTO> list = empurchangehisMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPurchangeHis-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMPurchangeHis" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/empurchangehis/searchdefault")
	public ResponseEntity<Page<EMPurchangeHisDTO>> searchDefault(@RequestBody EMPurchangeHisSearchContext context) {
        Page<EMPurchangeHis> domains = empurchangehisService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(empurchangehisMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
