package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMObjMap;
import cn.ibizlab.eam.core.eam_core.service.IEMObjMapService;
import cn.ibizlab.eam.core.eam_core.filter.EMObjMapSearchContext;

@Slf4j
@Api(tags = {"EMObjMap" })
@RestController("WebApi-emobjmap")
@RequestMapping("")
public class EMObjMapResource {

    @Autowired
    private IEMObjMapService emobjmapService;

    @Autowired
    @Lazy
    public EMObjMapMapping emobjmapMapping;

    public EMObjMapDTO permissionDTO=new EMObjMapDTO();

    @PreAuthorize("hasPermission(#emobjmap_id,'Update',{'Sql',this.emobjmapMapping,#emobjmapdto})")
    @ApiOperation(value = "Update", tags = {"EMObjMap" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emobjmaps/{emobjmap_id}")
    @Transactional
    public ResponseEntity<EMObjMapDTO> update(@PathVariable("emobjmap_id") String emobjmap_id, @RequestBody EMObjMapDTO emobjmapdto) {
		EMObjMap domain  = emobjmapMapping.toDomain(emobjmapdto);
        domain .setEmobjmapid(emobjmap_id);
		emobjmapService.update(domain );
		EMObjMapDTO dto = emobjmapMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emobjmapMapping,#emobjmapdtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMObjMap" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emobjmaps/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMObjMapDTO> emobjmapdtos) {
        emobjmapService.updateBatch(emobjmapMapping.toDomain(emobjmapdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emobjmapMapping,#emobjmapdto})")
    @ApiOperation(value = "Create", tags = {"EMObjMap" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emobjmaps")
    @Transactional
    public ResponseEntity<EMObjMapDTO> create(@RequestBody EMObjMapDTO emobjmapdto) {
        EMObjMap domain = emobjmapMapping.toDomain(emobjmapdto);
		emobjmapService.create(domain);
        EMObjMapDTO dto = emobjmapMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emobjmapMapping,#emobjmapdtos})")
    @ApiOperation(value = "createBatch", tags = {"EMObjMap" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emobjmaps/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMObjMapDTO> emobjmapdtos) {
        emobjmapService.createBatch(emobjmapMapping.toDomain(emobjmapdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emobjmap_id,'Remove',{'Sql',this.emobjmapMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMObjMap" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emobjmaps/{emobjmap_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emobjmap_id") String emobjmap_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emobjmapService.remove(emobjmap_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emobjmapMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMObjMap" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emobjmaps/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emobjmapService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emobjmapMapping,#emobjmapdto})")
    @ApiOperation(value = "Save", tags = {"EMObjMap" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emobjmaps/save")
    public ResponseEntity<Boolean> save(@RequestBody EMObjMapDTO emobjmapdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emobjmapService.save(emobjmapMapping.toDomain(emobjmapdto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emobjmapMapping,#emobjmapdtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMObjMap" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emobjmaps/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMObjMapDTO> emobjmapdtos) {
        emobjmapService.saveBatch(emobjmapMapping.toDomain(emobjmapdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMObjMap-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMObjMap" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emobjmaps/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMObjMapDTO emobjmapdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emobjmapService.checkKey(emobjmapMapping.toDomain(emobjmapdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMObjMap-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMObjMap" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emobjmaps/getdraft")
    public ResponseEntity<EMObjMapDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emobjmapMapping.toDto(emobjmapService.getDraft(new EMObjMap())));
    }

    @PreAuthorize("hasPermission(#emobjmap_id,'Get',{'Sql',this.emobjmapMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMObjMap" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emobjmaps/{emobjmap_id}")
    public ResponseEntity<EMObjMapDTO> get(@PathVariable("emobjmap_id") String emobjmap_id) {
        EMObjMap domain = emobjmapService.get(emobjmap_id);
        EMObjMapDTO dto = emobjmapMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMObjMap-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMObjMap" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emobjmaps/fetchdefault")
	public ResponseEntity<List<EMObjMapDTO>> fetchDefault(EMObjMapSearchContext context) {
        Page<EMObjMap> domains = emobjmapService.searchDefault(context) ;
        List<EMObjMapDTO> list = emobjmapMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMObjMap-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMObjMap" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emobjmaps/searchdefault")
	public ResponseEntity<Page<EMObjMapDTO>> searchDefault(@RequestBody EMObjMapSearchContext context) {
        Page<EMObjMap> domains = emobjmapService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emobjmapMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMObjMap-IndexDER-all')")
	@ApiOperation(value = "fetchIndexDER", tags = {"EMObjMap" } ,notes = "fetchIndexDER")
    @RequestMapping(method= RequestMethod.GET , value="/emobjmaps/fetchindexder")
	public ResponseEntity<List<EMObjMapDTO>> fetchIndexDER(EMObjMapSearchContext context) {
        Page<EMObjMap> domains = emobjmapService.searchIndexDER(context) ;
        List<EMObjMapDTO> list = emobjmapMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMObjMap-IndexDER-all')")
	@ApiOperation(value = "searchIndexDER", tags = {"EMObjMap" } ,notes = "searchIndexDER")
    @RequestMapping(method= RequestMethod.POST , value="/emobjmaps/searchindexder")
	public ResponseEntity<Page<EMObjMapDTO>> searchIndexDER(@RequestBody EMObjMapSearchContext context) {
        Page<EMObjMap> domains = emobjmapService.searchIndexDER(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emobjmapMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
