package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMItemSubMap;
import cn.ibizlab.eam.core.eam_core.service.IEMItemSubMapService;
import cn.ibizlab.eam.core.eam_core.filter.EMItemSubMapSearchContext;

@Slf4j
@Api(tags = {"EMItemSubMap" })
@RestController("WebApi-emitemsubmap")
@RequestMapping("")
public class EMItemSubMapResource {

    @Autowired
    private IEMItemSubMapService emitemsubmapService;

    @Autowired
    @Lazy
    public EMItemSubMapMapping emitemsubmapMapping;

    public EMItemSubMapDTO permissionDTO=new EMItemSubMapDTO();

    @PreAuthorize("hasPermission(#emitemsubmap_id,'Get',{'Sql',this.emitemsubmapMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMItemSubMap" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emitemsubmaps/{emitemsubmap_id}")
    public ResponseEntity<EMItemSubMapDTO> get(@PathVariable("emitemsubmap_id") String emitemsubmap_id) {
        EMItemSubMap domain = emitemsubmapService.get(emitemsubmap_id);
        EMItemSubMapDTO dto = emitemsubmapMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emitemsubmapMapping,#emitemsubmapdto})")
    @ApiOperation(value = "Save", tags = {"EMItemSubMap" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemsubmaps/save")
    public ResponseEntity<Boolean> save(@RequestBody EMItemSubMapDTO emitemsubmapdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emitemsubmapService.save(emitemsubmapMapping.toDomain(emitemsubmapdto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emitemsubmapMapping,#emitemsubmapdtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMItemSubMap" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemsubmaps/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMItemSubMapDTO> emitemsubmapdtos) {
        emitemsubmapService.saveBatch(emitemsubmapMapping.toDomain(emitemsubmapdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemSubMap-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMItemSubMap" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemsubmaps/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMItemSubMapDTO emitemsubmapdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemsubmapService.checkKey(emitemsubmapMapping.toDomain(emitemsubmapdto)));
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emitemsubmapMapping,#emitemsubmapdto})")
    @ApiOperation(value = "Create", tags = {"EMItemSubMap" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemsubmaps")
    @Transactional
    public ResponseEntity<EMItemSubMapDTO> create(@RequestBody EMItemSubMapDTO emitemsubmapdto) {
        EMItemSubMap domain = emitemsubmapMapping.toDomain(emitemsubmapdto);
		emitemsubmapService.create(domain);
        EMItemSubMapDTO dto = emitemsubmapMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emitemsubmapMapping,#emitemsubmapdtos})")
    @ApiOperation(value = "createBatch", tags = {"EMItemSubMap" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemsubmaps/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMItemSubMapDTO> emitemsubmapdtos) {
        emitemsubmapService.createBatch(emitemsubmapMapping.toDomain(emitemsubmapdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emitemsubmap_id,'Update',{'Sql',this.emitemsubmapMapping,#emitemsubmapdto})")
    @ApiOperation(value = "Update", tags = {"EMItemSubMap" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitemsubmaps/{emitemsubmap_id}")
    @Transactional
    public ResponseEntity<EMItemSubMapDTO> update(@PathVariable("emitemsubmap_id") String emitemsubmap_id, @RequestBody EMItemSubMapDTO emitemsubmapdto) {
		EMItemSubMap domain  = emitemsubmapMapping.toDomain(emitemsubmapdto);
        domain .setEmitemsubmapid(emitemsubmap_id);
		emitemsubmapService.update(domain );
		EMItemSubMapDTO dto = emitemsubmapMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emitemsubmapMapping,#emitemsubmapdtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMItemSubMap" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitemsubmaps/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMItemSubMapDTO> emitemsubmapdtos) {
        emitemsubmapService.updateBatch(emitemsubmapMapping.toDomain(emitemsubmapdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemSubMap-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMItemSubMap" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emitemsubmaps/getdraft")
    public ResponseEntity<EMItemSubMapDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emitemsubmapMapping.toDto(emitemsubmapService.getDraft(new EMItemSubMap())));
    }

    @PreAuthorize("hasPermission(#emitemsubmap_id,'Remove',{'Sql',this.emitemsubmapMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMItemSubMap" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitemsubmaps/{emitemsubmap_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emitemsubmap_id") String emitemsubmap_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emitemsubmapService.remove(emitemsubmap_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emitemsubmapMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMItemSubMap" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitemsubmaps/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emitemsubmapService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemSubMap-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMItemSubMap" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emitemsubmaps/fetchdefault")
	public ResponseEntity<List<EMItemSubMapDTO>> fetchDefault(EMItemSubMapSearchContext context) {
        Page<EMItemSubMap> domains = emitemsubmapService.searchDefault(context) ;
        List<EMItemSubMapDTO> list = emitemsubmapMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemSubMap-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMItemSubMap" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emitemsubmaps/searchdefault")
	public ResponseEntity<Page<EMItemSubMapDTO>> searchDefault(@RequestBody EMItemSubMapSearchContext context) {
        Page<EMItemSubMap> domains = emitemsubmapService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemsubmapMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
