package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMItemPUse;
import cn.ibizlab.eam.core.eam_core.service.IEMItemPUseService;
import cn.ibizlab.eam.core.eam_core.filter.EMItemPUseSearchContext;

@Slf4j
@Api(tags = {"EMItemPUse" })
@RestController("WebApi-emitempuse")
@RequestMapping("")
public class EMItemPUseResource {

    @Autowired
    private IEMItemPUseService emitempuseService;

    @Autowired
    @Lazy
    public EMItemPUseMapping emitempuseMapping;

    public EMItemPUseDTO permissionDTO=new EMItemPUseDTO();

    @PreAuthorize("hasPermission(#emitempuse_id,'Update',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "Update", tags = {"EMItemPUse" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> update(@PathVariable("emitempuse_id") String emitempuse_id, @RequestBody EMItemPUseDTO emitempusedto) {
		EMItemPUse domain  = emitempuseMapping.toDomain(emitempusedto);
        domain .setEmitempuseid(emitempuse_id);
		emitempuseService.update(domain );
		EMItemPUseDTO dto = emitempuseMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMItemPUse" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitempuses/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMItemPUseDTO> emitempusedtos) {
        emitempuseService.updateBatch(emitempuseMapping.toDomain(emitempusedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMItemPUse" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emitempuses/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMItemPUseDTO emitempusedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitempuseService.checkKey(emitempuseMapping.toDomain(emitempusedto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMItemPUse" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emitempuses/getdraft")
    public ResponseEntity<EMItemPUseDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseMapping.toDto(emitempuseService.getDraft(new EMItemPUse())));
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Remove',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMItemPUse" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emitempuse_id") String emitempuse_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.remove(emitempuse_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emitempuseMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMItemPUse" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitempuses/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emitempuseService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Get',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMItemPUse" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emitempuses/{emitempuse_id}")
    public ResponseEntity<EMItemPUseDTO> get(@PathVariable("emitempuse_id") String emitempuse_id) {
        EMItemPUse domain = emitempuseService.get(emitempuse_id);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "Save", tags = {"EMItemPUse" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emitempuses/save")
    public ResponseEntity<Boolean> save(@RequestBody EMItemPUseDTO emitempusedto) {
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.save(emitempuseMapping.toDomain(emitempusedto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMItemPUse" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emitempuses/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMItemPUseDTO> emitempusedtos) {
        emitempuseService.saveBatch(emitempuseMapping.toDomain(emitempusedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "Create", tags = {"EMItemPUse" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emitempuses")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> create(@RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
		emitempuseService.create(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "createBatch", tags = {"EMItemPUse" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emitempuses/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMItemPUseDTO> emitempusedtos) {
        emitempuseService.createBatch(emitempuseMapping.toDomain(emitempusedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMItemPUse" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emitempuses/fetchdefault")
	public ResponseEntity<List<EMItemPUseDTO>> fetchDefault(EMItemPUseSearchContext context) {
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
        List<EMItemPUseDTO> list = emitempuseMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMItemPUse" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emitempuses/searchdefault")
	public ResponseEntity<Page<EMItemPUseDTO>> searchDefault(@RequestBody EMItemPUseSearchContext context) {
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitempuseMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emitempuse_id,'Update',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "UpdateByEMEquip", tags = {"EMItemPUse" },  notes = "UpdateByEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> updateByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emitempuse_id") String emitempuse_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setEquipid(emequip_id);
        domain.setEmitempuseid(emitempuse_id);
		emitempuseService.update(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "UpdateBatchByEMEquip", tags = {"EMItemPUse" },  notes = "UpdateBatchByEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emitempuses/batch")
    public ResponseEntity<Boolean> updateBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emitempuseService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMEquip", tags = {"EMItemPUse" },  notes = "CheckKeyByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emitempuses/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMItemPUseDTO emitempusedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitempuseService.checkKey(emitempuseMapping.toDomain(emitempusedto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMEquip", tags = {"EMItemPUse" },  notes = "GetDraftByEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emitempuses/getdraft")
    public ResponseEntity<EMItemPUseDTO> getDraftByEMEquip(@PathVariable("emequip_id") String emequip_id) {
        EMItemPUse domain = new EMItemPUse();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseMapping.toDto(emitempuseService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Remove',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMEquip", tags = {"EMItemPUse" },  notes = "RemoveByEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emitempuse_id") String emitempuse_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.remove(emitempuse_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emitempuseMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMEquip", tags = {"EMItemPUse" },  notes = "RemoveBatchByEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emitempuses/batch")
    public ResponseEntity<Boolean> removeBatchByEMEquip(@RequestBody List<String> ids) {
        emitempuseService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Get',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMEquip", tags = {"EMItemPUse" },  notes = "GetByEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emitempuses/{emitempuse_id}")
    public ResponseEntity<EMItemPUseDTO> getByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emitempuse_id") String emitempuse_id) {
        EMItemPUse domain = emitempuseService.get(emitempuse_id);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "SaveByEMEquip", tags = {"EMItemPUse" },  notes = "SaveByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emitempuses/save")
    public ResponseEntity<Boolean> saveByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "SaveBatchByEMEquip", tags = {"EMItemPUse" },  notes = "SaveBatchByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emitempuses/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emitempuseService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "CreateByEMEquip", tags = {"EMItemPUse" },  notes = "CreateByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emitempuses")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> createByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setEquipid(emequip_id);
		emitempuseService.create(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "createBatchByEMEquip", tags = {"EMItemPUse" },  notes = "createBatchByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emitempuses/batch")
    public ResponseEntity<Boolean> createBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emitempuseService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMEquip", tags = {"EMItemPUse" } ,notes = "fetchDEFAULTByEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emequips/{emequip_id}/emitempuses/fetchdefault")
	public ResponseEntity<List<EMItemPUseDTO>> fetchEMItemPUseDefaultByEMEquip(@PathVariable("emequip_id") String emequip_id,EMItemPUseSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
        List<EMItemPUseDTO> list = emitempuseMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMEquip", tags = {"EMItemPUse" } ,notes = "searchDEFAULTByEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emequips/{emequip_id}/emitempuses/searchdefault")
	public ResponseEntity<Page<EMItemPUseDTO>> searchEMItemPUseDefaultByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMItemPUseSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitempuseMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emitempuse_id,'Update',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "UpdateByEMItem", tags = {"EMItemPUse" },  notes = "UpdateByEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitems/{emitem_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> updateByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emitempuse_id") String emitempuse_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setItemid(emitem_id);
        domain.setEmitempuseid(emitempuse_id);
		emitempuseService.update(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "UpdateBatchByEMItem", tags = {"EMItemPUse" },  notes = "UpdateBatchByEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitems/{emitem_id}/emitempuses/batch")
    public ResponseEntity<Boolean> updateBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitempuseService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMItem", tags = {"EMItemPUse" },  notes = "CheckKeyByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitempuses/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPUseDTO emitempusedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitempuseService.checkKey(emitempuseMapping.toDomain(emitempusedto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMItem", tags = {"EMItemPUse" },  notes = "GetDraftByEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emitems/{emitem_id}/emitempuses/getdraft")
    public ResponseEntity<EMItemPUseDTO> getDraftByEMItem(@PathVariable("emitem_id") String emitem_id) {
        EMItemPUse domain = new EMItemPUse();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseMapping.toDto(emitempuseService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Remove',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMItem", tags = {"EMItemPUse" },  notes = "RemoveByEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitems/{emitem_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emitempuse_id") String emitempuse_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.remove(emitempuse_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emitempuseMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMItem", tags = {"EMItemPUse" },  notes = "RemoveBatchByEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitems/{emitem_id}/emitempuses/batch")
    public ResponseEntity<Boolean> removeBatchByEMItem(@RequestBody List<String> ids) {
        emitempuseService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Get',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMItem", tags = {"EMItemPUse" },  notes = "GetByEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emitems/{emitem_id}/emitempuses/{emitempuse_id}")
    public ResponseEntity<EMItemPUseDTO> getByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emitempuse_id") String emitempuse_id) {
        EMItemPUse domain = emitempuseService.get(emitempuse_id);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "SaveByEMItem", tags = {"EMItemPUse" },  notes = "SaveByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitempuses/save")
    public ResponseEntity<Boolean> saveByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "SaveBatchByEMItem", tags = {"EMItemPUse" },  notes = "SaveBatchByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitempuses/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitempuseService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "CreateByEMItem", tags = {"EMItemPUse" },  notes = "CreateByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitempuses")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> createByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setItemid(emitem_id);
		emitempuseService.create(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "createBatchByEMItem", tags = {"EMItemPUse" },  notes = "createBatchByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitempuses/batch")
    public ResponseEntity<Boolean> createBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitempuseService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMItem", tags = {"EMItemPUse" } ,notes = "fetchDEFAULTByEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emitems/{emitem_id}/emitempuses/fetchdefault")
	public ResponseEntity<List<EMItemPUseDTO>> fetchEMItemPUseDefaultByEMItem(@PathVariable("emitem_id") String emitem_id,EMItemPUseSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
        List<EMItemPUseDTO> list = emitempuseMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMItem", tags = {"EMItemPUse" } ,notes = "searchDEFAULTByEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emitems/{emitem_id}/emitempuses/searchdefault")
	public ResponseEntity<Page<EMItemPUseDTO>> searchEMItemPUseDefaultByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPUseSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitempuseMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emitempuse_id,'Update',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "UpdateByEMPurPlan", tags = {"EMItemPUse" },  notes = "UpdateByEMPurPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/empurplans/{empurplan_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> updateByEMPurPlan(@PathVariable("empurplan_id") String empurplan_id, @PathVariable("emitempuse_id") String emitempuse_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setPurplanid(empurplan_id);
        domain.setEmitempuseid(emitempuse_id);
		emitempuseService.update(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "UpdateBatchByEMPurPlan", tags = {"EMItemPUse" },  notes = "UpdateBatchByEMPurPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/empurplans/{empurplan_id}/emitempuses/batch")
    public ResponseEntity<Boolean> updateBatchByEMPurPlan(@PathVariable("empurplan_id") String empurplan_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setPurplanid(empurplan_id);
        }
        emitempuseService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMPurPlan", tags = {"EMItemPUse" },  notes = "CheckKeyByEMPurPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/empurplans/{empurplan_id}/emitempuses/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMPurPlan(@PathVariable("empurplan_id") String empurplan_id, @RequestBody EMItemPUseDTO emitempusedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitempuseService.checkKey(emitempuseMapping.toDomain(emitempusedto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMPurPlan", tags = {"EMItemPUse" },  notes = "GetDraftByEMPurPlan")
    @RequestMapping(method = RequestMethod.GET, value = "/empurplans/{empurplan_id}/emitempuses/getdraft")
    public ResponseEntity<EMItemPUseDTO> getDraftByEMPurPlan(@PathVariable("empurplan_id") String empurplan_id) {
        EMItemPUse domain = new EMItemPUse();
        domain.setPurplanid(empurplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseMapping.toDto(emitempuseService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Remove',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMPurPlan", tags = {"EMItemPUse" },  notes = "RemoveByEMPurPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/empurplans/{empurplan_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMPurPlan(@PathVariable("empurplan_id") String empurplan_id, @PathVariable("emitempuse_id") String emitempuse_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.remove(emitempuse_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emitempuseMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMPurPlan", tags = {"EMItemPUse" },  notes = "RemoveBatchByEMPurPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/empurplans/{empurplan_id}/emitempuses/batch")
    public ResponseEntity<Boolean> removeBatchByEMPurPlan(@RequestBody List<String> ids) {
        emitempuseService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Get',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMPurPlan", tags = {"EMItemPUse" },  notes = "GetByEMPurPlan")
	@RequestMapping(method = RequestMethod.GET, value = "/empurplans/{empurplan_id}/emitempuses/{emitempuse_id}")
    public ResponseEntity<EMItemPUseDTO> getByEMPurPlan(@PathVariable("empurplan_id") String empurplan_id, @PathVariable("emitempuse_id") String emitempuse_id) {
        EMItemPUse domain = emitempuseService.get(emitempuse_id);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "SaveByEMPurPlan", tags = {"EMItemPUse" },  notes = "SaveByEMPurPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/empurplans/{empurplan_id}/emitempuses/save")
    public ResponseEntity<Boolean> saveByEMPurPlan(@PathVariable("empurplan_id") String empurplan_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setPurplanid(empurplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "SaveBatchByEMPurPlan", tags = {"EMItemPUse" },  notes = "SaveBatchByEMPurPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/empurplans/{empurplan_id}/emitempuses/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMPurPlan(@PathVariable("empurplan_id") String empurplan_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
             domain.setPurplanid(empurplan_id);
        }
        emitempuseService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "CreateByEMPurPlan", tags = {"EMItemPUse" },  notes = "CreateByEMPurPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/empurplans/{empurplan_id}/emitempuses")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> createByEMPurPlan(@PathVariable("empurplan_id") String empurplan_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setPurplanid(empurplan_id);
		emitempuseService.create(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "createBatchByEMPurPlan", tags = {"EMItemPUse" },  notes = "createBatchByEMPurPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/empurplans/{empurplan_id}/emitempuses/batch")
    public ResponseEntity<Boolean> createBatchByEMPurPlan(@PathVariable("empurplan_id") String empurplan_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setPurplanid(empurplan_id);
        }
        emitempuseService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMPurPlan", tags = {"EMItemPUse" } ,notes = "fetchDEFAULTByEMPurPlan")
    @RequestMapping(method= RequestMethod.GET , value="/empurplans/{empurplan_id}/emitempuses/fetchdefault")
	public ResponseEntity<List<EMItemPUseDTO>> fetchEMItemPUseDefaultByEMPurPlan(@PathVariable("empurplan_id") String empurplan_id,EMItemPUseSearchContext context) {
        context.setN_purplanid_eq(empurplan_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
        List<EMItemPUseDTO> list = emitempuseMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMPurPlan", tags = {"EMItemPUse" } ,notes = "searchDEFAULTByEMPurPlan")
    @RequestMapping(method= RequestMethod.POST , value="/empurplans/{empurplan_id}/emitempuses/searchdefault")
	public ResponseEntity<Page<EMItemPUseDTO>> searchEMItemPUseDefaultByEMPurPlan(@PathVariable("empurplan_id") String empurplan_id, @RequestBody EMItemPUseSearchContext context) {
        context.setN_purplanid_eq(empurplan_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitempuseMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emitempuse_id,'Update',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "UpdateByEMService", tags = {"EMItemPUse" },  notes = "UpdateByEMService")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> updateByEMService(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitempuse_id") String emitempuse_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setMserviceid(emservice_id);
        domain.setEmitempuseid(emitempuse_id);
		emitempuseService.update(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "UpdateBatchByEMService", tags = {"EMItemPUse" },  notes = "UpdateBatchByEMService")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitempuses/batch")
    public ResponseEntity<Boolean> updateBatchByEMService(@PathVariable("emservice_id") String emservice_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setMserviceid(emservice_id);
        }
        emitempuseService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMService", tags = {"EMItemPUse" },  notes = "CheckKeyByEMService")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitempuses/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMService(@PathVariable("emservice_id") String emservice_id, @RequestBody EMItemPUseDTO emitempusedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitempuseService.checkKey(emitempuseMapping.toDomain(emitempusedto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMService", tags = {"EMItemPUse" },  notes = "GetDraftByEMService")
    @RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitempuses/getdraft")
    public ResponseEntity<EMItemPUseDTO> getDraftByEMService(@PathVariable("emservice_id") String emservice_id) {
        EMItemPUse domain = new EMItemPUse();
        domain.setMserviceid(emservice_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseMapping.toDto(emitempuseService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Remove',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMService", tags = {"EMItemPUse" },  notes = "RemoveByEMService")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMService(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitempuse_id") String emitempuse_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.remove(emitempuse_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emitempuseMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMService", tags = {"EMItemPUse" },  notes = "RemoveBatchByEMService")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitempuses/batch")
    public ResponseEntity<Boolean> removeBatchByEMService(@RequestBody List<String> ids) {
        emitempuseService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Get',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMService", tags = {"EMItemPUse" },  notes = "GetByEMService")
	@RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitempuses/{emitempuse_id}")
    public ResponseEntity<EMItemPUseDTO> getByEMService(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitempuse_id") String emitempuse_id) {
        EMItemPUse domain = emitempuseService.get(emitempuse_id);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "SaveByEMService", tags = {"EMItemPUse" },  notes = "SaveByEMService")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitempuses/save")
    public ResponseEntity<Boolean> saveByEMService(@PathVariable("emservice_id") String emservice_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setMserviceid(emservice_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "SaveBatchByEMService", tags = {"EMItemPUse" },  notes = "SaveBatchByEMService")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitempuses/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMService(@PathVariable("emservice_id") String emservice_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
             domain.setMserviceid(emservice_id);
        }
        emitempuseService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "CreateByEMService", tags = {"EMItemPUse" },  notes = "CreateByEMService")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitempuses")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> createByEMService(@PathVariable("emservice_id") String emservice_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setMserviceid(emservice_id);
		emitempuseService.create(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "createBatchByEMService", tags = {"EMItemPUse" },  notes = "createBatchByEMService")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitempuses/batch")
    public ResponseEntity<Boolean> createBatchByEMService(@PathVariable("emservice_id") String emservice_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setMserviceid(emservice_id);
        }
        emitempuseService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMService", tags = {"EMItemPUse" } ,notes = "fetchDEFAULTByEMService")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emitempuses/fetchdefault")
	public ResponseEntity<List<EMItemPUseDTO>> fetchEMItemPUseDefaultByEMService(@PathVariable("emservice_id") String emservice_id,EMItemPUseSearchContext context) {
        context.setN_mserviceid_eq(emservice_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
        List<EMItemPUseDTO> list = emitempuseMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMService", tags = {"EMItemPUse" } ,notes = "searchDEFAULTByEMService")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emitempuses/searchdefault")
	public ResponseEntity<Page<EMItemPUseDTO>> searchEMItemPUseDefaultByEMService(@PathVariable("emservice_id") String emservice_id, @RequestBody EMItemPUseSearchContext context) {
        context.setN_mserviceid_eq(emservice_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitempuseMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emitempuse_id,'Update',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "UpdateByEMStorePart", tags = {"EMItemPUse" },  notes = "UpdateByEMStorePart")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> updateByEMStorePart(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitempuse_id") String emitempuse_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setStorepartid(emstorepart_id);
        domain.setEmitempuseid(emitempuse_id);
		emitempuseService.update(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "UpdateBatchByEMStorePart", tags = {"EMItemPUse" },  notes = "UpdateBatchByEMStorePart")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitempuses/batch")
    public ResponseEntity<Boolean> updateBatchByEMStorePart(@PathVariable("emstorepart_id") String emstorepart_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setStorepartid(emstorepart_id);
        }
        emitempuseService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMStorePart", tags = {"EMItemPUse" },  notes = "CheckKeyByEMStorePart")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitempuses/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStorePart(@PathVariable("emstorepart_id") String emstorepart_id, @RequestBody EMItemPUseDTO emitempusedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitempuseService.checkKey(emitempuseMapping.toDomain(emitempusedto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMStorePart", tags = {"EMItemPUse" },  notes = "GetDraftByEMStorePart")
    @RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitempuses/getdraft")
    public ResponseEntity<EMItemPUseDTO> getDraftByEMStorePart(@PathVariable("emstorepart_id") String emstorepart_id) {
        EMItemPUse domain = new EMItemPUse();
        domain.setStorepartid(emstorepart_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseMapping.toDto(emitempuseService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Remove',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMStorePart", tags = {"EMItemPUse" },  notes = "RemoveByEMStorePart")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStorePart(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitempuse_id") String emitempuse_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.remove(emitempuse_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emitempuseMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMStorePart", tags = {"EMItemPUse" },  notes = "RemoveBatchByEMStorePart")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitempuses/batch")
    public ResponseEntity<Boolean> removeBatchByEMStorePart(@RequestBody List<String> ids) {
        emitempuseService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Get',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMStorePart", tags = {"EMItemPUse" },  notes = "GetByEMStorePart")
	@RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitempuses/{emitempuse_id}")
    public ResponseEntity<EMItemPUseDTO> getByEMStorePart(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitempuse_id") String emitempuse_id) {
        EMItemPUse domain = emitempuseService.get(emitempuse_id);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "SaveByEMStorePart", tags = {"EMItemPUse" },  notes = "SaveByEMStorePart")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitempuses/save")
    public ResponseEntity<Boolean> saveByEMStorePart(@PathVariable("emstorepart_id") String emstorepart_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setStorepartid(emstorepart_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "SaveBatchByEMStorePart", tags = {"EMItemPUse" },  notes = "SaveBatchByEMStorePart")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitempuses/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStorePart(@PathVariable("emstorepart_id") String emstorepart_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
             domain.setStorepartid(emstorepart_id);
        }
        emitempuseService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "CreateByEMStorePart", tags = {"EMItemPUse" },  notes = "CreateByEMStorePart")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitempuses")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> createByEMStorePart(@PathVariable("emstorepart_id") String emstorepart_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setStorepartid(emstorepart_id);
		emitempuseService.create(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "createBatchByEMStorePart", tags = {"EMItemPUse" },  notes = "createBatchByEMStorePart")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitempuses/batch")
    public ResponseEntity<Boolean> createBatchByEMStorePart(@PathVariable("emstorepart_id") String emstorepart_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setStorepartid(emstorepart_id);
        }
        emitempuseService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMStorePart", tags = {"EMItemPUse" } ,notes = "fetchDEFAULTByEMStorePart")
    @RequestMapping(method= RequestMethod.GET , value="/emstoreparts/{emstorepart_id}/emitempuses/fetchdefault")
	public ResponseEntity<List<EMItemPUseDTO>> fetchEMItemPUseDefaultByEMStorePart(@PathVariable("emstorepart_id") String emstorepart_id,EMItemPUseSearchContext context) {
        context.setN_storepartid_eq(emstorepart_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
        List<EMItemPUseDTO> list = emitempuseMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMStorePart", tags = {"EMItemPUse" } ,notes = "searchDEFAULTByEMStorePart")
    @RequestMapping(method= RequestMethod.POST , value="/emstoreparts/{emstorepart_id}/emitempuses/searchdefault")
	public ResponseEntity<Page<EMItemPUseDTO>> searchEMItemPUseDefaultByEMStorePart(@PathVariable("emstorepart_id") String emstorepart_id, @RequestBody EMItemPUseSearchContext context) {
        context.setN_storepartid_eq(emstorepart_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitempuseMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emitempuse_id,'Update',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "UpdateByEMStore", tags = {"EMItemPUse" },  notes = "UpdateByEMStore")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> updateByEMStore(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitempuse_id") String emitempuse_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setStoreid(emstore_id);
        domain.setEmitempuseid(emitempuse_id);
		emitempuseService.update(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "UpdateBatchByEMStore", tags = {"EMItemPUse" },  notes = "UpdateBatchByEMStore")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitempuses/batch")
    public ResponseEntity<Boolean> updateBatchByEMStore(@PathVariable("emstore_id") String emstore_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setStoreid(emstore_id);
        }
        emitempuseService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMStore", tags = {"EMItemPUse" },  notes = "CheckKeyByEMStore")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitempuses/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStore(@PathVariable("emstore_id") String emstore_id, @RequestBody EMItemPUseDTO emitempusedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitempuseService.checkKey(emitempuseMapping.toDomain(emitempusedto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMStore", tags = {"EMItemPUse" },  notes = "GetDraftByEMStore")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitempuses/getdraft")
    public ResponseEntity<EMItemPUseDTO> getDraftByEMStore(@PathVariable("emstore_id") String emstore_id) {
        EMItemPUse domain = new EMItemPUse();
        domain.setStoreid(emstore_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseMapping.toDto(emitempuseService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Remove',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMStore", tags = {"EMItemPUse" },  notes = "RemoveByEMStore")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStore(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitempuse_id") String emitempuse_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.remove(emitempuse_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emitempuseMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMStore", tags = {"EMItemPUse" },  notes = "RemoveBatchByEMStore")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitempuses/batch")
    public ResponseEntity<Boolean> removeBatchByEMStore(@RequestBody List<String> ids) {
        emitempuseService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Get',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMStore", tags = {"EMItemPUse" },  notes = "GetByEMStore")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitempuses/{emitempuse_id}")
    public ResponseEntity<EMItemPUseDTO> getByEMStore(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitempuse_id") String emitempuse_id) {
        EMItemPUse domain = emitempuseService.get(emitempuse_id);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "SaveByEMStore", tags = {"EMItemPUse" },  notes = "SaveByEMStore")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitempuses/save")
    public ResponseEntity<Boolean> saveByEMStore(@PathVariable("emstore_id") String emstore_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setStoreid(emstore_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "SaveBatchByEMStore", tags = {"EMItemPUse" },  notes = "SaveBatchByEMStore")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitempuses/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStore(@PathVariable("emstore_id") String emstore_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
             domain.setStoreid(emstore_id);
        }
        emitempuseService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "CreateByEMStore", tags = {"EMItemPUse" },  notes = "CreateByEMStore")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitempuses")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> createByEMStore(@PathVariable("emstore_id") String emstore_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setStoreid(emstore_id);
		emitempuseService.create(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "createBatchByEMStore", tags = {"EMItemPUse" },  notes = "createBatchByEMStore")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitempuses/batch")
    public ResponseEntity<Boolean> createBatchByEMStore(@PathVariable("emstore_id") String emstore_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setStoreid(emstore_id);
        }
        emitempuseService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMStore", tags = {"EMItemPUse" } ,notes = "fetchDEFAULTByEMStore")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emitempuses/fetchdefault")
	public ResponseEntity<List<EMItemPUseDTO>> fetchEMItemPUseDefaultByEMStore(@PathVariable("emstore_id") String emstore_id,EMItemPUseSearchContext context) {
        context.setN_storeid_eq(emstore_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
        List<EMItemPUseDTO> list = emitempuseMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMStore", tags = {"EMItemPUse" } ,notes = "searchDEFAULTByEMStore")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emitempuses/searchdefault")
	public ResponseEntity<Page<EMItemPUseDTO>> searchEMItemPUseDefaultByEMStore(@PathVariable("emstore_id") String emstore_id, @RequestBody EMItemPUseSearchContext context) {
        context.setN_storeid_eq(emstore_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitempuseMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emitempuse_id,'Update',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "UpdateByPFDept", tags = {"EMItemPUse" },  notes = "UpdateByPFDept")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfdepts/{pfdept_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> updateByPFDept(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emitempuse_id") String emitempuse_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setDeptid(pfdept_id);
        domain.setEmitempuseid(emitempuse_id);
		emitempuseService.update(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "UpdateBatchByPFDept", tags = {"EMItemPUse" },  notes = "UpdateBatchByPFDept")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfdepts/{pfdept_id}/emitempuses/batch")
    public ResponseEntity<Boolean> updateBatchByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setDeptid(pfdept_id);
        }
        emitempuseService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFDept", tags = {"EMItemPUse" },  notes = "CheckKeyByPFDept")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emitempuses/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody EMItemPUseDTO emitempusedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitempuseService.checkKey(emitempuseMapping.toDomain(emitempusedto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFDept", tags = {"EMItemPUse" },  notes = "GetDraftByPFDept")
    @RequestMapping(method = RequestMethod.GET, value = "/pfdepts/{pfdept_id}/emitempuses/getdraft")
    public ResponseEntity<EMItemPUseDTO> getDraftByPFDept(@PathVariable("pfdept_id") String pfdept_id) {
        EMItemPUse domain = new EMItemPUse();
        domain.setDeptid(pfdept_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseMapping.toDto(emitempuseService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Remove',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFDept", tags = {"EMItemPUse" },  notes = "RemoveByPFDept")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfdepts/{pfdept_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFDept(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emitempuse_id") String emitempuse_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.remove(emitempuse_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emitempuseMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFDept", tags = {"EMItemPUse" },  notes = "RemoveBatchByPFDept")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfdepts/{pfdept_id}/emitempuses/batch")
    public ResponseEntity<Boolean> removeBatchByPFDept(@RequestBody List<String> ids) {
        emitempuseService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Get',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFDept", tags = {"EMItemPUse" },  notes = "GetByPFDept")
	@RequestMapping(method = RequestMethod.GET, value = "/pfdepts/{pfdept_id}/emitempuses/{emitempuse_id}")
    public ResponseEntity<EMItemPUseDTO> getByPFDept(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emitempuse_id") String emitempuse_id) {
        EMItemPUse domain = emitempuseService.get(emitempuse_id);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "SaveByPFDept", tags = {"EMItemPUse" },  notes = "SaveByPFDept")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emitempuses/save")
    public ResponseEntity<Boolean> saveByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setDeptid(pfdept_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "SaveBatchByPFDept", tags = {"EMItemPUse" },  notes = "SaveBatchByPFDept")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emitempuses/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
             domain.setDeptid(pfdept_id);
        }
        emitempuseService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "CreateByPFDept", tags = {"EMItemPUse" },  notes = "CreateByPFDept")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emitempuses")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> createByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setDeptid(pfdept_id);
		emitempuseService.create(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "createBatchByPFDept", tags = {"EMItemPUse" },  notes = "createBatchByPFDept")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emitempuses/batch")
    public ResponseEntity<Boolean> createBatchByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setDeptid(pfdept_id);
        }
        emitempuseService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFDept", tags = {"EMItemPUse" } ,notes = "fetchDEFAULTByPFDept")
    @RequestMapping(method= RequestMethod.GET , value="/pfdepts/{pfdept_id}/emitempuses/fetchdefault")
	public ResponseEntity<List<EMItemPUseDTO>> fetchEMItemPUseDefaultByPFDept(@PathVariable("pfdept_id") String pfdept_id,EMItemPUseSearchContext context) {
        context.setN_deptid_eq(pfdept_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
        List<EMItemPUseDTO> list = emitempuseMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFDept", tags = {"EMItemPUse" } ,notes = "searchDEFAULTByPFDept")
    @RequestMapping(method= RequestMethod.POST , value="/pfdepts/{pfdept_id}/emitempuses/searchdefault")
	public ResponseEntity<Page<EMItemPUseDTO>> searchEMItemPUseDefaultByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody EMItemPUseSearchContext context) {
        context.setN_deptid_eq(pfdept_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitempuseMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emitempuse_id,'Update',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "UpdateByPFEmp", tags = {"EMItemPUse" },  notes = "UpdateByPFEmp")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> updateByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitempuse_id") String emitempuse_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setApprempid(pfemp_id);
        domain.setEmitempuseid(emitempuse_id);
		emitempuseService.update(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "UpdateBatchByPFEmp", tags = {"EMItemPUse" },  notes = "UpdateBatchByPFEmp")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitempuses/batch")
    public ResponseEntity<Boolean> updateBatchByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setApprempid(pfemp_id);
        }
        emitempuseService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFEmp", tags = {"EMItemPUse" },  notes = "CheckKeyByPFEmp")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitempuses/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody EMItemPUseDTO emitempusedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitempuseService.checkKey(emitempuseMapping.toDomain(emitempusedto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFEmp", tags = {"EMItemPUse" },  notes = "GetDraftByPFEmp")
    @RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitempuses/getdraft")
    public ResponseEntity<EMItemPUseDTO> getDraftByPFEmp(@PathVariable("pfemp_id") String pfemp_id) {
        EMItemPUse domain = new EMItemPUse();
        domain.setApprempid(pfemp_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseMapping.toDto(emitempuseService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Remove',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFEmp", tags = {"EMItemPUse" },  notes = "RemoveByPFEmp")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitempuse_id") String emitempuse_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.remove(emitempuse_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emitempuseMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFEmp", tags = {"EMItemPUse" },  notes = "RemoveBatchByPFEmp")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitempuses/batch")
    public ResponseEntity<Boolean> removeBatchByPFEmp(@RequestBody List<String> ids) {
        emitempuseService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Get',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFEmp", tags = {"EMItemPUse" },  notes = "GetByPFEmp")
	@RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitempuses/{emitempuse_id}")
    public ResponseEntity<EMItemPUseDTO> getByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitempuse_id") String emitempuse_id) {
        EMItemPUse domain = emitempuseService.get(emitempuse_id);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "SaveByPFEmp", tags = {"EMItemPUse" },  notes = "SaveByPFEmp")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitempuses/save")
    public ResponseEntity<Boolean> saveByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setApprempid(pfemp_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "SaveBatchByPFEmp", tags = {"EMItemPUse" },  notes = "SaveBatchByPFEmp")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitempuses/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
             domain.setApprempid(pfemp_id);
        }
        emitempuseService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "CreateByPFEmp", tags = {"EMItemPUse" },  notes = "CreateByPFEmp")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitempuses")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> createByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setApprempid(pfemp_id);
		emitempuseService.create(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "createBatchByPFEmp", tags = {"EMItemPUse" },  notes = "createBatchByPFEmp")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitempuses/batch")
    public ResponseEntity<Boolean> createBatchByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setApprempid(pfemp_id);
        }
        emitempuseService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFEmp", tags = {"EMItemPUse" } ,notes = "fetchDEFAULTByPFEmp")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emitempuses/fetchdefault")
	public ResponseEntity<List<EMItemPUseDTO>> fetchEMItemPUseDefaultByPFEmp(@PathVariable("pfemp_id") String pfemp_id,EMItemPUseSearchContext context) {
        context.setN_apprempid_eq(pfemp_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
        List<EMItemPUseDTO> list = emitempuseMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFEmp", tags = {"EMItemPUse" } ,notes = "searchDEFAULTByPFEmp")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emitempuses/searchdefault")
	public ResponseEntity<Page<EMItemPUseDTO>> searchEMItemPUseDefaultByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody EMItemPUseSearchContext context) {
        context.setN_apprempid_eq(pfemp_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitempuseMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emitempuse_id,'Update',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "UpdateByPFTeam", tags = {"EMItemPUse" },  notes = "UpdateByPFTeam")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> updateByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emitempuse_id") String emitempuse_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setTeamid(pfteam_id);
        domain.setEmitempuseid(emitempuse_id);
		emitempuseService.update(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "UpdateBatchByPFTeam", tags = {"EMItemPUse" },  notes = "UpdateBatchByPFTeam")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emitempuses/batch")
    public ResponseEntity<Boolean> updateBatchByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setTeamid(pfteam_id);
        }
        emitempuseService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFTeam", tags = {"EMItemPUse" },  notes = "CheckKeyByPFTeam")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emitempuses/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody EMItemPUseDTO emitempusedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitempuseService.checkKey(emitempuseMapping.toDomain(emitempusedto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFTeam", tags = {"EMItemPUse" },  notes = "GetDraftByPFTeam")
    @RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emitempuses/getdraft")
    public ResponseEntity<EMItemPUseDTO> getDraftByPFTeam(@PathVariable("pfteam_id") String pfteam_id) {
        EMItemPUse domain = new EMItemPUse();
        domain.setTeamid(pfteam_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseMapping.toDto(emitempuseService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Remove',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFTeam", tags = {"EMItemPUse" },  notes = "RemoveByPFTeam")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emitempuse_id") String emitempuse_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.remove(emitempuse_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emitempuseMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFTeam", tags = {"EMItemPUse" },  notes = "RemoveBatchByPFTeam")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emitempuses/batch")
    public ResponseEntity<Boolean> removeBatchByPFTeam(@RequestBody List<String> ids) {
        emitempuseService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Get',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFTeam", tags = {"EMItemPUse" },  notes = "GetByPFTeam")
	@RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emitempuses/{emitempuse_id}")
    public ResponseEntity<EMItemPUseDTO> getByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emitempuse_id") String emitempuse_id) {
        EMItemPUse domain = emitempuseService.get(emitempuse_id);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "SaveByPFTeam", tags = {"EMItemPUse" },  notes = "SaveByPFTeam")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emitempuses/save")
    public ResponseEntity<Boolean> saveByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setTeamid(pfteam_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "SaveBatchByPFTeam", tags = {"EMItemPUse" },  notes = "SaveBatchByPFTeam")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emitempuses/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
             domain.setTeamid(pfteam_id);
        }
        emitempuseService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "CreateByPFTeam", tags = {"EMItemPUse" },  notes = "CreateByPFTeam")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emitempuses")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> createByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setTeamid(pfteam_id);
		emitempuseService.create(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "createBatchByPFTeam", tags = {"EMItemPUse" },  notes = "createBatchByPFTeam")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emitempuses/batch")
    public ResponseEntity<Boolean> createBatchByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setTeamid(pfteam_id);
        }
        emitempuseService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFTeam", tags = {"EMItemPUse" } ,notes = "fetchDEFAULTByPFTeam")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emitempuses/fetchdefault")
	public ResponseEntity<List<EMItemPUseDTO>> fetchEMItemPUseDefaultByPFTeam(@PathVariable("pfteam_id") String pfteam_id,EMItemPUseSearchContext context) {
        context.setN_teamid_eq(pfteam_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
        List<EMItemPUseDTO> list = emitempuseMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFTeam", tags = {"EMItemPUse" } ,notes = "searchDEFAULTByPFTeam")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emitempuses/searchdefault")
	public ResponseEntity<Page<EMItemPUseDTO>> searchEMItemPUseDefaultByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody EMItemPUseSearchContext context) {
        context.setN_teamid_eq(pfteam_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitempuseMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emitempuse_id,'Update',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "UpdateByEMEQTypeEMEquip", tags = {"EMItemPUse" },  notes = "UpdateByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> updateByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emitempuse_id") String emitempuse_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setEquipid(emequip_id);
        domain.setEmitempuseid(emitempuse_id);
		emitempuseService.update(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "UpdateBatchByEMEQTypeEMEquip", tags = {"EMItemPUse" },  notes = "UpdateBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emitempuses/batch")
    public ResponseEntity<Boolean> updateBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emitempuseService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMEQTypeEMEquip", tags = {"EMItemPUse" },  notes = "CheckKeyByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emitempuses/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMItemPUseDTO emitempusedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitempuseService.checkKey(emitempuseMapping.toDomain(emitempusedto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMEQTypeEMEquip", tags = {"EMItemPUse" },  notes = "GetDraftByEMEQTypeEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emitempuses/getdraft")
    public ResponseEntity<EMItemPUseDTO> getDraftByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id) {
        EMItemPUse domain = new EMItemPUse();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseMapping.toDto(emitempuseService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Remove',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMEQTypeEMEquip", tags = {"EMItemPUse" },  notes = "RemoveByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emitempuse_id") String emitempuse_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.remove(emitempuse_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emitempuseMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMEQTypeEMEquip", tags = {"EMItemPUse" },  notes = "RemoveBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emitempuses/batch")
    public ResponseEntity<Boolean> removeBatchByEMEQTypeEMEquip(@RequestBody List<String> ids) {
        emitempuseService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Get',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMEQTypeEMEquip", tags = {"EMItemPUse" },  notes = "GetByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emitempuses/{emitempuse_id}")
    public ResponseEntity<EMItemPUseDTO> getByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emitempuse_id") String emitempuse_id) {
        EMItemPUse domain = emitempuseService.get(emitempuse_id);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "SaveByEMEQTypeEMEquip", tags = {"EMItemPUse" },  notes = "SaveByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emitempuses/save")
    public ResponseEntity<Boolean> saveByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "SaveBatchByEMEQTypeEMEquip", tags = {"EMItemPUse" },  notes = "SaveBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emitempuses/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emitempuseService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "CreateByEMEQTypeEMEquip", tags = {"EMItemPUse" },  notes = "CreateByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emitempuses")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> createByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setEquipid(emequip_id);
		emitempuseService.create(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "createBatchByEMEQTypeEMEquip", tags = {"EMItemPUse" },  notes = "createBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emitempuses/batch")
    public ResponseEntity<Boolean> createBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emitempuseService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMEQTypeEMEquip", tags = {"EMItemPUse" } ,notes = "fetchDEFAULTByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emitempuses/fetchdefault")
	public ResponseEntity<List<EMItemPUseDTO>> fetchEMItemPUseDefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id,EMItemPUseSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
        List<EMItemPUseDTO> list = emitempuseMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMEQTypeEMEquip", tags = {"EMItemPUse" } ,notes = "searchDEFAULTByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emitempuses/searchdefault")
	public ResponseEntity<Page<EMItemPUseDTO>> searchEMItemPUseDefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMItemPUseSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitempuseMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emitempuse_id,'Update',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "UpdateByPFTeamEMEquip", tags = {"EMItemPUse" },  notes = "UpdateByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> updateByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emitempuse_id") String emitempuse_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setEquipid(emequip_id);
        domain.setEmitempuseid(emitempuse_id);
		emitempuseService.update(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "UpdateBatchByPFTeamEMEquip", tags = {"EMItemPUse" },  notes = "UpdateBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emitempuses/batch")
    public ResponseEntity<Boolean> updateBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emitempuseService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFTeamEMEquip", tags = {"EMItemPUse" },  notes = "CheckKeyByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emitempuses/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMItemPUseDTO emitempusedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitempuseService.checkKey(emitempuseMapping.toDomain(emitempusedto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFTeamEMEquip", tags = {"EMItemPUse" },  notes = "GetDraftByPFTeamEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emitempuses/getdraft")
    public ResponseEntity<EMItemPUseDTO> getDraftByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id) {
        EMItemPUse domain = new EMItemPUse();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseMapping.toDto(emitempuseService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Remove',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFTeamEMEquip", tags = {"EMItemPUse" },  notes = "RemoveByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emitempuse_id") String emitempuse_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.remove(emitempuse_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emitempuseMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFTeamEMEquip", tags = {"EMItemPUse" },  notes = "RemoveBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emitempuses/batch")
    public ResponseEntity<Boolean> removeBatchByPFTeamEMEquip(@RequestBody List<String> ids) {
        emitempuseService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Get',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFTeamEMEquip", tags = {"EMItemPUse" },  notes = "GetByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emitempuses/{emitempuse_id}")
    public ResponseEntity<EMItemPUseDTO> getByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emitempuse_id") String emitempuse_id) {
        EMItemPUse domain = emitempuseService.get(emitempuse_id);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "SaveByPFTeamEMEquip", tags = {"EMItemPUse" },  notes = "SaveByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emitempuses/save")
    public ResponseEntity<Boolean> saveByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "SaveBatchByPFTeamEMEquip", tags = {"EMItemPUse" },  notes = "SaveBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emitempuses/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emitempuseService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "CreateByPFTeamEMEquip", tags = {"EMItemPUse" },  notes = "CreateByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emitempuses")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> createByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setEquipid(emequip_id);
		emitempuseService.create(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "createBatchByPFTeamEMEquip", tags = {"EMItemPUse" },  notes = "createBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emitempuses/batch")
    public ResponseEntity<Boolean> createBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emitempuseService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFTeamEMEquip", tags = {"EMItemPUse" } ,notes = "fetchDEFAULTByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emitempuses/fetchdefault")
	public ResponseEntity<List<EMItemPUseDTO>> fetchEMItemPUseDefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id,EMItemPUseSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
        List<EMItemPUseDTO> list = emitempuseMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFTeamEMEquip", tags = {"EMItemPUse" } ,notes = "searchDEFAULTByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emitempuses/searchdefault")
	public ResponseEntity<Page<EMItemPUseDTO>> searchEMItemPUseDefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMItemPUseSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitempuseMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emitempuse_id,'Update',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "UpdateByEMServiceEMItem", tags = {"EMItemPUse" },  notes = "UpdateByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> updateByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitempuse_id") String emitempuse_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setItemid(emitem_id);
        domain.setEmitempuseid(emitempuse_id);
		emitempuseService.update(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "UpdateBatchByEMServiceEMItem", tags = {"EMItemPUse" },  notes = "UpdateBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitempuses/batch")
    public ResponseEntity<Boolean> updateBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitempuseService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMServiceEMItem", tags = {"EMItemPUse" },  notes = "CheckKeyByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitempuses/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPUseDTO emitempusedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitempuseService.checkKey(emitempuseMapping.toDomain(emitempusedto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMServiceEMItem", tags = {"EMItemPUse" },  notes = "GetDraftByEMServiceEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitempuses/getdraft")
    public ResponseEntity<EMItemPUseDTO> getDraftByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemPUse domain = new EMItemPUse();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseMapping.toDto(emitempuseService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Remove',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMServiceEMItem", tags = {"EMItemPUse" },  notes = "RemoveByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitempuse_id") String emitempuse_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.remove(emitempuse_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emitempuseMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMServiceEMItem", tags = {"EMItemPUse" },  notes = "RemoveBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitempuses/batch")
    public ResponseEntity<Boolean> removeBatchByEMServiceEMItem(@RequestBody List<String> ids) {
        emitempuseService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Get',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMServiceEMItem", tags = {"EMItemPUse" },  notes = "GetByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitempuses/{emitempuse_id}")
    public ResponseEntity<EMItemPUseDTO> getByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitempuse_id") String emitempuse_id) {
        EMItemPUse domain = emitempuseService.get(emitempuse_id);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "SaveByEMServiceEMItem", tags = {"EMItemPUse" },  notes = "SaveByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitempuses/save")
    public ResponseEntity<Boolean> saveByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "SaveBatchByEMServiceEMItem", tags = {"EMItemPUse" },  notes = "SaveBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitempuses/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitempuseService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "CreateByEMServiceEMItem", tags = {"EMItemPUse" },  notes = "CreateByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitempuses")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> createByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setItemid(emitem_id);
		emitempuseService.create(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "createBatchByEMServiceEMItem", tags = {"EMItemPUse" },  notes = "createBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitempuses/batch")
    public ResponseEntity<Boolean> createBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitempuseService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMServiceEMItem", tags = {"EMItemPUse" } ,notes = "fetchDEFAULTByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emitems/{emitem_id}/emitempuses/fetchdefault")
	public ResponseEntity<List<EMItemPUseDTO>> fetchEMItemPUseDefaultByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id,EMItemPUseSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
        List<EMItemPUseDTO> list = emitempuseMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMServiceEMItem", tags = {"EMItemPUse" } ,notes = "searchDEFAULTByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emitems/{emitem_id}/emitempuses/searchdefault")
	public ResponseEntity<Page<EMItemPUseDTO>> searchEMItemPUseDefaultByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPUseSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitempuseMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emitempuse_id,'Update',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "UpdateByEMStorePartEMItem", tags = {"EMItemPUse" },  notes = "UpdateByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> updateByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitempuse_id") String emitempuse_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setItemid(emitem_id);
        domain.setEmitempuseid(emitempuse_id);
		emitempuseService.update(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "UpdateBatchByEMStorePartEMItem", tags = {"EMItemPUse" },  notes = "UpdateBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitempuses/batch")
    public ResponseEntity<Boolean> updateBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitempuseService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMStorePartEMItem", tags = {"EMItemPUse" },  notes = "CheckKeyByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitempuses/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPUseDTO emitempusedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitempuseService.checkKey(emitempuseMapping.toDomain(emitempusedto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMStorePartEMItem", tags = {"EMItemPUse" },  notes = "GetDraftByEMStorePartEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitempuses/getdraft")
    public ResponseEntity<EMItemPUseDTO> getDraftByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemPUse domain = new EMItemPUse();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseMapping.toDto(emitempuseService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Remove',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMStorePartEMItem", tags = {"EMItemPUse" },  notes = "RemoveByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitempuse_id") String emitempuse_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.remove(emitempuse_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emitempuseMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMStorePartEMItem", tags = {"EMItemPUse" },  notes = "RemoveBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitempuses/batch")
    public ResponseEntity<Boolean> removeBatchByEMStorePartEMItem(@RequestBody List<String> ids) {
        emitempuseService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Get',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMStorePartEMItem", tags = {"EMItemPUse" },  notes = "GetByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitempuses/{emitempuse_id}")
    public ResponseEntity<EMItemPUseDTO> getByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitempuse_id") String emitempuse_id) {
        EMItemPUse domain = emitempuseService.get(emitempuse_id);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "SaveByEMStorePartEMItem", tags = {"EMItemPUse" },  notes = "SaveByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitempuses/save")
    public ResponseEntity<Boolean> saveByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "SaveBatchByEMStorePartEMItem", tags = {"EMItemPUse" },  notes = "SaveBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitempuses/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitempuseService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "CreateByEMStorePartEMItem", tags = {"EMItemPUse" },  notes = "CreateByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitempuses")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> createByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setItemid(emitem_id);
		emitempuseService.create(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "createBatchByEMStorePartEMItem", tags = {"EMItemPUse" },  notes = "createBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitempuses/batch")
    public ResponseEntity<Boolean> createBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitempuseService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMStorePartEMItem", tags = {"EMItemPUse" } ,notes = "fetchDEFAULTByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitempuses/fetchdefault")
	public ResponseEntity<List<EMItemPUseDTO>> fetchEMItemPUseDefaultByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMItemPUseSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
        List<EMItemPUseDTO> list = emitempuseMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMStorePartEMItem", tags = {"EMItemPUse" } ,notes = "searchDEFAULTByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitempuses/searchdefault")
	public ResponseEntity<Page<EMItemPUseDTO>> searchEMItemPUseDefaultByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPUseSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitempuseMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emitempuse_id,'Update',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "UpdateByEMStoreEMItem", tags = {"EMItemPUse" },  notes = "UpdateByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> updateByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitempuse_id") String emitempuse_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setItemid(emitem_id);
        domain.setEmitempuseid(emitempuse_id);
		emitempuseService.update(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "UpdateBatchByEMStoreEMItem", tags = {"EMItemPUse" },  notes = "UpdateBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitempuses/batch")
    public ResponseEntity<Boolean> updateBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitempuseService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMStoreEMItem", tags = {"EMItemPUse" },  notes = "CheckKeyByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitempuses/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPUseDTO emitempusedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitempuseService.checkKey(emitempuseMapping.toDomain(emitempusedto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMStoreEMItem", tags = {"EMItemPUse" },  notes = "GetDraftByEMStoreEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitempuses/getdraft")
    public ResponseEntity<EMItemPUseDTO> getDraftByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemPUse domain = new EMItemPUse();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseMapping.toDto(emitempuseService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Remove',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMStoreEMItem", tags = {"EMItemPUse" },  notes = "RemoveByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitempuse_id") String emitempuse_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.remove(emitempuse_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emitempuseMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMStoreEMItem", tags = {"EMItemPUse" },  notes = "RemoveBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitempuses/batch")
    public ResponseEntity<Boolean> removeBatchByEMStoreEMItem(@RequestBody List<String> ids) {
        emitempuseService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Get',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMStoreEMItem", tags = {"EMItemPUse" },  notes = "GetByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitempuses/{emitempuse_id}")
    public ResponseEntity<EMItemPUseDTO> getByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitempuse_id") String emitempuse_id) {
        EMItemPUse domain = emitempuseService.get(emitempuse_id);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "SaveByEMStoreEMItem", tags = {"EMItemPUse" },  notes = "SaveByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitempuses/save")
    public ResponseEntity<Boolean> saveByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "SaveBatchByEMStoreEMItem", tags = {"EMItemPUse" },  notes = "SaveBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitempuses/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitempuseService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "CreateByEMStoreEMItem", tags = {"EMItemPUse" },  notes = "CreateByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitempuses")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> createByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setItemid(emitem_id);
		emitempuseService.create(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "createBatchByEMStoreEMItem", tags = {"EMItemPUse" },  notes = "createBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitempuses/batch")
    public ResponseEntity<Boolean> createBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitempuseService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMStoreEMItem", tags = {"EMItemPUse" } ,notes = "fetchDEFAULTByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emitems/{emitem_id}/emitempuses/fetchdefault")
	public ResponseEntity<List<EMItemPUseDTO>> fetchEMItemPUseDefaultByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id,EMItemPUseSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
        List<EMItemPUseDTO> list = emitempuseMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMStoreEMItem", tags = {"EMItemPUse" } ,notes = "searchDEFAULTByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emitems/{emitem_id}/emitempuses/searchdefault")
	public ResponseEntity<Page<EMItemPUseDTO>> searchEMItemPUseDefaultByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPUseSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitempuseMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emitempuse_id,'Update',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "UpdateByPFEmpEMItem", tags = {"EMItemPUse" },  notes = "UpdateByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> updateByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitempuse_id") String emitempuse_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setItemid(emitem_id);
        domain.setEmitempuseid(emitempuse_id);
		emitempuseService.update(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "UpdateBatchByPFEmpEMItem", tags = {"EMItemPUse" },  notes = "UpdateBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitempuses/batch")
    public ResponseEntity<Boolean> updateBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitempuseService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFEmpEMItem", tags = {"EMItemPUse" },  notes = "CheckKeyByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitempuses/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPUseDTO emitempusedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitempuseService.checkKey(emitempuseMapping.toDomain(emitempusedto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFEmpEMItem", tags = {"EMItemPUse" },  notes = "GetDraftByPFEmpEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitempuses/getdraft")
    public ResponseEntity<EMItemPUseDTO> getDraftByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemPUse domain = new EMItemPUse();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseMapping.toDto(emitempuseService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Remove',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFEmpEMItem", tags = {"EMItemPUse" },  notes = "RemoveByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitempuse_id") String emitempuse_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.remove(emitempuse_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emitempuseMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFEmpEMItem", tags = {"EMItemPUse" },  notes = "RemoveBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitempuses/batch")
    public ResponseEntity<Boolean> removeBatchByPFEmpEMItem(@RequestBody List<String> ids) {
        emitempuseService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Get',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFEmpEMItem", tags = {"EMItemPUse" },  notes = "GetByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitempuses/{emitempuse_id}")
    public ResponseEntity<EMItemPUseDTO> getByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitempuse_id") String emitempuse_id) {
        EMItemPUse domain = emitempuseService.get(emitempuse_id);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "SaveByPFEmpEMItem", tags = {"EMItemPUse" },  notes = "SaveByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitempuses/save")
    public ResponseEntity<Boolean> saveByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "SaveBatchByPFEmpEMItem", tags = {"EMItemPUse" },  notes = "SaveBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitempuses/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitempuseService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "CreateByPFEmpEMItem", tags = {"EMItemPUse" },  notes = "CreateByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitempuses")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> createByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setItemid(emitem_id);
		emitempuseService.create(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "createBatchByPFEmpEMItem", tags = {"EMItemPUse" },  notes = "createBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitempuses/batch")
    public ResponseEntity<Boolean> createBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitempuseService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFEmpEMItem", tags = {"EMItemPUse" } ,notes = "fetchDEFAULTByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emitempuses/fetchdefault")
	public ResponseEntity<List<EMItemPUseDTO>> fetchEMItemPUseDefaultByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id,EMItemPUseSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
        List<EMItemPUseDTO> list = emitempuseMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFEmpEMItem", tags = {"EMItemPUse" } ,notes = "searchDEFAULTByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emitempuses/searchdefault")
	public ResponseEntity<Page<EMItemPUseDTO>> searchEMItemPUseDefaultByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPUseSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitempuseMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emitempuse_id,'Update',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "UpdateByPFUnitEMItem", tags = {"EMItemPUse" },  notes = "UpdateByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> updateByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitempuse_id") String emitempuse_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setItemid(emitem_id);
        domain.setEmitempuseid(emitempuse_id);
		emitempuseService.update(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "UpdateBatchByPFUnitEMItem", tags = {"EMItemPUse" },  notes = "UpdateBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitempuses/batch")
    public ResponseEntity<Boolean> updateBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitempuseService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFUnitEMItem", tags = {"EMItemPUse" },  notes = "CheckKeyByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitempuses/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPUseDTO emitempusedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitempuseService.checkKey(emitempuseMapping.toDomain(emitempusedto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFUnitEMItem", tags = {"EMItemPUse" },  notes = "GetDraftByPFUnitEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitempuses/getdraft")
    public ResponseEntity<EMItemPUseDTO> getDraftByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemPUse domain = new EMItemPUse();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseMapping.toDto(emitempuseService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Remove',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFUnitEMItem", tags = {"EMItemPUse" },  notes = "RemoveByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitempuse_id") String emitempuse_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.remove(emitempuse_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emitempuseMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFUnitEMItem", tags = {"EMItemPUse" },  notes = "RemoveBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitempuses/batch")
    public ResponseEntity<Boolean> removeBatchByPFUnitEMItem(@RequestBody List<String> ids) {
        emitempuseService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Get',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFUnitEMItem", tags = {"EMItemPUse" },  notes = "GetByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitempuses/{emitempuse_id}")
    public ResponseEntity<EMItemPUseDTO> getByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitempuse_id") String emitempuse_id) {
        EMItemPUse domain = emitempuseService.get(emitempuse_id);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "SaveByPFUnitEMItem", tags = {"EMItemPUse" },  notes = "SaveByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitempuses/save")
    public ResponseEntity<Boolean> saveByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "SaveBatchByPFUnitEMItem", tags = {"EMItemPUse" },  notes = "SaveBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitempuses/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitempuseService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "CreateByPFUnitEMItem", tags = {"EMItemPUse" },  notes = "CreateByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitempuses")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> createByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setItemid(emitem_id);
		emitempuseService.create(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "createBatchByPFUnitEMItem", tags = {"EMItemPUse" },  notes = "createBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitempuses/batch")
    public ResponseEntity<Boolean> createBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitempuseService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFUnitEMItem", tags = {"EMItemPUse" } ,notes = "fetchDEFAULTByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emitempuses/fetchdefault")
	public ResponseEntity<List<EMItemPUseDTO>> fetchEMItemPUseDefaultByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id,EMItemPUseSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
        List<EMItemPUseDTO> list = emitempuseMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFUnitEMItem", tags = {"EMItemPUse" } ,notes = "searchDEFAULTByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emitempuses/searchdefault")
	public ResponseEntity<Page<EMItemPUseDTO>> searchEMItemPUseDefaultByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPUseSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitempuseMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emitempuse_id,'Update',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "UpdateByEMStoreEMStorePart", tags = {"EMItemPUse" },  notes = "UpdateByEMStoreEMStorePart")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> updateByEMStoreEMStorePart(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitempuse_id") String emitempuse_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setStorepartid(emstorepart_id);
        domain.setEmitempuseid(emitempuse_id);
		emitempuseService.update(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "UpdateBatchByEMStoreEMStorePart", tags = {"EMItemPUse" },  notes = "UpdateBatchByEMStoreEMStorePart")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitempuses/batch")
    public ResponseEntity<Boolean> updateBatchByEMStoreEMStorePart(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setStorepartid(emstorepart_id);
        }
        emitempuseService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMStoreEMStorePart", tags = {"EMItemPUse" },  notes = "CheckKeyByEMStoreEMStorePart")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitempuses/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStoreEMStorePart(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @RequestBody EMItemPUseDTO emitempusedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitempuseService.checkKey(emitempuseMapping.toDomain(emitempusedto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMStoreEMStorePart", tags = {"EMItemPUse" },  notes = "GetDraftByEMStoreEMStorePart")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitempuses/getdraft")
    public ResponseEntity<EMItemPUseDTO> getDraftByEMStoreEMStorePart(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id) {
        EMItemPUse domain = new EMItemPUse();
        domain.setStorepartid(emstorepart_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseMapping.toDto(emitempuseService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Remove',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMStoreEMStorePart", tags = {"EMItemPUse" },  notes = "RemoveByEMStoreEMStorePart")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStoreEMStorePart(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitempuse_id") String emitempuse_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.remove(emitempuse_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emitempuseMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMStoreEMStorePart", tags = {"EMItemPUse" },  notes = "RemoveBatchByEMStoreEMStorePart")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitempuses/batch")
    public ResponseEntity<Boolean> removeBatchByEMStoreEMStorePart(@RequestBody List<String> ids) {
        emitempuseService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Get',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMStoreEMStorePart", tags = {"EMItemPUse" },  notes = "GetByEMStoreEMStorePart")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitempuses/{emitempuse_id}")
    public ResponseEntity<EMItemPUseDTO> getByEMStoreEMStorePart(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitempuse_id") String emitempuse_id) {
        EMItemPUse domain = emitempuseService.get(emitempuse_id);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "SaveByEMStoreEMStorePart", tags = {"EMItemPUse" },  notes = "SaveByEMStoreEMStorePart")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitempuses/save")
    public ResponseEntity<Boolean> saveByEMStoreEMStorePart(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setStorepartid(emstorepart_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "SaveBatchByEMStoreEMStorePart", tags = {"EMItemPUse" },  notes = "SaveBatchByEMStoreEMStorePart")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitempuses/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStoreEMStorePart(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
             domain.setStorepartid(emstorepart_id);
        }
        emitempuseService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "CreateByEMStoreEMStorePart", tags = {"EMItemPUse" },  notes = "CreateByEMStoreEMStorePart")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitempuses")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> createByEMStoreEMStorePart(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setStorepartid(emstorepart_id);
		emitempuseService.create(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "createBatchByEMStoreEMStorePart", tags = {"EMItemPUse" },  notes = "createBatchByEMStoreEMStorePart")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitempuses/batch")
    public ResponseEntity<Boolean> createBatchByEMStoreEMStorePart(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setStorepartid(emstorepart_id);
        }
        emitempuseService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMStoreEMStorePart", tags = {"EMItemPUse" } ,notes = "fetchDEFAULTByEMStoreEMStorePart")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitempuses/fetchdefault")
	public ResponseEntity<List<EMItemPUseDTO>> fetchEMItemPUseDefaultByEMStoreEMStorePart(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id,EMItemPUseSearchContext context) {
        context.setN_storepartid_eq(emstorepart_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
        List<EMItemPUseDTO> list = emitempuseMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMStoreEMStorePart", tags = {"EMItemPUse" } ,notes = "searchDEFAULTByEMStoreEMStorePart")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitempuses/searchdefault")
	public ResponseEntity<Page<EMItemPUseDTO>> searchEMItemPUseDefaultByEMStoreEMStorePart(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @RequestBody EMItemPUseSearchContext context) {
        context.setN_storepartid_eq(emstorepart_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitempuseMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(#emitempuse_id,'Update',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "UpdateByEMStoreEMStorePartEMItem", tags = {"EMItemPUse" },  notes = "UpdateByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> updateByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitempuse_id") String emitempuse_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setItemid(emitem_id);
        domain.setEmitempuseid(emitempuse_id);
		emitempuseService.update(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "UpdateBatchByEMStoreEMStorePartEMItem", tags = {"EMItemPUse" },  notes = "UpdateBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitempuses/batch")
    public ResponseEntity<Boolean> updateBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitempuseService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMStoreEMStorePartEMItem", tags = {"EMItemPUse" },  notes = "CheckKeyByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitempuses/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPUseDTO emitempusedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitempuseService.checkKey(emitempuseMapping.toDomain(emitempusedto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMStoreEMStorePartEMItem", tags = {"EMItemPUse" },  notes = "GetDraftByEMStoreEMStorePartEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitempuses/getdraft")
    public ResponseEntity<EMItemPUseDTO> getDraftByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemPUse domain = new EMItemPUse();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseMapping.toDto(emitempuseService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Remove',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMStoreEMStorePartEMItem", tags = {"EMItemPUse" },  notes = "RemoveByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitempuses/{emitempuse_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitempuse_id") String emitempuse_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.remove(emitempuse_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emitempuseMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMStoreEMStorePartEMItem", tags = {"EMItemPUse" },  notes = "RemoveBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitempuses/batch")
    public ResponseEntity<Boolean> removeBatchByEMStoreEMStorePartEMItem(@RequestBody List<String> ids) {
        emitempuseService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emitempuse_id,'Get',{'Sql',this.emitempuseMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMStoreEMStorePartEMItem", tags = {"EMItemPUse" },  notes = "GetByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitempuses/{emitempuse_id}")
    public ResponseEntity<EMItemPUseDTO> getByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitempuse_id") String emitempuse_id) {
        EMItemPUse domain = emitempuseService.get(emitempuse_id);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "SaveByEMStoreEMStorePartEMItem", tags = {"EMItemPUse" },  notes = "SaveByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitempuses/save")
    public ResponseEntity<Boolean> saveByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitempuseService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "SaveBatchByEMStoreEMStorePartEMItem", tags = {"EMItemPUse" },  notes = "SaveBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitempuses/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitempuseService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emitempuseMapping,#emitempusedto})")
    @ApiOperation(value = "CreateByEMStoreEMStorePartEMItem", tags = {"EMItemPUse" },  notes = "CreateByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitempuses")
    @Transactional
    public ResponseEntity<EMItemPUseDTO> createByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPUseDTO emitempusedto) {
        EMItemPUse domain = emitempuseMapping.toDomain(emitempusedto);
        domain.setItemid(emitem_id);
		emitempuseService.create(domain);
        EMItemPUseDTO dto = emitempuseMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emitempuseMapping,#emitempusedtos})")
    @ApiOperation(value = "createBatchByEMStoreEMStorePartEMItem", tags = {"EMItemPUse" },  notes = "createBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitempuses/batch")
    public ResponseEntity<Boolean> createBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPUseDTO> emitempusedtos) {
        List<EMItemPUse> domainlist=emitempuseMapping.toDomain(emitempusedtos);
        for(EMItemPUse domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitempuseService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMStoreEMStorePartEMItem", tags = {"EMItemPUse" } ,notes = "fetchDEFAULTByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitempuses/fetchdefault")
	public ResponseEntity<List<EMItemPUseDTO>> fetchEMItemPUseDefaultByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMItemPUseSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
        List<EMItemPUseDTO> list = emitempuseMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPUse-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMStoreEMStorePartEMItem", tags = {"EMItemPUse" } ,notes = "searchDEFAULTByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitempuses/searchdefault")
	public ResponseEntity<Page<EMItemPUseDTO>> searchEMItemPUseDefaultByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPUseSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPUse> domains = emitempuseService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitempuseMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
