package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEQSpareMap;
import cn.ibizlab.eam.core.eam_core.service.IEMEQSpareMapService;
import cn.ibizlab.eam.core.eam_core.filter.EMEQSpareMapSearchContext;

@Slf4j
@Api(tags = {"EMEQSpareMap" })
@RestController("WebApi-emeqsparemap")
@RequestMapping("")
public class EMEQSpareMapResource {

    @Autowired
    private IEMEQSpareMapService emeqsparemapService;

    @Autowired
    @Lazy
    public EMEQSpareMapMapping emeqsparemapMapping;

    public EMEQSpareMapDTO permissionDTO=new EMEQSpareMapDTO();

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emeqsparemapMapping,#emeqsparemapdto})")
    @ApiOperation(value = "Save", tags = {"EMEQSpareMap" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqsparemaps/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEQSpareMapDTO emeqsparemapdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeqsparemapService.save(emeqsparemapMapping.toDomain(emeqsparemapdto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emeqsparemapMapping,#emeqsparemapdtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMEQSpareMap" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqsparemaps/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEQSpareMapDTO> emeqsparemapdtos) {
        emeqsparemapService.saveBatch(emeqsparemapMapping.toDomain(emeqsparemapdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSpareMap-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMEQSpareMap" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqsparemaps/getdraft")
    public ResponseEntity<EMEQSpareMapDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeqsparemapMapping.toDto(emeqsparemapService.getDraft(new EMEQSpareMap())));
    }

    @PreAuthorize("hasPermission(#emeqsparemap_id,'Get',{'Sql',this.emeqsparemapMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMEQSpareMap" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqsparemaps/{emeqsparemap_id}")
    public ResponseEntity<EMEQSpareMapDTO> get(@PathVariable("emeqsparemap_id") String emeqsparemap_id) {
        EMEQSpareMap domain = emeqsparemapService.get(emeqsparemap_id);
        EMEQSpareMapDTO dto = emeqsparemapMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSpareMap-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMEQSpareMap" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqsparemaps/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEQSpareMapDTO emeqsparemapdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqsparemapService.checkKey(emeqsparemapMapping.toDomain(emeqsparemapdto)));
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emeqsparemapMapping,#emeqsparemapdto})")
    @ApiOperation(value = "Create", tags = {"EMEQSpareMap" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqsparemaps")
    @Transactional
    public ResponseEntity<EMEQSpareMapDTO> create(@RequestBody EMEQSpareMapDTO emeqsparemapdto) {
        EMEQSpareMap domain = emeqsparemapMapping.toDomain(emeqsparemapdto);
		emeqsparemapService.create(domain);
        EMEQSpareMapDTO dto = emeqsparemapMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emeqsparemapMapping,#emeqsparemapdtos})")
    @ApiOperation(value = "createBatch", tags = {"EMEQSpareMap" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqsparemaps/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEQSpareMapDTO> emeqsparemapdtos) {
        emeqsparemapService.createBatch(emeqsparemapMapping.toDomain(emeqsparemapdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeqsparemap_id,'Update',{'Sql',this.emeqsparemapMapping,#emeqsparemapdto})")
    @ApiOperation(value = "Update", tags = {"EMEQSpareMap" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqsparemaps/{emeqsparemap_id}")
    @Transactional
    public ResponseEntity<EMEQSpareMapDTO> update(@PathVariable("emeqsparemap_id") String emeqsparemap_id, @RequestBody EMEQSpareMapDTO emeqsparemapdto) {
		EMEQSpareMap domain  = emeqsparemapMapping.toDomain(emeqsparemapdto);
        domain .setEmeqsparemapid(emeqsparemap_id);
		emeqsparemapService.update(domain );
		EMEQSpareMapDTO dto = emeqsparemapMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emeqsparemapMapping,#emeqsparemapdtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEQSpareMap" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqsparemaps/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEQSpareMapDTO> emeqsparemapdtos) {
        emeqsparemapService.updateBatch(emeqsparemapMapping.toDomain(emeqsparemapdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeqsparemap_id,'Remove',{'Sql',this.emeqsparemapMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMEQSpareMap" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqsparemaps/{emeqsparemap_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeqsparemap_id") String emeqsparemap_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeqsparemapService.remove(emeqsparemap_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emeqsparemapMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMEQSpareMap" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqsparemaps/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeqsparemapService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSpareMap-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEQSpareMap" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeqsparemaps/fetchdefault")
	public ResponseEntity<List<EMEQSpareMapDTO>> fetchDefault(EMEQSpareMapSearchContext context) {
        Page<EMEQSpareMap> domains = emeqsparemapService.searchDefault(context) ;
        List<EMEQSpareMapDTO> list = emeqsparemapMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSpareMap-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEQSpareMap" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeqsparemaps/searchdefault")
	public ResponseEntity<Page<EMEQSpareMapDTO>> searchDefault(@RequestBody EMEQSpareMapSearchContext context) {
        Page<EMEQSpareMap> domains = emeqsparemapService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqsparemapMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Save',{'Sql',this.emeqsparemapMapping,#emeqsparemapdto})")
    @ApiOperation(value = "SaveByEMEQSpare", tags = {"EMEQSpareMap" },  notes = "SaveByEMEQSpare")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqspares/{emeqspare_id}/emeqsparemaps/save")
    public ResponseEntity<Boolean> saveByEMEQSpare(@PathVariable("emeqspare_id") String emeqspare_id, @RequestBody EMEQSpareMapDTO emeqsparemapdto) {
        EMEQSpareMap domain = emeqsparemapMapping.toDomain(emeqsparemapdto);
        domain.setEqspareid(emeqspare_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqsparemapService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emeqsparemapMapping,#emeqsparemapdtos})")
    @ApiOperation(value = "SaveBatchByEMEQSpare", tags = {"EMEQSpareMap" },  notes = "SaveBatchByEMEQSpare")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqspares/{emeqspare_id}/emeqsparemaps/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEQSpare(@PathVariable("emeqspare_id") String emeqspare_id, @RequestBody List<EMEQSpareMapDTO> emeqsparemapdtos) {
        List<EMEQSpareMap> domainlist=emeqsparemapMapping.toDomain(emeqsparemapdtos);
        for(EMEQSpareMap domain:domainlist){
             domain.setEqspareid(emeqspare_id);
        }
        emeqsparemapService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSpareMap-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMEQSpare", tags = {"EMEQSpareMap" },  notes = "GetDraftByEMEQSpare")
    @RequestMapping(method = RequestMethod.GET, value = "/emeqspares/{emeqspare_id}/emeqsparemaps/getdraft")
    public ResponseEntity<EMEQSpareMapDTO> getDraftByEMEQSpare(@PathVariable("emeqspare_id") String emeqspare_id) {
        EMEQSpareMap domain = new EMEQSpareMap();
        domain.setEqspareid(emeqspare_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqsparemapMapping.toDto(emeqsparemapService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emeqsparemap_id,'Get',{'Sql',this.emeqsparemapMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMEQSpare", tags = {"EMEQSpareMap" },  notes = "GetByEMEQSpare")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqspares/{emeqspare_id}/emeqsparemaps/{emeqsparemap_id}")
    public ResponseEntity<EMEQSpareMapDTO> getByEMEQSpare(@PathVariable("emeqspare_id") String emeqspare_id, @PathVariable("emeqsparemap_id") String emeqsparemap_id) {
        EMEQSpareMap domain = emeqsparemapService.get(emeqsparemap_id);
        EMEQSpareMapDTO dto = emeqsparemapMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSpareMap-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMEQSpare", tags = {"EMEQSpareMap" },  notes = "CheckKeyByEMEQSpare")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqspares/{emeqspare_id}/emeqsparemaps/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEQSpare(@PathVariable("emeqspare_id") String emeqspare_id, @RequestBody EMEQSpareMapDTO emeqsparemapdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqsparemapService.checkKey(emeqsparemapMapping.toDomain(emeqsparemapdto)));
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emeqsparemapMapping,#emeqsparemapdto})")
    @ApiOperation(value = "CreateByEMEQSpare", tags = {"EMEQSpareMap" },  notes = "CreateByEMEQSpare")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqspares/{emeqspare_id}/emeqsparemaps")
    @Transactional
    public ResponseEntity<EMEQSpareMapDTO> createByEMEQSpare(@PathVariable("emeqspare_id") String emeqspare_id, @RequestBody EMEQSpareMapDTO emeqsparemapdto) {
        EMEQSpareMap domain = emeqsparemapMapping.toDomain(emeqsparemapdto);
        domain.setEqspareid(emeqspare_id);
		emeqsparemapService.create(domain);
        EMEQSpareMapDTO dto = emeqsparemapMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emeqsparemapMapping,#emeqsparemapdtos})")
    @ApiOperation(value = "createBatchByEMEQSpare", tags = {"EMEQSpareMap" },  notes = "createBatchByEMEQSpare")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqspares/{emeqspare_id}/emeqsparemaps/batch")
    public ResponseEntity<Boolean> createBatchByEMEQSpare(@PathVariable("emeqspare_id") String emeqspare_id, @RequestBody List<EMEQSpareMapDTO> emeqsparemapdtos) {
        List<EMEQSpareMap> domainlist=emeqsparemapMapping.toDomain(emeqsparemapdtos);
        for(EMEQSpareMap domain:domainlist){
            domain.setEqspareid(emeqspare_id);
        }
        emeqsparemapService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeqsparemap_id,'Update',{'Sql',this.emeqsparemapMapping,#emeqsparemapdto})")
    @ApiOperation(value = "UpdateByEMEQSpare", tags = {"EMEQSpareMap" },  notes = "UpdateByEMEQSpare")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqspares/{emeqspare_id}/emeqsparemaps/{emeqsparemap_id}")
    @Transactional
    public ResponseEntity<EMEQSpareMapDTO> updateByEMEQSpare(@PathVariable("emeqspare_id") String emeqspare_id, @PathVariable("emeqsparemap_id") String emeqsparemap_id, @RequestBody EMEQSpareMapDTO emeqsparemapdto) {
        EMEQSpareMap domain = emeqsparemapMapping.toDomain(emeqsparemapdto);
        domain.setEqspareid(emeqspare_id);
        domain.setEmeqsparemapid(emeqsparemap_id);
		emeqsparemapService.update(domain);
        EMEQSpareMapDTO dto = emeqsparemapMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emeqsparemapMapping,#emeqsparemapdtos})")
    @ApiOperation(value = "UpdateBatchByEMEQSpare", tags = {"EMEQSpareMap" },  notes = "UpdateBatchByEMEQSpare")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqspares/{emeqspare_id}/emeqsparemaps/batch")
    public ResponseEntity<Boolean> updateBatchByEMEQSpare(@PathVariable("emeqspare_id") String emeqspare_id, @RequestBody List<EMEQSpareMapDTO> emeqsparemapdtos) {
        List<EMEQSpareMap> domainlist=emeqsparemapMapping.toDomain(emeqsparemapdtos);
        for(EMEQSpareMap domain:domainlist){
            domain.setEqspareid(emeqspare_id);
        }
        emeqsparemapService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeqsparemap_id,'Remove',{'Sql',this.emeqsparemapMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMEQSpare", tags = {"EMEQSpareMap" },  notes = "RemoveByEMEQSpare")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqspares/{emeqspare_id}/emeqsparemaps/{emeqsparemap_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEQSpare(@PathVariable("emeqspare_id") String emeqspare_id, @PathVariable("emeqsparemap_id") String emeqsparemap_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emeqsparemapService.remove(emeqsparemap_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emeqsparemapMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMEQSpare", tags = {"EMEQSpareMap" },  notes = "RemoveBatchByEMEQSpare")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqspares/{emeqspare_id}/emeqsparemaps/batch")
    public ResponseEntity<Boolean> removeBatchByEMEQSpare(@RequestBody List<String> ids) {
        emeqsparemapService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSpareMap-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMEQSpare", tags = {"EMEQSpareMap" } ,notes = "fetchDEFAULTByEMEQSpare")
    @RequestMapping(method= RequestMethod.GET , value="/emeqspares/{emeqspare_id}/emeqsparemaps/fetchdefault")
	public ResponseEntity<List<EMEQSpareMapDTO>> fetchEMEQSpareMapDefaultByEMEQSpare(@PathVariable("emeqspare_id") String emeqspare_id,EMEQSpareMapSearchContext context) {
        context.setN_eqspareid_eq(emeqspare_id);
        Page<EMEQSpareMap> domains = emeqsparemapService.searchDefault(context) ;
        List<EMEQSpareMapDTO> list = emeqsparemapMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSpareMap-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMEQSpare", tags = {"EMEQSpareMap" } ,notes = "searchDEFAULTByEMEQSpare")
    @RequestMapping(method= RequestMethod.POST , value="/emeqspares/{emeqspare_id}/emeqsparemaps/searchdefault")
	public ResponseEntity<Page<EMEQSpareMapDTO>> searchEMEQSpareMapDefaultByEMEQSpare(@PathVariable("emeqspare_id") String emeqspare_id, @RequestBody EMEQSpareMapSearchContext context) {
        context.setN_eqspareid_eq(emeqspare_id);
        Page<EMEQSpareMap> domains = emeqsparemapService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqsparemapMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
