package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEQSetup;
import cn.ibizlab.eam.core.eam_core.service.IEMEQSetupService;
import cn.ibizlab.eam.core.eam_core.filter.EMEQSetupSearchContext;

@Slf4j
@Api(tags = {"EMEQSetup" })
@RestController("WebApi-emeqsetup")
@RequestMapping("")
public class EMEQSetupResource {

    @Autowired
    private IEMEQSetupService emeqsetupService;

    @Autowired
    @Lazy
    public EMEQSetupMapping emeqsetupMapping;

    public EMEQSetupDTO permissionDTO=new EMEQSetupDTO();

    @PreAuthorize("hasPermission('','Save',{'Sql',this.emeqsetupMapping,#emeqsetupdto})")
    @ApiOperation(value = "Save", tags = {"EMEQSetup" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqsetups/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEQSetupDTO emeqsetupdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeqsetupService.save(emeqsetupMapping.toDomain(emeqsetupdto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emeqsetupMapping,#emeqsetupdtos})")
    @ApiOperation(value = "SaveBatch", tags = {"EMEQSetup" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqsetups/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEQSetupDTO> emeqsetupdtos) {
        emeqsetupService.saveBatch(emeqsetupMapping.toDomain(emeqsetupdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeqsetup_id,'Remove',{'Sql',this.emeqsetupMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"EMEQSetup" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqsetups/{emeqsetup_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeqsetup_id") String emeqsetup_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeqsetupService.remove(emeqsetup_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emeqsetupMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"EMEQSetup" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqsetups/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeqsetupService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeqsetup_id,'Get',{'Sql',this.emeqsetupMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"EMEQSetup" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqsetups/{emeqsetup_id}")
    public ResponseEntity<EMEQSetupDTO> get(@PathVariable("emeqsetup_id") String emeqsetup_id) {
        EMEQSetup domain = emeqsetupService.get(emeqsetup_id);
        EMEQSetupDTO dto = emeqsetupMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSetup-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"EMEQSetup" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqsetups/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEQSetupDTO emeqsetupdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqsetupService.checkKey(emeqsetupMapping.toDomain(emeqsetupdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSetup-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"EMEQSetup" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqsetups/getdraft")
    public ResponseEntity<EMEQSetupDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeqsetupMapping.toDto(emeqsetupService.getDraft(new EMEQSetup())));
    }

    @PreAuthorize("hasPermission(#emeqsetup_id,'Update',{'Sql',this.emeqsetupMapping,#emeqsetupdto})")
    @ApiOperation(value = "Update", tags = {"EMEQSetup" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqsetups/{emeqsetup_id}")
    @Transactional
    public ResponseEntity<EMEQSetupDTO> update(@PathVariable("emeqsetup_id") String emeqsetup_id, @RequestBody EMEQSetupDTO emeqsetupdto) {
		EMEQSetup domain  = emeqsetupMapping.toDomain(emeqsetupdto);
        domain .setEmeqsetupid(emeqsetup_id);
		emeqsetupService.update(domain );
		EMEQSetupDTO dto = emeqsetupMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emeqsetupMapping,#emeqsetupdtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEQSetup" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqsetups/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEQSetupDTO> emeqsetupdtos) {
        emeqsetupService.updateBatch(emeqsetupMapping.toDomain(emeqsetupdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emeqsetupMapping,#emeqsetupdto})")
    @ApiOperation(value = "Create", tags = {"EMEQSetup" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqsetups")
    @Transactional
    public ResponseEntity<EMEQSetupDTO> create(@RequestBody EMEQSetupDTO emeqsetupdto) {
        EMEQSetup domain = emeqsetupMapping.toDomain(emeqsetupdto);
		emeqsetupService.create(domain);
        EMEQSetupDTO dto = emeqsetupMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emeqsetupMapping,#emeqsetupdtos})")
    @ApiOperation(value = "createBatch", tags = {"EMEQSetup" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqsetups/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEQSetupDTO> emeqsetupdtos) {
        emeqsetupService.createBatch(emeqsetupMapping.toDomain(emeqsetupdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSetup-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEQSetup" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeqsetups/fetchdefault")
	public ResponseEntity<List<EMEQSetupDTO>> fetchDefault(EMEQSetupSearchContext context) {
        Page<EMEQSetup> domains = emeqsetupService.searchDefault(context) ;
        List<EMEQSetupDTO> list = emeqsetupMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSetup-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEQSetup" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeqsetups/searchdefault")
	public ResponseEntity<Page<EMEQSetupDTO>> searchDefault(@RequestBody EMEQSetupSearchContext context) {
        Page<EMEQSetup> domains = emeqsetupService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqsetupMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Save',{'Sql',this.emeqsetupMapping,#emeqsetupdto})")
    @ApiOperation(value = "SaveByEMEquip", tags = {"EMEQSetup" },  notes = "SaveByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emeqsetups/save")
    public ResponseEntity<Boolean> saveByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMEQSetupDTO emeqsetupdto) {
        EMEQSetup domain = emeqsetupMapping.toDomain(emeqsetupdto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqsetupService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emeqsetupMapping,#emeqsetupdtos})")
    @ApiOperation(value = "SaveBatchByEMEquip", tags = {"EMEQSetup" },  notes = "SaveBatchByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emeqsetups/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQSetupDTO> emeqsetupdtos) {
        List<EMEQSetup> domainlist=emeqsetupMapping.toDomain(emeqsetupdtos);
        for(EMEQSetup domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emeqsetupService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeqsetup_id,'Remove',{'Sql',this.emeqsetupMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMEquip", tags = {"EMEQSetup" },  notes = "RemoveByEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emeqsetups/{emeqsetup_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emeqsetup_id") String emeqsetup_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emeqsetupService.remove(emeqsetup_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emeqsetupMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMEquip", tags = {"EMEQSetup" },  notes = "RemoveBatchByEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emeqsetups/batch")
    public ResponseEntity<Boolean> removeBatchByEMEquip(@RequestBody List<String> ids) {
        emeqsetupService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeqsetup_id,'Get',{'Sql',this.emeqsetupMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMEquip", tags = {"EMEQSetup" },  notes = "GetByEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emeqsetups/{emeqsetup_id}")
    public ResponseEntity<EMEQSetupDTO> getByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emeqsetup_id") String emeqsetup_id) {
        EMEQSetup domain = emeqsetupService.get(emeqsetup_id);
        EMEQSetupDTO dto = emeqsetupMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSetup-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMEquip", tags = {"EMEQSetup" },  notes = "CheckKeyByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emeqsetups/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMEQSetupDTO emeqsetupdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqsetupService.checkKey(emeqsetupMapping.toDomain(emeqsetupdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSetup-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMEquip", tags = {"EMEQSetup" },  notes = "GetDraftByEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emeqsetups/getdraft")
    public ResponseEntity<EMEQSetupDTO> getDraftByEMEquip(@PathVariable("emequip_id") String emequip_id) {
        EMEQSetup domain = new EMEQSetup();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqsetupMapping.toDto(emeqsetupService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emeqsetup_id,'Update',{'Sql',this.emeqsetupMapping,#emeqsetupdto})")
    @ApiOperation(value = "UpdateByEMEquip", tags = {"EMEQSetup" },  notes = "UpdateByEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emeqsetups/{emeqsetup_id}")
    @Transactional
    public ResponseEntity<EMEQSetupDTO> updateByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emeqsetup_id") String emeqsetup_id, @RequestBody EMEQSetupDTO emeqsetupdto) {
        EMEQSetup domain = emeqsetupMapping.toDomain(emeqsetupdto);
        domain.setEquipid(emequip_id);
        domain.setEmeqsetupid(emeqsetup_id);
		emeqsetupService.update(domain);
        EMEQSetupDTO dto = emeqsetupMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emeqsetupMapping,#emeqsetupdtos})")
    @ApiOperation(value = "UpdateBatchByEMEquip", tags = {"EMEQSetup" },  notes = "UpdateBatchByEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emeqsetups/batch")
    public ResponseEntity<Boolean> updateBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQSetupDTO> emeqsetupdtos) {
        List<EMEQSetup> domainlist=emeqsetupMapping.toDomain(emeqsetupdtos);
        for(EMEQSetup domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqsetupService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emeqsetupMapping,#emeqsetupdto})")
    @ApiOperation(value = "CreateByEMEquip", tags = {"EMEQSetup" },  notes = "CreateByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emeqsetups")
    @Transactional
    public ResponseEntity<EMEQSetupDTO> createByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMEQSetupDTO emeqsetupdto) {
        EMEQSetup domain = emeqsetupMapping.toDomain(emeqsetupdto);
        domain.setEquipid(emequip_id);
		emeqsetupService.create(domain);
        EMEQSetupDTO dto = emeqsetupMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emeqsetupMapping,#emeqsetupdtos})")
    @ApiOperation(value = "createBatchByEMEquip", tags = {"EMEQSetup" },  notes = "createBatchByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emeqsetups/batch")
    public ResponseEntity<Boolean> createBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQSetupDTO> emeqsetupdtos) {
        List<EMEQSetup> domainlist=emeqsetupMapping.toDomain(emeqsetupdtos);
        for(EMEQSetup domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqsetupService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSetup-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMEquip", tags = {"EMEQSetup" } ,notes = "fetchDEFAULTByEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emequips/{emequip_id}/emeqsetups/fetchdefault")
	public ResponseEntity<List<EMEQSetupDTO>> fetchEMEQSetupDefaultByEMEquip(@PathVariable("emequip_id") String emequip_id,EMEQSetupSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQSetup> domains = emeqsetupService.searchDefault(context) ;
        List<EMEQSetupDTO> list = emeqsetupMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSetup-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMEquip", tags = {"EMEQSetup" } ,notes = "searchDEFAULTByEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emequips/{emequip_id}/emeqsetups/searchdefault")
	public ResponseEntity<Page<EMEQSetupDTO>> searchEMEQSetupDefaultByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMEQSetupSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQSetup> domains = emeqsetupService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqsetupMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Save',{'Sql',this.emeqsetupMapping,#emeqsetupdto})")
    @ApiOperation(value = "SaveByEMEQTypeEMEquip", tags = {"EMEQSetup" },  notes = "SaveByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqsetups/save")
    public ResponseEntity<Boolean> saveByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQSetupDTO emeqsetupdto) {
        EMEQSetup domain = emeqsetupMapping.toDomain(emeqsetupdto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqsetupService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emeqsetupMapping,#emeqsetupdtos})")
    @ApiOperation(value = "SaveBatchByEMEQTypeEMEquip", tags = {"EMEQSetup" },  notes = "SaveBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqsetups/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQSetupDTO> emeqsetupdtos) {
        List<EMEQSetup> domainlist=emeqsetupMapping.toDomain(emeqsetupdtos);
        for(EMEQSetup domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emeqsetupService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeqsetup_id,'Remove',{'Sql',this.emeqsetupMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByEMEQTypeEMEquip", tags = {"EMEQSetup" },  notes = "RemoveByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqsetups/{emeqsetup_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqsetup_id") String emeqsetup_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emeqsetupService.remove(emeqsetup_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emeqsetupMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByEMEQTypeEMEquip", tags = {"EMEQSetup" },  notes = "RemoveBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqsetups/batch")
    public ResponseEntity<Boolean> removeBatchByEMEQTypeEMEquip(@RequestBody List<String> ids) {
        emeqsetupService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeqsetup_id,'Get',{'Sql',this.emeqsetupMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByEMEQTypeEMEquip", tags = {"EMEQSetup" },  notes = "GetByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqsetups/{emeqsetup_id}")
    public ResponseEntity<EMEQSetupDTO> getByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqsetup_id") String emeqsetup_id) {
        EMEQSetup domain = emeqsetupService.get(emeqsetup_id);
        EMEQSetupDTO dto = emeqsetupMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSetup-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByEMEQTypeEMEquip", tags = {"EMEQSetup" },  notes = "CheckKeyByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqsetups/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQSetupDTO emeqsetupdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqsetupService.checkKey(emeqsetupMapping.toDomain(emeqsetupdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSetup-GetDraft-all')")
    @ApiOperation(value = "GetDraftByEMEQTypeEMEquip", tags = {"EMEQSetup" },  notes = "GetDraftByEMEQTypeEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqsetups/getdraft")
    public ResponseEntity<EMEQSetupDTO> getDraftByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id) {
        EMEQSetup domain = new EMEQSetup();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqsetupMapping.toDto(emeqsetupService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emeqsetup_id,'Update',{'Sql',this.emeqsetupMapping,#emeqsetupdto})")
    @ApiOperation(value = "UpdateByEMEQTypeEMEquip", tags = {"EMEQSetup" },  notes = "UpdateByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqsetups/{emeqsetup_id}")
    @Transactional
    public ResponseEntity<EMEQSetupDTO> updateByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqsetup_id") String emeqsetup_id, @RequestBody EMEQSetupDTO emeqsetupdto) {
        EMEQSetup domain = emeqsetupMapping.toDomain(emeqsetupdto);
        domain.setEquipid(emequip_id);
        domain.setEmeqsetupid(emeqsetup_id);
		emeqsetupService.update(domain);
        EMEQSetupDTO dto = emeqsetupMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emeqsetupMapping,#emeqsetupdtos})")
    @ApiOperation(value = "UpdateBatchByEMEQTypeEMEquip", tags = {"EMEQSetup" },  notes = "UpdateBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqsetups/batch")
    public ResponseEntity<Boolean> updateBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQSetupDTO> emeqsetupdtos) {
        List<EMEQSetup> domainlist=emeqsetupMapping.toDomain(emeqsetupdtos);
        for(EMEQSetup domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqsetupService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emeqsetupMapping,#emeqsetupdto})")
    @ApiOperation(value = "CreateByEMEQTypeEMEquip", tags = {"EMEQSetup" },  notes = "CreateByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqsetups")
    @Transactional
    public ResponseEntity<EMEQSetupDTO> createByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQSetupDTO emeqsetupdto) {
        EMEQSetup domain = emeqsetupMapping.toDomain(emeqsetupdto);
        domain.setEquipid(emequip_id);
		emeqsetupService.create(domain);
        EMEQSetupDTO dto = emeqsetupMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emeqsetupMapping,#emeqsetupdtos})")
    @ApiOperation(value = "createBatchByEMEQTypeEMEquip", tags = {"EMEQSetup" },  notes = "createBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqsetups/batch")
    public ResponseEntity<Boolean> createBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQSetupDTO> emeqsetupdtos) {
        List<EMEQSetup> domainlist=emeqsetupMapping.toDomain(emeqsetupdtos);
        for(EMEQSetup domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqsetupService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSetup-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByEMEQTypeEMEquip", tags = {"EMEQSetup" } ,notes = "fetchDEFAULTByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqsetups/fetchdefault")
	public ResponseEntity<List<EMEQSetupDTO>> fetchEMEQSetupDefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id,EMEQSetupSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQSetup> domains = emeqsetupService.searchDefault(context) ;
        List<EMEQSetupDTO> list = emeqsetupMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSetup-Default-all')")
	@ApiOperation(value = "searchDEFAULTByEMEQTypeEMEquip", tags = {"EMEQSetup" } ,notes = "searchDEFAULTByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqsetups/searchdefault")
	public ResponseEntity<Page<EMEQSetupDTO>> searchEMEQSetupDefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQSetupSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQSetup> domains = emeqsetupService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqsetupMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission('','Save',{'Sql',this.emeqsetupMapping,#emeqsetupdto})")
    @ApiOperation(value = "SaveByPFTeamEMEquip", tags = {"EMEQSetup" },  notes = "SaveByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqsetups/save")
    public ResponseEntity<Boolean> saveByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQSetupDTO emeqsetupdto) {
        EMEQSetup domain = emeqsetupMapping.toDomain(emeqsetupdto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqsetupService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.emeqsetupMapping,#emeqsetupdtos})")
    @ApiOperation(value = "SaveBatchByPFTeamEMEquip", tags = {"EMEQSetup" },  notes = "SaveBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqsetups/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQSetupDTO> emeqsetupdtos) {
        List<EMEQSetup> domainlist=emeqsetupMapping.toDomain(emeqsetupdtos);
        for(EMEQSetup domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emeqsetupService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeqsetup_id,'Remove',{'Sql',this.emeqsetupMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByPFTeamEMEquip", tags = {"EMEQSetup" },  notes = "RemoveByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqsetups/{emeqsetup_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqsetup_id") String emeqsetup_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emeqsetupService.remove(emeqsetup_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.emeqsetupMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByPFTeamEMEquip", tags = {"EMEQSetup" },  notes = "RemoveBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqsetups/batch")
    public ResponseEntity<Boolean> removeBatchByPFTeamEMEquip(@RequestBody List<String> ids) {
        emeqsetupService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#emeqsetup_id,'Get',{'Sql',this.emeqsetupMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByPFTeamEMEquip", tags = {"EMEQSetup" },  notes = "GetByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqsetups/{emeqsetup_id}")
    public ResponseEntity<EMEQSetupDTO> getByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqsetup_id") String emeqsetup_id) {
        EMEQSetup domain = emeqsetupService.get(emeqsetup_id);
        EMEQSetupDTO dto = emeqsetupMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSetup-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByPFTeamEMEquip", tags = {"EMEQSetup" },  notes = "CheckKeyByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqsetups/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQSetupDTO emeqsetupdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqsetupService.checkKey(emeqsetupMapping.toDomain(emeqsetupdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSetup-GetDraft-all')")
    @ApiOperation(value = "GetDraftByPFTeamEMEquip", tags = {"EMEQSetup" },  notes = "GetDraftByPFTeamEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqsetups/getdraft")
    public ResponseEntity<EMEQSetupDTO> getDraftByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id) {
        EMEQSetup domain = new EMEQSetup();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqsetupMapping.toDto(emeqsetupService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(#emeqsetup_id,'Update',{'Sql',this.emeqsetupMapping,#emeqsetupdto})")
    @ApiOperation(value = "UpdateByPFTeamEMEquip", tags = {"EMEQSetup" },  notes = "UpdateByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqsetups/{emeqsetup_id}")
    @Transactional
    public ResponseEntity<EMEQSetupDTO> updateByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqsetup_id") String emeqsetup_id, @RequestBody EMEQSetupDTO emeqsetupdto) {
        EMEQSetup domain = emeqsetupMapping.toDomain(emeqsetupdto);
        domain.setEquipid(emequip_id);
        domain.setEmeqsetupid(emeqsetup_id);
		emeqsetupService.update(domain);
        EMEQSetupDTO dto = emeqsetupMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.emeqsetupMapping,#emeqsetupdtos})")
    @ApiOperation(value = "UpdateBatchByPFTeamEMEquip", tags = {"EMEQSetup" },  notes = "UpdateBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqsetups/batch")
    public ResponseEntity<Boolean> updateBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQSetupDTO> emeqsetupdtos) {
        List<EMEQSetup> domainlist=emeqsetupMapping.toDomain(emeqsetupdtos);
        for(EMEQSetup domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqsetupService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission('','Create',{'Sql',this.emeqsetupMapping,#emeqsetupdto})")
    @ApiOperation(value = "CreateByPFTeamEMEquip", tags = {"EMEQSetup" },  notes = "CreateByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqsetups")
    @Transactional
    public ResponseEntity<EMEQSetupDTO> createByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQSetupDTO emeqsetupdto) {
        EMEQSetup domain = emeqsetupMapping.toDomain(emeqsetupdto);
        domain.setEquipid(emequip_id);
		emeqsetupService.create(domain);
        EMEQSetupDTO dto = emeqsetupMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.emeqsetupMapping,#emeqsetupdtos})")
    @ApiOperation(value = "createBatchByPFTeamEMEquip", tags = {"EMEQSetup" },  notes = "createBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqsetups/batch")
    public ResponseEntity<Boolean> createBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQSetupDTO> emeqsetupdtos) {
        List<EMEQSetup> domainlist=emeqsetupMapping.toDomain(emeqsetupdtos);
        for(EMEQSetup domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqsetupService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSetup-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByPFTeamEMEquip", tags = {"EMEQSetup" } ,notes = "fetchDEFAULTByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqsetups/fetchdefault")
	public ResponseEntity<List<EMEQSetupDTO>> fetchEMEQSetupDefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id,EMEQSetupSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQSetup> domains = emeqsetupService.searchDefault(context) ;
        List<EMEQSetupDTO> list = emeqsetupMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSetup-Default-all')")
	@ApiOperation(value = "searchDEFAULTByPFTeamEMEquip", tags = {"EMEQSetup" } ,notes = "searchDEFAULTByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqsetups/searchdefault")
	public ResponseEntity<Page<EMEQSetupDTO>> searchEMEQSetupDefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQSetupSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQSetup> domains = emeqsetupService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqsetupMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
